﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.PresentProjectManage" Title="促销方案管理" Codebehind="PresentProjectManage.aspx.cs" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server"
        AdditionalNode="所有促销方案" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <pe:ExtendedGridView ID="GdvPresentProjectList" runat="server" AutoGenerateColumns="false"
        OnRowDataBound="GdvPresentProjectList_RowDataBound" EmptyDataText="暂无任何数据！" AllowPaging="true"
        DataSourceID="OdsPresentProjectList" DataKeyNames="ProjectId" OnRowCommand="GdvPresentProjectList_RowCommand"
        ItemName="方案" ItemUnit="个" RowDblclickBoundField="ProjectId" RowDblclickUrl="PresentProject.aspx?Action=Modify&amp;ProjectId={$Field}">
        <Columns>
            <pe:BoundField DataField="ProjectId" HeaderText="ID" SortExpression="ProjectId">
                <HeaderStyle Width="5%" />
            </pe:BoundField>
            <pe:BoundField DataField="ProjectName" HeaderText="方案名称" SortExpression="ProjectName"
                >
                <HeaderStyle Width="15%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="价格区间" SortExpression="BetweenMoney">
                <HeaderStyle Width="15%" />
                <ItemTemplate>
                    <%#Decimal.Round(Convert.ToDecimal(Eval("MinMoney")), 2)%>
                    ≤金额＜<%#Decimal.Round(Convert.ToDecimal(Eval("MaxMoney")), 2)%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="有效期" SortExpression="BetweenDate">
                <HeaderStyle Width="20%" />
                <ItemTemplate>
                    <%# Eval("BeginDate", "{0:yyyy-MM-dd}") %>
                    至 <%# DataBinder.Eval(Container.DataItem, "EndDate", "{0:yyyy-MM-dd}")%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="促销内容" SortExpression="PresentContent">
            </pe:TemplateField>
            <pe:TemplateField HeaderText="已启用" SortExpression="Disabled">
                <HeaderStyle Width="8%" />
                <ItemTemplate>
                    <%# (bool)Eval("Disabled") != false ? "<font color=red>×</font>" : "√"%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="常规操作">
                <HeaderStyle Width="14%" />
                <ItemTemplate>
                    <pe:ExtendedLinkButton IsChecked="true" OperateCode="PromotionProject" ID="LbtnIsLocked"
                        runat="server" CommandName='<%# (bool)Eval("Disabled") == true ? "UnLocked" : "Locked"%>'
                        CommandArgument='<%# Eval("ProjectId") %>' Text='<%# (bool)Eval("Disabled") == true ? "启用" : "禁用"%>' />
                    <pe:ExtendedAnchor IsChecked="true" runat="server" OperateCode="PromotionProject"
                        href='<%# Eval("ProjectId","PresentProject.aspx?Action=Modify&ProjectId={0}") %>'>修改</pe:ExtendedAnchor>
                    <pe:ExtendedLinkButton IsChecked="true" OperateCode="PromotionProject" ID="LbtnDelete"
                        OnClientClick="return confirm('确定要删除此记录吗？');" runat="server" CommandName="Delete"
                        CommandArgument='<%# Eval("ProjectId") %>'>删除</pe:ExtendedLinkButton>
                </ItemTemplate>
            </pe:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <br />
    <div id="prompt-note">
	    <dl>
	    <dt class="prompt-note-tit">
	    <span>提示说明</span>
	    </dt>
	    <dd class="prompt-note-con">
		    <asp:Label ID="LblMsg" runat="server" Text=" 注意：不同促销方案的价格区间必须不同，否则会产生冲突。"></asp:Label>
	    </dd>  
	    </dl>
    </div>
    
    <asp:ObjectDataSource ID="OdsPresentProjectList" runat="server" SelectCountMethod="GetTotalOfPresentProject"
        SelectMethod="GetList" TypeName="PowerEasy.Module.Shop.BusinessLogic.PresentProject" DeleteMethod="Delete"
        EnablePaging="true" StartRowIndexParameterName="startRowIndexId" MaximumRowsParameterName="maxNumberRows">
        <DeleteParameters>
            <asp:Parameter Name="projectId" Type="String" />
        </DeleteParameters>
    </asp:ObjectDataSource>
</asp:Content>
