﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="PresentShow.aspx.cs" Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.PresentShow"
    Title="促销礼品" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>促销商品选择</title>

    <script type="text/javascript">
        function ReturnValue(productId, productName) {
            parent.AddProduct(productId, productName, '', 1);
        }

        function CheckKeyword() {
            var dropSearchField = document.getElementById('DropSearchField');
            var txtKeyword = document.getElementById('TxtKeyword').value;
            if (dropSearchField.selectedIndex == 0) {
                alert("请选择要查找的字段！");
                return false;
            } else if (txtKeyword == '关键字') {
                alert("请输入搜索的关键字！");
                return false;
            }
            return true;

        }
    </script>

</head>
<body>
    <form id="form1" runat="server">
    <div>
        <div id="dHTMLADPreview" style="z-index: 1000; left: 0px; visibility: hidden; width: 10px;
            position: absolute; top: 0px; height: 10px">
        </div>

        <script src="../JS/Popup.js" type="text/javascript"></script>

        <table border="0" cellpadding="2" cellspacing="0" class="border" style="text-align: center"
            width="100%">
            <tr class="title">
                <td style="text-align: right">
                    查找商品：<asp:DropDownList ID="DropSearchField" runat="server">
                        <asp:ListItem Value="0">请选择</asp:ListItem>
                        <asp:ListItem Value="1">商品名称</asp:ListItem>
                    </asp:DropDownList>
                    &nbsp;
                    <asp:TextBox ID="TxtKeyword" runat="server" onfocus="select()" Text="关键字"></asp:TextBox>&nbsp;
                    <asp:Button ID="Button1" runat="server" OnClick="BtnSearch_Click" OnClientClick="return CheckKeyword()"
                        Text="搜索" />&nbsp;
                </td>
            </tr>
        </table>
        <div style="width: 100%; height: 360px">
            <pe:ExtendedGridView ID="Egv" runat="server" AutoGenerateColumns="False" CheckBoxFieldHeaderWidth="3%"
                DataSourceID="OdsPresentList" IsHoldState="True" SerialText="" AllowPaging="True"
                PageSize="15" OnRowDataBound="Egv_RowDataBound">
                <Columns>
                    <asp:TemplateField HeaderText="促销商品名称" SortExpression="PresentName">
                        <ItemTemplate>
                            <pe:ExtendedLabel HtmlEncode="false" runat="server" ID="LblPresentName" />
                        </ItemTemplate>
                        <ItemStyle HorizontalAlign="Left" />
                    </asp:TemplateField>
                    <asp:BoundField DataField="Stocks" HeaderText="库存">
                        <ItemStyle HorizontalAlign="Right" />
                    </asp:BoundField>
                    <asp:BoundField DataField="Unit" HeaderText="单位" SortExpression="Unit" />
                    <asp:TemplateField HeaderText="价格" SortExpression="Price">
                        <ItemTemplate>
                            <asp:Label runat="server" Text='<%# Eval("Price") %>' ID="LblPresentPrice"></asp:Label>
                        </ItemTemplate>
                        <ItemStyle HorizontalAlign="Right" />
                    </asp:TemplateField>
                    <asp:BoundField DataField="PriceMarket" DataFormatString="{0:0.00}" 
                        HeaderText="市场价" HtmlEncode="False">
                    <ItemStyle HorizontalAlign="Right" />
                    </asp:BoundField>
                    <asp:BoundField DataField="NeedCredits" HeaderText="换购积分" />
                </Columns>
            </pe:ExtendedGridView>
        </div>
        <asp:HiddenField ID="HdnSearch" runat="server" />
        <asp:HiddenField ID="HdnKeyword" runat="server" />
        <asp:ObjectDataSource ID="OdsPresentList" runat="server" OldValuesParameterFormatString="original_{0}"
            SelectMethod="GetPresentList" TypeName="PowerEasy.Module.Shop.BusinessLogic.Present"  SelectCountMethod="GetPresentTotal" 
             EnablePaging="True" MaximumRowsParameterName="maxNumberRows" StartRowIndexParameterName="startRowIndexId">
            <SelectParameters>
                <asp:QueryStringParameter Name="type" QueryStringField="PresentType" Type="Int32"
                    DefaultValue="0" />
                <asp:ControlParameter ControlID="HdnSearch" Name="searchType" PropertyName="Value"
                    Type="Int32" />
                <asp:ControlParameter ControlID="HdnKeyword" Name="keyword" PropertyName="Value"
                    Type="String" />
            </SelectParameters>
        </asp:ObjectDataSource>
    </div>
    </form>
</body>
</html>
