﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    ValidateRequest="false" Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.ProducerAdd" Title="厂商添加"
    Codebehind="ProducerAdd.aspx.cs" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <table width="100%" border="0" cellpadding="2" cellspacing="1" class="border">
        <tr align="center">
            <td colspan="2" class="spacingtitle">
                <b>添加生产商信息</b>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 15%; white-space:nowrap;" class="tdbgleft" align="right">
                厂商名称：</td>
            <td>
                <asp:TextBox ID="TxtProducerName" runat="server" MaxLength="100"></asp:TextBox>
                <pe:RequiredFieldValidator ID="ValrProducerName" runat="server" ErrorMessage="厂商名称不能为空"
                    ControlToValidate="TxtProducerName" SetFocusOnError="true" Display="Dynamic"></pe:RequiredFieldValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" align="right">
                厂商缩写：</td>
            <td>
                <asp:TextBox ID="TxtProducerShortName" runat="server" MaxLength="50"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td  class="tdbgleft" align="right">
                创立日期：</td>
            <td>
                <pe:DatePicker ID="DpkBirthDay" runat="server"></pe:DatePicker><br />
                <pe:RegexValidator ValidateType="Date" ID="VdateBirthDay" ControlToValidate="DpkBirthDay" runat="server"
                    Display="Dynamic" SetFocusOnError="True"></pe:RegexValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" align="right">
                公司地址：</td>
            <td>
                <asp:TextBox ID="TxtAddress" runat="server" MaxLength="255"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" align="right">
                联系电话：</td>
            <td>
                <asp:TextBox ID="TxtPhone" runat="server" MaxLength="50"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td  class="tdbgleft" align="right">
                传真号码：</td>
            <td>
                <asp:TextBox ID="TxtFax" runat="server" MaxLength="50"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" align="right">
                邮政编码：</td>
            <td>
                <asp:TextBox ID="TxtPostcode" runat="server" MaxLength="50"></asp:TextBox><br />
                <pe:RegexValidator ValidateType="ZipCode" ID="VzipTxtPostcode" ControlToValidate="TxtPostcode" Display="dynamic"
                    SetFocusOnError="true" runat="server"></pe:RegexValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td  class="tdbgleft" align="right">
                厂商主页：</td>
            <td>
                <asp:TextBox ID="TxtHomepage" runat="server" MaxLength="50"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" align="right">
                电子邮件：</td>
            <td>
                <asp:TextBox ID="TxtEmail" runat="server" MaxLength="50"></asp:TextBox><br />
                <pe:RegexValidator ValidateType="Email" ID="VmailEmail" ControlToValidate="TxtEmail" SetFocusOnError="true"
                    Display="dynamic" runat="server"></pe:RegexValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" align="right">
                厂商分类：</td>
            <td>
            
                <asp:RadioButtonList ID="RadlProducerType" runat="server" RepeatLayout="Flow"   
                    RepeatDirection="Horizontal"/>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" align="right">
                厂商照片：</td>
            <td>
                <pe:FileUploadControl ID="ExtenFileUpload" ModuleName="Producer"  Pattern="Img"
                    runat="server" IsAddFileRecord="true" Width="150" Height="172">
                </pe:FileUploadControl>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" align="right">
                厂商简介：</td>
            <td>
                <pe:UEditor Height="300px" ID="EditorProducerIntro" Width="600px" runat="server" Toolbar="Simple" LinkUpload="true" ModuleName="producer" FileRecord="true">
                </pe:UEditor>
            </td>
        </tr>
        <tr class="tdbgbottom">
            <td colspan="2">
                <pe:ExtendedButton IsChecked="true" OperateCode="ProducerManage" ID="BtnSubmit" runat="server"
                    Text="添加" Width="58px" OnClick="BtnSubmit_Click" />&nbsp;&nbsp;
<%--                <input name="Cancel" type="button" class="inputbutton" id="Cancel" value="取消" onclick="Redirect('ProducerManage.aspx')" />
--%>                <input name="Cancel" type='button' class="inputbutton" id="Cancel" value="取消" onclick="javascript:history.back()" />
                <asp:HiddenField ID="HdnUrl" runat="server" />
            </td>
        </tr>
    </table>

    <script type="text/javascript">
    //兼容编辑器返回值，商店没有预览
    function SetUrl(url){}
    </script>

</asp:Content>
