﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.ProducerManage" Title="厂商管理" Codebehind="ProducerManage.aspx.cs" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <pe:ExtendedGridView ID="EgvProducer" runat="server" AutoGenerateCheckBoxColumn="True"
        AutoGenerateColumns="False" OnRowCommand="EgvProducer_RowCommand" ItemName="厂商"
        ItemUnit="个" DataKeyNames="ProducerId" AllowPaging="True" DataSourceID="OdsProducer"
        CheckBoxFieldHeaderWidth="3%" SerialText="" OnRowDataBound="EgvProducer_RowDataBound"
        RowDblclickBoundField="ProducerId" RowDblclickUrl="ProducerModify.aspx?ProducerId={$Field}">
        <Columns>
            <pe:BoundField DataField="ProducerName" HeaderText="厂商名称" SortExpression="ProducerName">
            </pe:BoundField>
            <pe:BoundField DataField="ProducerShortName" HeaderText="厂商缩写" SortExpression="ProducerShortName"
                >
                <HeaderStyle Width="10%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="厂商分类" SortExpression="ProducerType">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <%#PowerEasy.Module.Shop.BusinessLogic.Producer.GetSearchTypeName(Convert.ToString(Eval("ProducerType")))%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="已启用" SortExpression="Passed">
                <HeaderStyle Width="6%" />
                <ItemTemplate>
                    <%# (bool)Eval("Passed") != false ? "<font color=green>√</font>" : "<font color=red>×</font>"%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="属性">
                <HeaderStyle Width="6%" />
                <ItemTemplate>
                    <pe:ExtendedLabel HtmlEncode="false" ID="LblProducerAttribute" runat="server"></pe:ExtendedLabel>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="操作">
                <HeaderStyle Width="28%" />
                <ItemTemplate>
                    <pe:ExtendedAnchor IsChecked="true" runat="server" OperateCode="TrademarkManage"
                        href='<%#Eval("ProducerId","TrademarkAdd.aspx?ProducerId={0}") %>'>增加品牌</pe:ExtendedAnchor>
                    <pe:ExtendedAnchor IsChecked="true" runat="server" operateCode="ProducerManage" href='<%#Eval("ProducerId","ProducerModify.aspx?ProducerId={0}") %>'>修改</pe:ExtendedAnchor>
                    <pe:ExtendedLinkButton IsChecked="true" OperateCode="ProducerManage" ID="LbtnPassed"
                        runat="server" CommandName="Passed" CommandArgument='<%# Bind("ProducerId") %>'
                        Visible='<%#!Convert.ToBoolean(Eval("Passed")) %>' CausesValidation="False">启用</pe:ExtendedLinkButton>
                    <pe:ExtendedLinkButton IsChecked="true" OperateCode="ProducerManage" ID="LbtnCancelPassed"
                        runat="server" CommandName="CancelPassed" CommandArgument='<%# Bind("ProducerId") %>'
                        Visible='<%# Convert.ToBoolean(Eval("Passed")) %>' CausesValidation="False">禁用</pe:ExtendedLinkButton>
                    <pe:ExtendedLinkButton IsChecked="true" OperateCode="ProducerManage" ID="LbtnOnTop"
                        runat="server" CommandArgument='<%# Bind("ProducerId") %>' CommandName="OnTop"
                        Visible='<%#!Convert.ToBoolean(Eval("OnTop")) %>' CausesValidation="False">固顶</pe:ExtendedLinkButton>
                    <pe:ExtendedLinkButton IsChecked="true" OperateCode="ProducerManage" ID="LbtnCancelOnTop"
                        runat="server" CommandArgument='<%# Bind("ProducerId") %>' CommandName="CancelOnTop"
                        Visible='<%#Convert.ToBoolean(Eval("OnTop")) %>' CausesValidation="False">解固</pe:ExtendedLinkButton>
                    <pe:ExtendedLinkButton IsChecked="true" OperateCode="ProducerManage" ID="LbtnElite"
                        runat="server" CommandArgument='<%# Bind("ProducerId") %>' CommandName="Elite"
                        Visible='<%#!Convert.ToBoolean(Eval("IsElite")) %>' CausesValidation="False">推荐</pe:ExtendedLinkButton>
                    <pe:ExtendedLinkButton IsChecked="true" OperateCode="ProducerManage" ID="LbtnCancelElite"
                        runat="server" CommandArgument='<%# Bind("ProducerId") %>' CommandName="CancelElite"
                        Visible='<%#Convert.ToBoolean(Eval("IsElite")) %>' CausesValidation="False">解荐</pe:ExtendedLinkButton>
                    <pe:ExtendedLinkButton IsChecked="true" OperateCode="ProducerManage" ID="LbtnDelete"
                        runat="server" CausesValidation="False" CommandArgument='<%# Eval("ProducerId") %>'
                        CommandName="Del" OnClientClick="return confirm('是否删除该厂商？')">删除</pe:ExtendedLinkButton>
                </ItemTemplate>
            </pe:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <asp:ObjectDataSource ID="OdsProducer" runat="server" SelectCountMethod="GetTotalOfProducer"
        SelectMethod="GetList" TypeName="PowerEasy.Module.Shop.BusinessLogic.Producer" EnablePaging="True"
        StartRowIndexParameterName="startRowIndexId" MaximumRowsParameterName="maxNumberRows">
        <SelectParameters>
            <asp:QueryStringParameter Name="searchType" QueryStringField="SearchType" Type="String" />
            <asp:QueryStringParameter Name="keyword" QueryStringField="KeyWord" Type="String" />
            <asp:QueryStringParameter Name="producerType" QueryStringField="ProducerType" Type="String" />
            <asp:Parameter Name="isPassed" DefaultValue="false" Type="Boolean" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <br />
    &nbsp;&nbsp;
    <pe:ExtendedButton IsChecked="true" OperateCode="ProducerManage" ID="BtnDelete" runat="server"
        OnClientClick="return batchconfirm('是否要删除记录？')" Text="删除选中的厂商" OnClick="BtnDelete_Click" />
    <br />
</asp:Content>
