﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="True"
    CodeBehind="Product.aspx.cs" Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.ProductUI"
    EnableEventValidation="false" ValidateRequest="false" Title="商品添加/修改" %>

<asp:content id="Content1" contentplaceholderid="CphNavigation" runat="server">
    <table style="width: 100%; margin: 0 auto;" cellpadding="0" cellspacing="0">
        <tr>
            <td>
                <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
            </td>
            <td align="right">
                &nbsp;
            </td>
        </tr>
    </table>
</asp:content>
<asp:content id="Content2" contentplaceholderid="CphContent" runat="server">
    <asp:scriptmanager runat="server" id="SmgeProperties" enablepartialrendering="true">
    </asp:scriptmanager>
    <script language="javascript" type="text/javascript">

        var openEditor = false;

        function ShowTabs(ID) {
            for (var i = 0; i < 11; i++) {
                if (i == ID) {
                    document.getElementById("TabTitle" + i).className = "titlemouseover";
                    document.getElementById("Tabs" + i).style.display = "";
                } else {
                    document.getElementById("TabTitle" + i).className = "tabtitle";
                    document.getElementById("Tabs" + i).style.display = "none";
                }
            }
        }


        function EgvChildproducts_Bindjs() {
            $("#<%=EgvChildProducts.ClientID %> input[type='text']").each(function () {
                var text = $(this);
                var value = text.val();
                text
            .focus(function () { $(this).val(""); })
            .blur(function () {
                if (text.val() == '') {
                    text.val(value);
                } else {
                    var num = parseFloat(text.val());
                    if (isNaN(num)) {
                        alert("请输入有效数值！");
                        text.focus();
                    }
                }
            });
            });
        }

        $(function () {
            $("td[id^='TabTitle']").each(function (i) {
                $(this).click(function () { ShowTabs(i); });
            });
        });
    </script>
    <table width="100%" border="0" cellpadding="0" cellspacing="0">
        <tr align="center">
            <td id="TabTitle0" class="titlemouseover">
                基本信息
            </td>
            <td id="TabTitle1" class="tabtitle">
                介绍及图片
            </td>
            <td id="TabTitle2" class="tabtitle">
                其它信息
            </td>
            <td id="TabTitle3" class="tabtitle">
                价格设置
            </td>
            <td id="TabTitle4" class="tabtitle">
                促销设置
            </td>
            <td id="TabTitle5" class="tabtitle">
                商品属性
            </td>
            <td id="TabTitle6" class="tabtitle">
                其它设置
            </td>
            <td id="TabTitle7" class="tabtitle">
                相关信息
            </td>
            <td id="TabTitle8" class="tabtitle">
                商品套装
            </td>
            <td id="TabTitle9" class="tabtitle">
                秒杀设置
            </td>
            <td id="TabTitle10" class="tabtitle">
                限时设置
            </td>
            <td>
                &nbsp;
            </td>
        </tr>
    </table>
    <table width="100%" border="0" cellpadding="5" cellspacing="1" class="border">
        <tr class="tdbg">
            <td style="height: 100px;" valign="top">
                <%--基本信息--%>
                <table id="Tabs0" cellpadding="2" cellspacing="1" style="width: 98%; background-color: white;">
                    <tr class="tdbg">
                        <td align="right" class="tdbgleft" style="width: 20%">
                            <strong>所属节点：&nbsp; </strong>
                        </td>
                        <td align="left" class="tdbg">
                            <pec:NodeType ID="NodeType1" FieldAlias="所属节点" runat="server" />
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td align="right" class="tdbgleft" style="width: 20%">
                            <strong>所属专题：&nbsp; </strong>
                        </td>
                        <td align="left" class="tdbg">
                            <pec:SpecialType ID="SpecialType1" FieldAlias="所属专题" runat="server" />
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td align="right" class="tdbgleft" style="width: 20%">
                            <strong>商品编号：&nbsp; </strong>
                        </td>
                        <td align="left" class="tdbg">
                            <pec:ProductNumber ID="ProductNumber1" runat="server" ></pec:ProductNumber>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td class="tdbgleft" align="right">
                            <strong>条形码：&nbsp; </strong>
                        </td>
                        <td class="tdbg" align="left">
                            <asp:textbox id="TxtBarCode" runat="server" columns="30" maxlength="80">
                            </asp:textbox>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td align="right" class="tdbgleft" style="width: 20%">
                            <strong>商品名称：&nbsp; </strong>
                        </td>
                        <td align="left" class="tdbg">
                            <asp:TextBox id="TxtProductName" runat="server" columns="50" maxlength="200">
                            </asp:TextBox>
                            <pe:RequiredFieldValidator ID="ValrProductName" runat="server" ControlToValidate="TxtProductName"
                                SetFocusOnError="true" Display="dynamic" ErrorMessage="商品名称不能为空！"></pe:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td align="right" class="tdbgleft" style="width: 20%">
                            <strong>副标题：&nbsp; </strong>
                        </td>
                        <td align="left" class="tdbg">
                            <asp:TextBox id="TxtSubTitle" runat="server" columns="50" maxlength="200">
                            </asp:TextBox>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td align="right" class="tdbgleft" style="width: 20%">
                            <strong>关键字：&nbsp; </strong>
                        </td>
                        <td align="left" class="tdbg">
                            <pec:KeywordType ID="KeywordType" runat="server" FieldAlias="关键字" />
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td class="tdbgleft" align="right">
                            <strong>商品单位：&nbsp; </strong>
                        </td>
                        <td class="tdbg" align="left">
                            <pec:ProductUnit ID="ProductUnit" runat="server"></pec:ProductUnit>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td class="tdbgleft" align="right">
                            <strong>商品重量：&nbsp; </strong>
                        </td>
                        <td class="tdbg" align="left">
                            <asp:textbox id="TxtWeight" runat="server" width="80px" maxlength="8">
                            </asp:textbox>
                            千克（Kg）&nbsp;&nbsp;&nbsp;本处的“商品重量”用于发货时计算订单重量。
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td class="tdbgleft" align="right">
                            <strong>服务期限：&nbsp; </strong>
                        </td>
                        <td class="tdbg" align="left">
                            <pe:NumericBox ID="TxtServiceTerm" runat="server" MaxLength="5" width="80px"></pe:NumericBox>
                            <asp:dropdownlist id="DropServiceTermUnit" runat="server">
                                <asp:listitem selected="true" value="0">年</asp:listitem>
                                <asp:listitem value="1">月</asp:listitem>
                                <asp:listitem value="2">日</asp:listitem>
                            </asp:dropdownlist>
                            <asp:CustomValidator ID="ValrServiceTerm" runat="server" ClientValidationFunction="CheckServiceLimit" ControlToValidate="TxtServiceTerm"
                             Display="Dynamic" SetFocusOnError="true" ErrorMessage="服务期限不能大于超过100年"></asp:CustomValidator>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td class="tdbgleft" align="right">
                            <strong>商品类型：&nbsp; </strong>
                        </td>
                        <td class="tdbg" align="left">
                            <asp:radiobuttonlist id="RadlProductType" runat="server" repeatdirection="horizontal">
                                <asp:listitem selected="true" value="0">正常销售</asp:listitem>
                                <asp:listitem value="3">特价处理</asp:listitem>
                            </asp:radiobuttonlist>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td class="tdbgleft" align="right" style="height: 24px">
                            <strong>属性设置：&nbsp; </strong>
                        </td>
                        <td class="tdbg" align="left" style="height: 24px">
                            <asp:checkbox id="ChkIsNew" runat="server" checked="true" text="新品" />
                            &nbsp;<asp:checkbox id="ChkIsHot" runat="server" checked="false" text="热销" />
                            &nbsp;<asp:checkbox id="ChkIsBest" runat="server" checked="false" text="精品" />
                        </td>
                    </tr>
                    <tbody style='<%=IsShow("DisplayDownloadUrl") %>'>
                        <tr class="tdbg">
                            <td class="tdbgleft" align="right">
                                <strong>下载地址：&nbsp; </strong>
                            </td>
                            <td class="tdbg" align="left">
                                <asp:textbox id="TxtDownloadUrl" width="550px" runat="server" maxlength="200">
                                </asp:textbox>
                            </td>
                        </tr>
                        <tr class="tdbg">
                            <td class="tdbgleft" align="right">
                                <strong>下载说明：&nbsp; </strong>
                            </td>
                            <td class="tdbg" align="left">
                                <pe:UEditor ID="EditDownloadRemark" runat="server" Width="550px" Height="200px"
                                    Toolbar="Basic" LinkUpload="true" ModuleName="Shop">
                                </pe:UEditor>
                            </td>
                        </tr>
                    </tbody>
                    <tr class="tdbg">
                        <td class="tdbgleft" align="right">
                            <strong>销售操作：&nbsp; </strong>
                        </td>
                        <td class="tdbg" align="left">
                            <asp:checkbox id="ChkEnableSale" runat="server" checked="true" />
                            &nbsp;打勾表示允许销售，否则不允许销售
                        </td>
                    </tr>
                </table>
                <%--介绍及图片--%>
                <div id="Tabs1" style="display: none;">
                    <table cellpadding="2" cellspacing="1" style="width: 98%; background-color: white;">
                        <tr class="tdbg">
                            <td class="tdbgleft" align="right" style="width: 20%">
                                <strong>商品简介：&nbsp; </strong>
                            </td>
                            <td class="tdbg" align="left">
                                用于首页及栏目页显示，不要超过255个字符<br />
                                <asp:textbox id="TxtProductIntro" runat="server" textmode="MultiLine" columns="67"
                                    rows="38" width="580px" height="50px">
                                </asp:textbox>
                                <asp:customvalidator id="ValxProductIntro" runat="server" errormessage="商品简介长度不能超过255！"
                                    clientvalidationfunction="ValxProductIntro_ClientValidate" controltovalidate="TxtProductIntro"
                                    display="Dynamic" setfocusonerror="True" validateemptytext="True">
                                </asp:customvalidator>
                            </td>
                        </tr>
                    </table>
                    <table cellpadding="2" cellspacing="1" style="width: 98%; background-color: white;">
                        <tr class="tdbg">
                            <td class="tdbgleft" align="right" style="width: 20%">
                                <strong>详细介绍：&nbsp; </strong>
                            </td>
                            <td class="tdbg" align="left">
                                <pe:UEditor ID="ProductExplain" runat="server" Width="580px" Height="300px" Toolbar="Full"
                                    LinkUpload="true" FlashUpload="true" ImageUpload="true" ModuleName="shop" FileRecord="true">
                                </pe:UEditor>
                            </td>
                        </tr>
                    </table>
                    <table cellpadding="2" cellspacing="1" style="width: 98%; background-color: white;">
                        <pec:ProductPic runat="server" ID="ProductPic1" ></pec:ProductPic>
                        <tr class="tdbg">
                            <td class="tdbgleft" align="right" style="width: 20%">
                                <strong>多图展示：&nbsp; </strong>
                            </td>
                            <td class="tdbg" align="left">
                                <pec:MultiplePhoto ID="MultiplePhoto1" runat="server" maxuploadphotocount="5"></pec:MultiplePhoto>
                            </td>
                        </tr>
                    </table>
                </div>
                <%--其它信息--%>
                <table id="Tabs2" cellpadding="2" cellspacing="1" style="width: 98%; background-color: white;
                    display: none">
                    <tr class="tdbg">
                        <td class="tdbgleft" align="right">
                            <strong>生 产 商：&nbsp; </strong>
                        </td>
                        <td class="tdbg" align="left">
                            <pec:Producer ID="Producer" runat="server" FieldAlias="生 产 商" ></pec:Producer>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td class="tdbgleft" align="right">
                            <strong>品牌/商标：&nbsp; </strong>
                        </td>
                        <td class="tdbg" align="left">
                            <%--<pec:Trademark ID="Trademark" runat="server" FieldAlias="品牌/商标" />--%>
                            <pec:TrademarkPicker ID="TrademarkPicker1" runat="server" IsAdminManage="true" ></pec:TrademarkPicker>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td class="tdbgleft" align="right">
                            <strong>缺货时允许购买：&nbsp; </strong>
                        </td>
                        <td class="tdbg" align="left">
                            <asp:checkbox id="ChkEnableBuyWhenOutofstock" runat="server" />
                            &nbsp; 打勾表示缺货时允许购买，否则缺货时不允许购买
                        </td>
                    </tr>
                    <tr class="tdbg" id="tr1">
                        <td class="tdbgleft" align="right">
                            <strong>限购数量：&nbsp; </strong>
                        </td>
                        <td class="tdbg" align="left">
                            <asp:UpdatePanel ID="UpnlLimitNum" runat="server">
                                <ContentTemplate>
                                    <asp:TextBox ID="TxtLimitNum" runat="server" Width="80" MaxLength="8" Text="0" AutoPostBack="true"
                                        OnTextChanged="TxtLimitNum_TextChanged"></asp:TextBox>
                                    &nbsp; 0为不限制，大于0时，此商品将不允许批发</contenttemplate>
                            </asp:UpdatePanel>
                        </td>
                    </tr>
                    <tr class="tdbg" id="tr2">
                        <td class="tdbgleft" align="right">
                            <strong>最低购买数量：&nbsp; </strong>
                        </td>
                        <td class="tdbg" align="left">
                            <asp:textbox id="TxtMinimum" runat="server" width="80" maxlength="8" text="0">
                            </asp:textbox>
                            &nbsp; 0为不限制，大于0时，此商品的最低购买数量为设定的数量
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td class="tdbgleft" align="right">
                            <strong>库存数量：&nbsp; </strong>
                        </td>
                        <td class="tdbg" align="left">
                            <asp:textbox id="TxtStocks" text="1000" runat="server" width="80" maxlength="8">
                            </asp:textbox>
                        </td>
                    </tr>
                    <tr class="tdbg" id="trAlarmNum">
                        <td class="tdbgleft" align="right">
                            <strong>库存报警下限：&nbsp; </strong>
                        </td>
                        <td class="tdbg" align="left">
                            <asp:textbox id="TxtAlarmNum" runat="server" width="80" maxlength="8" text="10">
                            </asp:textbox>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td class="tdbgleft" align="right">
                            <strong>前台库存计算方式：&nbsp; </strong>
                        </td>
                        <td class="tdbg" align="left">
                            <asp:radiobuttonlist id="RadlStocksProject" runat="server" repeatdirection="Vertical">
                                <asp:listitem selected="true" value="0">实际库存</asp:listitem>
                                <asp:listitem value="1">虚拟库存（下订单时扣除）</asp:listitem>
                                <asp:listitem value="2">虚拟库存（支付订单时扣除）</asp:listitem>
                            </asp:radiobuttonlist>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td class="tdbgleft" align="right">
                            <strong>税率设置：&nbsp; </strong>
                        </td>
                        <td class="tdbg" align="left">
                            <pec:TaxRateSetting ID="TaxRateTypeSetting" runat="server" EnableTheming="true" EnableViewState="true"
                                Visible="true" ></pec:TaxRateSetting>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td class="tdbgleft" align="right" style="height: 27px">
                            <strong>商品税率：&nbsp; </strong>
                        </td>
                        <td class="tdbg" align="left" style="height: 27px">
                            <asp:textbox id="TxtTaxRate" runat="server" width="80" maxlength="8">
                            </asp:textbox>
                            %
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td class="tdbgleft" align="right" style="height: 27px">
                            <strong>商品推荐等级：&nbsp; </strong>
                        </td>
                        <td class="tdbg" align="left" style="height: 27px">
                            <asp:dropdownlist id="DropStars" runat="server">
                                <asp:listitem value="5">★★★★★</asp:listitem>
                                <asp:listitem value="4">★★★★</asp:listitem>
                                <asp:listitem value="3" selected="True">★★★</asp:listitem>
                                <asp:listitem value="2">★★</asp:listitem>
                                <asp:listitem value="1">★</asp:listitem>
                            </asp:dropdownlist>
                        </td>
                    </tr>
                </table>
                <%--价格设置--%>
                <table id="Tabs3" cellpadding="2" cellspacing="1" style="width: 98%; background-color: white;
                    display: none">
                    <tr class="tdbg">
                        <td class="tdbgleft" align="right" style="width: 20%">
                            <strong>市场参考价：&nbsp; </strong>
                        </td>
                        <td align="left">
                            <asp:textbox id="TxtPrice_Market" width="60px" maxlength="10" runat="server">
                            </asp:textbox>元
                            <br />
                            <pe:RegexValidator ValidateType="PositiveNum" ID="VpnumPrice_Market" ControlToValidate="TxtPrice_Market"
                                SetFocusOnError="true" Display="dynamic" ErrorMessage="市场参考价格式不正确" runat="server"></pe:RegexValidator>
                        </td>
                        <td align="left">
                            仅供消费者购买此商品时参考的市场零售价，一般可以得比当前零售价高一些。<%= PowerEasy.Foundation.SiteConfig.ShopConfig.DiscountBasePriceComputeType == 1 ? "<br/><span style='color:blue'>会员组和代理商组的折扣计算以此为基数，折扣基价计算方式的设置请在商店参数配置中设置。</span>" : ""%>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td class="tdbgleft" align="right" style="width: 20%">
                            <strong>当前零售价：&nbsp; </strong>
                        </td>
                        <td align="left">
                            <asp:textbox id="TxtPrice" width="60px" maxlength="10" runat="server">
                            </asp:textbox>元
                            <pe:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ControlToValidate="TxtPrice"
                                SetFocusOnError="true" Display="dynamic" ErrorMessage="当前零售价不能为空！"></pe:RequiredFieldValidator>
                            <pe:RegexValidator ValidateType="PositiveNum" ID="VpnumPrice" ControlToValidate="TxtPrice"
                                SetFocusOnError="true" Display="dynamic" ErrorMessage="当前零售价格式不正确" runat="server"></pe:RegexValidator>
                        </td>
                        <td align="left">
                            商店销售此商品时的价格。一般在前台显示为“***商店价”。游客购买时以此价格为准。<%= PowerEasy.Foundation.SiteConfig.ShopConfig.DiscountBasePriceComputeType == 0 ? "<br/><span style='color:blue'>会员组和代理商组的折扣计算以此为基数，折扣基价计算方式的设置请在商店参数配置中设置。</span>" : ""%>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td class="tdbgleft" align="right" style="width: 20%">
                            <strong>会员零售价：&nbsp; </strong>
                        </td>
                        <td colspan="2">
                            <asp:UpdatePanel id="UpnlGroupPrice" runat="server" updatemode="conditional">
                                <contenttemplate>
                                    <asp:RadioButton ID="RadMemberDiscount" OnCheckedChanged="RadMemberDiscount_CheckChanged"
                                        AutoPostBack="true" Checked="true" GroupName="Price_Member" runat="server" />会员组折扣率&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;使用会员组中设定的折扣比率。<br />
                                    <asp:RadioButton ID="RadMemberPrice" GroupName="Price_Member" OnCheckedChanged="RadMemberPrice_CheckChanged"
                                        AutoPostBack="true" runat="server" />统一会员价格&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;会员价：<asp:TextBox
                                            ID="TxtPrice_Member" Width="60px" MaxLength="10" runat="server"></asp:TextBox>元
                                    <pe:RegexValidator ValidateType="PositiveNum" ID="VpnumPrice_Member" ControlToValidate="TxtPrice_Member"
                                        SetFocusOnError="true" Display="dynamic" ErrorMessage="会员价格式不正确" runat="server"></pe:RegexValidator>&nbsp;&nbsp;&nbsp;&nbsp;所有会员都以此为准，不区分组别。<br />
                                    <asp:RadioButton ID="RadGroupPrice" GroupName="Price_Member" AutoPostBack="true"
                                        runat="server" OnCheckedChanged="RadGroupPrice_CheckedChanged" />详细设置会员价&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;详细设置每个会员组的价格。<br />
                                    <asp:Repeater ID="RptGroupPrice" Visible="true" runat="server">
                                        <HeaderTemplate>
                                            <table style="width: 95%" class="boder">
                                                <tr class="tdbg">
                                                    <td align="center" class="tdbgleft">
                                                        会员组
                                                    </td>
                                                    <td align="center" class="tdbgleft">
                                                        价格
                                                    </td>
                                                </tr>
                                        </HeaderTemplate>
                                        <ItemTemplate>
                                            <tr class="tdbg">
                                                <td align="center">
                                                    <%#Eval("GroupName")%>
                                                    <asp:HiddenField ID="HdnGroupID" Value='<%#Eval("GroupId")%>' runat="server" />
                                                </td>
                                                <td align="center">
                                                    <asp:TextBox ID="TxtGroupPrice" runat="server"></asp:TextBox>
                                                </td>
                                            </tr>
                                        </ItemTemplate>
                                        <FooterTemplate>
                </table>
                </FooterTemplate> </asp:Repeater> </ContentTemplate> </asp:UpdatePanel>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" align="right">
                <strong>代理商价格：&nbsp; </strong>
            </td>
            <td colspan="2">
                <asp:UpdatePanel id="UpnlAgentGroupPrice" runat="server">
                    <contenttemplate>
                                    <asp:RadioButton ID="RadAgentDiscount" OnCheckedChanged="RadAgentDiscount_CheckChanged"
                                        AutoPostBack="true" Checked="true" GroupName="Price_Agent" runat="server" />代理商组折扣率&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;使用代理商组中设定的折扣比率。<br />
                                    <asp:RadioButton ID="RadAgentPrice" GroupName="Price_Agent" OnCheckedChanged="RadAgentPrice_CheckChanged"
                                        AutoPostBack="true" runat="server" />统一代理商价格&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;代理商价：<asp:TextBox
                                            ID="TxtPrice_Agent" Width="60px" MaxLength="10" runat="server"></asp:TextBox>元
                                    <pe:RegexValidator ValidateType="PositiveNum" ID="VpnumPrice_Agent" ControlToValidate="TxtPrice_Agent"
                                        SetFocusOnError="true" Display="dynamic" ErrorMessage="代理商价格式不正确" runat="server"></pe:RegexValidator>&nbsp;&nbsp;&nbsp;&nbsp;所有代理商都以此为准，不区分组别。<br />
                                    <asp:RadioButton ID="RadAgentGroupPrice" GroupName="Price_Agent" AutoPostBack="true"
                                        runat="server" OnCheckedChanged="RadAgentGroupPrice_CheckedChanged" />详细设置代理商价&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;详细设置每个代理商组的价格。<br />
                                    <asp:Repeater ID="RptAgentGroupPrice" Visible="true" runat="server">
                                        <HeaderTemplate>
                                            <table style="width: 95%" class="boder">
                                                <tr class="tdbg">
                                                    <td align="center" class="tdbgleft">
                                                        代理商组
                                                    </td>
                                                    <td align="center" class="tdbgleft">
                                                        价格
                                                    </td>
                                                </tr>
                                        </HeaderTemplate>
                                        <ItemTemplate>
                                            <tr class="tdbg">
                                                <td align="center">
                                                    <%#Eval("GroupName")%>
                                                    <asp:HiddenField ID="HdnGroupID" Value='<%#Eval("GroupId")%>' runat="server" />
                                                </td>
                                                <td align="center">
                                                    <asp:TextBox ID="TxtAgentGroupPrice" runat="server"></asp:TextBox>
                                                </td>
                                            </tr>
                                        </ItemTemplate>
                                        <FooterTemplate>
    </table>
                                        </FooterTemplate>
                                    </asp:Repeater>
                                </ContentTemplate>
                            </asp:UpdatePanel>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td class="tdbgleft" align="right">
                            <strong>批发价格设置：&nbsp; </strong>
                        </td>
                        <td colspan="2">
                            <asp:UpdatePanel id="UpnlWholesale" runat="server">
                                <contenttemplate>
                                    <asp:CheckBox ID="ChkEnableWholesale" runat="server" OnCheckedChanged="ChkEnableWholesale_CheckedChanged"
                                        AutoPostBack="true" />允许批发
                                    <table cellpadding="0" id="tbWholesale" runat="server" visible="false">
                                        <tr>
                                            <td>
                                                ① 一次性购买此商品数量满<asp:TextBox ID="TxtNumber_Wholesale1" Width="40px" MaxLength="8" Text="10"
                                                    runat="server"></asp:TextBox>时，批发价为<asp:TextBox ID="TxtPrice_Wholesale1" Width="40px"
                                                        runat="server"></asp:TextBox>
                                                元
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                ② 一次性购买此商品数量满<asp:TextBox ID="TxtNumber_Wholesale2" Width="40px" MaxLength="10" Text="50"
                                                    runat="server"></asp:TextBox>时，批发价为<asp:TextBox ID="TxtPrice_Wholesale2" Width="40px"
                                                        runat="server"></asp:TextBox>
                                                元
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                ③ 一次性购买此商品数量满<asp:TextBox ID="TxtNumber_Wholesale3" Width="40px" MaxLength="12" Text="100"
                                                    runat="server"></asp:TextBox>时，批发价为<asp:TextBox ID="TxtPrice_Wholesale3" Width="40px"
                                                        runat="server"></asp:TextBox>
                                                元
                                            </td>
                                        </tr>
                                    </table>
                                </contenttemplate>
                            </asp:updatepanel>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td class="tdbgleft" align="right">
                            <strong>允许单独销售：&nbsp; </strong>
                        </td>
                        <td colspan="2">
                            <asp:radiobutton id="RadEnableSingleSell" checked="true" groupname="EnableSingleSell"
                                runat="server" />是&nbsp;&nbsp;
                            <asp:radiobutton id="RadDisabledSingleSell" groupname="EnableSingleSell" runat="server" />否&nbsp;&nbsp;&nbsp;
                            <span style="color: Blue">如果不允许单独销售，请指定从属的商品。</span>
                        </td>
                    </tr>
                    <tr class="tdbg" id="trDependentProducts" style="<%= IsShow("DependentProducts")%>">
                        <td class="tdbgleft" align="right">
                            <strong>从属商品：&nbsp; </strong>
                        </td>
                        <td align="left" colspan="2">
                            <pec:DependentProduct ID="DependentProduct" runat="server" ></pec:DependentProduct>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td class="tdbgleft" align="right">
                            <strong>体验价格设置：&nbsp; </strong>
                        </td>
                        <td colspan="2">
                            <asp:updatepanel id="UpdateExperience" runat="server">
                                <contenttemplate>
                                    <asp:CheckBox ID="ChkEnableExperience" runat="server" AutoPostBack="true" OnCheckedChanged="ChkEnableExperience_CheckedChanged"
                                        Checked="false" />开启商品体验功能 &nbsp;&nbsp;&nbsp;<span style="color: Blue;">体验价只对注册会员第一次购买商品时有效</span>
                                    <table cellpadding="0" id="tbExperience" runat="server" visible="false">
                                        <tr>
                                            <td colspan="2">
                                                体验价格：<asp:TextBox ID="TxtExpPrice" MaxLength="10" runat="server" Width="60px"></asp:TextBox>元
                                                <pe:RegexValidator ID="VregExpPrice" runat="server" ValidateType="Money" ErrorMessage="请输入正确的价格"
                                                    ControlToValidate="TxtExpPrice" Display="Dynamic"></pe:RegexValidator>
                                                <asp:RequiredFieldValidator ID="ValrExpPrice" runat="server" ErrorMessage="请输入体验价格"
                                                    Display="Dynamic" Enabled="false" ControlToValidate="TxtExpPrice"></asp:RequiredFieldValidator>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                体验价限购数量：
                                            </td>
                                            <td>
                                                <asp:RadioButton ID="RadCustomExpMaxQuantity" runat="server" Text="自定义数量:" AutoPostBack="true"
                                                    OnCheckedChanged="RadCustomExpMaxQuantity_CheckedChanged" Checked="true" />
                                                <asp:TextBox ID="TxtExpMaxQuantity" runat="server" MaxLength="8" Width="40px" Text="1"></asp:TextBox>
                                                <asp:RegularExpressionValidator ID="VregExpMaxQuantity" runat="server" ValidationExpression="^[0-9]*[1-9][0-9]*$"
                                                    ErrorMessage="数量必须为正整数" ControlToValidate="TxtExpMaxQuantity" Display="Dynamic"></asp:RegularExpressionValidator>
                                                <asp:RequiredFieldValidator ID="ValrExpMaxQuantity" runat="server" ErrorMessage="请输入数量"
                                                    Display="Dynamic" ControlToValidate="TxtExpMaxQuantity" Enabled="false"></asp:RequiredFieldValidator>
                                                <asp:RadioButton ID="RadLimitlessExpMaxQuantity" runat="server" Text="无限制" AutoPostBack="true"
                                                    OnCheckedChanged="RadLimitlessExpMaxQuantity_CheckedChanged" />
                                            </td>
                                        </tr>
                                    </table>
                                </contenttemplate>
                            </asp:updatepanel>
                        </td>
                    </tr>
                </table>
                <%--促销设置--%>
                <table id="Tabs4" cellpadding="2" cellspacing="1" style="width: 98%; background-color: white;
                    display: none">
                    <tr class="tdbg">
                        <td align="right" class="tdbgleft" style="width: 20%">
                            <strong>促销方案：&nbsp;</strong>
                        </td>
                        <td>
                            <pec:SalePromotion runat="server" ID="SalePromotion"></pec:SalePromotion>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td align="right" class="tdbgleft">
                            <strong>赠送<pe:ShowPointName runat="server" ID="ShowPointName2" PointType="PointName"></pe:ShowPointName>：&nbsp;
                            </strong>
                        </td>
                        <td>
                            购买一件此商品可以得到
                            <asp:textbox id="TxtPresentPoint" runat="server" columns="5">
                            </asp:textbox>
                            <pe:ShowPointName runat="server" ID="ShowPointName1" PointType="PointName"></pe:ShowPointName>
                            <br />
                            买满××元可以得××<pe:ShowPointName runat="server" ID="ShowPointName3" PointType="PointName"></pe:ShowPointName>等更多促销方案，请到“促销方案管理”中设置。
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td align="right" class="tdbgleft">
                            <strong>购物积分：&nbsp; </strong>
                        </td>
                        <td>
                            购买一件此商品可以得到
                            <asp:textbox id="TxtPresentExp" runat="server" columns="5" maxlength="8">
                            </asp:textbox>
                            积分<br />
                            买满××元可以得××积分等更多促销方案，请到“促销方案管理”中设置。
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td align="right" class="tdbgleft">
                            <strong>赠送现金券：&nbsp;</strong>
                        </td>
                        <td>
                            购买一件此商品可以得到
                            <asp:textbox id="TxtPresentMoney" runat="server" columns="5" maxlength="8">
                            </asp:textbox>
                            元现金券<br />
                            买满××元可以得××元现金券等更多促销方案，请到“促销方案管理”中设置。
                        </td>
                    </tr>
                </table>
                <%--商品属性--%>
                <div id="Tabs5" style="display: none">
                    <asp:updatepanel id="UpnlChildProducts" runat="server" updatemode="Conditional" childrenastriggers="true">
                        <contenttemplate>
                            <table cellpadding="2" cellspacing="1" style="width: 98%; background-color: white;">
                                <asp:Repeater ID="RepModel" runat="server" OnItemDataBound="RepModel_OnItemDataBound">
                                    <ItemTemplate>
                                        <tr id='Tab' runat="server" class='tdbg'>
                                            <td class='tdbgleft' align='right' style="width: 20%;">
                                                <div class="DivWordBreak">
                                                    <strong>
                                                        <%# Eval("FieldAlias")%>
                                                        ：&nbsp;</strong><br />
                                                    <%# Eval("Tips") %>
                                                </div>
                                            </td>
                                            <td class='tdbg' align='left'>
                                                <pe:AdminFieldControl ID="Field" runat="server" EnableNull='<%# (bool)Eval("EnableNull") %>'
                                                    FieldAlias='<%# Eval("FieldAlias")%>' Tips='<%# Eval("Tips") %>' FieldName='<%#Eval("FieldName")%>'
                                                    ControlType='<%# Eval("FieldType") %>' FieldLevel='<%# Eval("FieldLevel") %>'
                                                    Description='<%# Eval("Description")%>' Settings='<%# ((PowerEasy.Module.General.Model.CommonModel.FieldInfo)Container.DataItem).Settings %>'
                                                    Value='<%# Eval("DefaultValue") %>'>
                                                </pe:AdminFieldControl>
                                            </td>
                                        </tr>
                                    </ItemTemplate>
                                </asp:Repeater>
                                <tr class="tdbg" id="TRChildProducts" runat="server" visible="false">
                                    <td colspan="2">
                                        <pe:ExtendedGridView runat="server" ID="EgvChildProducts" AutoGenerateColumns="false"
                                            AllowPaging="false" OnRowDataBound="EgdvChildProducts_RowDataBound" OnDataBound="EgvChildProducts_DataBound">
                                        </pe:ExtendedGridView>
                                        <br />
                                        <pe:ExtendedLabel HtmlEncode="false" ID="LblChildProductsMsg" runat="server">提示：<br />1、商品属性中的值不填则自动获取商品中对应的值，如：库存不填则获取商品基本信息中设定的库存值；<br />
2、如果设置了N个多属性，商品基本信息中设定的库存和库存报警下限值将会变为这N个多属性对应值的总和。</pe:ExtendedLabel>
                                    </td>
                                </tr>
                            </table>
                        </contenttemplate>
                    </asp:updatepanel>
                </div>
                <%--其它设置--%>
                <table id="Tabs6" cellpadding="2" cellspacing="1" style="width: 98%; background-color: white;
                    display: none">
                    <tr class="tdbg">
                        <td align="right" class="tdbgleft" style="width: 20%">
                            <strong>推荐级别：&nbsp; </strong>
                        </td>
                        <td>
                            <asp:textbox id="TxtEliteLevel" runat="server" text="0" maxlength="8">
                            </asp:textbox>
                            <pe:RequiredFieldValidator ID="ValrEliteLevel" runat="server" SetFocusOnError="true"
                                Display="Dynamic" ErrorMessage="推荐级别不能为空" ControlToValidate="TxtEliteLevel"></pe:RequiredFieldValidator>
                            <pe:RegexValidator ValidateType="Number" ID="VnumEliteLevel" runat="server" SetFocusOnError="true"
                                ControlToValidate="TxtEliteLevel" Display="Dynamic"></pe:RegexValidator>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td align="right" class="tdbgleft">
                            <strong>优先级：&nbsp; </strong>
                        </td>
                        <td>
                            <asp:textbox id="TxtPriority" runat="server" text="0" maxlength="8">
                            </asp:textbox>
                            <pe:RequiredFieldValidator ID="ValrPriority" runat="server" SetFocusOnError="true"
                                Display="Dynamic" ErrorMessage="优先级不能为空" ControlToValidate="TxtPriority"></pe:RequiredFieldValidator>
                            <pe:RegexValidator ValidateType="Number" ID="VnumPriority" runat="server" SetFocusOnError="true"
                                ControlToValidate="TxtPriority" Display="Dynamic"></pe:RegexValidator>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td align="right" class="tdbgleft">
                            <strong>点击数：&nbsp; </strong>
                        </td>
                        <td>
                            <asp:textbox id="TxtHits" runat="server" text="0" maxlength="8">
                            </asp:textbox>
                            <pe:RequiredFieldValidator ID="ValrHits" runat="server" SetFocusOnError="true" Display="Dynamic"
                                ErrorMessage="点击数不能为空" ControlToValidate="TxtHits"></pe:RequiredFieldValidator>
                            <pe:RegexValidator ValidateType="Number" ID="VnumHits" runat="server" SetFocusOnError="true"
                                ControlToValidate="TxtHits" Display="Dynamic"></pe:RegexValidator>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td align="right" class="tdbgleft">
                            <strong>日点击数：&nbsp; </strong>
                        </td>
                        <td>
                            <asp:textbox id="TxtDayHits" runat="server" text="0" maxlength="8">
                            </asp:textbox>
                            <pe:RequiredFieldValidator ID="ValrDayHits" runat="server" SetFocusOnError="true"
                                Display="Dynamic" ErrorMessage="日点击数不能为空" ControlToValidate="TxtDayHits"></pe:RequiredFieldValidator>
                            <pe:RegexValidator ValidateType="Number" ID="VnumDayHits" runat="server" SetFocusOnError="true"
                                ControlToValidate="TxtDayHits" Display="Dynamic"></pe:RegexValidator>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td align="right" class="tdbgleft">
                            <strong>周点击数：&nbsp; </strong>
                        </td>
                        <td>
                            <asp:textbox id="TxtWeekHits" runat="server" text="0" maxlength="8">
                            </asp:textbox>
                            <pe:RequiredFieldValidator ID="ValrWeekHits" runat="server" SetFocusOnError="true"
                                Display="Dynamic" ErrorMessage="周点击数不能为空" ControlToValidate="TxtWeekHits"></pe:RequiredFieldValidator>
                            <pe:RegexValidator ValidateType="Number" ID="VnumWeekHits" runat="server" SetFocusOnError="true"
                                ControlToValidate="TxtWeekHits" Display="Dynamic"></pe:RegexValidator>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td align="right" class="tdbgleft">
                            <strong>月点击数：&nbsp; </strong>
                        </td>
                        <td>
                            <asp:textbox id="TxtMonthHits" runat="server" text="0" maxlength="8">
                            </asp:textbox>
                            <pe:RequiredFieldValidator ID="ValrMonthHits" runat="server" SetFocusOnError="true"
                                Display="Dynamic" ErrorMessage="月点击数不能为空" Visible="true" ControlToValidate="TxtMonthHits"></pe:RequiredFieldValidator>
                            <pe:RegexValidator ValidateType="Number" ID="VnumMonthHits" runat="server" SetFocusOnError="true"
                                ControlToValidate="TxtMonthHits" Display="Dynamic"></pe:RegexValidator>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td align="right" class="tdbgleft">
                            <strong>更新时间：&nbsp; </strong>
                        </td>
                        <td>
                            <pe:DatePicker ID="PickDate" IsLongDate="true" runat="server"></pe:DatePicker>
                            <pe:RequiredFieldValidator ID="ReqPickDate" runat="server" SetFocusOnError="true"
                                ControlToValidate="PickDate" Display="Dynamic" ErrorMessage="日期不能为空"></pe:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td align="right" class="tdbgleft">
                            <strong>内容页模板：&nbsp; </strong>
                        </td>
                        <td>
                            <pe:TemplateSelectControl ID="FscTemplate" runat="server"></pe:TemplateSelectControl>
                        </td>
                    </tr>
                </table>
                <%--相关信息--%>
                <table id="Tabs7" cellpadding="2" cellspacing="1" style="width: 100%; background-color: white;
                    display: none">
                    <tr class="tdbg">
                        <td>
                            <pec:FloatingDialog ID="FloatingDialogCorrelativeItem" runat="server" ShowType="1"
                                Width="600" Height="400" Name="添加相关信息" Skin="inputbutton" Title="添加相关信息" />
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td>
                            <asp:updatepanel id="panCorrelativeItem" runat="server" onload="panCorrelativeItem_onLoad"
                                updatemode="Conditional">
                                <contenttemplate>
                                    <asp:HiddenField ID="HdnGeneralIds" runat="server" Value='' />
                                    <asp:Repeater ID="RptCorrelativeItem" runat="server" OnItemDataBound="RptCorrelativeItem_ItemDataBound"
                                        OnItemCommand="RptCorrelativeItem_ItemCommand">
                                        <HeaderTemplate>
                                            <table width="100%" border="0" cellpadding="2" cellspacing="1" class="border">
                                                <tr align="center" class="title">
                                                    <td style="width: 80%">
                                                        名称/标题
                                                    </td>
                                                    <td>
                                                        排序
                                                    </td>
                                                    <td style="width: 10%">
                                                        操作
                                                    </td>
                                                </tr>
                                        </HeaderTemplate>
                                        <ItemTemplate>
                                            <tr class="tdbg">
                                                <td>
                                                    <div class="linkType">
                                                        <pe:ExtendedLabel ID="LblTitle" runat="server" HtmlEncode="false"></pe:ExtendedLabel>
                                                    </div>
                                                    <asp:HiddenField ID="GeneralId" runat="server" Value='<%# Eval("GeneralId")%>' />
                                                    <asp:HiddenField ID="hdnModelId" Value='<%# Eval("ModelId")%>' runat="server" />
                                                </td>
                                                <td align="center">
                                                    <asp:TextBox ID="TxtOrderId" Width="30" runat="server" Text='<%# Eval("OrderId")%>'></asp:TextBox>
                                                </td>
                                                <td align="center">
                                                    <asp:LinkButton ID="LbtnDelete" runat="server" CommandName="DelOrderItem" CommandArgument='<%#Eval("GeneralId")%>'
                                                        CausesValidation="False">删除</asp:LinkButton>
                                                </td>
                                            </tr>
                                        </ItemTemplate>
                                        <FooterTemplate>
                                            </table>
                                        </FooterTemplate>
                                    </asp:Repeater>
                                </ContentTemplate>
                            </asp:UpdatePanel>
                        </td>
                    </tr>
                </table>
                <%--商品套装--%>
                <table id="Tabs8" cellpadding="2" cellspacing="1" style="width: 100%; background-color: white;
                    display: none">
                    <tr class="tdbg">
                        <td class="tdbgleft">
                            <table style="width: 100%;" cellpadding="2" cellspacing="1" id="Table1">
                                <tr class="tdbg">
                                    <td class="tdbgleft">
                                        相关商品套装：
                                    </td>
                                    <td>
                                        <div id="returnVoteItem">
                                            <table id='searchinnet_Table_Title' cellspacing='1' cellpadding='2' style='width: 500px;'>
                                                <tr class='title'>
                                                    <td width='12%' align='center'>
                                                        ID
                                                    </td>
                                                    <td width='46%' align='center'>
                                                        商品名称
                                                    </td>
                                                    <td width='12%' align='center'>
                                                        价格
                                                    </td>
                                                    <td width='30%' align='center'>
                                                        操作
                                                    </td>
                                                </tr>
                                            </table>
                                            <table id='searchinnet_Table' cellspacing='1' cellpadding='2' style='width: 500px;'>
                                                <pe:ExtendedLiteral ID="LitProductSuitId" runat="server" HtmlEncode="false"></pe:ExtendedLiteral>
                                            </table>
                                            <pec:FloatingDialog Title="选择商品套装导购项" runat="server" ID="FdProductSuite" LoadUrl="ProductList.aspx?ShowProperty=True&ProductType=0,1,2,3&FunctionName=GetProductInfo&IsParent=true&PropertieType=1"
                                                Width="800" Height="400" ShowType="2" Name="选择商品套装导购项" />
                                            <span style="color: Green">*套装商品只能选择非多属性商品</span>
                                            <asp:hiddenfield id="HdnProductSuitItemId" runat="server" />
                                        </div>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </table>
                <%--秒杀设置--%>
                <table id="Tabs9" cellpadding="2" cellspacing="1" style="width: 100%; background-color: white;
                    display: none">
                    <tr class="tdbg">
                        <td class="tdbgleft" align="right" style="width: 20%">
                            <strong>是否秒杀：&nbsp; </strong>
                        </td>
                        <td align="left">
                            <asp:CheckBox ID="ChkIsSecondskill" runat="server"  />
                        </td>
                    </tr>
                    <tbody id="tbSecondskill" runat="server" style="display:none;" >
                        <tr class="tdbg">
                            <td class="tdbgleft" align="right" style="width: 20%">
                                <strong>秒杀价格：&nbsp; </strong>
                            </td>
                            <td align="left">
                                <asp:TextBox ID="TxtSecondskillPrice" Width="60px" MaxLength="10" runat="server"></asp:TextBox>元
                                <br />
                                <pe:RegexValidator ValidateType="PositiveNum" ID="RegexValidator2" ControlToValidate="TxtSecondskillPrice"
                                    SetFocusOnError="true" Display="dynamic" ErrorMessage="秒杀价格式不正确" runat="server"></pe:RegexValidator>
                            </td>
                        </tr>
                        <tr class="tdbg">
                            <td align="right" class="tdbgleft" style="width: 20%">
                                <strong>限购数量：&nbsp; </strong>
                            </td>
                            <td>
                                <asp:TextBox ID="TxtSecondskillNumber" runat="server" Text="0" MaxLength="8"></asp:TextBox>
                                <pe:RegexValidator ValidateType="Number" ID="RegexValidator1" runat="server" SetFocusOnError="true"
                                    ControlToValidate="TxtSecondskillNumber" Display="Dynamic"></pe:RegexValidator>
                            </td>
                        </tr>
                        <tr class="tdbg">
                            <td align="right" class="tdbgleft" style="width: 20%">
                                <strong>开始时间：&nbsp; </strong>
                            </td>
                            <td>
                                <pe:DatePicker ID="DpkStartTime" runat="server"></pe:DatePicker>
                                <asp:DropDownList ID="DropStartHour" runat="server">
                                </asp:DropDownList>时
                                <asp:DropDownList ID="DropStartMinute" runat="server">
                                </asp:DropDownList>分
                            </td>
                        </tr>
                        <tr class="tdbg">
                            <td align="right" class="tdbgleft" style="width: 20%">
                                <strong>秒杀有效时间：&nbsp; </strong>
                            </td>
                            <td>
                                <asp:TextBox ID="TxtEffectiveTime" runat="server" Text="3" MaxLength="4"></asp:TextBox>秒
                                <pe:RegexValidator ValidateType="Number" ID="RegexValidator3" runat="server" SetFocusOnError="true"
                                    ControlToValidate="TxtEffectiveTime" Display="Dynamic"></pe:RegexValidator>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <%--限时设置--%>
                <table id="Tabs10" cellpadding="2" cellspacing="1" style="width: 100%; background-color: white;
                    display: none">
                    <tr class="tdbg">
                        <td class="tdbgleft" align="right" style="width: 20%">
                            <strong>是否限时：&nbsp; </strong>
                        </td>
                        <td align="left">
                            <asp:CheckBox ID="ChkIsLimitProduct" runat="server"  />
                        </td>
                    </tr>
                    <tbody id="tdLimitProduct" runat="server" style="display:none;" >
                        <tr class="tdbg">
                            <td class="tdbgleft" align="right" style="width: 20%">
                                <strong>限时价格：&nbsp; </strong>
                            </td>
                            <td align="left">
                                <asp:TextBox ID="TxtLimitProductPrice" Width="60px" MaxLength="10" runat="server"></asp:TextBox>元
                                <br />
                                <pe:RegexValidator ValidateType="PositiveNum" ID="RegexValidator4" ControlToValidate="TxtLimitProductPrice"
                                    SetFocusOnError="true" Display="dynamic" ErrorMessage="秒杀价格式不正确" runat="server"></pe:RegexValidator>
                            </td>
                        </tr>
                        <tr class="tdbg">
                            <td align="right" class="tdbgleft" style="width: 20%">
                                <strong>开始时间：&nbsp; </strong>
                            </td>
                            <td>
                                <pe:DatePicker ID="DpkStartTime2" runat="server"></pe:DatePicker>
                                <asp:DropDownList ID="DropStartHour2" runat="server">
                                </asp:DropDownList>时
                                <asp:DropDownList ID="DropStartMinute2" runat="server">
                                </asp:DropDownList>分
                            </td>
                        </tr>
                        <tr class="tdbg">
                            <td align="right" class="tdbgleft" style="width: 20%">
                                <strong>结束时间：&nbsp; </strong>
                            </td>
                            <td>
								<pe:DatePicker ID="DpkEndTime2" runat="server"></pe:DatePicker>
                                <asp:DropDownList ID="DropEndHour2" runat="server">
                                </asp:DropDownList>时
                                <asp:DropDownList ID="DropEndMinute2" runat="server">
                                </asp:DropDownList>分
                            </td>
                        </tr>
                    </tbody>
                </table>
            </td>
        </tr>
    </table>
    <p style="text-align: center">
        <asp:hiddenfield id="HdnProductCharacter" runat="server" />
        <pe:ExtendedButton ID="BtnSave" Text="　保存　" IsChecked="true" OperateCode="None" OnClick="BtnSave_Click"
            runat="server" IsShowTabs="true" CustomValProcessFunction="ValProcessFunction" CustomValProcessFunction2="validation" />
        <pe:ExtendedButton ID="BtnAddNewProduct" Text="添加为新商品" IsChecked="true" OperateCode="None"
            runat="server" IsShowTabs="true" CustomValProcessFunction="ValProcessFunction" CustomValProcessFunction2="validation"
            Visible="false" OnClick="BtnAddNewProduct_Click" />
    </p>
    <div style="display: none">
        <input type="button" id="BtnCorrelativeItemAdd" onclick="CorrelativeItemAdd()" />
    </div>
    <script language="javascript" type="text/javascript">
        jQuery(function(){
            jQuery("#<%=DropServiceTermUnit.ClientID %>").change(function(){
                for (var i = 0; i < Page_Validators.length; i++) {
                    val = Page_Validators[i];
                    if(val.id == "<%=ValrServiceTerm.ClientID %>")
                    {
                        ValidatorValidate(val, null, jQuery("#<%=TxtServiceTerm.ClientID %>")[0]);
                    }
                }
            });
        });

        function CheckServiceLimit(source,value){
            var val = parseInt(value.Value);
            if(val > 0){
                var unit = jQuery(source).prev().val();
                if(unit == "0"){
                    if(val > 100){
                        jQuery(source).html("<font color='red'>服务期限不能超过100年</font>");
                        value.IsValid = false;
                    }
                }else if(unit == 1){
                    if(val > 100 * 12){
                        jQuery(source).html("<font color='red'>服务期限不能超过1200个月</font>");
                        value.IsValid = false;
                    }
                }else if(unit == 2){
                    if(val > 100 * 365){
                        jQuery(source).html("<font color='red'>服务期限不能超过36500天</font>");
                        value.IsValid = false;
                    }
                }
            }
        }

        function validation() {
            productSuitSubmit();
            var isok = true;
            var isSecondskill = document.getElementById('<%=ChkIsSecondskill.ClientID %>').checked;
            if (isSecondskill) {
                var secondskillPrice = document.getElementById('<%=TxtSecondskillPrice.ClientID %>');
                var startTime = document.getElementById('<%=DpkStartTime.ClientID %>');
                var effectiveTime = document.getElementById('<%=TxtEffectiveTime.ClientID %>');
                var secondskillNumber = document.getElementById('<%=TxtSecondskillNumber.ClientID %>');
                var stocks = document.getElementById('<%=TxtStocks.ClientID %>');     
                var strErrInfo = "";
                if (secondskillPrice.value == '') {
                    isok = false;
                    strErrInfo = "秒杀价格不能为空！\r\n";
                    secondskillPrice.focus();
                }
                
                if (secondskillNumber.value == '' || stocks.value == '') {
                    isok = false;
                    strErrInfo += "秒杀库存和商品库存不能为空！\r\n";
                    secondskillNumber.focus();
                }
                else {
                    if (parseInt(secondskillNumber.value) < 1) {
                        isok = false;
                        strErrInfo += "限购数量不能小于1！\r\n";
                        secondskillNumber.focus();
                    }
                    
                    if (parseInt(secondskillNumber.value) > parseInt(stocks.value)) {
                        isok = false;
                        strErrInfo += "限购数量不能大于商品库存！\r\n";
                        secondskillNumber.focus();
                    }
                }
                if (startTime.value == '') {
                    isok = false;
                    strErrInfo += "秒杀开始时间不能为空！\r\n";
                    startTime.focus();
                }

                if (effectiveTime.value == '') {
                    isok = false;
                    strErrInfo += "秒杀有效时间不能为空！\r\n";
                    effectiveTime.focus();
                }
                if (!isok) {
                    ShowTabs(9);
                    alert(strErrInfo);
                }
            }

            var isLimitProduct = document.getElementById('<%=ChkIsLimitProduct.ClientID %>').checked;
            if (isLimitProduct) {
                var limitProductPrice = document.getElementById('<%=TxtLimitProductPrice.ClientID %>');
                var startTime = document.getElementById('<%=DpkStartTime2.ClientID %>');
                var endTime = document.getElementById('<%=DpkEndTime2.ClientID %>');
                var stocks = document.getElementById('<%=TxtStocks.ClientID %>');
                var strErrInfo = "";
                if (limitProductPrice.value == '') {
                    isok = false;
                    strErrInfo += "限时价格不能为空！\r\n";
                    limitProductPrice.focus();
                }

                if (startTime.value == '') {
                    isok = false;
                    strErrInfo += "限购开始时间不能为空！\r\n";
                    startTime.focus();
                }
                if (endTime.value == '') {
                    isok = false;
                    strErrInfo += "限购结束时间不能为空！\r\n";
                    endTime.focus();
                }
                if (!isok) {
                    ShowTabs(10);
                    alert(strErrInfo);
                }
            }

            if (isSecondskill && isLimitProduct) {
                ShowTabs(9);
                alert("商品不能既是秒杀商品又是限时商品，请取消一个。");
                isok = false;

            }
            return isok;
        }
        //返回浏览器类型
        function getOs() {
            if (navigator.userAgent.indexOf("MSIE") > 0) return 1;
            if (isFirefox = navigator.userAgent.indexOf("Firefox") > 0) return 2;
            if (isSafari = navigator.userAgent.indexOf("Safari") > 0) return 3;
            if (isCamino = navigator.userAgent.indexOf("Camino") > 0) return 4;
            if (isMozilla = navigator.userAgent.indexOf("Gecko") > 0) return 5;
            return 0;
        }
        function cleanWhitespace(element) {
            //遍历element的子结点
            for (var i = 0; i < element.childNodes.length; i++) {
                var node = element.childNodes[i];
                //判断是否是空白文本结点，如果是，则删除该结点
                if (node.nodeType == 3 && !/S/.test(node.nodeValue))
                    node.parentNode.removeChild(node);
            }
        }
        //获得表格对象
        var _table = document.getElementById("searchinnet_Table");
        cleanWhitespace(_table);
        var _id = <%=m_ProductSuitNum.ToString()%>;        
        //增加节点
        function insertRow(node) {
            addProductSuitItem(node.parentNode.parentNode.rowIndex + 1,0,"");
        }
        //删除节点
        function removeRow(node) {
            _table.deleteRow(node.parentNode.parentNode.rowIndex);
        }
        function removeLastRow() {
            _table.deleteRow(-1);
        }
        //解决火狐浏览器问题递归查找节点  节点、类型 （1 = previousSibling，2 = nextSibling)
        function getChildNode(node, type) {
            if (type == 1) {
                //判断是否是空白文本结点，则继续选择下一个节点
                return (node.nodeType == 3 && !/S/.test(node.nodeValue)) ? getChildNode(node.previousSibling, 1) : node.previousSibling;
            }
            else {
                return (node.nodeType == 3 && !/S/.test(node.nodeValue)) ? getChildNode(node.nextSibling, 2) : node.nextSibling;
            }
        }
        //使表格行上移，接收参数为链接对象
        function moveUp(_a) {
            //通过链接对象获取表格行的引用
            var _row = _a.parentNode.parentNode;
            //如果不是第一行，则与上一行交换顺序
            if (_row.previousSibling) {
                var _previousSibling = (getOs() > 1) ? getChildNode(_row, 1) : _row.previousSibling;
                swapNode(_row, _previousSibling);
            }
        }
        //使表格行下移，接收参数为链接对象
        function moveDown(_a) {
            //通过链接对象获取表格行的引用
            var _row = _a.parentNode.parentNode;
            //如果不是最后一行，则与下一行交换顺序
            if (_row.nextSibling) {
                var _nextSibling = (getOs() > 1) ? getChildNode(_row, 2) : _row.nextSibling;
                swapNode(_row, _nextSibling);
            }
        }
        //定义通用的函数交换两个结点的位置
        function swapNode(node1, node2) {
            if (node2 != null) {
                //获取父结点
                var _parent = node1.parentNode;
                //获取两个结点的相对位置
                var _t1 = node1.nextSibling;
                var _t2 = node2.nextSibling;
                //将node2插入到原来node1的位置
                if (_t1) _parent.insertBefore(node2, _t1);
                else _parent.appendChild(node2);
                //将node1插入到原来node2的位置
                if (_t2) _parent.insertBefore(node1, _t2);
                else _parent.appendChild(node1);
            }
        }
        //获取表格内所有ID、Title 值
        function productSuitSubmit() {
            var rows = document.getElementById("searchinnet_Table").getElementsByTagName('input');
            var idvalue = "";
            var property = "";
            for (var i = 0; i < rows.length; i++) {
                if (rows[i].name == "_id") {
                    idvalue = (idvalue == "") ? rows[i].value : idvalue + "," + rows[i].value;
                }
            }      
            document.getElementById('<%=HdnProductSuitItemId.ClientID%>').value = idvalue;
            return true;
        }
        //添加新投票选项
        function addProductSuitItem(nodeAddress,id,title,price,property){
            //判断是否有重复商品
            var rows = document.getElementById("searchinnet_Table").getElementsByTagName('input');
            var idvalue = "";
            var property = "";
            var tempProperty = "";
            if (property != "") {
                tempProperty = property;
            }    
            for (var i = 0; i < rows.length; i++) {
                if (rows[i].name == "_id") {
                    if(rows[i].value == (id + "|" + tempProperty) || rows[i].value == id){
                        return;
                    }
                }
            }

            var a = _table.insertRow(nodeAddress);
            var b = a.insertCell(0);
            var c = a.insertCell(1);
            var d = a.insertCell(2);
            var e = a.insertCell(3);
                    
            b.innerHTML = "<input type='hidden' id='hdn_id_" + id + "' name='_id' value='" + id + "|" + tempProperty+ "'/>" + id;
            b.width = "12%";
            c.align ="center"; 
            c.innerHTML = title;
            c.width = "46%";
            d.align = "right";
            d.innerHTML = price;
            d.width = "12%";
            var setVote = "<span onclick='moveUp(this)'  style='cursor: pointer;'><img border='0' id='img_id_Up" + _id + "' alt='上移项目' src='<%=BasePath%>Admin/Images/icon_up.gif' title='上移项目' align='absmiddle' /></span>";
            setVote += "&nbsp;<span onclick='moveDown(this)'  style='cursor: pointer;'><img border='0' id='img_id_Down" + _id + "' alt='下移项目' src='<%=BasePath%>Admin/Images/icon_down.gif' title='下移项目' align='absmiddle'/></span>";
            setVote += "&nbsp;<span onclick='removeRow(this)'  style='cursor: pointer;'><img border='0' id='img_id_Remove" + _id + "' alt='删除项目' src='<%=BasePath%>Admin/Images/icon_del.gif' title='删除项目' align='absmiddle' /></span>";
       
            e.align ="center";
            e.width = "30%";
            e.innerHTML = setVote; 
            _id += 1;
        }
        //返回内容值
        function GetProductInfo(str) {
            var iProperty = "";
            if (str.indexOf("|")) {
                var arrStr = str.split("|");
                str = arrStr[0];
                iProperty = arrStr[1];
            }
                 
            if (str.indexOf("$$$")) {
                var arrstr = str.split("$$$");
                addProductSuitItem(-1,arrstr[1],arrstr[0],arrstr[2],iProperty);
            }else{
                alert("返回值错误！");
            } 
        }
        //------------------------------------------
        //获得表格对象
        var _SyncTable = document.getElementById("searchinnet_SyncTable");
        function ProtectBox(e) {
            return false;
        }
        function ValProcessFunction() {
            for (i = 0; i < Page_Validators.length; i++) {
                val = Page_Validators[i];
                if (val.isvalid == false) {
                    var id = val.id;
                    var controltovalidate = document.getElementById(val.controltovalidate);
                    var tempobj = controltovalidate;
                    var tabIndex;
                    while (tempobj) {
                        if (tempobj.id != "" && tempobj.id.indexOf('Tabs') >= 0) {
                            if (tempobj.nodeName == "TR" || tempobj.nodeName == "TABLE" || tempobj.nodeName == "DIV") {
                                for (i = 0; i < 9; i++) {
                                    if (document.getElementById("Tabs" + i).id == tempobj.id) {
                                        document.getElementById("TabTitle" + i).className = "titlemouseover";
                                        document.getElementById("Tabs" + i).style.display = "";
                                    }
                                    else {
                                        document.getElementById("TabTitle" + i).className = "tabtitle";
                                        document.getElementById("Tabs" + i).style.display = "none";
                                    }
                                }
                                break;
                            }
                        }
                        tempobj = tempobj.parentNode;
                    }
                    if (typeof (controltovalidate.focus) != "undefined" && controltovalidate.focus != null) {
                        try {
                            controltovalidate.focus();
                        }
                        catch (err) {
                        }
                    }
                    break;
                }
            }
        }
        //兼容编辑器返回值，商店没有预览
        function SetUrl(url) {

        }
        function ValxProductIntro_ClientValidate(s, e) {
            var accounts = document.getElementById('<%=TxtProductIntro.ClientID %>').value;
            if (accounts.length > 255) {
                e.IsValid = false;
            }
            else {
                e.IsValid = true;
            }
        }

        function CorrelativeItemAdd() {
            __doPostBack("<%=panCorrelativeItem.ClientID %>", "");
        }

    </script>
</asp:content>
