﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    ValidateRequest="false" CodeBehind="ProductBatchModify.aspx.cs" Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.ProductBatchModify"
    Title="商品批量编辑" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <div style="padding-top: 10px;">
        <pe:ExtendedSiteMapPath ID="SmpNavigator" runat="server" SiteMapProvider="AdminMapProvider">
        </pe:ExtendedSiteMapPath>
    </div>
    <asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    <asp:Wizard ID="WzdProductBachModify" runat="server" ActiveStepIndex="0" Width="100%"
        CellPadding="5" Font-Names="Verdana" Font-Size="0.8em" DisplaySideBar="False"
        OnNextButtonClick="WzdProductBachModify_NextButtonClick" OnPreviousButtonClick="WzdProductBachModify_PreviousButtonClick"
        FinishCompleteButtonText=" 保存 " OnFinishButtonClick="WzdProductBachModify_FinishButtonClick">
        <WizardSteps>
            <asp:WizardStep ID="WizardStep1" runat="server" Title="Step 1">
                <table width="100%" border="0" cellspacing="1" cellpadding="2" class="border">
                    <tr align="center">
                        <td colspan="2" class="title">
                            <b>商品批量编辑（商品及属性选择）</b>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td align="right" class="tdbgleft">
                            商品模型选择
                        </td>
                        <td align="left">
                            <asp:DropDownList ID="DropProductModel" DataTextField="ModelName" DataValueField="ModelId"
                                runat="server" OnSelectedIndexChanged="DropProductModel_SelectedIndexChanged"
                                AutoPostBack="true">
                            </asp:DropDownList>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td align="right" class="tdbgleft">
                            查询条件
                        </td>
                        <td align="left">
                            <asp:UpdatePanel ID="UpnlSearchType" runat="server" UpdateMode="Conditional">
                                <Triggers>
                                    <asp:PostBackTrigger ControlID="BtnSearch" />
                                </Triggers>
                                <ContentTemplate>
                                    <asp:DropDownList ID="DropSearchType" runat="server" AutoPostBack="true" OnSelectedIndexChanged="DropSearchType_SelectedIndexChanged">
                                        <asp:ListItem Value="0" Selected="true">无</asp:ListItem>
                                        <asp:ListItem Value="1">商品名称</asp:ListItem>
                                        <asp:ListItem Value="2">价格范围</asp:ListItem>
                                        <asp:ListItem Value="3">商品ID</asp:ListItem>
                                    </asp:DropDownList>
                                    <asp:TextBox ID="TxtKeyWord" runat="server" Visible="false"></asp:TextBox>
                                    <asp:Literal runat="server" ID="LtrMsg" Visible="false">到</asp:Literal>
                                    <asp:TextBox ID="TxtKeyWord2" runat="server" Visible="false"></asp:TextBox>
                                    <asp:Button ID="BtnSearch" Text="查询" runat="server" CausesValidation="false" OnClick="BtnSearch_Click" CssClass="inputbutton" />
                                </ContentTemplate>
                            </asp:UpdatePanel>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td align="right" class="tdbgleft">
                            选择商品
                        </td>
                        <td align="left">
                            <table width="100%">
                                <tr>
                                    <td style="width: 250px">
                                        待选列表
                                    </td>
                                    <td style="width: 70px">
                                    </td>
                                    <td>
                                        选定列表
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <asp:UpdatePanel runat="server" ID="UpnlChooseProduct">
                                            <ContentTemplate>
                                                <asp:ListBox ID="LstSourceProduct" runat="server" Height="200px" Width="250px" DataTextField="value"
                                                    DataValueField="key" SelectionMode="Multiple"></asp:ListBox>
                                            </ContentTemplate>
                                        </asp:UpdatePanel>
                                    </td>
                                    <td align="center">
                                        <asp:UpdatePanel runat="server" ID="UpdatePanel1">
                                            <ContentTemplate>
                                                <asp:Button ID="BtnChoose" runat="server" CausesValidation="false" Text="&gt;&gt;"
                                                    OnClick="BtnChoose_Click" CssClass="inputbutton" /><br />
                                                <br />
                                                <asp:Button ID="BtnDelChoose" runat="server" CausesValidation="false" Text="<<" OnClick="BtnDelChoose_Click" CssClass="inputbutton" />
                                            </ContentTemplate>
                                        </asp:UpdatePanel>
                                    </td>
                                    <td>
                                        <asp:UpdatePanel runat="server" ID="UpdatePanel2">
                                            <ContentTemplate>
                                                <asp:ListBox ID="LstTargetProduct" runat="server" Height="200px" Width="250px" DataTextField="value"
                                                    DataValueField="key" SelectionMode="Multiple"></asp:ListBox>
                                            </ContentTemplate>
                                        </asp:UpdatePanel>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td align="right" class="tdbgleft">
                            需要编辑的字段
                        </td>
                        <td align="left">
                            <asp:ListBox ID="LstField" runat="server" Height="200px" Width="250px" DataTextField="value"
                                DataValueField="key" SelectionMode="Multiple"></asp:ListBox>
                            <pe:RequiredFieldValidator ID="ValrField" ControlToValidate="LstField" runat="server"
                                ValidationGroup="okEdit" SetFocusOnError="true" Display="dynamic" ErrorMessage="请选择需要编辑的字段"
                                ShowRequiredText="false"></pe:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td align="right" class="tdbgleft">
                            编辑方式
                        </td>
                        <td align="left">
                            <asp:RadioButtonList ID="RadlEditType" RepeatDirection="horizontal" runat="server">
                                <asp:ListItem Value="0" Enabled="false">逐一编辑</asp:ListItem>
                                <asp:ListItem Value="1" Selected="true">统一编辑</asp:ListItem>
                            </asp:RadioButtonList>
                        </td>
                    </tr>
                </table>
            </asp:WizardStep>
            <asp:WizardStep ID="WizardStep2" runat="server" Title="Step 2">
                <table width="100%" border="0" cellspacing="1" cellpadding="2" class="border">
                    <tr align="center">
                        <td colspan="2" class="title">
                            <b>商品批量编辑（统一编辑）</b>
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td align="right" class="tdbgleft" style="width: 20%;">
                            <strong>当前编辑的商品：&nbsp; </strong>
                        </td>
                        <td align="left">
                            <asp:DataList RepeatColumns="5" Width="98%" ItemStyle-Width="150px" runat="server"
                                ID="DlstProductList" ItemStyle-HorizontalAlign="left">
                                <ItemStyle Width="20%" />
                                <ItemTemplate>
                                    <%#Eval("value") %>
                                </ItemTemplate>
                            </asp:DataList>
                        </td>
                    </tr>
                    <tr class="tdbg" id="trBarCode" runat="server" visible="false">
                        <td class="tdbgleft" align="right">
                            <strong>条形码：&nbsp; </strong>
                        </td>
                        <td class="tdbg" align="left">
                            <asp:TextBox ID="TxtBarCode" runat="server" Columns="30" MaxLength="80"></asp:TextBox>
                        </td>
                    </tr>
                    <tr class="tdbg" id="trUnit" runat="server" visible="false">
                        <td class="tdbgleft" align="right">
                            <strong>商品单位：&nbsp; </strong>
                        </td>
                        <td class="tdbg" align="left">
                            <pec:ProductUnit ID="ProductUnitPick" runat="server" />
                        </td>
                    </tr>
                    <tr class="tdbg" id="trKeyword" runat="server" visible="false">
                        <td class="tdbgleft" align="right">
                            关键字：
                        </td>
                        <td>
                            <pec:KeywordType ID="KeywordType" runat="server" FieldAlias="关键字" />
                        </td>
                    </tr>
                    <tr class="tdbg" id="trStocksProject" runat="server" visible="false">
                        <td class="tdbgleft" align="right">
                            <strong>前台库存计算方式：&nbsp; </strong>
                        </td>
                        <td class="tdbg" align="left">
                            <asp:RadioButtonList ID="RadlStocksProject" runat="server" RepeatDirection="horizontal">
                                <asp:ListItem Selected="true" Value="0">实际库存</asp:ListItem>
                                <asp:ListItem Value="1">虚拟库存（实际库存－已订购数）</asp:ListItem>
                                <asp:ListItem Value="2">虚拟库存（支付订单时扣除）</asp:ListItem>
                            </asp:RadioButtonList>
                        </td>
                    </tr>
                    <tr class="tdbg" id="trAlarmNum" runat="server" visible="false">
                        <td class="tdbgleft" align="right">
                            <strong>库存报警下限：&nbsp; </strong>
                        </td>
                        <td class="tdbg" align="left">
                            <asp:TextBox ID="TxtAlarmNum" runat="server" Width="40" MaxLength="8"></asp:TextBox>
                            注：多属性商品更新所有属性对应的库存报警下限
                        </td>
                    </tr>
                    <tr class="tdbg" id="trIncludeTax" runat="server" visible="false">
                        <td class="tdbgleft" align="right">
                            <strong>税率设置：&nbsp; </strong>
                        </td>
                        <td class="tdbg" align="left">
                            <pec:TaxRateSetting ID="TaxRateTypeSetting" runat="server" EnableTheming="true" EnableViewState="true"
                                Visible="true" />
                        </td>
                    </tr>
                    <tr class="tdbg" id="trTaxRate" runat="server" visible="false">
                        <td class="tdbgleft" align="right" style="height: 27px">
                            <strong>商品税率：&nbsp; </strong>
                        </td>
                        <td class="tdbg" align="left" style="height: 27px">
                            <asp:TextBox ID="TxtTaxRate" runat="server" Width="40" MaxLength="8"></asp:TextBox>%
                        </td>
                    </tr>
                    <tr class="tdbg" id="trWeight" runat="server" visible="false">
                        <td class="tdbgleft" align="right">
                            <strong>商品重量：&nbsp; </strong>
                        </td>
                        <td class="tdbg" align="left">
                            <asp:TextBox ID="TxtWeight" runat="server" Width="40px" MaxLength="8"></asp:TextBox>
                            千克（Kg）
                        </td>
                    </tr>
                    <tr class="tdbg" id="trProductType" runat="server" visible="false">
                        <td class="tdbgleft" align="right">
                            <strong>商品类型：&nbsp; </strong>
                        </td>
                        <td class="tdbg" align="left">
                            <asp:RadioButtonList ID="RadlProductType" runat="server" RepeatDirection="horizontal">
                                <asp:ListItem Selected="true" Value="0">正常销售</asp:ListItem>
                                <asp:ListItem Value="3">特价处理</asp:ListItem>
                            </asp:RadioButtonList>
                        </td>
                    </tr>
                    <tr class="tdbg" id="trIsNew" runat="server" visible="false">
                        <td class="tdbgleft" align="right">
                            <strong>是否新品：&nbsp; </strong>
                        </td>
                        <td class="tdbg" align="left">
                            <asp:CheckBox ID="ChkIsNew" runat="server" Checked="true" Text="新品" />
                        </td>
                    </tr>
                    <tr class="tdbg" id="trIsHot" runat="server" visible="false">
                        <td class="tdbgleft" align="right">
                            <strong>是否热销：&nbsp; </strong>
                        </td>
                        <td class="tdbg" align="left">
                            <asp:CheckBox ID="ChkIsHot" runat="server" Checked="false" Text="热销" />
                        </td>
                    </tr>
                    <tr class="tdbg" id="trIsBest" runat="server" visible="false">
                        <td class="tdbgleft" align="right">
                            <strong>是否精品：&nbsp; </strong>
                        </td>
                        <td class="tdbg" align="left">
                            <asp:CheckBox ID="ChkIsBest" runat="server" Checked="false" Text="精品" />
                        </td>
                    </tr>
                    <tr class="tdbg" id="trServiceTerm" runat="server" visible="false">
                        <td class="tdbgleft" align="right">
                            <strong>服务期限：&nbsp; </strong>
                        </td>
                        <td class="tdbg" align="left">
                            <asp:TextBox Width="40px" MaxLength="5" ID="TxtServiceTerm" runat="server"></asp:TextBox>
                            <asp:DropDownList ID="DropServiceTermUnit" runat="server">
                                <asp:ListItem Selected="true" Value="0">年</asp:ListItem>
                                <asp:ListItem Value="1">月</asp:ListItem>
                                <asp:ListItem Value="2">日</asp:ListItem>
                            </asp:DropDownList>
                        </td>
                    </tr>
                    <tr class="tdbg" id="trDownloadUrl" runat="server" visible="false">
                        <td class="tdbgleft" align="right">
                            <strong>下载地址：&nbsp; </strong>
                        </td>
                        <td class="tdbg" align="left">
                            <asp:TextBox ID="TxtDownloadUrl" runat="server" MaxLength="200"></asp:TextBox>
                        </td>
                    </tr>
                    <tr class="tdbg" id="trDownloadUrlRemark" runat="server" visible="false">
                        <td class="tdbgleft" align="right">
                            <strong>下载说明：&nbsp; </strong>
                        </td>
                        <td class="tdbg" align="left">
                            <asp:TextBox ID="TxtDownloadUrlRemark" runat="server"></asp:TextBox>
                        </td>
                    </tr>
                    <tr class="tdbg" id="trEnableSale" runat="server" visible="false">
                        <td class="tdbgleft" align="right">
                            <strong>销售操作：&nbsp; </strong>
                        </td>
                        <td class="tdbg" align="left">
                            <asp:CheckBox ID="ChkEnableSale" runat="server" Checked="true" Text="立即销售" />
                        </td>
                    </tr>
                    <tr class="tdbg" id="trProductIntro" runat="server" visible="false">
                        <td class="tdbgleft" align="right">
                            <strong>商品简介：&nbsp; </strong>
                        </td>
                        <td class="tdbg" align="left">
                            用于首页及栏目页显示，不要超过255个字符<br />
                            <asp:TextBox ID="TxtProductIntro" runat="server" TextMode="MultiLine" Columns="67"
                                Rows="38" Height="50px"></asp:TextBox>
                        </td>
                    </tr>
                    <tr class="tdbg" id="trProductExplain" runat="server" visible="false">
                        <td class="tdbgleft" align="right" >
                            <strong>详细介绍：&nbsp; </strong>
                        </td>
                        <td class="tdbg" align="left">
                            <pe:UEditor ID="ProductExplain" runat="server" Width="580px" Height="300px" LinkUpload="true" FlashUpload="true" ImageUpload="true" ModuleName="shop" FileRecord="true">
                            </pe:UEditor>
                        </td>
                    </tr>
                    <pec:ProductPic ID="trProductPic" runat="server" Visible="false" />
                    <tr class="tdbg" id="trProducer" runat="server" visible="false">
                        <td class="tdbgleft" align="right" >
                            <strong>生 产 商：&nbsp; </strong>
                        </td>
                        <td class="tdbg" align="left">
                            <pec:Producer ID="Producer" runat="server" FieldAlias="生 产 商" />
                        </td>
                    </tr>
                    <tr class="tdbg" id="trTrademark" runat="server" visible="false">
                        <td class="tdbgleft" align="right">
                            <strong>品牌/商标：&nbsp; </strong>
                        </td>
                        <td class="tdbg" align="left">
                            <pec:Trademark ID="Trademark" runat="server" FieldAlias="品牌/商标" />
                        </td>
                    </tr>
                    <tr class="tdbg" id="trEnableBuyWhenOutofstock" runat="server" visible="false">
                        <td class="tdbgleft" align="right">
                            <strong>缺货时允许购买：&nbsp; </strong>
                        </td>
                        <td class="tdbg" align="left">
                            <asp:CheckBox ID="ChkEnableBuyWhenOutofstock" runat="server" />
                            &nbsp; 打勾表示缺货时允许购买，否则缺货时不允许购买
                        </td>
                    </tr>
                    <tr class="tdbg" id="trLimitNum" runat="server" visible="false">
                        <td class="tdbgleft" align="right">
                            <strong>限购数量：&nbsp; </strong>
                        </td>
                        <td class="tdbg" align="left">
                            <asp:UpdatePanel ID="UpnlLimitNum" runat="server">
                                <ContentTemplate>
                                    <asp:TextBox ID="TxtLimitNum" runat="server" Width="80" MaxLength="8" Text="0" AutoPostBack="true"
                                        OnTextChanged="TxtLimitNum_TextChanged"></asp:TextBox>
                                    &nbsp; 0为不限制，大于0时，此商品将不允许批发</ContentTemplate>
                            </asp:UpdatePanel>
                        </td>
                    </tr>
                    <tr class="tdbg" id="trStars" runat="server" visible="false">
                        <td class="tdbgleft" align="right" style="height: 27px">
                            <strong>商品推荐等级：&nbsp; </strong>
                        </td>
                        <td class="tdbg" align="left" style="height: 27px">
                            <asp:DropDownList ID="DropStars" runat="server">
                                <asp:ListItem Value="5">★★★★★</asp:ListItem>
                                <asp:ListItem Value="4">★★★★</asp:ListItem>
                                <asp:ListItem Value="3" Selected="True">★★★</asp:ListItem>
                                <asp:ListItem Value="2">★★</asp:ListItem>
                                <asp:ListItem Value="1">★</asp:ListItem>
                            </asp:DropDownList>
                        </td>
                    </tr>
                    <tr class="tdbg" id="trPrice_Market" runat="server" visible="false">
                        <td class="tdbgleft" align="right" >
                            <strong>市场参考价：&nbsp; </strong>
                        </td>
                        <td align="left">
                            <asp:TextBox ID="TxtPrice_Market" Width="60px" MaxLength="10" runat="server"></asp:TextBox>元
                            <br />
                            <pe:RegexValidator ValidateType="PositiveNum" ID="VpnumPrice_Market" ControlToValidate="TxtPrice_Market"
                                SetFocusOnError="true" Display="dynamic" ErrorMessage="市场参考价格式不正确" runat="server"></pe:RegexValidator>
                        </td>
                    </tr>
                    <tr class="tdbg" id="trPrice" runat="server" visible="false">
                        <td class="tdbgleft" align="right" >
                            <strong>当前零售价：&nbsp; </strong>
                        </td>
                        <td align="left">
                            <asp:TextBox ID="TxtPrice" Width="60px" MaxLength="10" runat="server"></asp:TextBox>元
                            <pe:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ControlToValidate="TxtPrice"
                                SetFocusOnError="true" Display="dynamic" ErrorMessage="当前零售价不能为空！"></pe:RequiredFieldValidator>
                            <pe:RegexValidator ValidateType="PositiveNum" ID="VpnumPrice" ControlToValidate="TxtPrice" SetFocusOnError="true"
                                Display="dynamic" ErrorMessage="当前零售价格式不正确" runat="server"></pe:RegexValidator>
                        </td>
                    </tr>
                    <tr class="tdbg" id="trWholesale" runat="server" visible="false">
                        <td class="tdbgleft" align="right">
                            <strong>允许批发：&nbsp; </strong>
                        </td>
                        <td colspan="2">
                            <asp:UpdatePanel ID="UpnlWholesale" runat="server">
                                <ContentTemplate>
                                    <asp:CheckBox ID="ChkEnableWholesale" runat="server" OnCheckedChanged="ChkEnableWholesale_CheckedChanged"
                                        AutoPostBack="true" />
                                    <table cellpadding="0" id="tbWholesale" runat="server" visible="false">
                                        <tr>
                                            <td>
                                                ① 一次性购买此商品数量满<asp:TextBox ID="TxtNumber_Wholesale1" Width="40px" MaxLength="8" Text="10"
                                                    runat="server"></asp:TextBox>时，批发价为<asp:TextBox ID="TxtPrice_Wholesale1" Width="40px"
                                                        runat="server"></asp:TextBox>
                                                元
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                ② 一次性购买此商品数量满<asp:TextBox ID="TxtNumber_Wholesale2" Width="40px" MaxLength="10" Text="50"
                                                    runat="server"></asp:TextBox>时，批发价为<asp:TextBox ID="TxtPrice_Wholesale2" Width="40px"
                                                        runat="server"></asp:TextBox>
                                                元
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                ③ 一次性购买此商品数量满<asp:TextBox ID="TxtNumber_Wholesale3" Width="40px" MaxLength="12" Text="100"
                                                    runat="server"></asp:TextBox>时，批发价为<asp:TextBox ID="TxtPrice_Wholesale3" Width="40px"
                                                        runat="server"></asp:TextBox>
                                                元
                                            </td>
                                        </tr>
                                    </table>
                                </ContentTemplate>
                            </asp:UpdatePanel>
                        </td>
                    </tr>
                    <tr class="tdbg" id="trSingleSell" runat="server" visible="false">
                        <td class="tdbgleft" align="right">
                            <strong>允许单独销售：&nbsp; </strong>
                        </td>
                        <td>
                            <asp:RadioButton ID="RadEnableSingleSell" Checked="true" GroupName="EnableSingleSell"
                                runat="server" />是&nbsp;&nbsp;
                            <asp:RadioButton ID="RadDisabledSingleSell" GroupName="EnableSingleSell" runat="server" />否&nbsp;&nbsp;&nbsp;
                            <span style="color: Blue">如果不允许单独销售，请指定从属的商品。</span>
                        </td>
                    </tr>
                    <tr class="tdbg" id="trDependentProducts" visible="false" runat="server">
                        <td class="tdbgleft" align="right">
                            <strong>从属商品：&nbsp; </strong>
                        </td>
                        <td align="left">
                            <pec:DependentProduct ID="DependentProduct" runat="server" />
                        </td>
                    </tr>
                    <tr class="tdbg" id="trSalePromotion" runat="server" visible="false">
                        <td align="right" class="tdbgleft" >
                            <strong>促销方案：&nbsp;</strong>
                        </td>
                        <td>
                            <pec:SalePromotion runat="server" ID="SalePromotion"></pec:SalePromotion>
                        </td>
                    </tr>
                    <tr class="tdbg" id="trPresentPoint" runat="server" visible="false">
                        <td align="right" class="tdbgleft">
                            <strong>赠送<pe:ShowPointName runat="server" ID="ShowPointName2" PointType="PointName"></pe:ShowPointName>：&nbsp;
                            </strong>
                        </td>
                        <td>
                            购买一件此商品可以得到
                            <asp:TextBox ID="TxtPresentPoint" runat="server" Columns="5"></asp:TextBox>
                            点券<br />
                            买满××元可以得××<pe:ShowPointName runat="server" ID="ShowPointName1" PointType="PointName"></pe:ShowPointName>等更多促销方案，请到“促销方案管理”中设置。
                        </td>
                    </tr>
                    <tr class="tdbg" id="trPresentExp" runat="server" visible="false">
                        <td align="right" class="tdbgleft">
                            <strong>购物积分：&nbsp; </strong>
                        </td>
                        <td>
                            购买一件此商品可以得到
                            <asp:TextBox ID="TxtPresentExp" runat="server" Columns="5" MaxLength="8"></asp:TextBox>
                            积分<br />
                            买满××元可以得××积分等更多促销方案，请到“促销方案管理”中设置。
                        </td>
                    </tr>
                    <tr class="tdbg" id="trPresentMoney" runat="server" visible="false">
                        <td align="right" class="tdbgleft">
                            <strong>赠送现金券：&nbsp;</strong>
                        </td>
                        <td>
                            购买一件此商品可以得到
                            <asp:TextBox ID="TxtPresentMoney" runat="server" Columns="5" MaxLength="8"></asp:TextBox>
                            元现金券<br />
                            买满××元可以得××元现金券等更多促销方案，请到“促销方案管理”中设置。
                        </td>
                    </tr>
                    <tr class="tdbg" id="trEliteLevel" runat="server" visible="false">
                        <td align="right" class="tdbgleft" >
                            <strong>推荐级别：&nbsp; </strong>
                        </td>
                        <td>
                            <asp:TextBox ID="TxtEliteLevel" runat="server" Text="0" MaxLength="8"></asp:TextBox>
                            <pe:RequiredFieldValidator ID="ValrEliteLevel" runat="server" SetFocusOnError="true"
                                Display="Dynamic" ErrorMessage="推荐级别不能为空" ControlToValidate="TxtEliteLevel"></pe:RequiredFieldValidator>
                            <pe:RegexValidator ValidateType="Number" ID="VnumEliteLevel" runat="server" SetFocusOnError="true" ControlToValidate="TxtEliteLevel"
                                Display="Dynamic"></pe:RegexValidator>
                        </td>
                    </tr>
                    <tr class="tdbg" id="trPriority" runat="server" visible="false">
                        <td align="right" class="tdbgleft">
                            <strong>优先级：&nbsp; </strong>
                        </td>
                        <td>
                            <asp:TextBox ID="TxtPriority" runat="server" Text="0" MaxLength="8"></asp:TextBox>
                            <pe:RequiredFieldValidator ID="ValrPriority" runat="server" SetFocusOnError="true"
                                Display="Dynamic" ErrorMessage="优先级不能为空" ControlToValidate="TxtPriority"></pe:RequiredFieldValidator>
                            <pe:RegexValidator ValidateType="Number" ID="VnumPriority" runat="server" SetFocusOnError="true" ControlToValidate="TxtPriority"
                                Display="Dynamic"></pe:RegexValidator>
                        </td>
                    </tr>
                    <tr class="tdbg" id="trHits" runat="server" visible="false">
                        <td align="right" class="tdbgleft">
                            <strong>点击数：&nbsp; </strong>
                        </td>
                        <td>
                            <asp:TextBox ID="TxtHits" runat="server" Text="0" MaxLength="8"></asp:TextBox>
                            <pe:RequiredFieldValidator ID="ValrHits" runat="server" SetFocusOnError="true" Display="Dynamic"
                                ErrorMessage="点击数不能为空" ControlToValidate="TxtHits"></pe:RequiredFieldValidator>
                            <pe:RegexValidator ValidateType="Number" ID="VnumHits" runat="server" SetFocusOnError="true" ControlToValidate="TxtHits"
                                Display="Dynamic"></pe:RegexValidator>
                        </td>
                    </tr>
                    <tr class="tdbg" id="trDayHits" runat="server" visible="false">
                        <td align="right" class="tdbgleft">
                            <strong>日点击数：&nbsp; </strong>
                        </td>
                        <td>
                            <asp:TextBox ID="TxtDayHits" runat="server" Text="0" MaxLength="8"></asp:TextBox>
                            <pe:RequiredFieldValidator ID="ValrDayHits" runat="server" SetFocusOnError="true"
                                Display="Dynamic" ErrorMessage="日点击数不能为空" ControlToValidate="TxtDayHits"></pe:RequiredFieldValidator>
                            <pe:RegexValidator ValidateType="Number" ID="VnumDayHits" runat="server" SetFocusOnError="true" ControlToValidate="TxtDayHits"
                                Display="Dynamic"></pe:RegexValidator>
                        </td>
                    </tr>
                    <tr class="tdbg" id="trWeekHits" runat="server" visible="false">
                        <td align="right" class="tdbgleft">
                            <strong>周点击数：&nbsp; </strong>
                        </td>
                        <td>
                            <asp:TextBox ID="TxtWeekHits" runat="server" Text="0" MaxLength="8"></asp:TextBox>
                            <pe:RequiredFieldValidator ID="ValrWeekHits" runat="server" SetFocusOnError="true"
                                Display="Dynamic" ErrorMessage="周点击数不能为空" ControlToValidate="TxtWeekHits"></pe:RequiredFieldValidator>
                            <pe:RegexValidator ValidateType="Number" ID="VnumWeekHits" runat="server" SetFocusOnError="true" ControlToValidate="TxtWeekHits"
                                Display="Dynamic"></pe:RegexValidator>
                        </td>
                    </tr>
                    <tr class="tdbg" id="trMonthHits" runat="server" visible="false">
                        <td align="right" class="tdbgleft">
                            <strong>月点击数：&nbsp; </strong>
                        </td>
                        <td>
                            <asp:TextBox ID="TxtMonthHits" runat="server" Text="0" MaxLength="8"></asp:TextBox>
                            <pe:RequiredFieldValidator ID="ValrMonthHits" runat="server" SetFocusOnError="true"
                                Display="Dynamic" ErrorMessage="月点击数不能为空" Visible="true" ControlToValidate="TxtMonthHits"></pe:RequiredFieldValidator>
                            <pe:RegexValidator ValidateType="Number" ID="VnumMonthHits" runat="server" SetFocusOnError="true" ControlToValidate="TxtMonthHits"
                                Display="Dynamic"></pe:RegexValidator>
                        </td>
                    </tr>
                    <tr class="tdbg" id="trUpdateTime" runat="server" visible="false">
                        <td align="right" class="tdbgleft">
                            <strong>更新时间：&nbsp; </strong>
                        </td>
                        <td>
                            <pe:DatePicker ID="PickDate" runat="server"></pe:DatePicker>
                            <pe:RequiredFieldValidator ID="ReqPickDate" runat="server" SetFocusOnError="true"
                                ControlToValidate="PickDate" Display="Dynamic" ErrorMessage="日期不能为空"></pe:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr class="tdbg" id="trTemplate" runat="server" visible="false">
                        <td align="right" class="tdbgleft">
                            <strong>内容页模板：&nbsp; </strong>
                        </td>
                        <td>
                            <pe:TemplateSelectControl ID="FscTemplate" runat="server"></pe:TemplateSelectControl>
                        </td>
                    </tr>
                </table>
                <asp:Repeater ID="RepModel" runat="server" OnItemDataBound="RepModel_OnItemDataBound">
                    <HeaderTemplate>
                        <table width="100%" border="0" cellspacing="1" cellpadding="2" class="border">
                    </HeaderTemplate>
                    <ItemTemplate>
                        <tr class="tdbg">
                            <td align="right" class="tdbgleft" style="width:20%">
                                    <strong>
                                        <%# Eval("FieldAlias")%>
                                        ：&nbsp;</strong><br />
                                    <%# Eval("Tips") %>
                            </td>
                            <td>
                                <pe:AdminFieldControl ID="Field" runat="server" EnableNull='<%# (bool)Eval("EnableNull") %>'
                                    FieldAlias='<%# Eval("FieldAlias")%>' Tips='<%# Eval("Tips") %>' FieldName='<%#Eval("FieldName")%>'
                                    ControlType='<%# Eval("FieldType") %>' FieldLevel='<%# Eval("FieldLevel") %>'
                                    Description='<%# Eval("Description")%>' Settings='<%# ((PowerEasy.Module.General.Model.CommonModel.FieldInfo)Container.DataItem).Settings %>'
                                    Value='<%# Eval("DefaultValue") %>'>
                                </pe:AdminFieldControl>
                            </td>
                        </tr>
                    </ItemTemplate>
                    <FooterTemplate>
                        </table>
                    </FooterTemplate>
                </asp:Repeater>
            </asp:WizardStep>
        </WizardSteps>
        <StartNavigationTemplate>
            <center>
                <asp:Button ID="StartNextButton" runat="server" ValidationGroup="okEdit" CommandName="MoveNext"
                    Text="进入编辑" /></center>
        </StartNavigationTemplate>
        <FinishNavigationTemplate>
            <center>
                <asp:Button ID="FinishPreviousButton" runat="server" CausesValidation="False" CommandName="MovePrevious"
                    Text="上一步" />
                <asp:Button ID="FinishButton" runat="server" CommandName="MoveComplete" Text="完成" /></center>
        </FinishNavigationTemplate>
    </asp:Wizard>
</asp:Content>
