﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    CodeBehind="ProductHtml.aspx.cs" Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.ProductHtml"
    Title="商品生成管理" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <asp:ScriptManager ID="ScriptManageContent" runat="server">
    </asp:ScriptManager>
    <div style="padding-top: 5px;">
        <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
    </div>     
    <div>
        <div id="AdminTabs" >
        <ul>
            <!-- CSS Tabs -->
            <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="EliteContentList" />>
                <asp:LinkButton ID="LinkContentList" runat="server"   CommandArgument="100"
                    onclick="ShowBookmarks"><span>所有内容</span></asp:LinkButton>
            </li>
            <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="EliteCreated" />> 
                <asp:LinkButton ID="LinkDraft" runat="server"  CommandArgument="1"
                    onclick="ShowBookmarks"><span>已生成的内容</span></asp:LinkButton>  
            </li>
            <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="EliteUnCreated" />>    
                <asp:LinkButton ID="LinkPending" runat="server" CommandArgument="2"
                    onclick="ShowBookmarks"><span>未生成的内容</span></asp:LinkButton> 
            </li>
        </ul>
        <div class="clearbox2"></div>
    </div>
    <div>
        <table style="width: 100%; margin: 0 auto;" cellpadding="1" cellspacing="1" class="border">
            <tr>
                <td style="width: 80px" align="left" class="tdbg">
                    <b>内容选项：</b>
                </td>
                <td class="tdbg">
                    <asp:DropDownList ID="DrpSearchType" runat="server">
                        <asp:ListItem Value="Title" Text="内容标题" />
                        <asp:ListItem Value="Inputer" Text="录入者" />
                    </asp:DropDownList>
                    <asp:TextBox ID="TxtSearchKeyword" runat="server" />
                    <asp:Button ID="BtnSearch" runat="server" Text="搜索" OnClick="BtnSearch_Click" />
                </td>
                <td align="right" class="tdbg">
                排序方式：
                <asp:DropDownList ID="DropRescentQuery" AutoPostBack="true" OnSelectedIndexChanged="DropSelectedIndex_Changed"
                    runat="server">
                    <asp:ListItem Value="-1">按ID降序</asp:ListItem>
                    <asp:ListItem Value="-2">按ID升序</asp:ListItem>
                    <asp:ListItem Value="1">按推荐级别降序</asp:ListItem>
                    <asp:ListItem Value="2">按推荐级别升序</asp:ListItem>
                    <asp:ListItem Value="3">按优先级别降序</asp:ListItem>
                    <asp:ListItem Value="4">按优先级别升序</asp:ListItem>
                    <asp:ListItem Value="5">按日点击数降序</asp:ListItem>
                    <asp:ListItem Value="6">按日点击数升序</asp:ListItem>
                    <asp:ListItem Value="7">按周点击数降序</asp:ListItem>
                    <asp:ListItem Value="8">按周点击数升序</asp:ListItem>
                    <asp:ListItem Value="9">按月点击数降序</asp:ListItem>
                    <asp:ListItem Value="10">按月点击数升序</asp:ListItem>
                    <asp:ListItem Value="11">按总点击数降序</asp:ListItem>
                    <asp:ListItem Value="12">按总点击数升序</asp:ListItem>
                </asp:DropDownList>
                &nbsp;
            </td>
            </tr>
        </table>
    </div>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    <div style="padding-top: 10px;">
        <pe:ExtendedGridView ID="EgvContents" runat="server" DataSourceID="OdsContents" SerialText=""
            AutoGenerateCheckBoxColumn="True" AutoGenerateColumns="False" AllowPaging="True"
            DataKeyNames="GeneralId" OnRowCommand="EgvContents_RowCommand" OnRowDataBound="EgvContents_RowDataBound"
            CheckBoxFieldHeaderWidth="3%">
            <Columns>
                <pe:BoundField DataField="GeneralId" HeaderText="ID" SortExpression="GeneralId">
                    <HeaderStyle Width="10%" />
                </pe:BoundField>
                <pe:TemplateField HeaderText="标题" SortExpression="Title">
                    <ItemStyle HorizontalAlign="Left" />
                    <ItemTemplate>
                        <div class="linkType">
                            <asp:PlaceHolder ID="PlhLink" runat="server">
                                <div class="link">
                                </div>
                            </asp:PlaceHolder>
                            <asp:Image ID="ImgItemIcon" runat="server" />
                            <asp:HyperLink ID="LnkNodeLink" runat="server"></asp:HyperLink>
                            <asp:HyperLink ID="LnkTitle" runat="server" Text='<%# Eval("Title").ToString().Length <= 20 ? Eval("Title") : Eval("Title").ToString().Substring(0, 20) + ".."%>'></asp:HyperLink>
                        </div>
                    </ItemTemplate>
                </pe:TemplateField>
                <pe:BoundField DataField="Inputer" HeaderText="录入者" SortExpression="Inputer">
                    <HeaderStyle Width="8%" />
                </pe:BoundField>
                <pe:TemplateField HeaderText="已生成" SortExpression="Status">
                    <HeaderStyle Width="7%" />
                    <ItemTemplate>
                        <pe:ExtendedLabel HtmlEncode="false" ID="LblIsCreateHtml" runat="server"></pe:ExtendedLabel>
                    </ItemTemplate>
                </pe:TemplateField>
                <pe:TemplateField HeaderText="生成HTML操作" SortExpression="Disabled">
                    <HeaderStyle Width="25%" />
                    <ItemTemplate>
                        <asp:LinkButton ID="LnkCreateHtml" CommandName="CreateHtml" CommandArgument='<%# Eval("GeneralId") %>'
                            runat="server">生成文件</asp:LinkButton>
                        <asp:HyperLink ID="LnkHtmlView" runat="server" Target="_blank">查看文件</asp:HyperLink>
                        <asp:LinkButton ID="LnkDeleteHtml" CommandName="DeleteHtml" CommandArgument='<%# Eval("GeneralId") %>'
                            runat="server">删除文件</asp:LinkButton>
                    </ItemTemplate>
                </pe:TemplateField>
            </Columns>
        </pe:ExtendedGridView>
        <asp:HiddenField ID="HdnCreated" runat="server" Value="0" />
        <asp:HiddenField ID="HdnListType" runat="server" Value="-1" />
        <asp:HiddenField ID="HdnSearchType" runat="server" Value="" />
        <asp:HiddenField ID="HdnSearchKeyword" runat="server" Value="" />
        <asp:ObjectDataSource ID="OdsContents" runat="server" SelectMethod="GetCreateHtmlCommonModelInfoList"
            TypeName="PowerEasy.Module.General.BusinessLogic.Contents.ContentManage" EnablePaging="True" MaximumRowsParameterName="maxNumberRows"
            StartRowIndexParameterName="startRowIndexId" SelectCountMethod="GetTotalOfCreateHtmlCommonModelInfo">
            <SelectParameters>
                <asp:QueryStringParameter Name="nodeId" QueryStringField="NodeID" Type="Int32" DefaultValue="0" />
                <asp:ControlParameter ControlID="HdnCreated" Type="Int32" Name="created" PropertyName="Value" />
                <asp:ControlParameter ControlID="HdnListType" Type="Int32" Name="sortType" PropertyName="Value" />
                <asp:Parameter DefaultValue="2" Name="modelType" Type="Int32" />
                <asp:ControlParameter ControlID="HdnSearchType" Type="String" Name="searchType" PropertyName="Value" />
                <asp:ControlParameter ControlID="HdnSearchKeyword" Type="String" Name="keyword" PropertyName="Value" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <br />
        <input id="ChkAll" onclick="javascript:CheckAll(this);" type="checkbox" /><label
            for="ChkAll">选中本页显示的所有项目</label>
        &nbsp;&nbsp;
        <asp:Button ID="BtnCreateAll" runat="server" Text="生成所有内容" OnClick="BtnCreateAll_Click" />
        <asp:Button ID="BtnCreate" runat="server" Text="生成选定内容" OnClientClick="return batchconfirm('是否要生成选定的记录？')" OnClick="BtnCreate_Click" />
        <asp:Button ID="BtnDelete" runat="server" OnClientClick="return batchconfirm('是否要删除项目？');"
            Text="删除选定内容的HTML文件" CausesValidation="False" OnClick="BtnDelete_Click" />
    </div>
</asp:Content>
