﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    CodeBehind="ProductImport.aspx.cs" Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.ProductImport"
    ValidateRequest="false" Title="导入商品" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <div style="padding-top: 10px;">
        <pe:ExtendedSiteMapPath ID="SmpNavigator" runat="server" SiteMapProvider="AdminMapProvider">
        </pe:ExtendedSiteMapPath>
    </div>
    <asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    <div style="padding-top: 5px;">
        <asp:Wizard ID="WzdProductImport" Font-Names="Verdana" Font-Size="0.8em" runat="server"
            DisplaySideBar="False" Width="100%" ActiveStepIndex="0" OnFinishButtonClick="WzdProductImport_FinishButtonClick"
            OnNextButtonClick="WzdProductImport_NextButtonClick" FinishCompleteButtonText=" 完 成 "
            CancelButtonText=" 取 消 ">
            <WizardSteps>
                <asp:WizardStep ID="WizardStep1" runat="server" Title="Step 1">
                    <table width="100%" border="0" cellspacing="1" cellpadding="2" class="border">
                        <tr align="center">
                            <td colspan="2" class="title" style="height: 19px">
                                <b>商品批量导入</b>
                            </td>
                        </tr>
                        <tr class="tdbg">
                            <td align="right" class="tdbgleft" style="width: 30%">
                                <strong>导入文件类型&nbsp;：&nbsp;</strong>
                            </td>
                            <td>
                                <strong>
                                    <asp:DropDownList ID="dropFileType" runat="server">
                                        <asp:ListItem Text="动易CSV文件" Value="0"></asp:ListItem>
                                        <asp:ListItem Text="动易EXCEL文件" Value="1"></asp:ListItem>
                                        <asp:ListItem Text="淘宝助理4.X CSV文件" Value="2"></asp:ListItem>
                                        <asp:ListItem Text="拍拍助理 CSV文件" Value="3"></asp:ListItem>
                                        <asp:ListItem Text="有啊助理 CSV文件" Value="4"></asp:ListItem>
                                    </asp:DropDownList>
                                </strong>
                            </td>
                        </tr>
                        <tr class="tdbg">
                            <td align="right" class="tdbgleft" style="width: 30%">
                                <strong>所属节点&nbsp;：&nbsp;</strong>
                            </td>
                            <td>
                                <strong>
                                    <asp:UpdatePanel ID="UpdatePanel1" runat="server">
                                        <ContentTemplate>
                                            <asp:DropDownList ID="DropShopNodeList" runat="server" DataTextField="NodeName" DataValueField="NodeId"
                                                AutoPostBack="True" OnSelectedIndexChanged="DropShopNodeList_SelectedIndexChanged">
                                            </asp:DropDownList>
                                            &nbsp;<strong> 所属模型&nbsp;：&nbsp;</strong><asp:DropDownList ID="DropModelList" runat="server"
                                                DataTextField="ModelName" DataValueField="ModelId">
                                            </asp:DropDownList>
                                        </ContentTemplate>
                                    </asp:UpdatePanel>
                                </strong>
                            </td>
                        </tr>
                        <tr class="tdbg">
                            <td align="right" class="tdbgleft">
                                <strong>所属专题&nbsp;：&nbsp;</strong>
                            </td>
                            <td>
                                <pec:SpecialType ID="SpecialType1" FieldAlias="所属专题" runat="server" />
                            </td>
                        </tr>
                        <tr class="tdbg">
                            <td align="right" style="width: 30%;" class="tdbgleft">
                                <b>选择要导入的数据文件&nbsp;：&nbsp;</b>
                            </td>
                            <td>
                                <asp:FileUpload ID="UpExcellFile" runat="server" Width="400px" />
                            </td>
                        </tr>
                    </table>
                </asp:WizardStep>
                <asp:WizardStep ID="WizardStep2" runat="server" Title="Step 2">
                    <table width="100%" border="0" cellspacing="1" cellpadding="2" class="border">
                        <tr align="center">
                            <td colspan="2" class="title">
                                <b>商品批量导入（选择导入项）</b>
                            </td>
                        </tr>
                        <asp:Repeater ID="RepeaterExcelFields" runat="server" OnItemDataBound="RepeaterExcelFields_ItemDataBound">
                            <ItemTemplate>
                                <tr class="tdbg" runat="server">
                                    <td align="right" style="width: 50%;" class="tdbgleft">
                                        <%--<asp:PlaceHolder ID="PlaceHolderExcelField" runat="server"></asp:PlaceHolder>--%>
                                        <asp:DropDownList ID="DropExcelFields" runat="server">
                                        </asp:DropDownList>
                                        &nbsp;&nbsp;==>&nbsp;&nbsp;
                                    </td>
                                    <td>
                                        &nbsp;&nbsp;&nbsp;<asp:Literal ID="LiteralTableField" runat="server"></asp:Literal>
                                    </td>
                                </tr>
                            </ItemTemplate>
                        </asp:Repeater>
                    </table>
                </asp:WizardStep>
            </WizardSteps>
            <StartNavigationTemplate>
                <center>
                    <br />
                    <asp:Button ID="StartNextButton" runat="server" CommandName="MoveNext" Text="下一步" /></center>
            </StartNavigationTemplate>
            <FinishNavigationTemplate>
                <center>
                    <br />
                    <asp:Button ID="StartPreButton" runat="server" CommandName="MovePrevious" Text="上一步" />
                    <asp:Button ID="FinishButton" runat="server" CommandName="MoveComplete" Text="导入" /></center>
            </FinishNavigationTemplate>
        </asp:Wizard>
        <div id="prompt-note">
            <dl>
                <dt class="prompt-note-tit"><span>温馨提醒</span> </dt>
                <dd class="prompt-note-con">
                    <li>导入动易Excel文件前先<a style="color: Blue; text-decoration: underline;" href="../../Admin/Shop/Products.xls">点此下载《参考模板Excel》</a>，把商品数据复制到模板中即可导入。</li>
                    <li>导入动易CSV文件前先<a style="color: Blue; text-decoration: underline;" href="../../Admin/Shop/Product.csv">点此下载《参考模板CSV》</a>。</li>
                    <li>模板文件中的红色字体为必填项，并注意字段上的批注！</li>
                    <li>CSV文件批量上传的规范，参见Excel模型中的批注和标识！</li>
                    <li>由于批量导入操作比较占用资源，请不要上传过大的文件，建议在服务器访问人数少时进行！</li>
                </dd>
            </dl>
        </div>
    </div>
</asp:Content>
