﻿<%@ Page Language="C#" EnableEventValidation="false" MasterPageFile="~/Admin/MasterPage.master"
    AutoEventWireup="true" Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.ProductManage"
    CodeBehind="ProductManage.aspx.cs" Title="商品管理" %>

<%@ Import Namespace="PowerEasy.Framework.Components" %>
<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
<style type="text/css">
#AdminTabs a {
      min-width:66px;
}
</style>
    <asp:ScriptManager ID="ScriptManageContent" runat="server" />
    <table style="width: 100%; margin: 0 auto;" cellpadding="0" cellspacing="0">
        <tr>
            <td>
                <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
            </td>
            <td align="right">
                <asp:DropDownList ID="DrModelQuery" AutoPostBack="true" OnSelectedIndexChanged="DrModelQuery_Changed" runat="server">
                    <asp:ListItem Value="0">--请选择模型--</asp:ListItem>
                </asp:DropDownList>&nbsp;&nbsp;
                <asp:DropDownList ID="DropRescentQuery" AutoPostBack="true" OnSelectedIndexChanged="DropSelectedIndex_Changed"
                    runat="server">
                    <asp:ListItem Value="-1">按ID降序</asp:ListItem>
                    <asp:ListItem Value="-2">按ID升序</asp:ListItem>
                    <asp:ListItem Value="1">按推荐级别降序</asp:ListItem>
                    <asp:ListItem Value="2">按推荐级别升序</asp:ListItem>
                    <asp:ListItem Value="3">按优先级别降序</asp:ListItem>
                    <asp:ListItem Value="4">按优先级别升序</asp:ListItem>
                    <asp:ListItem Value="5">按日点击数降序</asp:ListItem>
                    <asp:ListItem Value="6">按日点击数升序</asp:ListItem>
                    <asp:ListItem Value="7">按周点击数降序</asp:ListItem>
                    <asp:ListItem Value="8">按周点击数升序</asp:ListItem>
                    <asp:ListItem Value="9">按月点击数降序</asp:ListItem>
                    <asp:ListItem Value="10">按月点击数升序</asp:ListItem>
                    <asp:ListItem Value="11">按总点击数降序</asp:ListItem>
                    <asp:ListItem Value="12">按总点击数升序</asp:ListItem>
                </asp:DropDownList>
                &nbsp;
            </td>
        </tr>
                  <tr>
            <td id="AdminTabs" colspan="2">
                <ul>
                    <!-- CSS Tabs -->
                    <li><asp:DropDownList ID="dropSaleState" AutoPostBack="true" runat="server" OnSelectedIndexChanged="dropSaleState_SelectedIndexChanged">
                        <asp:ListItem Value="20">全部</asp:ListItem>
                        <asp:ListItem Value="21">销售中</asp:ListItem>
                        <asp:ListItem Value="22">停止销售</asp:ListItem>
                        <asp:ListItem Value="31">已售完</asp:ListItem>                        
                                    </asp:DropDownList>&nbsp;&nbsp;
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitAll" />>
                        <asp:LinkButton ID="LinkAll" runat="server" CommandArgument="20"
                             onclick="ShowBookmarks"><span>全部</span></asp:LinkButton>
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitUpToSnuff" />> 
                        <asp:LinkButton ID="LinkUpToSnuff" runat="server" CommandArgument="23"
                             onclick="ShowBookmarks"><span>正价</span></asp:LinkButton>  
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitSpecialPrice" />>    
                        <asp:LinkButton ID="LinkSpecialPrice" runat="server" CommandArgument="24"
                            onclick="ShowBookmarks" ><span>特价</span></asp:LinkButton> 
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitWholesale" />>    
                        <asp:LinkButton ID="LinkWholesale" runat="server" CommandArgument="32"
                            onclick="ShowBookmarks" ><span>批发</span></asp:LinkButton> 
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitHotSale" />>    
                        <asp:LinkButton ID="LinkHotSale" runat="server" CommandArgument="25"
                            onclick="ShowBookmarks" ><span>热销</span></asp:LinkButton> 
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitNew" />>    
                        <asp:LinkButton ID="LinkNew" runat="server" CommandArgument="26"
                            onclick="ShowBookmarks" ><span>新品</span></asp:LinkButton> 
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitBest" />>    
                        <asp:LinkButton ID="LinkBest" runat="server" CommandArgument="27"
                            onclick="ShowBookmarks" ><span>精品</span></asp:LinkButton> 
                    </li>
                      <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitSalesPromotion" />>    
                        <asp:LinkButton ID="LinkSalesPromotion" runat="server" CommandArgument="28"
                            onclick="ShowBookmarks" ><span>促销</span></asp:LinkButton> 
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitSecondskill" />>    
                        <asp:LinkButton ID="LinkSecondskill" runat="server" CommandArgument="33"
                            onclick="ShowBookmarks" ><span>秒杀</span></asp:LinkButton> 
                    </li>
                    <li <pe:ExtendedLiteral HtmlEncode="false" runat="server" ID="LitLimitProduct" />>    
                        <asp:LinkButton ID="LinkLimitProduct" runat="server" CommandArgument="34"
                            onclick="ShowBookmarks" ><span>限时</span></asp:LinkButton> 
                    </li>
                </ul>
            </td>
        </tr>
    </table>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
<div style =" word-break :break-all ; word-wrap:break-word ">
    <pe:ExtendedGridView ID="GdvProductList" runat="server" AutoGenerateColumns="False"
        OnRowDataBound="GdvProductList_RowDataBound" AllowPaging="True" DataSourceID="OdsProductList"
        AutoGenerateCheckBoxColumn="True" OnRowCommand="GdvProductList_RowCommand" DataKeyNames="GeneralId,ProductId,TableName,ProductName"
        ItemName="商品" ItemUnit="个" CheckBoxFieldHeaderWidth="3%" SerialText="" OnDataBound="GdvProductList_DataBound"
        RowDblclickBoundField="GeneralID" RowDblclickUrl="ProductView.aspx?GeneralID={$Field}">
        <Columns>
           <pe:TemplateField HeaderText="操作">
                <ItemTemplate>
                    <pe:DropdownMenu runat="server" ID="ddmenu">
                        <pe:LinkMenuItem ID="ProductModify" SkinID="Edit" runat="server" />
                        <pe:ButtonMenuItem ID="ProductDelete" SkinID="Delete" runat="server" CommandName="DeleteProduct" OnClientClick="if(!this.disabled) return confirm('确实要删除此商品吗（有订单的商品无法删除）？删除后还可以从回收站中还原！');" />
                        <pe:MenuSeparator runat="server" ID="MenuSeparator1"></pe:MenuSeparator>
                        <pe:ButtonMenuItem ID="BMSale" runat="server"  OnCommand="ExecuteSingleCommand" CommandArgument='<%# Eval("GeneralId") %>' />
                        <pe:ButtonMenuItem ID="BMSetHot" runat="server" OnCommand="ExecuteSingleCommand" CommandArgument='<%# Eval("GeneralId") %>' />
                        <pe:ButtonMenuItem ID="BMSetTop" runat="server" OnCommand="ExecuteSingleCommand" CommandArgument='<%# Eval("GeneralId") %>' />
                        <pe:ButtonMenuItem ID="BMSetNew" runat="server" OnCommand="ExecuteSingleCommand" CommandArgument='<%# Eval("GeneralId") %>' />
                        <pe:LinkMenuItem ID="BMPreivew" Text="前台预览" runat="server" NavigateUrl='<%# GetProcutContentPageLink(Eval("GeneralId").ToString()) %>' Target="_blank" />
                    </pe:DropdownMenu>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField DataField="GeneralId" HeaderText="ID" SortExpression="GeneralId" >
                <HeaderStyle Width="5%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="商品图片">
                <ItemStyle HorizontalAlign="center" />
                <ItemTemplate>
                    <pe:ExtendedImage ID="extendedImage" runat="server" />
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="商品名称" SortExpression="ProductName">
                <ItemStyle HorizontalAlign="Left" />
                <ItemTemplate>
                    <pe:LinkImage ID="LinkImageModel" runat="server">
                        <pe:ExtendedHyperLink ID="LnkNodeName" runat="server"></pe:ExtendedHyperLink>
                        <asp:HyperLink ID="LnkProductName" runat="server"></asp:HyperLink>
                    </pe:LinkImage>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField DataField="Unit" HeaderText="单位" SortExpression="Unit">
                <HeaderStyle Width="5%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="库存" SortExpression="Stocks">
                <ItemStyle HorizontalAlign="Right" Width="6%" />
                <ItemTemplate>
                    <%#Eval("Stocks")%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField HeaderText="价格">
                <ItemStyle HorizontalAlign="Right" />
                <HeaderStyle Width="7%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="体验价格">
                <ItemStyle HorizontalAlign="Right" />
                <HeaderStyle Width="7%" />
                <ItemTemplate>
                    <asp:Label ID="LblExpPrice" runat="server"></asp:Label>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="类型" SortExpression="ProductType">
                <HeaderStyle Width="5%" />
                <ItemTemplate>
                    <asp:Label ID="LblProductType" runat="server"></asp:Label>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="推荐级别" SortExpression="EliteLevel">
                <ItemStyle HorizontalAlign="Right" Width="7%" />
                <ItemTemplate>
                    <%#Eval("EliteLevel")%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="商品属性">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <pe:ExtendedLabel HtmlEncode="false" ID="LblProductAttribute" runat="server"></pe:ExtendedLabel>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="销售中" SortExpression="Saling">
                <HeaderStyle Width="6%" />
                <ItemTemplate>
                    <%#(bool)Eval("EnableSale") ? "√" : "<font color=red>×</font>"%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="已生成" SortExpression="Created">
                <HeaderStyle Width="6%" />
                <ItemTemplate>
                    <%# (DateTime)Eval("CreateTime") <= (DateTime)Eval("UpdateTime") ? "<font color=red>×</font>" : "√"%>
                </ItemTemplate>
            </pe:TemplateField>
<%--            <pe:TemplateField HeaderText="操作">
                <HeaderStyle Width="9%" />
                <ItemTemplate>
                    <asp:HyperLink runat="server" ID="LbtnModify" NavigateUrl='<%#string.Format("Product.aspx?Action=Modify&NodeID={0}&GeneralID={1}&ModelID={2}&LinkType={3}",Eval("NodeID"),Eval("GeneralID"),Eval("ModelID"),Eval("LinkType")) %>'
                        Text="修改" />
                    <asp:LinkButton ID="LbtnDelete" runat="server" CommandName="DeleteProduct" OnClientClick="if(!this.disabled) return confirm('确实要删除此商品吗（有订单的商品无法删除）？删除后还可以从回收站中还原！');">删除</asp:LinkButton>
                </ItemTemplate>
            </pe:TemplateField>--%>
        </Columns>
    </pe:ExtendedGridView>
    </div>
    <asp:HiddenField ID="HdnListType" runat="server" Value="-1" />
    <asp:HiddenField ID="HdnStatus" runat="server" Value="100" />
    <asp:HiddenField ID="HdnSearch" runat="server" Value="SpeedSearch" />
    <asp:HiddenField ID="HdnKeyword" runat="server" Value="20" />
    <asp:HiddenField ID="HdnProductType" runat="server" Value="0" />
    <asp:HiddenField ID="HdnProductStatus" runat="server" Value="0" />
    <asp:HiddenField ID="HdnModelID" runat="server" Value="0" />
      
    <asp:ObjectDataSource ID="OdsProductList" runat="server" SelectCountMethod="GetTotalOfAllProducts"
        SelectMethod="GetProductsList" TypeName="PowerEasy.Module.Shop.BusinessLogic.Product" DeleteMethod="Delete"
        EnablePaging="true" StartRowIndexParameterName="startRowIndexId" MaximumRowsParameterName="maxNumberRows">
        <DeleteParameters>
            <asp:Parameter Name="generalId" Type="String" />
        </DeleteParameters>
        <SelectParameters>
            <asp:ControlParameter ControlID="HdnSearch" Type="String" Name="searchType" PropertyName="Value" />
            <asp:ControlParameter ControlID="HdnKeyword" Type="String" Name="keyword" PropertyName="Value" />
            <asp:QueryStringParameter Name="nodeId" QueryStringField="NodeID" Type="Int32" />
            <asp:ControlParameter Name="modelId" ControlID="HdnModelID" Type="Int32" PropertyName="Value" />
            <asp:ControlParameter ControlID="HdnListType" Type="Int32" Name="listType" PropertyName="Value" />
            <asp:ControlParameter ControlID="HdnStatus" Type="Int32" Name="status" PropertyName="Value" />
            <asp:ControlParameter ControlID="HdnProductType" Type="Int32" Name="productType" PropertyName="Value" />
            <asp:ControlParameter ControlID="HdnProductStatus" Type="Int32" Name="productState" PropertyName="Value" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <br />
    <table border="0">
        <tr>
            <td align="left" width="160">
                <input id="ChkAll" onclick="javascript:CheckAll(this);" type="checkbox" /><label
                    for="ChkAll">选中本页显示的所有商品</label>
                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            </td>
            <td align="left">
                <asp:Button ID="BtnStartSale" Width="95px" runat="server" CommandName="BtnStartSale" Text="开始销售"
                    OnClick="ExecuteCommand" />
                <asp:Button ID="BtnSetHot" Width="95px" runat="server" CommandName="BtnSetHot" Text="设为热卖" OnClick="ExecuteCommand" />
                <asp:Button ID="BtnSetBest" Width="95px" runat="server" CommandName="BtnSetBest" Text="设为精品" OnClick="ExecuteCommand" />
                <asp:Button ID="BtnSetNew" Width="95px" runat="server" CommandName="BtnSetNew" Text="设为新品" OnClick="ExecuteCommand" />
                <asp:Button ID="BtnDelete" Width="95px" runat="server" CommandName="BtnDelete" OnClientClick="return batchconfirm('是否要删除记录？')"
                    Text="批量删除" OnClick="ExecuteCommand" />
                <asp:Button ID="BtnBatchMove" Width="95px" OnClientClick="return batchconfirm('确定移动选中的商品？');" runat="server" CommandName="BtnBatchMove"
                    Text="批量移动" OnClick="ExecuteCommand" />
                 <asp:Button ID="BtnBatchSet" Width="95px" runat="server" CommandName="BtnBatchSet" Text="批量设置"
                    OnClick="ExecuteCommand" />
               
                <asp:Button ID="BtnStopSale" Width="95px" runat="server" CommandName="BtnStopSale" Text="停止销售"
                    OnClick="ExecuteCommand" />
                <asp:Button ID="BtnStopHot" Width="95px" runat="server" CommandName="BtnStopHot" Text="取消热卖" OnClick="ExecuteCommand" />
                <asp:Button ID="BtnStopBest" Width="95px" runat="server" CommandName="BtnStopBest" Text="取消精品"
                    OnClick="ExecuteCommand" />
                <asp:Button ID="BtnStopNew" Width="95px" runat="server" CommandName="BtnStopNew" Text="取消新品" OnClick="ExecuteCommand" />
                <pe:OneClickButton IsOneClick="false" ID="BtnExportExcel" Width="95px" runat="server" OnClick="BtnExportExcel_Click" 
                    Text="导出到Excel"  />
                <pe:OneClickButton IsOneClick="false" ID="BtnExportCSV" Width="95px" runat="server" OnClick="BtnExportCSV_Click" 
                    Text="导出到CSV" />
                <asp:Button ID="BtnAddToSpecial" runat="server" CommandName="BtnAddToSpecial" OnClick="ExecuteCommand"
                    Text="添加到专题" Width="95px" />                    
                <asp:Button ID="BtnAddToNode" Width="95px" style="padding:0;" runat="server" CommandName="BtnAddToNode" Text="添加到其他栏目" OnClick="ExecuteCommand" />
                  <pe:OneClickButton IsOneClick="false" ID="BtnExportTaobao" Width="95px" style="padding:0;" 
                    runat="server" CommandName="BtnExportTaobao" Text="导出到淘宝助理" 
                    onclick="BtnExportTaobao_Click"/>
                    <pe:OneClickButton IsOneClick="false" ID="BtnExportPaipai" Width="95px" style="padding:0;" 
                    runat="server" CommandName="BtnExportPaipai" Text="导出到拍拍助理" 
                    onclick="BtnExportPaipai_Click"/>
                    <pe:OneClickButton IsOneClick="false" ID="BtnExportYoua" Width="95px" style="padding:0;" 
                    runat="server" CommandName="BtnExportYoua" Text="导出到有啊助理" 
                    onclick="BtnExportYoua_Click"/>
            </td>
        </tr>
    </table>
     <div style="padding-top: 5px;">
        <table style="width: 100%; margin: 0 auto;" cellpadding="1" cellspacing="1" class="border">
            <tr>
                <td class="tdbg">
                    <table border="0">
                        <tr>
                            <td style="width: 65px">
                                <b>高级查询：</b>
                            </td>
                            <td>
                                <asp:DropDownList ID="DropSearchField" runat="server">
                                    <asp:ListItem Value="ProductId">商品ID</asp:ListItem>
                                    <asp:ListItem Value="ProductName" Selected>商品名称</asp:ListItem>
                                    <asp:ListItem Value="ProductIntro">商品简介</asp:ListItem>
                                    <asp:ListItem Value="ProductExplain">商品介绍</asp:ListItem>
                                    <asp:ListItem Value="ProducerName">厂商</asp:ListItem>
                                    <asp:ListItem Value="TrademarkName">品牌/商标</asp:ListItem>
                                </asp:DropDownList>
                            </td>
                            <td>
                                <asp:TextBox ID="TxtKeyword" runat="server" Text=""></asp:TextBox>
                                <asp:Button ID="BtnSearch" runat="server" Text="搜索" OnClick="BtnSearch_Click" OnClientClick="return CheckKeyword()" />
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
    </div>
    <br />
    <div id="prompt-note">
	    <dl>
	    <dt class="prompt-note-tit">
	    <span>提示说明</span>
	    </dt>
	    <dd class="prompt-note-con">
		    <b>商品属性中的各项含义：</b><br />
            <font color="blue">精</font>----推荐精品，<font color="red">热</font>----热门商品，<font color="green">新</font>----推荐新品，<font
                color="blue">图</font>----有商品缩略图
	    </dd>  
	    </dl>
    </div>
    <br />
    <br />
    <script type="text/javascript">
        function CheckKeyword() {
            var keyword = document.getElementById('<%=TxtKeyword.ClientID %>');
            if (keyword.value == '') {
                alert("请输入搜索关键字！");
                return false;
            }
            return true;        
         }
    </script>
</asp:Content>
