﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="ProductModelFilterField.aspx.cs"
    Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.ProductModelFilterField" Title="城市列表" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>筛选字段列表</title>
    <style type="text/css">
        .field_value
        {
            margin-top:10px;
        }
        
        .field_value li
        {
            width: 45%;
            float: left;
        }
        
        .price_msg
        {
            color: Red;
        }
    </style>
</head>
<body>
    <form id="form1" runat="server">
    <table style="width: 100%; margin: 0 auto;" cellpadding="2" cellspacing="1" class="border">
        <tr align="center">
            <td colspan="3" class="spacingtitle">
                <asp:Literal runat="server">筛选字段列表</asp:Literal>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" align="left"  colspan="3">
                <span style="color:Green">注：页面载入的时候已自动更新商品筛选字段的信息，而价格区间请手动配置</span>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" align="right" style="width: 15%">
                <strong>价格区间：&nbsp;</strong>
            </td>
            <td class="tdbg" align="left">                
                请点此添加价格：<span onclick="$.PriceRange.AddPriceControl()" style='cursor: pointer;'>
                    <img border='0' alt='增加项目' src='<%=BasePath%>Admin/Images/icon_add.gif' align="absmiddle"
                        title='增加项目' /></span>
                <asp:HiddenField ID="HdnPriceValue" runat="server" />
                <ul id="UlContainer">
                    
                </ul>
            </td>
            <td class="tdbg" align="left">
                <div>区间如下：</div>
                <ul id="UlPriceRangeTips">
                </ul>
            </td>
        </tr>
        <asp:Repeater ID="RptFieldAlias" runat="server" OnItemDataBound="RptFieldAlias_ItemDataBound">
            <ItemTemplate>
                <tr class="tdbg">
                    <td class="tdbgleft" align="right" style="width: 15%">
                        <strong>
                            <%#Eval("FieldAlias")%>：&nbsp;</strong>
                    </td>
                    <td class="tdbg" align="left" colspan="2">
                        <asp:Repeater ID="RptFieldValue" runat="server" OnItemDataBound="RptFieldValue_ItemDataBound">
                            <HeaderTemplate>
                                <ul class="field_value">
                            </HeaderTemplate>
                            <ItemTemplate>
                                <li>
                                    <%#Eval("Name")%>(<%#Eval("Count")%>)</li>
                            </ItemTemplate>
                            <FooterTemplate>
                                </ul>
                            </FooterTemplate>
                        </asp:Repeater>
                    </td>
                </tr>
            </ItemTemplate>
        </asp:Repeater>
        <tr class="tdbgbottom">
            <td colspan="3">
                <pe:ExtendedButton ID="EBtnSubmit" Text="保存" OnClick="EBtnSubmit_Click" runat="server" />
            </td>
        </tr>
    </table>
    <script type="text/javascript">
        (function ($) {
            var arrPriceValue = new Array();
            var $HdnPriceValue = $("#HdnPriceValue");
            var $UlContainer = $("#UlContainer");
            $.PriceRange = {
                AddPriceControl: function (initPrice) {
                    var strPrice = "";
                    var strDisabled = "";
                    if (initPrice != null) {
                        strPrice = initPrice;
                        strDisabled = " disabled='disabled' ";
                    }
                    var html = "<li> \n";
                    html += "        <input type=\"text\" size=\"10\" id=\"\" class=\"price_value\" value=\"" + strPrice + "\" " + strDisabled + " /> \n";
                    html += "        <span class=\"price_del\" style=\"cursor: pointer;\"> \n";
                    html += "            <img border=\"0\" alt=\"删除此项目\" src=\"<%=BasePath%>Admin/Images/icon_del.gif\" align=\"absmiddle\" title=\"删除此项目\" /> \n";
                    html += "         </span> \n";
                    html += "        <span class=\"price_msg\"></span> \n";
                    html += "    </li> \n";
                    var $NewLi = $(html);
                    $UlContainer.append($NewLi);

                    //绑定删除事件
                    $NewLi.find(".price_del").click(function () {
                        var $this = $(this);
                        var $TxtPrice = $this.prev();
                        if ($TxtPrice.val() != "") {
                            $.PriceRange.DelPrice(parseInt($TxtPrice.val()));
                        }
                        //$UlContainer.remove("#" + $this.parent().attr("id"));
                        $this.parent().remove();
                    });
                    //绑定文本框事件
                    $NewLi.find(":text").blur(function () {
                        var $this = $(this);
                        var price = parseInt($this.val());
                        //数据校验
                        if (isNaN(price)) {
                            $this.siblings(".price_msg").text("请填写正整数！"); //设定提示
                            $this.val("").focus();
                            return;
                        }
                        if ($.PriceRange.IsInArrPriceValue(price)) {
                            $this.siblings(".price_msg").text("已有该价格！"); //设定提示
                            $this.val("").focus();
                            return;
                        }

                        //校验成功
                        $this.val(price).attr("disabled", "disabled");

                        $.PriceRange.AddPrice(price);

                    }).keydown(function (e) {
                        var $this = $(this);
                        $this.siblings(".price_msg").text("");
                        if ((e.which && e.which == 13) || (e.keyCode && e.keyCode == 13)) {
                            $this.blur();
                            return false;
                        }
                    });
                },
                AddPrice: function (price) {
                    arrPriceValue.push(price);
                    $HdnPriceValue.val(arrPriceValue.join("|"));
                    $.PriceRange.SortPriceRange(); //按价格排序控件
                    $.PriceRange.BuildTips(); //排序过后，生成提示
                },
                DelPrice: function (price) {
                    arrPriceValue = $.grep(arrPriceValue, function (item, i) {
                        return item != price;
                    });
                    $HdnPriceValue.val(arrPriceValue.join("|"));
                    $.PriceRange.BuildTips(); //生成提示
                },
                BuildTips: function () {
                    var $UlPriceRangeTips = $("#UlPriceRangeTips");
                    $UlPriceRangeTips.empty(); //清空旧提示
                    if (arrPriceValue.length == 0) {
                        $UlPriceRangeTips.append("<li>没有设置价格区间!</li>");
                    }
                    else {
                        var htmlTips = "";
                        for (var i = 0; i < arrPriceValue.length; i++) {
                            if (i == 0) {
                                htmlTips += "<li>0~" + (arrPriceValue[i] - 1) + "元</li>";
                            }
                            else {
                                htmlTips += "<li>" + arrPriceValue[i - 1] + "~" + (arrPriceValue[i] - 1) + "元</li>";
                            }

                            if (i == arrPriceValue.length - 1) {
                                htmlTips += "<li>" + arrPriceValue[i] + "元以上</li>";
                            }
                        }
                        $UlPriceRangeTips.append(htmlTips);
                    }
                },
                SortPriceRange: function () {
                    arrPriceValue = arrPriceValue.sort(function (value1, value2) {
                        return parseInt(value1) - parseInt(value2);
                    });
                    for (var i = 0; i < arrPriceValue.length; i++) {
                        var $LiCurrent = $UlContainer.find("li :text[value=" + arrPriceValue[i] + "]").parent();
                        $UlContainer.append($LiCurrent);
                    }
                },
                IsInArrPriceValue: function (price) {
                    for (var i = 0; i < arrPriceValue.length; i++) {
                        if (arrPriceValue[i] == price) {
                            return true;
                        }
                    }
                    return false;
                },
                Init: function (strPriceValue) {
                    arrPriceValue = strPriceValue.split('|');
                    $HdnPriceValue.val(strPriceValue);
                    for (var i = 0; i < arrPriceValue.length; i++) {
                        $.PriceRange.AddPriceControl(arrPriceValue[i]);
                    }
                    $.PriceRange.BuildTips();
                }
            }
        })(jQuery);


    </script>
    </form>
</body>
</html>
