﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    Codebehind="ProductModelManage.aspx.cs" Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.ProductModelManage"
    Title="商品模型管理" %>

<asp:Content ID="Content3" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="CphContent" runat="Server">
    <pe:ExtendedGridView ID="EgvModel" runat="server" AutoGenerateColumns="False" DataKeyNames="ModelID"
        DataSourceID="OdsModel" ItemName="模型" ItemUnit="个" SerialText="" OnRowCommand="EgvModel_RowCommand"
        CheckBoxFieldHeaderWidth="3%" RowDblclickBoundField="ModelID" RowDblclickUrl="ProductModel.aspx?Action=Modify&amp;ModelID={$Field}">
        <Columns>
            <pe:BoundField DataField="ModelID" HeaderText="ID">
                <HeaderStyle Width="5%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="图标">
                <HeaderStyle Width="5%" />
                <ItemTemplate>
                    <asp:Image ID="ImgItemIcon" runat="server" ImageUrl='<%#"~/Images/ModelIcon/" + (string.IsNullOrEmpty(Eval("ItemIcon").ToString())?"Product.gif":Eval("ItemIcon").ToString()) %>' />
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="模型名称" SortExpression="ModelName">
                <HeaderStyle Width="15%" />
                <ItemTemplate>
                    <a href='ProductModel.aspx?Action=Modify&ModelID=<%#Eval("ModelID") %>'>
                        <%# Eval("ModelName").ToString().Length <= 10 ? Eval("ModelName") : Eval("ModelName").ToString().Substring(0, 10) + ".."%>
                    </a>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="模型描述" SortExpression="IsCountHits">
                <ItemTemplate>
                    <%# Eval("Description").ToString()%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="项目名称" SortExpression="ItemName">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <%# Eval("ItemName").ToString().Length <= 10 ? Eval("ItemName") : Eval("ItemName").ToString().Substring(0, 10) + ".."%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField DataField="TableName" HeaderText="表名" SortExpression="TableName" >
                <ItemStyle HorizontalAlign="Center" />
                <HeaderStyle Width="10%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="状态" SortExpression="Disabled">
                <HeaderStyle Width="5%" />
                <ItemTemplate>
                    <%# (bool)Eval("Disabled") ? "<span style='color:Red'>已禁用</span>" : "正常"%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="管理操作">
                <HeaderStyle Width="30%" />
                <ItemTemplate>
                    <a href='<%# "ProductModel.aspx?Action=Modify&ModelID=" + Eval("ModelID")%>'>修改</a>
                    <asp:LinkButton ID="ELbtnDisabled" Text='<%# (bool)Eval("Disabled") ? "启用" : "禁用"%>'
                        runat="server" CommandName='<%# (bool)Eval("Disabled") ? "Enabled" : "Disabled"%>'
                        CommandArgument='<%# Eval("ModelID")%>' />
                    <a href='<%# AppendSecurityCode("ProductModelManage.aspx?Action=Delete&ModelID=" + Eval("ModelID"))%>'
                        onclick="return confirm('是否删除该模型？');" runat="server">删除</a> <a href='<%# "~/Admin/CommonModel/FieldManage.aspx?ModelType=2&ModelID=" + Eval("ModelID")+"&ModelName="+Server.UrlEncode(Eval("ModelName").ToString())%>'
                            runat="server">字段列表</a> <a href='<%# AppendSecurityCode("~/Admin/CommonModel/ModelTemplate.aspx?Action=AddModelToFieldTemplate&ModelType=2&ModelID=" + Eval("ModelID")+"&ModelName="+Server.UrlEncode(Eval("ModelName").ToString()))%>'
                                runat="server">存为模型模板</a>
                </ItemTemplate>
            </pe:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <asp:ObjectDataSource ID="OdsModel" runat="server" SelectMethod="GetShopModelList"
        TypeName="PowerEasy.Module.General.BusinessLogic.CommonModel.ModelManager">
        <SelectParameters>
            <asp:Parameter DefaultValue="0" Name="showType" Type="Int32" />
        </SelectParameters>
    </asp:ObjectDataSource>
</asp:Content>
