﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    CodeBehind="ProductRecycle.aspx.cs" Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.ProductRecycle"
    Title="商品回收站管理" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <div style="padding-top: 5px;">
        <pe:ExtendedSiteMapPath ID="SmpNavigator" runat="server" SiteMapProvider="AdminMapProvider">
        </pe:ExtendedSiteMapPath>
    </div>
    <asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
    <div style="padding-top: 10px;">
        <table style="width: 100%;" cellpadding="2" cellspacing="1" class="border">
            <tr>
                <td style="width: 80px" align="left" class="tdbg">
                    <b>搜索：</b>
                </td>
                <td class="tdbg">
                    <asp:DropDownList ID="DrpSearchType" runat="server">
                        <asp:ListItem Value="ProductName">商品名称</asp:ListItem>
                        <asp:ListItem Value="Inputer">录入者</asp:ListItem>
                    </asp:DropDownList>
                    <asp:TextBox ID="TxtSearchKeyword" runat="server" />
                    <asp:Button ID="BtnSearch" runat="server" Text="搜索" OnClick="BtnSearch_Click" />
                </td>
                <td align="right" class="tdbg" valign="bottom">
                    排序方式：
                    <asp:DropDownList ID="DropRescentQuery" AutoPostBack="true" OnSelectedIndexChanged="DropRescentQuerySelectedIndex_Changed"
                        runat="server">
                        <asp:ListItem Value="-1">按ID降序</asp:ListItem>
                        <asp:ListItem Value="-2">按ID升序</asp:ListItem>
                        <asp:ListItem Value="1">按推荐级别降序</asp:ListItem>
                        <asp:ListItem Value="2">按推荐级别升序</asp:ListItem>
                        <asp:ListItem Value="3">按优先级别降序</asp:ListItem>
                        <asp:ListItem Value="4">按优先级别升序</asp:ListItem>
                        <asp:ListItem Value="5">按日点击数降序</asp:ListItem>
                        <asp:ListItem Value="6">按日点击数升序</asp:ListItem>
                        <asp:ListItem Value="7">按周点击数降序</asp:ListItem>
                        <asp:ListItem Value="8">按周点击数升序</asp:ListItem>
                        <asp:ListItem Value="9">按月点击数降序</asp:ListItem>
                        <asp:ListItem Value="10">按月点击数升序</asp:ListItem>
                        <asp:ListItem Value="11">按总点击数降序</asp:ListItem>
                        <asp:ListItem Value="12">按总点击数升序</asp:ListItem>
                    </asp:DropDownList>
                    &nbsp;
                </td>
            </tr>
        </table>
    </div>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    <div style="padding-top: 10px;">
        <pe:ExtendedGridView ID="EgvContentRecycle" runat="server" AllowPaging="True" AutoGenerateCheckBoxColumn="True"
            AutoGenerateColumns="False" CheckBoxFieldHeaderWidth="3%" DataKeyNames="GeneralId"
            DataSourceID="OdsContents" OnRowCommand="EgvContentRecycle_RowCommand" OnRowDataBound="EgvContentRecycle_RowDataBound"
            SerialText="" RowDblclickBoundField="GeneralID" RowDblclickUrl="ProductView.aspx?GeneralID={$Field}">
            <Columns>
                <pe:BoundField DataField="GeneralId" HeaderText="ID" SortExpression="GeneralId">
                    <HeaderStyle Width="5%" />
                </pe:BoundField>
                <pe:TemplateField HeaderText="标题" SortExpression="Title">
                    <ItemStyle HorizontalAlign="Left" />
                    <HeaderStyle Width="30%" />
                    <ItemTemplate>
                        <div class="linkType">
                            <asp:PlaceHolder ID="PlhLink" runat="server">
                                <div class="link">
                                </div>
                            </asp:PlaceHolder>
                            <asp:Image ID="ImgItemIcon" runat="server" />
                            <pe:ExtendedHyperLink ID="LnkNodeLink" runat="server" />
                            <asp:HyperLink ID="LnkTitle" runat="server" Text='<%# Eval("Title").ToString().Length <= 20 ? Eval("Title") : Eval("Title").ToString().Substring(0, 20) + ".."%>'></asp:HyperLink>
                        </div>
                    </ItemTemplate>
                </pe:TemplateField>
                <pe:BoundField DataField="Inputer" HeaderText="录入者" SortExpression="Inputer">
                    <HeaderStyle Width="8%" />
                </pe:BoundField>
                <pe:BoundField DataField="Hits" HeaderText="点击数" SortExpression="Hits">
                    <HeaderStyle Width="8%" />
                </pe:BoundField>
                <pe:BoundField DataField="EliteLevel" HeaderText="推荐级别" SortExpression="EliteLevel">
                    <HeaderStyle Width="10%" />
                </pe:BoundField>
                <pe:BoundField DataField="Priority" HeaderText="优先级" SortExpression="Priority">
                    <HeaderStyle Width="8%" />
                </pe:BoundField>
                <pe:TemplateField HeaderText="状态" SortExpression="Status">
                    <HeaderStyle Width="8%" />
                    <ItemTemplate>
                        <asp:Label ID="LabStatus" runat="server"></asp:Label>
                    </ItemTemplate>
                </pe:TemplateField>
                <pe:TemplateField HeaderText="已生成" SortExpression="Status">
                    <HeaderStyle Width="8%" />
                    <ItemTemplate>
                        <pe:ExtendedLabel ID="LblIsCreateHtml" HtmlEncode="false" runat="Server"></pe:ExtendedLabel>
                    </ItemTemplate>
                </pe:TemplateField>
                <pe:TemplateField HeaderText="常规管理操作" SortExpression="Disabled">
                    <HeaderStyle Width="15%" />
                    <ItemTemplate>
                        <asp:LinkButton ID="DeleteContent" runat="server" CommandArgument='<%# Eval("GeneralId")%>'
                            CommandName="DeleteContent" OnClientClick="if(!this.disabled) return confirm('确实要彻底删除该信息吗？彻底删除后将无法还原！');">彻底删除</asp:LinkButton>
                        <asp:LinkButton ID="RestoreContent" runat="server" CommandArgument='<%# Eval("GeneralId")%>'
                            CommandName="RestoreContent">还原</asp:LinkButton>
                    </ItemTemplate>
                </pe:TemplateField>
            </Columns>
        </pe:ExtendedGridView>
        <asp:HiddenField ID="HdnListType" runat="server" Value="-1" />
        <asp:HiddenField ID="HdnStatus" runat="server" Value="-3" />
        <asp:HiddenField ID="HdnSearchType" runat="server" Value="" />
        <asp:HiddenField ID="HdnSearchKeyword" runat="server" Value="" />
        <asp:ObjectDataSource ID="OdsContents" runat="server" EnablePaging="True" MaximumRowsParameterName="maxNumberRows"
            SelectCountMethod="GetTotalOfCommonModelInfo" SelectMethod="GetCommonModelInfoListByShop"
            StartRowIndexParameterName="startRowIndexId" TypeName="PowerEasy.Module.General.BusinessLogic.Contents.ContentManage">
            <SelectParameters>
                <asp:QueryStringParameter Name="nodeId" QueryStringField="NodeID" Type="Int32" />
                <asp:ControlParameter ControlID="HdnListType" Name="sortType" PropertyName="Value"
                    Type="Int32" />
                <asp:ControlParameter ControlID="HdnStatus" Name="status" PropertyName="Value" Type="Int32" />
                <asp:ControlParameter ControlID="HdnSearchType" Type="String" Name="searchType" PropertyName="Value" />
                <asp:ControlParameter ControlID="HdnSearchKeyword" Type="String" Name="keyword" PropertyName="Value" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <br />
        <input id="ChkAll" onclick="javascript:CheckAll(this);" type="checkbox" />
        <label for="ChkAll">
            选中本页显示的所有项目</label>
        &nbsp;&nbsp;
        <asp:Button ID="EBtnDelete" runat="server" CausesValidation="false" OnClick="EBtnDelete_Click"
            OnClientClick="return batchconfirm('确定彻底删除选中的信息吗？彻底删除后将无法还原！');" 
            Text="彻底删除选定的商品" />
        <%--<pe:ExtendedButton ID="EBtnDelRecycle" Text="清空回收站" IsChecked="true" OperateCode="ContentManage"
        OnClientClick="if(!this.disabled) return confirm('确定要清空回收站吗？一旦清空将不能恢复！');" OnClick="EEBtnDelRecycle_Click"
        runat="server" />--%>
        <asp:Button ID="EBtnRestore" OnClientClick="return batchconfirm('确定还原选定的信息吗？');"
            runat="server" OnClick="EBtnRestore_Click" Text="还原选定的商品" />
    &nbsp;<asp:Button ID="EBtnDeleteAll" runat="server" CausesValidation="false" OnClick="EBtnDeleteAll_Click"
            OnClientClick="if(!this.disabled) return confirm('确定要清空回收站吗？一旦清空将不能恢复！');" 
            Text="清空回收站" />
        &nbsp;<asp:Button ID="EBtnRestoreAll" runat="server" CausesValidation="false" OnClick="EBtnRestoreAll_Click" 
            Text="还原所有的商品" />
    </div>
</asp:Content>
