﻿<%@ Page Language="C#" AutoEventWireup="true" Codebehind="ProductShow.aspx.cs" Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.ProductShow" Title="商品列表" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>商品选择</title>

    <script type="text/javascript">
        function ReturnValue(productId,productName,rowindex)
        {
            var dropProperty = document.getElementById(rowindex+"_DropProperty");
            var property ='';
            if(dropProperty != null)
            {
                property = dropProperty.options[dropProperty.selectedIndex].text;
            }
            parent.AddProduct(productId,productName,escape(property),0);
        }
        
        function CheckKeyword()
        {
            var dropSearchField = document.getElementById('DropSearchField');
            var txtKeyword = document.getElementById('TxtKeyword').value;
            if(dropSearchField.selectedIndex==0)
            {
                alert("请选择要查找的字段！");
                return false;
            }else if(txtKeyword =='关键字')
            {
                alert("请输入搜索的关键字！");
                return false;
            }
            return true;
            
        }
    </script>

</head>
<body>
    <form id="form1" runat="server">
        <div id="dHTMLADPreview" style="z-index: 1000; left: 0px; visibility: hidden; width: 10px;
            position: absolute; top: 0px; height: 10px">
        </div>
            <script type="text/javascript" src="<%=BasePath%>Admin/JS/Popup.js"></script>
 <table width="100%" border="0" style="text-align: center" cellpadding="2" cellspacing="0"
                class="border">
                <tr class="title">
                    <td style="text-align: right;">
                        查找商品：<asp:DropDownList ID="DropSearchField" runat="server">
                            <asp:ListItem Value="">请选择</asp:ListItem>
                            <asp:ListItem Value="ProductName">商品名称</asp:ListItem>
                            <asp:ListItem Value="ProductIntro">商品简介</asp:ListItem>
                            <asp:ListItem Value="ProductExplain">商品介绍</asp:ListItem>
                            <asp:ListItem Value="ProducerName">厂商</asp:ListItem>
                            <asp:ListItem Value="TrademarkName">品牌/商标</asp:ListItem>
                        </asp:DropDownList>&nbsp;
                        <asp:TextBox ID="TxtKeyword" runat="server" Text="关键字" onfocus="select()"></asp:TextBox>&nbsp;
                        <asp:Button ID="Button1" runat="server" OnClick="BtnSearch_Click" Text="搜索" OnClientClick="return CheckKeyword()" />&nbsp;</td>
                </tr>
            </table>   
        <div style="width:100%; height:360px">
         <pe:ExtendedGridView ID="GdvProductList" runat="server" AllowPaging="True" AutoGenerateColumns="False"
            CheckBoxFieldHeaderWidth="3%" DataKeyNames="GeneralId,ProductId,TableName,ProductName"
            DataSourceID="OdsProductList" IsHoldState="True" ItemName="商品" ItemUnit="个" SerialText=""
            OnRowDataBound="GdvProductList_RowDataBound" PageSize="15">
            <Columns>
                <asp:TemplateField HeaderText="商品名称" SortExpression="ProductName">
                    <itemstyle horizontalalign="Left" />
                    <itemtemplate>
                        <div class="linkType">    
                            <pe:LinkImage ID="LinkImageModel" runat="server">
                            <pe:ExtendedLabel ID="LblProductName" runat="server" HtmlEncode="false"></pe:ExtendedLabel>
                            </pe:LinkImage>
                        </div>
                    </itemtemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="商品属性"></asp:TemplateField>
                <asp:TemplateField HeaderText="库存">
                    <ItemStyle HorizontalAlign="Right" />
                    <ItemTemplate>
                        <asp:Label ID="LblStocks" runat="server" Text='<%# Bind("Stocks") %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField DataField="Unit" HeaderText="单位"  SortExpression="Unit">
                </asp:BoundField>
                <asp:TemplateField HeaderText="价格" SortExpression="Price">
                    <itemstyle horizontalalign="Right" />
                    <itemtemplate>
                    <asp:Label  ID="LblProductPrice" runat="server" Text=""></asp:Label>
                
</itemtemplate>
                </asp:TemplateField>
            </Columns>
        </pe:ExtendedGridView>
        </div>        


        <asp:ObjectDataSource ID="OdsProductList" runat="server" SelectMethod="GetProductsList"
            TypeName="PowerEasy.Module.Shop.BusinessLogic.Product" EnablePaging="True" MaximumRowsParameterName="maxNumberRows"
            SelectCountMethod="GetTotalOfAllProducts" StartRowIndexParameterName="startRowIndexId">
            <SelectParameters>
                <asp:ControlParameter ControlID="HdnSearch" Name="searchType" PropertyName="Value"
                    Type="String" />
                <asp:ControlParameter ControlID="HdnKeyword" Name="keyword" PropertyName="Value"
                    Type="String" />
                <asp:QueryStringParameter Name="nodeId" QueryStringField="NodeID" Type="Int32" />
                <asp:Parameter DefaultValue="0" Name="listType" Type="Int32" />
                <asp:Parameter DefaultValue="99" Name="status" Type="Int32" />
                <asp:ControlParameter ControlID="HdnProductType" Type="Int32" Name="productType" PropertyName="Value" />
                <asp:Parameter DefaultValue="0" Type="Int32" Name="productState"/>
            </SelectParameters>
        </asp:ObjectDataSource>
        <asp:HiddenField ID="HdnSearch" runat="server" Value="SpeedSearch" />
        <asp:HiddenField ID="HdnKeyword" runat="server" Value="20" />
        <asp:HiddenField ID="HdnProductType" runat="server" Value="0" />
    </form>
    <script type="text/javascript">
        function SelectProperty(obj)
        {
            var label = document.getElementById(obj.id.replace("DropProperty","LblStocks"));
            label.innerHTML = obj.options[obj.selectedIndex].value;
        }
    </script>
</body>
</html>
