﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" Title="供应商管理" AutoEventWireup="true"
    CodeBehind="ProviderManage.aspx.cs" Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.ProviderManage" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    <pe:ExtendedGridView ID="EgvProvider" runat="server" AllowPaging="True" AutoGenerateColumns="False"
        AutoGenerateCheckBoxColumn="True" DataKeyNames="ProviderId" DataSourceID="OdsProvider"
        ItemName="供应商" ItemUnit="个" OnRowCommand="EgvProvider_RowCommand" RowDblclickBoundField="ProviderId"
        RowDblclickUrl="Provider.aspx?Action=Modify&ProviderId={$Field}">
        <Columns>
            <pe:BoundField DataField="ProviderId" HeaderText="供应商ID" SortExpression="ProviderId" />
            <pe:BoundField DataField="ProviderName" HeaderText="名称" SortExpression="ProviderName" />
            <pe:TemplateField HeaderText="录入者" SortExpression="Inputer">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                        <%# Eval("Inputer")%>
                </ItemTemplate>
            </pe:TemplateField>
            <asp:BoundField DataField="InputTime" DataFormatString="{0:yyyy-MM-dd HH:mm:ss}"
                HeaderText="录入时间" HtmlEncode="False" SortExpression="InputTime">
                <HeaderStyle Width="15%" />
            </asp:BoundField>
            <asp:TemplateField HeaderText="备注" SortExpression="Remark">
                <ItemStyle HorizontalAlign="Left" />
                <ItemTemplate>
                    <asp:Label ID="lblRemark" runat="server" Text='<%# PowerEasy.Framework.Common.StringHelper.SubString(Eval("Remark").ToString(),30,"...") %>'
                        ToolTip='<%# Eval("Remark") %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <pe:TemplateField HeaderText="操作">
                <HeaderStyle Width="20%" />
                <ItemTemplate>
                    <pe:ExtendedAnchor IsChecked="true" runat="server" OperateCode="ProviderManage" href='<%# Eval("ProviderId","Provider.aspx?Action=Modify&ProviderId={0}") %>'>
                        修改</pe:ExtendedAnchor>
                    <pe:ExtendedLinkButton IsChecked="true" OperateCode="ProviderManage" ID="LbtnDelete"
                        runat="server" CausesValidation="False" CommandArgument='<%# Eval("ProviderId") %>'
                        CommandName="Del" OnClientClick="return confirm('是否删除该供应商？')">删除</pe:ExtendedLinkButton>
                </ItemTemplate>
            </pe:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <asp:ObjectDataSource ID="OdsProvider" runat="server" SelectCountMethod="GetTotalOfProvider"
        SelectMethod="GetList" TypeName="PowerEasy.Module.Shop.BusinessLogic.Provider" EnablePaging="True"
        StartRowIndexParameterName="startRowIndexId" MaximumRowsParameterName="maxNumberRows">
        <SelectParameters>
            <asp:QueryStringParameter Name="searchType" QueryStringField="SearchType" Type="String" />
            <asp:QueryStringParameter Name="keyword" QueryStringField="KeyWord" Type="String" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <br />
    &nbsp;&nbsp;
    <pe:ExtendedButton IsChecked="true" OperateCode="ProviderManage" ID="BtnDelete" runat="server"
        OnClientClick="return batchconfirm('是否要删除记录？')" Text="删除选中的供应商" OnClick="BtnDelete_Click" />
    <br />
</asp:Content>
