﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.RefundUI" Title="录入订单退款信息"
    CodeBehind="Refund.aspx.cs" Async="true" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <asp:ScriptManager runat="server" ID="SmgeRefund">
    </asp:ScriptManager>
    <table width="100%" border="0" cellpadding="2" cellspacing="1" class="border">
        <tr align="center">
            <td colspan="2" class="spacingtitle">
                <b>添加订单退款信息</b>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 15%" class="tdbgleft" align="right">
                客户名称：
            </td>
            <td>
                <asp:Label ID="LblClientName" runat="server"></asp:Label><asp:HiddenField ID="HdnClientId"
                    runat="server" />
                &nbsp;
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft" style="width: 15%;">
                用户名：
            </td>
            <td>
                <asp:Label ID="LblUserName" runat="server"></asp:Label>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft" style="width: 15%">
                支付内容：
            </td>
            <td>
                <table>
                    <tr class="tdbg">
                        <td style="width: 15%" class="tdbgleft" align="right">
                            订单编号：
                        </td>
                        <td>
                            <asp:Label ID="LblOrderNum" runat="server"></asp:Label>
                            <asp:HiddenField ID="HdnOrderId" runat="server" />
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td style="width: 15%" class="tdbgleft" align="right">
                            订单金额：
                        </td>
                        <td>
                            <asp:Label ID="LblMoneyTotal" runat="server"></asp:Label>元
                        </td>
                    </tr>
                    <tr class="tdbg">
                        <td style="width: 15%; height: 23px;" class="tdbgleft" align="right">
                            已 付 款：
                        </td>
                        <td style="height: 23px">
                            <asp:Label ID="LblMoneyReceipt" runat="server"></asp:Label>元
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 15%" class="tdbgleft" align="right">
                退款时间：
            </td>
            <td>
                <pe:DatePicker ID="DpkRefundDate" IsLongDate="true" runat="server"></pe:DatePicker>
                <pe:RequiredFieldValidator ID="ValrRefundDate" runat="server" ControlToValidate="DpkRefundDate"
                    ErrorMessage="请输入退款时间" Display="Dynamic" SetFocusOnError="True"></pe:RequiredFieldValidator><pe:RegexValidator
                        ValidateType="Date" ID="VdateRefundDate" ControlToValidate="DpkRefundDate" runat="server"
                        Display="Dynamic" SetFocusOnError="True"></pe:RegexValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 15%" class="tdbgleft" align="right">
                手续费：
            </td>
            <td>
                <asp:UpdatePanel ID="UpnHandlingCharge" runat="server" RenderMode="Inline">
                    <ContentTemplate>
                        <asp:TextBox ID="TxtHandlingCharge" AutoPostBack="true" OnTextChanged="TxtHandlingCharge_TextChanged"
                            Text="0" runat="server" Width="100px" MaxLength="10"></asp:TextBox>元
                    </ContentTemplate>
                </asp:UpdatePanel>
                <pe:RegexValidator ValidateType="PositiveNum" ID="VHandlingCharge" ControlToValidate="TxtHandlingCharge"
                    SetFocusOnError="true" Display="dynamic" runat="server" ErrorMessage="输入的金额不正确！"></pe:RegexValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 15%" class="tdbgleft" align="right">
                退款金额：
            </td>
            <td>
                <asp:UpdatePanel ID="UpnMoney" runat="server">
                    <ContentTemplate>
                        <asp:TextBox ID="TxtMoney" runat="server" Width="100px" MaxLength="10"></asp:TextBox>
                        元
                        <pe:RequiredFieldValidator ID="ValrMoney" ControlToValidate="TxtMoney" SetFocusOnError="true"
                            Display="dynamic" runat="server" ErrorMessage="请输入退款金额" ></pe:RequiredFieldValidator>
                        <pe:RegexValidator ValidateType="Money" ID="VmoneyMoney" ControlToValidate="TxtMoney"
                            SetFocusOnError="true" Display="dynamic" runat="server"></pe:RegexValidator>
                    </ContentTemplate>
                </asp:UpdatePanel>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 15%" class="tdbgleft" align="right">
                退款方式：
            </td>
            <td>
                <asp:UpdatePanel ID="UpdatePanel1" runat="server">
                    <ContentTemplate>
                        <asp:RadioButtonList ID="RadlRefundType" AutoPostBack="true" OnSelectedIndexChanged="RadlRefundType_SelectedIndexChanged"
                            runat="server">
                            <asp:ListItem Selected="True" Value="1">扣除的金额添加到会员资金余额中</asp:ListItem>
                            <asp:ListItem Value="2">采用其它方式：如银行转帐，现金交付等等</asp:ListItem>
                        </asp:RadioButtonList>
                    </ContentTemplate>
                </asp:UpdatePanel>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 15%" class="tdbgleft" align="right">
                备注：
            </td>
            <td>
                <asp:UpdatePanel ID="UpnlLimitNum" runat="server">
                    <ContentTemplate>
                        <asp:TextBox ID="TxtRemark" runat="server" Width="200px" MaxLength="200"></asp:TextBox>
                    </ContentTemplate>
                </asp:UpdatePanel>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 15%" class="tdbgleft" align="right">
                通知会员：
            </td>
            <td>
                <pec:SendMessageOfOrder ID="SendMessageOfOrder1" Description="已经退款" runat="server" />
            </td>
        </tr>
        <tr class="tdbg">
            <td colspan="2">
                <span style="color: #ff0000">注意：退款信息一旦录入，就不能再修改或删除！所以在保存之前确认输入无误！</span>
            </td>
        </tr>
        <tr class="tdbg">
            <td colspan="2" style="text-align: center">
                <asp:HiddenField ID="HdnAdminName" runat="server" />
                <pe:ExtendedButton IsChecked="true" OperateCode="OrderRefund" ID="BtnSaveRefund"
                    runat="server" OnClick="BtnSaveRefund_Click" OnClientClick="return confirm('确定录入的退款信息都正确无误了吗？')"
                    Text="保存退款信息" />
                <asp:Button ID="BtnReturn" runat="server" Text="取消" CausesValidation="false" OnClick="BtnReturn_Click" />
            </td>
        </tr>
    </table>
</asp:Content>
