﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.RemittanceAdd" Title="录入订单汇款信息"
    CodeBehind="RemittanceAdd.aspx.cs" Async="true" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <table width="100%" border="0" cellpadding="2" cellspacing="1" class="border">
        <tr align="center">
            <td colspan="2" class="spacingtitle">
                <b>
                    <asp:Label ID="lblTitle" runat="server" Text="添加订单汇款信息"></asp:Label></b>
            </td>
        </tr>
        <tbody runat="server" id="TbodyClient">
            <tr class="tdbg">
                <td style="width: 15%" class="tdbgleft" align="right">
                    客户名称：
                </td>
                <td>
                    <asp:Label ID="LblClientName" runat="server"></asp:Label><asp:HiddenField ID="HdnClientId"
                        runat="server" />
                    &nbsp;
                </td>
            </tr>
        </tbody>
        <tr class="tdbg">
            <td align="right" class="tdbgleft" style="width: 15%;">
                用户名：
            </td>
            <td>
                <asp:Label ID="LblUserName" runat="server"></asp:Label>
            </td>
        </tr>
        <tbody runat="server" id="TbodyPaymentContext">
            <tr runat="server" id="TrPaymentContext" class="tdbg">
                <td align="right" class="tdbgleft" style="width: 15%">
                    可选择一同支付的订单：
                </td>
                <td>
                    <pe:ExtendedGridView ID="EgvOrders" runat="server" AutoGenerateCheckBoxColumn="True"
                        AutoGenerateColumns="False" CheckBoxFieldHeaderWidth="3%" DataKeyNames="OrderId"
                        IsHoldState="True" SerialText="" Width="400px" 
                        OnRowDataBound="EgvOrders_RowDataBound" ondatabound="EgvOrders_DataBound">
                        <FooterStyle CssClass="tdbg" />
                        <Columns>
                            <asp:BoundField DataField="OrderNum" HeaderText="订单编号" />
                            <asp:TemplateField HeaderText="订单金额">
                                <ItemTemplate>
                                    <asp:Label ID="LblMoneyTotal" runat="server" 
                                        Text='<%# Eval("MoneyTotal", "{0:0.00}") %>'></asp:Label>
                                </ItemTemplate>
                                <ItemStyle HorizontalAlign="Right" />
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="已 付 款">
                                <ItemTemplate>
                                    <asp:Label ID="LblMoneyReceipt" runat="server" 
                                        Text='<%# Eval("MoneyReceipt", "{0:0.00}") %>'></asp:Label>
                                </ItemTemplate>
                                <ItemStyle HorizontalAlign="Right" />
                            </asp:TemplateField>
                        </Columns>
                    </pe:ExtendedGridView>
                    <table runat="server" id="TableCalculateMoney" visible="false">
                        <tr>
                            <td>
                                合计应付款：
                            </td>
                            <td>
                                <input type="text" id="TxtTotalMoney" value="" readonly="readonly" style="text-align: right; width:100px;" /> 元
                            </td>
                            <td>
                                <input type="button" value="计算" onclick="CalculateMoney()" />
                                <script type="text/javascript">
                                    function CalculateMoney()
                                    {
                                        var totalMoney = 0.0;
                                        $('#<%=EgvOrders.ClientID %> input:checked[id$="CheckBoxButton"]').each(function(){
                                            var prefix = this.id.replace("CheckBoxButton","");
                                            var total = parseFloat($( "#" +prefix + "LblMoneyTotal").html());
                                            var receipt = parseFloat($( "#" +prefix + "LblMoneyReceipt").html()); 
                                            totalMoney += (total - receipt);
                                        });
                                        $("#TxtTotalMoney").val(totalMoney);
                                    }
                                </script>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </tbody>
        <tr class="tdbg">
            <td style="width: 15%" class="tdbgleft" align="right">
                汇款日期：
            </td>
            <td>
                <asp:TextBox ID="TxtDateAndTime" runat="server" Width="150px"></asp:TextBox>
                <pe:RequiredFieldValidator ID="ValrRemittanceDate" runat="server" ControlToValidate="TxtDateAndTime"
                    ErrorMessage="请输入详细的汇款日期与时间！" Display="Dynamic" SetFocusOnError="True"></pe:RequiredFieldValidator>
                <asp:RegularExpressionValidator ID="ValeDateAndTime" runat="server" 
                    ControlToValidate="TxtDateAndTime" ErrorMessage='日期格式不正确！' 
                    
                    ValidationExpression="^((\d{2}(([02468][048])|([13579][26]))[\-\/\s]?((((0?[13578])|(1[02]))[\-\/\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\-\/\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\-\/\s]?((0?[1-9])|([1-2][0-9])))))|(\d{2}(([02468][1235679])|([13579][01345789]))[\-\/\s]?((((0?[13578])|(1[02]))[\-\/\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\-\/\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\-\/\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\s((([01]?[0-9])|([2][0-3]))\:([0-5]?[0-9])))$" 
                    Display="Dynamic"></asp:RegularExpressionValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 15%" class="tdbgleft" align="right">
                汇款金额：
            </td>
            <td>
                <asp:TextBox ID="TxtMoney" runat="server" Width="100px" MaxLength="10"></asp:TextBox>
                元
                <pe:RequiredFieldValidator ID="ValrMoney" runat="server" ControlToValidate="TxtMoney"
                    Display="Dynamic" ErrorMessage="请输入汇款金额" SetFocusOnError="True"></pe:RequiredFieldValidator><pe:RegexValidator ValidateType="Money"
                        ID="VmoneyMoney" ControlToValidate="TxtMoney" Display="Dynamic" SetFocusOnError="True"
                        runat="server"></pe:RegexValidator>
            </td>
        </tr>
        <tbody runat="server" id="TbodyOption">
            <tr class="tdbg">
                <td style="width: 15%" class="tdbgleft" align="right">
                </td>
                <td>
                    <asp:CheckBox ID="ChkResidualMoney" runat="server" Checked="True" />银行汇款超过订单金额时，将多余款项打入到对应的会员帐户中做为预付款
                </td>
            </tr>
        </tbody>
        <tr class="tdbg">
            <td style="width: 15%" class="tdbgleft" align="right">
            </td>
            <td>
                <asp:CheckBox ID="ChkPoint" runat="server" />给用户赠送<asp:TextBox ID="TxtPoint" runat="server"
                    Width="50px" MaxLength="9"></asp:TextBox><pe:ShowPointName ID="ShowPointName2" PointType="PointUnit"
                        runat="server" /><pe:ShowPointName ID="ShowPointName1" runat="server" />
                <asp:RegularExpressionValidator ID="ValrPoint" ControlToValidate="TxtPoint" SetFocusOnError="true"
                    Display="dynamic" ValidationExpression="\d*" runat="server" ErrorMessage="赠送数应输入整数"></asp:RegularExpressionValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 15%" class="tdbgleft" align="right">
                汇入银行：
            </td>
            <td>
                <asp:DropDownList ID="DropBank" DataTextField="BankShortName" DataValueField="BankShortName"
                    runat="server">
                </asp:DropDownList>
                <pe:RequiredFieldValidator ID="ValgBank" Display="Dynamic" ControlToValidate="DropBank"
                    runat="server" ErrorMessage="请输入银行名称！"></pe:RequiredFieldValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 15%" class="tdbgleft" align="right">
                备注：
            </td>
            <td>
                <asp:TextBox ID="TxtRemark" runat="server" Width="300px" MaxLength="200"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 15%" class="tdbgleft" align="right">
                通知会员：
            </td>
            <td style="width: 826px">
                <pec:SendMessageOfOrder ID="SendMessageOfOrder1" Description="已经收到汇款" runat="server" />
            </td>
        </tr>
        <tr class="tdbg">
            <td colspan="2">
                <span style="color: #ff0000">注意：汇款信息一旦录入，就不能再修改或删除！所以在保存之前确认输入无误！</span>
            </td>
        </tr>
        <tr class="tdbg">
            <td colspan="2" style="text-align: center">
                <asp:HiddenField ID="HdnAdminName" runat="server" />
                <asp:HiddenField ID="HdnUserId" runat="server" />
                <asp:HiddenField ID="HdnReturnUrl" runat="server" />
                <asp:HiddenField ID="HdnOrderId" runat="server" />
                <pe:ExtendedButton IsChecked="true" OperateCode="OrderRemitAndPay" ID="BtnSaveRemittance"
                    runat="server" OnClientClick="return confirm('确定录入的订单汇款信息都正确无误了吗？')" Text="保存汇款信息"
                    OnClick="BtnSaveRemittance_Click" />
                <asp:Button ID="BtnReturn" runat="server" Text="取消" CausesValidation="false" OnClick="BtnReturn_Click" />
            </td>
        </tr>
    </table>
</asp:Content>
