﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.ReturnGoods" Title="录入退货信息"
    CodeBehind="ReturnGoods.aspx.cs" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
    <table width="100%" border="0" cellpadding="2" cellspacing="1" class="border">
        <tr align="center">
            <td colspan="4" class="spacingtitle">
                <b>录入退货信息</b>
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft" style="width: 15%">
                用户名：
            </td>
            <td>
                <asp:Label ID="LblUserName" runat="server"></asp:Label>
            </td>
            <td style="width: 15%" class="tdbgleft" align="right">
                客户名称：
            </td>
            <td>
                <asp:Label ID="LblClientName" runat="server"></asp:Label>&nbsp;
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 15%" class="tdbgleft" align="right">
                订单编号：
            </td>
            <td>
                <asp:Label ID="LblOrderNum" runat="server"></asp:Label>
                <asp:HiddenField ID="HdnOrderId" runat="server" />
            </td>
            <td align="right" class="tdbgleft" style="width: 15%">
                收货人姓名：
            </td>
            <td>
                <asp:Label ID="LblContacterName" runat="server"></asp:Label>
            </td>
        </tr>
        <tr class="tdbg" runat="server" id="TdCreditProdut">
            <td style="width: 15%; height: 23px;" class="tdbgleft" align="right">
                已 付 款：
            </td>
            <td style="height: 23px">
                <asp:Label ID="LblMoneyReceipt" runat="server"></asp:Label>元
            </td>
            <td style="width: 15%" class="tdbgleft" align="right">
                订单金额：
            </td>
            <td>
                <asp:Label ID="LblMoneyTotal" runat="server"></asp:Label>元
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 15%" class="tdbgleft" align="right">
                退货日期：
            </td>
            <td>
                <pe:DatePicker ID="DpkDeliverItemDate" runat="server"></pe:DatePicker>
                <pe:RequiredFieldValidator ID="ValrDeliverItemDate" runat="server" ControlToValidate="DpkDeliverItemDate"
                    ErrorMessage="请输入退货日期" Display="Dynamic" SetFocusOnError="True"></pe:RequiredFieldValidator><pe:RegexValidator
                        ValidateType="Date" ID="VdateDeliverItemDate" ControlToValidate="DpkDeliverItemDate"
                        runat="server" Display="Dynamic" SetFocusOnError="True"></pe:RegexValidator>
            </td>
            <td style="width: 15%; height: 23px;" class="tdbgleft" align="right">
                送货方式：
            </td>
            <td style="height: 23px">
                <asp:Label ID="LblDeliverType" runat="server"></asp:Label>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 15%" class="tdbgleft" align="right">
                退货原因：
            </td>
            <td>
                <asp:TextBox ID="TxtRemark" runat="server" Width="100px" MaxLength="50"></asp:TextBox>
            </td>
            <td style="width: 15%" class="tdbgleft" align="right">
                经 手 人：
            </td>
            <td>
                <asp:TextBox ID="TxtHandlerName" runat="server" Width="100px" MaxLength="50"></asp:TextBox>
                <pe:RequiredFieldValidator ID="ValrHandlerName" runat="server" ErrorMessage="请输入发货人姓名！"
                    ControlToValidate="TxtHandlerName" Display="Dynamic"></pe:RequiredFieldValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 15%" class="tdbgleft" align="right">
                内部记录：
            </td>
            <td colspan="3">
                <asp:TextBox ID="TxtMemo" runat="server" Width="300px" Columns="50" Height="60px"
                    Rows="4" TextMode="MultiLine"></asp:TextBox>
            </td>
            
        </tr>
        <tr class='tdbg'>
            <td colspan='4'>
                <asp:UpdatePanel ID="UpdatePanel2" runat="server">
                    <ContentTemplate>
                        <asp:Repeater ID="RptReturnGoods" OnItemDataBound="RptReturnGoods_ItemDataBound"
                            runat="server">
                            <HeaderTemplate>
                                <table width="100%" border="0" cellpadding="2" cellspacing="1" class="border">
                                    <tr align="center" class="title">
                                        <td style="white-space: nowrap;">
                                            商 品 名 称
                                        </td>
                                        <td style="width: 16%; text-align: center;">
                                            规格型号
                                        </td>
                                        <td style="width: 6%;">
                                            单位
                                        </td>
                                        <td style="width: 8%;">
                                            现有库存
                                        </td>
                                        <td style="width: 8%;">
                                            购买数量
                                        </td>
                                        <td style="width: 10%;">
                                            已发货数量
                                        </td>
                                        <td style="width: 15%;">
                                            本次退/换货数量
                                        </td>
                                        <td style="width: 15%;">
                                            退/换货
                                        </td>
                                    </tr>
                            </HeaderTemplate>
                            <ItemTemplate>
                                <tr align="center" class="tdbg">
                                    <td>
                                        <asp:Label ID="LabProductName" Style="text-align: center" Text='<%# Eval("productname") %>'
                                            Width="80%" runat="server"></asp:Label>
                                        <asp:HiddenField ID="HdnProductCharacter" runat="server" Value='' />
                                        <asp:HiddenField ID="ItemID" runat="server" Value='<%# Eval("ItemId")%>' />
                                        <asp:HiddenField ID="ProductID" runat="server" Value='<%# Eval("ProductID") %>' />
                                    </td>
                                    <td>
                                        <asp:Label ID="Labproperty" Style="text-align: center" Text='<%# Eval("property") %>'
                                            runat="server"></asp:Label>
                                        <asp:DropDownList ID="DropProperty" DataValueField="key" DataTextField="value" runat="server">
                                        </asp:DropDownList>
                                    </td>
                                    <td>
                                        <asp:Label ID="LabUnit" Style="text-align: center" Text='<%# Eval("unit") %>' Width="80%"
                                            runat="server"></asp:Label>
                                    </td>
                                    <td style="width: 80px;">
                                        <asp:Label ID="LabStocks" Style="text-align: center" Text='' Width="80%" runat="server"></asp:Label>
                                    </td>
                                    <td>
                                        <asp:Label ID="LabAmount" runat="server" Text='<%# Eval("Amount") %>'></asp:Label>
                                    </td>
                                    <td>
                                        <asp:TextBox ID="TxtAlreadySend" Style="text-align: center;" Width="45px" runat="server"
                                            HtmlEncode="false" Enabled="false"></asp:TextBox>
                                    </td>
                                    <td>
                                        <asp:TextBox ID="TxtReturnNum" Style="text-align: center" Width="50px" runat="server" Text="2"></asp:TextBox>
                                        <pe:RequiredFieldValidator ID="ValSendNum" Display="dynamic" runat="server" ControlToValidate="TxtReturnNum"
                                            ErrorMessage="请输入数量！" SetFocusOnError="True"></pe:RequiredFieldValidator>
                                        <pe:RegexValidator ValidateType="Number" ID="VSendNum" ControlToValidate="TxtReturnNum"
                                            SetFocusOnError="true" Display="dynamic" runat="server" Text="请输入正整数！"></pe:RegexValidator>
                                        <asp:CompareValidator ID="CPVPass" runat="server" ControlToCompare="TxtAlreadySend"
                                            ControlToValidate="TxtReturnNum" Display="Dynamic" ErrorMessage="不能多于已发货数！" Operator="LessThanEqual"
                                            Type="Double"></asp:CompareValidator><asp:RegularExpressionValidator ID="VSReturnNum" ControlToValidate="TxtReturnNum"
                                              ValidationExpression="^[1-9]+\d*|0\d+"  runat="server" ErrorMessage="数量不能为零！" Display="Dynamic"></asp:RegularExpressionValidator>                                                                                       
                                    </td>
                                    <td>
                                        <asp:RadioButtonList ID="RdbReturn" runat="server" AutoPostBack="true" OnSelectedIndexChanged="RdbReturn_SelectedIndexChanged"
                                            Width="100px" RepeatDirection="Horizontal">
                                            <asp:ListItem Selected="True" Text="换货" Value="1"></asp:ListItem>
                                            <asp:ListItem Selected="false" Text="退货" Value="2"></asp:ListItem>
                                        </asp:RadioButtonList>
                                    </td>
                                </tr>
                            </ItemTemplate>
                            <FooterTemplate>
                                </table>
                            </FooterTemplate>
                        </asp:Repeater>
                    </ContentTemplate>
                </asp:UpdatePanel>
            </td>
        </tr>
        <tr class="tdbg">
            <td colspan="4" style="text-align: center">
                <asp:HiddenField ID="HdnAdminName" runat="server" />
                <pe:ExtendedButton IsChecked="true" OperateCode="OnsignmentList" ID="BtnSaveDeliverItem"
                    runat="server" OnClientClick="javascript:Page_ClientValidate();if(Page_IsValid){return confirm('确定录入的退/换货信息都正确无误了吗？');}"
                    Text="保　存" OnClick="BtnSaveDeliverItem_Click" />
                <asp:Button ID="BtnReturn" runat="server" Text="取消" CausesValidation="false" OnClick="BtnReturn_Click" />
            </td>
        </tr>
    </table>
</asp:Content>
