﻿<%@ Page Language="C#" AutoEventWireup="true" MasterPageFile="~/Admin/MasterPage.master"
    Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.SaleCount" Title="销售统计/排行" Codebehind="SaleCount.aspx.cs" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <table class="border" cellpadding="1" cellspacing="1" width="100%">
        <tr align="center">
            <td class="spacingtitle">
                <b>按时间统计商品销售排名</b>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbg" align="center">
                <pec:StatisticalTime ID="PECStatisticalTime" runat="server" DateType="1"  DefaultBeginDateYear="-1" IsAutoPostBack="false" OnSearchButtonOnClick="PECStatisticalTime_OnSearchButtonOnClick"/>
            </td>
        </tr>
    </table>
    <br />
    <div style="text-align: center; font-size: large;">
        <asp:Label ID="LblTitle" runat="server" Text="商品销售排名"></asp:Label>
    </div>
    <asp:ObjectDataSource ID="OdsSaleCount" runat="server" SelectMethod="GetSaleCountList" SelectCountMethod="GetTotalOfSaleCount"
        TypeName="PowerEasy.Module.Shop.BusinessLogic.SaleCount" EnablePaging="true" StartRowIndexParameterName="startRowIndexId"
        MaximumRowsParameterName="maxNumberRows">
        <SelectParameters>
            <asp:QueryStringParameter Name="infoType" QueryStringField="InfoType" Type="String" />
            <asp:QueryStringParameter Name="searchType" QueryStringField="SearchType" Type="String" />
            <asp:QueryStringParameter Name="keyword" QueryStringField="Keyword" Type="String" />
            <asp:QueryStringParameter Name="orderType" QueryStringField="OrderType" Type="Int32" />
            <asp:Parameter Name="beginDate" Type="DateTime" />
            <asp:Parameter Name="endDate" Type="DateTime" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <pe:ExtendedGridView ID="GdvSaleCount" runat="server" AllowPaging="True" AutoGenerateColumns="False"
        AutoGenerateCheckBoxColumn="False" DataKeyNames="" DataSourceID="OdsSaleCount"
        ItemName="记录" ItemUnit="条">
        <Columns>
            <pe:TemplateField HeaderText="名次" HeaderStyle-Width="5%">
                <ItemTemplate>
                    <%# Container.DataItemIndex + GdvSaleCount.PageIndex*GdvSaleCount.PageSize + 1 %>
                    <asp:HiddenField ID="HdfProductId" runat="server" Value='<%# Eval("ProductID") %>' />
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="商品名称">
                <ItemTemplate>
                    <pe:ExtendedAnchor IsChecked="true" runat="server" OperateCode="ProductManage" href='<%#string.Format("SaleList.aspx?SearchType=4&KeyWord={0}|{1}", Eval("ProductID"),Eval("TableName")) %>'>
                        <%# Eval("ProductName")%>
                    </pe:ExtendedAnchor>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField DataField="Unit" HeaderText="单位"  HeaderStyle-Width="10%" />
            <pe:TemplateField HeaderStyle-Width="15%" >
                <HeaderTemplate>
                    <asp:LinkButton runat="server" ID="LbtnSaleCount" PostBackUrl='<%#string.Format("salecount.aspx?InfoType={0}&SearchType={1}&OrderType={2}&Keyword={3}",RequestString("InfoType"),RequestString("SearchType"),RequestInt32("OrderType") == 0?"1":"0",RequestString("Keyword"))%>'>销售数量</asp:LinkButton>
                </HeaderTemplate>
                <ItemTemplate>
                    <asp:Label ID="LblTotalAmount" runat="server" Text='<%# Eval("TotalAmount") %>'></asp:Label>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderStyle-Width="15%" >
                <HeaderTemplate>
                    <asp:LinkButton runat="server" ID="LbtnSaleMoney" PostBackUrl='<%#string.Format("salecount.aspx?InfoType={0}&SearchType={1}&OrderType={2}&Keyword={3}",RequestString("InfoType"),RequestString("SearchType"),RequestInt32("OrderType") == 0 || RequestInt32("OrderType") ==2 ?"3":"2",RequestString("Keyword"))%>'>销售金额</asp:LinkButton>
                </HeaderTemplate>
                <ItemTemplate>
                    <asp:Label ID="LblSubTotal" runat="server" Text='<%# string.Format("{0:N2}",Eval("SubTotal")) %>'></asp:Label>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderStyle-Width="15%" >
                <HeaderTemplate>
                    <asp:LinkButton runat="server" ID="LbtnNoDeliverCount" PostBackUrl='<%#string.Format("salecount.aspx?InfoType=NoDeliver&SearchType={0}&OrderType={1}&Keyword={2}",RequestString("SearchType"),RequestInt32("OrderType") == 0?"1":"0",RequestString("Keyword"))%>'>未发货数量</asp:LinkButton>
                    <%--<a href='<%#string.Format("salecount.aspx?InfoType=NoDeliver&SearchType={0}&OrderType={1}",RequestString("SearchType"),RequestInt32("OrderType") == 0?"1":"0")%>'>未发货数量</a>--%>
                </HeaderTemplate>
                <ItemTemplate>
                    <asp:Label ID="LblNoDeliverAmount" runat="server" Text='<%# Bind("NoDeliverAmount") %>'></asp:Label>
                </ItemTemplate>
            </pe:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
</asp:Content>
