﻿<%@ Page Language="C#" MasterPageFile="~/Admin/Guide.master" AutoEventWireup="true"
    Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.SaleCountGuide" Codebehind="SaleCountGuide.aspx.cs"
    Title="销售统计向导" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphTitle" runat="Server">
    销售统计
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphSubMenu" runat="Server">
    <div class="guideexpand" onclick="Switch(this)">
        快速查找</div>
    <div class="guide">
        <ul>
            <li><a href="SaleCount.aspx?InfoType=All" target="main_right">所有销售统计记录</a></li>
            <li><a href="SaleCount.aspx?InfoType=NoDeliver" target="main_right">所有未发货记录</a></li>
        </ul>
    </div>
    <div class="guideexpand" onclick="Switch(this)">
        快速统计</div>
    <div class="guidesearch">
        <ul>
            <li>
                <select id="Select1" style="width: 140px" runat="server" onchange="JumpTo(this.options[this.selectedIndex].value,'Select1')">
                    <option selected="selected" value="0">所有销售统计</option>
                    <option value="Day">今天销售统计</option>
                    <option value="Week">本周销售统计</option>
                    <option value="Month">本月销售统计</option>
                </select>
            </li>
            <li>
                <select id="Select2" style="width: 140px" runat="server" onchange="JumpTo(this.options[this.selectedIndex].value,'Select2')">
                    <option selected="selected" value="AllNoDeliver">所有未发货统计</option>
                    <option value="Day">今天未发货统计</option>
                    <option value="Week">本周未发货统计</option>
                    <option value="Month">本月未发货统计</option>
                </select>
                <br />
            </li>
        </ul>
    </div>
    <div class="guideexpand" onclick="Switch(this)">
        高级查询</div>
    <div class="guidesearch">
        <ul>
            <li>
                <select id="SelInfoType" style="width: 140px">
                    <option selected="selected" value="All">所有销售统计</option>
                    <option value="NoDeliver">未发货统计</option>
                </select>
            </li>
            <li>
                <select id="SelField" style="width: 140px">
                    <option selected="selected" value="ProductName">商品名称</option>
                    <option value="InputTime">购买时间</option>
                </select>
            </li>
            <li>
                <input id="TxtKeyWord" style="width: 134px;" type="text" class="inputtext" />
            </li>
            <li>
                <input id="BtnSearch" type="button" class="inputbutton" value="查询" onclick="OpenMainRight()" />
            </li>
        </ul>
    </div>

    <script type="text/javascript">

    function OpenMainRight()
    {
        var field=0;
        var InfoType;
        var keyword = document.getElementById("TxtKeyWord").value.trim();
        var objSel = document.getElementById("SelField");
        if (keyword == '') {
            alert("请输入关键字！");
            return;
         }
        var objSelInfoType = document.getElementById("SelInfoType");
        InfoType=objSelInfoType.options[objSelInfoType.options.selectedIndex].value;
        field = objSel.options[objSel.options.selectedIndex].value;
        var url = "SaleCount.aspx?InfoType="+InfoType+"&SearchType="+field+"&KeyWord="+escape(keyword);
        JumpToMainRight(url);
    }
    
    function JumpTo(SelectValue,str)
    {
        var InfoType;
        if(str == 'Select1')
        {
            InfoType = 'All';
        }
        else
        {
            InfoType = 'NoDeliver';
        }
        var url="SaleCount.aspx?InfoType="+InfoType+"&SearchType="+SelectValue+"&Keyword=''";
        JumpToMainRight(url);
    }
    </script>

</asp:Content>
