﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.SaleListUI" Title="销售明细" Codebehind="SaleList.aspx.cs" %>

<%@ Import Namespace="PowerEasy.Module.Shop.BusinessLogic" %>
<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <pe:ExtendedGridView ID="EgvSaleList" runat="server" AllowPaging="True" AutoGenerateColumns="False"
        DataSourceID="OdsSaleList" EmptyDataText="没有任何商品销售记录！" ItemName="销售明细" OnDataBound="EgvSaleList_DataBound"
        CheckBoxFieldHeaderWidth="3%" SerialText="" OnRowDataBound="EgvSaleList_RowDataBound"
        ShowFooter="True" RowDblclickBoundField="OrderId" RowDblclickUrl="OrderManage.aspx?OrderId={$Field}">
        <Columns>
            <pe:BoundField DataField="InputTime" HeaderText="下单时间" SortExpression="InputTime"
                DataFormatString="{0:yyyy-MM-dd HH:mm:ss}" HtmlEncode="False">
                <HeaderStyle Width="10%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="订单编号">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <pe:ExtendedAnchor IsChecked="true" runat="server" OperateCode="OrderView" href='<%# Eval("OrderId", "OrderManage.aspx?OrderID={0}") %>'>
                        <%# Eval("OrderNum") %>
                    </pe:ExtendedAnchor>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="客户名称">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <pe:ExtendedAnchor IsChecked="true" runat="server" operateCode="ClientView" href='<%# Eval("ClientId", "../Crm/ClientShow.aspx?ClientId={0}") %>'>
                        <%# Eval("ClientName") %>
                    </pe:ExtendedAnchor>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="用户名称">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <pe:ExtendedAnchor IsChecked="true" runat="server" operateCode="UserView" href='<%# Eval("UserName", "../User/UserShow.aspx?UserName={0}") %>'>
                        <%# Eval("UserName") %>
                    </pe:ExtendedAnchor>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="商品名称">
                <ItemTemplate>
                    <pe:ExtendedAnchor IsChecked="true" runat="server" OperateCode="ProductManage" href='<%# string.Format("SaleList.aspx?SearchType=4&KeyWord={0}|{1}",Eval("ProductId"),Eval("TableName"))%>'>
                        <%# Eval("ProductName").ToString() +(string.IsNullOrEmpty(Eval("Property").ToString())?"":"（"+Eval("Property").ToString()+"）") + SaleList.GetSaleTypeString(Eval("SaleType")) %>
                    </pe:ExtendedAnchor>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField DataField="Unit" HeaderText="单位" SortExpression="Unit" >
                <HeaderStyle Width="6%" />
            </pe:BoundField>
            <pe:BoundField DataField="Amount" HeaderText="数量" SortExpression="Amount">
                <HeaderStyle Width="7%" />
            </pe:BoundField>
            <pe:BoundField DataField="TruePrice" HeaderText="指定价" SortExpression="TruePrice"
                DataFormatString="{0:N2}" HtmlEncode="False">
                <ItemStyle HorizontalAlign="Right" />
                <HeaderStyle Width="9%" />
            </pe:BoundField>
            <pe:BoundField DataField="Price" HeaderText="实价" SortExpression="Price" DataFormatString="{0:N2}"
                HtmlEncode="False">
                <ItemStyle HorizontalAlign="Right" />
                <HeaderStyle Width="10%" />
            </pe:BoundField>
            <pe:BoundField DataField="SubTotal" HeaderText="金 额" SortExpression="SubTotal" DataFormatString="{0:N2}"
                HtmlEncode="False">
                <ItemStyle HorizontalAlign="Right" />
                <HeaderStyle Width="10%" />
            </pe:BoundField>
            <pe:BoundField DataField="PresentExp" HeaderText="积分" SortExpression="PresentExp">
                <HeaderStyle Width="6%" />
            </pe:BoundField>
        </Columns>
    </pe:ExtendedGridView>
    <asp:ObjectDataSource ID="OdsSaleList" runat="server" SelectMethod="GetSaleList"
        TypeName="PowerEasy.Module.Shop.BusinessLogic.SaleList" EnablePaging="True" SelectCountMethod="GetTotalOfSaleList"
        StartRowIndexParameterName="startRowIndex" MaximumRowsParameterName="maximumRows">
        <SelectParameters>
            <asp:QueryStringParameter DefaultValue="0" Name="searchType" QueryStringField="SearchType"
                Type="Int32" />
            <asp:QueryStringParameter DefaultValue="0" Name="field" QueryStringField="Field"
                Type="Int32" />
            <asp:QueryStringParameter DefaultValue="" Name="keyword" QueryStringField="KeyWord"
                Type="String" />
        </SelectParameters>
    </asp:ObjectDataSource>
</asp:Content>
