﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    CodeBehind="SalesSaleroomRanking.aspx.cs" Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.SalesSaleroomRanking"
    Title="销售员销售额排名" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    <table border="0" cellpadding="5" cellspacing="1" class="border" style="width: 100%">
        <tr align="center">
            <td colspan="2" class="spacingtitle">
                <b>销售员销售额排名</b>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbg">
                统计时间段：从<font color="red"><asp:Label ID="LblStarTime" runat="server" Text=""></asp:Label></font>至<font
                    color="red"><asp:Label ID="LblEndTime" runat="server" Text=""></asp:Label></font>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbg">
                <pe:ExtendedGridView ID="EgvSalesRanking" runat="server" CheckBoxFieldHeaderWidth="3%"
                    IsHoldState="True" SerialText="" AutoGenerateColumns="False" DataSourceID="OdsSalesRanking"
                    PageSize="20" OnRowDataBound="EgvSalesRanking_RowDataBound" 
                    EmptyDataText="所选的销售员均无任何销售业绩！">
                    <Columns>
                        <asp:TemplateField HeaderText="名次">
                            <ItemTemplate>
                                <%# Container.DataItemIndex + 1%>
                            </ItemTemplate>
                            <HeaderStyle Width="5%" />
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="销售员名称">
                            <ItemTemplate>
                                <asp:Label ID="LblAdminName" runat="server" Text="Label"></asp:Label>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="销售金额">
                            <ItemTemplate>
                                <asp:Label ID="lblMoney" runat="server" Text="Label"></asp:Label>
                            </ItemTemplate>
                            <ItemStyle HorizontalAlign="Right" />
                        </asp:TemplateField>
                    </Columns>
                </pe:ExtendedGridView>
                <asp:ObjectDataSource ID="OdsSalesRanking" runat="server" SelectMethod="GetSalesRankingList"
                    TypeName="PowerEasy.Module.Shop.BusinessLogic.SalesSaleroomRanking">
                    <SelectParameters>
                        <asp:QueryStringParameter Name="idList" QueryStringField="IDList" Type="String" />
                        <asp:QueryStringParameter DefaultValue="" Name="startime" QueryStringField="StarTime"
                            Type="DateTime" />
                        <asp:QueryStringParameter DefaultValue="" Name="endTime" QueryStringField="EndTime"
                            Type="DateTime" />
                    </SelectParameters>
                </asp:ObjectDataSource>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbg">
                <asp:Label ID="LblNoSalesAdmin" runat="server" Font-Bold="True"></asp:Label>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbg" align="center">
                <asp:Button ID="BtnBack" runat="server" Text="返回重新统计" OnClick="BtnBack_Click" />
            </td>
        </tr>
    </table>
</asp:Content>
