﻿<%@ Page Title="退货单操作" Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    CodeBehind="SendBack.aspx.cs" Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.SendBackUI" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" runat="server" SiteMapProvider="AdminMapProvider">
    </pe:ExtendedSiteMapPath>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    <table border="0" cellpadding="2" cellspacing="1" class="border" width="100%">
        <tr align="center">
            <td class="spacingtitle" colspan="2">
                <strong>
                    <asp:Label ID="LblTitle" runat="server"></asp:Label></strong>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 25%; text-align: right">
                单据编号：
            </td>
            <td style="width: 75%">
                <asp:Label ID="LblSendBackNum" runat="server"></asp:Label>
            </td>
        </tr>
        <tr class="tdbg" style="color: #000000">
            <td style="text-align: right">
                录入时间：
            </td>
            <td>
                <pe:DatePicker ID="DpkInputTime" runat="server" IsLongDate="True"></pe:DatePicker>
            </td>
        </tr>
        <tr class="tdbg" style="color: #000000">
            <td style="text-align: right">
                录 入 者：
            </td>
            <td>
                <asp:TextBox ID="TxtAuthor" runat="server" CssClass="inputxt" MaxLength="255"></asp:TextBox>
                <pe:FloatDivDialog ID="OlAuthorType" runat="server" BeginString="【" EndString="】"
                    Height="450" Width="600" CloseText="关闭" Name="选择录入者" Title="选择录入者" Skin="floatingDialogFontSkin"
                    ButtonWidth="180" Enabled="true">
                </pe:FloatDivDialog>
                <pe:RequiredFieldValidator ID="ReqAuthor" runat="server" Display="Dynamic" SetFocusOnError="true"
                    ErrorMessage="录入者不能为空" Visible="false" ControlToValidate="TxtAuthor"></pe:RequiredFieldValidator>
            </td>
        </tr>
        <tr class="tdbg" style="color: #000000">
            <td style="text-align: right">
                备&nbsp; &nbsp; 注：
            </td>
            <td>
                <asp:TextBox ID="TxtRemark" runat="server" Height="65px" TextMode="MultiLine" Width="338px"
                    MaxLength="100" Wrap="true"></asp:TextBox>
                <span style="color: red"></span>
            </td>
        </tr>
        <tr align="center" class="tdbg">
            <td colspan="2" style="text-align: center">
                <pec:FloatingDialog ID="FdAddProduct" runat="server" Name="添加商品" BeginString="【"
                    EndString="】" Title="添加商品" Width="700" Height="450" Skin="floatingDialogFontSkin" />
            </td>
        </tr>
        <tr align="center" class="tdbg">
            <td colspan="2">
                <asp:ScriptManager ID="ScriptManager1" runat="server">
                </asp:ScriptManager>
                <asp:UpdatePanel ID="UpdatePanel1" runat="server" OnLoad="UpdatePanel1_Load">
                    <ContentTemplate>
                        <pe:ExtendedGridView ID="EgvSendBackItem" runat="server" AutoGenerateColumns="False"
                            CheckBoxFieldHeaderWidth="3%" SerialText="" OnRowDeleting="EgvSendBackItem_RowDeleting"
                            IsHoldState="True" OnRowDataBound="EgvSendBackItem_RowDataBound">
                            <Columns>
                                <asp:TemplateField HeaderText="商品名称">
                                    <ItemStyle HorizontalAlign="Left" />
                                    <ItemTemplate>
                                        <asp:Label runat="server" Text='' ID="LblProductName"></asp:Label>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:BoundField DataField="ProductNum" HeaderText="商品编号" />
                                <asp:BoundField DataField="Unit" HeaderText="单位">
                                    <HeaderStyle Width="5%" />
                                </asp:BoundField>
                                <asp:TemplateField HeaderText="数量">
                                    <ItemTemplate>
                                        <asp:TextBox ID="TxtAmount" Style="text-align: center" runat="server" Width="75px"
                                            MaxLength="9" Text='<%# Eval("Amount") %>'></asp:TextBox>
                                        <asp:RangeValidator ID="ValcAmount" runat="server" ControlToValidate="TxtAmount"
                                            Display="Dynamic" ErrorMessage="请输入数量!" MinimumValue="1" MaximumValue="2147483647"
                                            SetFocusOnError="True" Type="Integer"></asp:RangeValidator>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="价格">
                                    <ItemTemplate>
                                        <asp:TextBox ID="TxtPrice" Style="text-align: right" runat="server" Width="75px"
                                            MaxLength="12" Text='<%# Eval("Price","{0:0.00}") %>'></asp:TextBox>
                                        <asp:CompareValidator ID="ValcPrice" runat="server" ErrorMessage="请输入价钱!" Display="Dynamic"
                                            ControlToValidate="TxtPrice" Type="Double" Operator="GreaterThanEqual" ValueToCompare="0"></asp:CompareValidator>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="操作">
                                    <HeaderStyle Width="5%" />
                                    <ItemTemplate>
                                        <asp:LinkButton ID="LbtnDelete" runat="server" CausesValidation="False" CommandName="Delete">删除</asp:LinkButton>
                                    </ItemTemplate>
                                </asp:TemplateField>
                            </Columns>
                        </pe:ExtendedGridView>
                    </ContentTemplate>
                </asp:UpdatePanel>
            </td>
        </tr>
    </table>
    <p style="text-align: center">
        <asp:Button ID="BtnSave" runat="server" OnClick="BtnSave_Click" Text="保 存" />
        <input name="Cancel" type="button" runat="server" class="inputbutton" id="BtnCancel"
            value="取消" onclick="Redirect('SendBackManage.aspx')" />
    </p>
    <br />
    <div id="prompt-note">
        <dl>
            <dt class="prompt-note-tit"><span>提示说明</span> </dt>
            <dd class="prompt-note-con">
                退货单保存后只能修改“备注”一项。
            </dd>
        </dl>
    </div>
    <script type="text/javascript">
        function DoProductPickerPostBack(arrProductList) {
            __doPostBack('<%=UpdatePanel1.ClientID %>', arrProductList);
            CloseFloatingDialog();
        }

        function CheckLength(obj) {
            if (obj.value.length > 200) {
                obj.value = obj.value.substr(0, 200);
            }
        }
    </script>
</asp:Content>
