﻿<%@ Page Title="退货单管理" Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    CodeBehind="SendBackManage.aspx.cs" Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.SendBackManage" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" runat="server" SiteMapProvider="AdminMapProvider">
    </pe:ExtendedSiteMapPath>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    &nbsp;<asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
    <asp:UpdatePanel ID="UpdatePanel2" runat="server">
        <ContentTemplate>
            <asp:ObjectDataSource ID="OdsSendBack" runat="server" EnablePaging="True" MaximumRowsParameterName="maxNumberRows"
                SelectCountMethod="GetTotalOfSendBack" SelectMethod="GetList" StartRowIndexParameterName="startRowIndexId"
                TypeName="PowerEasy.Module.Shop.BusinessLogic.SendBack" DeleteMethod="Delete">
                <SelectParameters>
                    <asp:QueryStringParameter DefaultValue="0" Name="searchType" QueryStringField="SearchType"
                        Type="String" />
                    <asp:QueryStringParameter DefaultValue="" Name="keyword" QueryStringField="KeyWord"
                        Type="String" />
                </SelectParameters>
                <DeleteParameters>
                    <asp:Parameter Name="sendBackId" Type="String" />
                </DeleteParameters>
            </asp:ObjectDataSource>
            <pe:ExtendedGridView ID="EgvSendBack" runat="server" Width="100%" AllowPaging="True"
                AutoGenerateCheckBoxColumn="True" AutoGenerateColumns="False" CheckBoxFieldHeaderWidth="3%"
                DataKeyNames="SendBackId" DataSourceID="OdsSendBack" SerialText="" OnRowCommand="EgvSendBack_RowCommand"
                OnRowDeleting="EgvSendBack_RowDeleting" Font-Underline="False" IsHoldState="True"
                RowDblclickBoundField="SendBackId" RowDblclickUrl="SendBack.aspx?Action=Modify&amp;SendBackId={$Field}">
                <Columns>
                    <asp:TemplateField HeaderText="单据编号" ShowHeader="False">
                        <HeaderStyle Width="15%" />
                        <ItemTemplate>
                            <asp:LinkButton runat="server" CommandName="View" CausesValidation="false" ID="LbtnView"
                                Text='<%# Eval("SendBackNum") %>' CommandArgument='<%# Eval("SendBackId").ToString() +"|"+Eval("SendBackNum").ToString() %>'></asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:BoundField DataField="InputTime" DataFormatString="{0:yyyy-MM-dd HH:mm:ss}"
                        HeaderText="录入时间" HtmlEncode="False" SortExpression="InputTime">
                        <HeaderStyle Width="15%" />
                    </asp:BoundField>
                    <pe:TemplateField HeaderText="录入者" SortExpression="Inputer">
                        <HeaderStyle Width="10%" />
                        <ItemTemplate>
                                <%# Eval("Inputer")%>
                        </ItemTemplate>
                    </pe:TemplateField>
                    <asp:TemplateField HeaderText="备注" SortExpression="Remark">
                        <ItemStyle HorizontalAlign="Left" />
                        <ItemTemplate>
                            <asp:Label ID="Label1" runat="server" Text='<%# PowerEasy.Framework.Common.StringHelper.SubString(Eval("Remark").ToString(),30,"...") %>'
                                ToolTip='<%# Eval("Remark") %>'></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="操作">
                        <HeaderStyle Width="15%" />
                        <ItemTemplate>
                            <asp:LinkButton ID="LbtnDelete" runat="server" CommandName="Delete" OnClientClick="if(!this.disabled) return confirm('是否要删除此记录？')">删除</asp:LinkButton>
                            <a href='SendBack.aspx?SendBackId=<%#Eval("SendBackId") %>&Action=Modify'>修改</a>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </pe:ExtendedGridView>
        </ContentTemplate>
    </asp:UpdatePanel>
    <div style="padding: 5px 0 5px 0;">
        <asp:Button ID="BtnDelete" runat="server" Text="删除选择的记录" OnClick="BtnDelete_Click"
            OnClientClick="return batchconfirm('是否要删除选定的记录？')" />
        <asp:Button ID="BtnExportExcel" runat="server" Text="导出到Excel" OnClick="BtnExportExcel_Click" />
        导出选项：<asp:RadioButton GroupName="ExportExcel" Text="导出所有记录" ID="rbExportAll"  runat="server" Checked="true" />
        <asp:RadioButton GroupName="ExportExcel" Text="导出选中记录" ID="rbExportSelected" runat="server" />
    </div>
    <asp:UpdatePanel ID="UpdatePanel1" runat="server" UpdateMode="Conditional">
        <ContentTemplate>
            <asp:Panel ID="PnlSendBackItem" runat="server" Visible="False" Width="100%">
                <table border="0" cellpadding="0" cellspacing="0" class="border" style="width: 100%;">
                    <tr>
                        <td class="title" style="height: 25px; text-align: center">
                            <asp:Label ID="LblTitle" runat="server"></asp:Label>
                        </td>
                    </tr>
                    <tr>
                        <td class="tdbg" style="padding-right: 5px; padding-left: 5px; padding-bottom: 5px;
                            padding-top: 5px">
                            <pe:ExtendedGridView ID="EgvSendBackItem" runat="server" AutoGenerateColumns="False"
                                CheckBoxFieldHeaderWidth="3%" OnDataBound="EgvSendBackItem_DataBound" OnRowDataBound="EgvSendBackItem_RowDataBound"
                                SerialText="" ShowFooter="True" IsHoldState="True">
                                <Columns>
                                    <asp:TemplateField HeaderText="商品名称">
                                        <ItemStyle HorizontalAlign="Left" />
                                        <ItemTemplate>
                                            <asp:Label runat="server" Text='' ID="LblProductName"></asp:Label>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                    <asp:BoundField DataField="ProductNum" HeaderText="商品编号" />
                                    <asp:BoundField DataField="Unit" HeaderText="单位">
                                        <HeaderStyle Width="5%" />
                                    </asp:BoundField>
                                    <asp:BoundField DataField="Amount" HeaderText="数量" />
                                    <asp:BoundField DataField="Price" DataFormatString="{0:0.00}" HeaderText="价格" HtmlEncode="False">
                                        <ItemStyle HorizontalAlign="Right" />
                                    </asp:BoundField>
                                    <asp:TemplateField HeaderText="金额">
                                        <ItemStyle HorizontalAlign="Right" />
                                        <ItemTemplate>
                                            <asp:Label ID="LblMoney" runat="server"></asp:Label>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                </Columns>
                            </pe:ExtendedGridView>
                        </td>
                    </tr>
                </table>
            </asp:Panel>
        </ContentTemplate>
        <Triggers>
            <asp:AsyncPostBackTrigger ControlID="EgvSendBack" EventName="RowCommand" />
        </Triggers>
    </asp:UpdatePanel>
</asp:Content>
