﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.SendGoods" Title="录入发货信息"
    CodeBehind="SendGoods.aspx.cs" Async="true" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
    <table width="100%" border="0" cellpadding="2" cellspacing="1" class="border">
        <tr align="center">
            <td colspan="2" class="spacingtitle">
                <b>录入发货信息</b>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 15%" class="tdbgleft" align="right">
                客户名称：
            </td>
            <td style="width: 826px">
                <asp:Label ID="LblClientName" runat="server"></asp:Label>&nbsp;
            </td>
        </tr>
        <tr class="tdbg">
            <td align="right" class="tdbgleft" style="width: 15%">
                用户名：
            </td>
            <td style="width: 826px">
                <asp:Label ID="LblUserName" runat="server"></asp:Label>
            </td>
        </tr>
        <%if (PowerEasy.Framework.Common.DataConverter.ToBoolean(HdnIsAliay.Value))
          { %>
        <tr class="tdbg">
            <td align="right" class="tdbgleft" style="width: 15%">
                支付宝交易号：
            </td>
            <td style="width: 826px">
                <asp:Label ID="LblTradeNo" runat="server"></asp:Label>
            </td>
        </tr>
        <%} %>
        <tr class="tdbg">
            <td align="right" class="tdbgleft" style="width: 15%">
                收货人姓名：
            </td>
            <td style="width: 826px">
                <asp:Label ID="LblContacterName" runat="server"></asp:Label>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 15%" class="tdbgleft" align="right">
                订单编号：
            </td>
            <td style="width: 826px">
                <asp:Label ID="LblOrderNum" runat="server"></asp:Label>
                <asp:HiddenField ID="HdnOrderId" runat="server" />
            </td>
        </tr>
        <% if(!m_IsCreditProduct){%>
        <tr class="tdbg">
            <td style="width: 15%" class="tdbgleft" align="right">
                订单金额：
            </td>
            <td style="width: 826px">
                <asp:Label ID="LblMoneyTotal" runat="server"></asp:Label>元
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 15%; height: 23px;" class="tdbgleft" align="right">
                已 付 款：
            </td>
            <td style="height: 23px; width: 826px;">
                <asp:Label ID="LblMoneyReceipt" runat="server"></asp:Label>元
            </td>
        </tr>
        <%} %>
        <tr class="tdbg">
            <td style="width: 15%; height: 23px;" class="tdbgleft" align="right">
                送货方式：
            </td>
            <td style="height: 23px; width: 826px;">
                <asp:Label ID="LblDeliverType" runat="server"></asp:Label>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 15%" class="tdbgleft" align="right">
                发货日期：
            </td>
            <td style="width: 826px">
                <pe:DatePicker ID="DpkDeliverItemDate" runat="server"></pe:DatePicker>
                <pe:RequiredFieldValidator ID="ValrDeliverItemDate" runat="server" ControlToValidate="DpkDeliverItemDate"
                    ErrorMessage="请输入发货日期" Display="Dynamic" SetFocusOnError="True"></pe:RequiredFieldValidator><pe:RegexValidator
                        ValidateType="Date" ID="VdateDeliverItemDate" ControlToValidate="DpkDeliverItemDate"
                        runat="server" Display="Dynamic" SetFocusOnError="True"></pe:RegexValidator>
            </td>
        </tr>
        <tbody id="TbodyExpress" runat="server">
            <tr class="tdbg">
                <td style="width: 15%" class="tdbgleft" align="right">
                    快递公司：
                </td>
                <td style="width: 826px">
                    <asp:DropDownList ID="dropExpressCompany" runat="server">
                    </asp:DropDownList>
                    <pe:RequiredFieldValidator ID="ValrExpressCompany" ShowRequiredText="false" runat="server"
                        ErrorMessage="请输入快递公司名！" ControlToValidate="DropExpressCompany" Display="Dynamic"></pe:RequiredFieldValidator>
                </td>
            </tr>
            <tr class="tdbg">
                <td style="width: 15%" class="tdbgleft" align="right">
                    快递单号：
                </td>
                <td style="width: 826px">
                    <asp:TextBox ID="TxtExpressNumber" runat="server" Width="100px" MaxLength="50"></asp:TextBox> <pe:RequiredFieldValidator ID="ValrExpressNumber" runat="server" ErrorMessage="请输快递单号"
                        ControlToValidate="TxtExpressNumber" Display="Dynamic" Enabled="false" Visible="false"></pe:RequiredFieldValidator>
                </td>
            </tr>
        </tbody>
        <tr class="tdbg">
            <td style="width: 15%" class="tdbgleft" align="right">
                经 手 人：
            </td>
            <td style="width: 826px">
                <asp:TextBox ID="TxtHandlerName" runat="server" Width="100px" MaxLength="50"></asp:TextBox>
                <pe:RequiredFieldValidator ID="ValrHandlerName" runat="server" ErrorMessage="请输入发货人姓名！"
                    ControlToValidate="TxtHandlerName" Display="Dynamic"></pe:RequiredFieldValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 15%" class="tdbgleft" align="right">
                备 注：
            </td>
            <td style="width: 826px">
                <asp:TextBox ID="TxtRemark" runat="server" Width="200px" MaxLength="200"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 15%" class="tdbgleft" align="right">
                内部记录：
            </td>
            <td>
                <asp:TextBox ID="TxtMemo" runat="server" Width="400px" Columns="50" Height="60px"
                    Rows="4" TextMode="MultiLine"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 15%" class="tdbgleft" align="right">
                通知会员：
            </td>
            <td style="width: 826px">
                <pec:SendMessageOfOrder ID="SendMessageOfOrder1" Description="已经发货" runat="server" />
            </td>
        </tr>
        <tr>
            <td colspan="2">
                <asp:UpdatePanel ID="UpdatePanel2" runat="server">
                    <ContentTemplate>
                        <asp:Repeater ID="RptSendGoods" OnItemDataBound="RptSendGoods_ItemDataBound" runat="server">
                            <HeaderTemplate>
                                <table width="100%" border="0" cellpadding="2" cellspacing="1" class="border">
                                    <tr align="center" class="title">
                                        <td style="white-space: nowrap;">
                                            商 品 名 称
                                        </td>
                                        <td style="width: 16%;">
                                            规格型号
                                        </td>
                                        <td style="width: 6%;">
                                            单位
                                        </td>
                                        <td style="width: 8%;">
                                            现有库存
                                        </td>
                                        <td style="width: 8%;">
                                            购买数量
                                        </td>
                                        <td style="width: 10%;">
                                            已发货数量
                                        </td>
                                        <td style="width: 10%;">
                                            需发货数量
                                        </td>
                                        <td style="width: 15%;">
                                            本次发货数量
                                        </td>
                                    </tr>
                            </HeaderTemplate>
                            <ItemTemplate>
                                <tr align="center" class="tdbg">
                                    <td>
                                        <asp:Label ID="LabProductName" Style="text-align: center"  Text='<%# Eval("productname") %>'
                                            Width="80%" runat="server"></asp:Label>
                                        <asp:HiddenField ID="HdnProductCharacter" runat="server" Value='' />
                                        <asp:HiddenField ID="ItemID" runat="server" Value='<%# Eval("ItemId")%>' />
                                    </td>
                                    <td>
                                        <asp:Label ID="Labproperty" Style="text-align: center" Text='<%# Eval("property") %>'
                                            Width="80%" runat="server"></asp:Label>
                                    </td>
                                    <td>
                                        <asp:Label ID="LabUnit" Style="text-align: center" Text='<%# Eval("unit") %>' Width="80%"
                                            runat="server"></asp:Label>
                                    </td>
                                    <td style="width: 80px;">
                                        <asp:Label ID="LabStocks" Style="text-align: center" Text='' Width="80%" runat="server"></asp:Label>
                                    </td>
                                    <td style="width: 80px;">
                                        <asp:Label ID="LabAmount" runat="server" Text='<%# Eval("Amount") %>'></asp:Label>
                                    </td>
                                    <td>
                                        <asp:Label ID="LblAlreadySend" runat="server" HtmlEncode="false"></asp:Label>
                                    </td>
                                    <td>
                                        <asp:TextBox ID="LabNeedSend" Enabled="false" Style="text-align: center" Width="80%" runat="server"></asp:TextBox>
                                        
                                    </td>
                                    <td>
                                        <asp:TextBox ID="TxtSendNum" Style="text-align: center"  Width="80%" runat="server"></asp:TextBox>
                                        <asp:Label ID="LabNOSend" runat="server" Text="不需发货" Visible="false"></asp:Label>
                                        <pe:RequiredFieldValidator ID="ValSendNum" Display="dynamic" runat="server" ControlToValidate="TxtSendNum"
                                            ErrorMessage="请输入数量！" SetFocusOnError="True"></pe:RequiredFieldValidator>
                                        <pe:RegexValidator ValidateType="Number" ID="VSendNum" ControlToValidate="TxtSendNum"
                                            SetFocusOnError="true" Display="dynamic" runat="server" Text="请输入正整数"></pe:RegexValidator>
                                        <asp:CompareValidator ID="CPVPass" runat="server" ControlToCompare="LabNeedSend"
                                            ControlToValidate="TxtSendNum" Display="Dynamic" ErrorMessage="不能多于需发货数！" Operator="LessThanEqual"
                                            Type="Double"></asp:CompareValidator>
                                        <asp:CompareValidator ID="ValcStocks" runat="server"  ControlToValidate="TxtSendNum" Display="Dynamic"
                                             ErrorMessage="不能多于现有库存！" Operator="LessThanEqual" Type="Integer"></asp:CompareValidator>
                                    </td>
                                </tr>
                            </ItemTemplate>
                            <FooterTemplate>
                                </table>
                            </FooterTemplate>
                        </asp:Repeater>
                    </ContentTemplate>
                </asp:UpdatePanel>
            </td>
        </tr>
        <tr class="tdbg">
            <td colspan="2" style="text-align: center">
                <asp:HiddenField ID="HdnAdminName" runat="server" />
                <pe:ExtendedButton IsChecked="true" OperateCode="OnsignmentList" ID="BtnSaveDeliverItem"
                    runat="server" Text="保　存" OnClick="BtnSaveDeliverItem_Click" />
                <asp:HiddenField ID="HdnIsAliay" runat="server" Value="0" />
                <asp:Button ID="BtnReturn" runat="server" Text="取消" CausesValidation="false" OnClick="BtnReturn_Click" />
            </td>
        </tr>
    </table>
</asp:Content>
