﻿<%@ Page Language="C#" AutoEventWireup="True" MasterPageFile="~/Admin/MasterPage.master"
    CodeBehind="ShopConfig.aspx.cs" ValidateRequest="false" EnableEventValidation="false"
    Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.ShopConfigUI" Title="商店参数配置" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" runat="server" SiteMapProvider="AdminMapProvider" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <asp:ScriptManager ID="SmgeRegion" runat="server" EnablePartialRendering="true">
    </asp:ScriptManager>
    <table width="100%" border="0" cellpadding="2" cellspacing="1" class="border">
        <tr align="center">
            <td colspan="2" class="spacingtitle">
                <asp:Label ID="LblTitle" runat="server" Text="商店参数配置" Font-Bold="True"></asp:Label>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 35%;" class="tdbgleft">
                <strong>是否允许游客购买商品：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RadlEnableGuestBuy" runat="server" RepeatDirection="Horizontal">
                    <asp:ListItem Selected="True" Value="true">是</asp:ListItem>
                    <asp:ListItem Value="false">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>默认商品税率优惠类型：</strong>
            </td>
            <td>
                <pec:TaxRateSetting ID="TaxRateTypeSet" runat="server" EnableTheming="true" EnableViewState="true"
                    Visible="true" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>默认税率设置：</strong>
            </td>
            <td>
                <asp:TextBox ID="TxtTaxRate" runat="server" MaxLength="6" Columns="5"></asp:TextBox>%
                <asp:CompareValidator ID="CompareValidator1" runat="server" ControlToValidate="TxtTaxRate"
                    Display="Dynamic" ErrorMessage="请输入正确的数值！" Operator="GreaterThanEqual" SetFocusOnError="True"
                    Type="Double" ValueToCompare="0"></asp:CompareValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>订单编号前缀：</strong>
            </td>
            <td>
                <asp:TextBox ID="TxtPrefixOrderFormNum" runat="server" MaxLength="4" Columns="5"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>在线支付单编号前缀：</strong>
            </td>
            <td>
                <asp:TextBox ID="TxtPrefixPaymentNum" runat="server" MaxLength="4" Columns="5"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>商城服务接口密钥：</strong>
            </td>
            <td>
                <asp:TextBox ID="TxtShopServicesKey" runat="server"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>我所在的地区：</strong>
            </td>
            <td>
                <pec:Region ID="Region1" runat="server" EnableViewState="true" Visible="true" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>订购流程收银台处收货人默认地址：</strong>
                <br />
                对游客或尚无收货地址的用户，此处设置才有效；如果无需默认，请保留“请选择”。
            </td>
            <td>
                <pec:Region ID="Region2" runat="server" EnableViewState="true" Visible="true" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>我所在地区的邮政编码：</strong>
            </td>
            <td>
                <asp:TextBox ID="TxtPostCode" runat="server" MaxLength="20"></asp:TextBox>
                <asp:RegularExpressionValidator ID="ValePostCode" runat="server" ControlToValidate="TxtPostCode"
                    Display="Dynamic" ErrorMessage="请输入正确的邮政编号！" SetFocusOnError="True" ValidationExpression="\d{6}"></asp:RegularExpressionValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否允许会员自主对订单只支付部分金额（即交定金）：</strong>
                <br />
                如果不允许，当会员预付款小于订单金额时，不允许支付；当对订单在线支付时，检查支付金额是否小于订单金额，如果小于，只打入会员帐户中作为预付款，不对订单进行支付。
            </td>
            <td>
                <asp:RadioButton ID="RadlEnablePartPay1" runat="server" GroupName="NeedLogin" Text="是" />&nbsp;
                <asp:RadioButton ID="RadlEnablePartPay0" runat="server" GroupName="NeedLogin" Text="否"
                    Checked="True" />
            </td>
        </tr>
        <tr id="partAgeTR" class="tdbg" style="display: none">
            <td class="tdbgleft">
                <strong>支付部份金额比率：</strong>
                <br />
                输入1-100之间的支付金额比率
            </td>
            <td>
                <asp:TextBox ID="txtAge" runat="server" Text="30" Width="66px"></asp:TextBox>%
                <asp:RequiredFieldValidator ID="ReqPriceAge" ControlToValidate="txtAge" runat="server"
                    ErrorMessage="支付金额比率不能为空" Display="Dynamic"></asp:RequiredFieldValidator>
                <asp:RangeValidator ID="ValrPriceAge" ControlToValidate="txtAge" runat="server" MaximumValue="100"
                    MinimumValue="1" Type="Double" ErrorMessage="请输入1-100之间的支付金额比率" Display="Dynamic"></asp:RangeValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>订单商品种类的数量限制：</strong>
                <br />
                当设置为＂0＂时，代表不限制。
            </td>
            <td>
                <asp:TextBox ID="txtOrderProductNumber" Width="66px" runat="server"></asp:TextBox>
                <asp:RequiredFieldValidator ID="valrOrderProductNumber" ControlToValidate="txtOrderProductNumber"
                    runat="server" Display="Dynamic" ErrorMessage="订单商品种类的数量限制不能为空"></asp:RequiredFieldValidator>
                <asp:RangeValidator ID="valrOrderProductNumberMin" ControlToValidate="txtOrderProductNumber"
                    runat="server" Display="Dynamic" MinimumValue="0" MaximumValue="65535" Type="Integer"
                    ErrorMessage="请输入正确的订单商品种类数量限制"></asp:RangeValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>订单商品过期天数：</strong>
                <br />
                当设置为＂0＂时，未付款的订单不会作废。
            </td>
            <td>
                <asp:TextBox ID="txtOrderOverdueDate" Width="66px" runat="server"></asp:TextBox>
                <asp:RequiredFieldValidator ID="valrOrderOverdueDate" ControlToValidate="txtOrderOverdueDate"
                    runat="server" Display="Dynamic" ErrorMessage="订单商品过期天数不能为空"></asp:RequiredFieldValidator>
                <asp:RangeValidator ID="valrOrderOverdueDateMin" ControlToValidate="txtOrderOverdueDate"
                    runat="server" Display="Dynamic" MinimumValue="0" MaximumValue="65535" Type="Integer"
                    ErrorMessage="请输入正确的订单商品过期天数"></asp:RangeValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>添加银行汇款时资金与赠送<pe:ShowPointName runat="server" ID="ShowPointName1"></pe:ShowPointName>的比率：</strong>
            </td>
            <td>
                每<asp:TextBox ID="TxtMoneyPresentPoint" Width="50px" Text="1" runat="server"></asp:TextBox>元钱可赠送
                1
                <pe:ShowPointName PointType="PointUnit" runat="server" ID="PointUnit"></pe:ShowPointName><pe:ShowPointName
                    runat="server" ID="PointName"></pe:ShowPointName>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否开启预付款支付密码功能：</strong>
                <br />
                如果开启，当会员注册成功后，将提示“请设置您的预付款支付密码”；当使用预付款支付订单时，必须输入“预付款支付密码”。
            </td>
            <td>
                <asp:RadioButtonList ID="RadPayPassword" runat="server" RepeatLayout="Flow" RepeatDirection="Horizontal">
                    <asp:ListItem Selected="True" Value="True">是</asp:ListItem>
                    <asp:ListItem Value="False">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否启用优惠券功能：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RadlEnableCoupon" runat="server" RepeatDirection="Horizontal"
                    RepeatLayout="flow" Width="128px">
                    <asp:ListItem Value="true">是</asp:ListItem>
                    <asp:ListItem Value="false">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否启用自动指派跟单员功能：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RadlSetFunctionary" runat="server" RepeatDirection="Horizontal"
                    RepeatLayout="flow" Width="128px">
                    <asp:ListItem Value="true">是</asp:ListItem>
                    <asp:ListItem Value="false">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否自动生成缩略图：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RadlThumb" runat="server" RepeatLayout="Flow" RepeatDirection="Horizontal">
                    <asp:ListItem Selected="True" Value="True">是</asp:ListItem>
                    <asp:ListItem Value="False">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否给商品图片添加水印：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RadlWatermark" runat="server" RepeatLayout="Flow" RepeatDirection="Horizontal">
                    <asp:ListItem Selected="True" Value="True">是</asp:ListItem>
                    <asp:ListItem Value="False">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否在购物车页面的商品列表中显示商品类别：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RadGwcProductType" runat="server" RepeatLayout="Flow" RepeatDirection="Horizontal">
                    <asp:ListItem Selected="True" Value="True">是</asp:ListItem>
                    <asp:ListItem Value="False">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否在收银台页的商品列表中显示商品类别：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RadPaymentProductType" runat="server" RepeatLayout="Flow"
                    RepeatDirection="Horizontal">
                    <asp:ListItem Selected="True" Value="True">是</asp:ListItem>
                    <asp:ListItem Value="False">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否在订单预览页的商品列表中显示商品类别：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RadPreviewProductType" runat="server" RepeatLayout="Flow"
                    RepeatDirection="Horizontal">
                    <asp:ListItem Selected="True" Value="True">是</asp:ListItem>
                    <asp:ListItem Value="False">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否在购物车页面的商品列表中显示销售类型：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RadGwcSaleType" runat="server" RepeatLayout="Flow" RepeatDirection="Horizontal">
                    <asp:ListItem Selected="True" Value="True">是</asp:ListItem>
                    <asp:ListItem Value="False">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否在收银台页的商品列表中显示销售类型：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RadPaymentSaleType" runat="server" RepeatLayout="Flow" RepeatDirection="Horizontal">
                    <asp:ListItem Selected="True" Value="True">是</asp:ListItem>
                    <asp:ListItem Value="False">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否在订单预览页的商品列表中显示销售类型：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RadPreviewSaleType" runat="server" RepeatLayout="Flow" RepeatDirection="Horizontal">
                    <asp:ListItem Selected="True" Value="True">是</asp:ListItem>
                    <asp:ListItem Value="False">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否在购物车页面的商品列表显示市场价：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RadGwcMarkPrice" runat="server" RepeatLayout="Flow" RepeatDirection="Horizontal">
                    <asp:ListItem Selected="True" Value="True">是</asp:ListItem>
                    <asp:ListItem Value="False">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否在收银台页的商品列表中显示市场价：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RadPaymentMarkPrice" runat="server" RepeatLayout="Flow"
                    RepeatDirection="Horizontal">
                    <asp:ListItem Selected="True" Value="True">是</asp:ListItem>
                    <asp:ListItem Value="False">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否在订单预览页的商品列表中显示市场价：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RadPreviewMarkPrice" runat="server" RepeatLayout="Flow"
                    RepeatDirection="Horizontal">
                    <asp:ListItem Selected="True" Value="True">是</asp:ListItem>
                    <asp:ListItem Value="False">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否在会员中心订单页列表中显示市场价：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RadUserMarkPrice" runat="server" RepeatLayout="Flow" RepeatDirection="Horizontal">
                    <asp:ListItem Selected="True" Value="True">是</asp:ListItem>
                    <asp:ListItem Value="False">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否在购物车页面的商品列表显示实价：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RadGwcPrice" runat="server" RepeatLayout="Flow" RepeatDirection="Horizontal">
                    <asp:ListItem Selected="True" Value="True">是</asp:ListItem>
                    <asp:ListItem Value="False">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否在收银台页的商品列表中显示实价：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RadPaymentPrice" runat="server" RepeatLayout="Flow" RepeatDirection="Horizontal">
                    <asp:ListItem Selected="True" Value="True">是</asp:ListItem>
                    <asp:ListItem Value="False">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否在订单预览页的商品列表中显示实价：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RadPreviewPrice" runat="server" RepeatLayout="Flow" RepeatDirection="Horizontal">
                    <asp:ListItem Selected="True" Value="True">是</asp:ListItem>
                    <asp:ListItem Value="False">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否在会员中心订单页列表中显示实价：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RadUserPrice" runat="server" RepeatLayout="Flow" RepeatDirection="Horizontal">
                    <asp:ListItem Selected="True" Value="True">是</asp:ListItem>
                    <asp:ListItem Value="False">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" style="font-weight: bold">
                服务到期的软件类商品是否继续提供下载：
            </td>
            <td>
                <asp:RadioButtonList ID="RadlAllowDownloadOvertime" runat="server" RepeatLayout="Flow"
                    RepeatDirection="Horizontal">
                    <asp:ListItem Selected="True" Value="True">是</asp:ListItem>
                    <asp:ListItem Value="False">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" style="font-weight: bold">
                是否显示订单总价及资金明细总价：
            </td>
            <td>
                <asp:RadioButtonList ID="RalOrderDetailsTotal" runat="server" RepeatLayout="Flow"
                    RepeatDirection="Horizontal">
                    <asp:ListItem Selected="True" Value="True">是</asp:ListItem>
                    <asp:ListItem Value="False">否</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>折扣基价计算方式：</strong>
                <br />
                （会员组折扣和代理商组折扣的计算标准）
            </td>
            <td>
                <asp:RadioButtonList ID="RadDiscountBasePriceComputeType" runat="server" RepeatDirection="Horizontal"
                    Width="240px">
                    <asp:ListItem Selected="True" Value="0">按本店零售价计算</asp:ListItem>
                    <asp:ListItem Value="1">按市场价计算</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" style="font-weight: bold">
                代理商代付时代理价的计算方式：
            </td>
            <td>
                <asp:RadioButtonList ID="RadlAgentPaymentComputType" runat="server" RepeatDirection="Horizontal"
                    Width="569px">
                    <asp:ListItem Selected="True" Value="0">按照当前商品价格的代理折扣价计算订单金额</asp:ListItem>
                    <asp:ListItem Value="1">按照订单商品的指定价的代理折扣价计算订单金额</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" style="font-weight: bold">
                代理商代付时扣款方式：
            </td>
            <td>
                <asp:RadioButtonList ID="RadlAgentPaymentDeductMoneyType" runat="server" RepeatDirection="Horizontal"
                    Width="316px">
                    <asp:ListItem Selected="True" Value="0">全额扣款后再返还代理价差额</asp:ListItem>
                    <asp:ListItem Value="1">直接以代理价扣款</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否在购物车显示商品缩略图：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RadGwcProducdtThumb" runat="server" RepeatLayout="Flow"
                    AutoPostBack="true" RepeatDirection="Horizontal" OnSelectedIndexChanged="RadGwcProducdtThumb_SelectedIndexChanged">
                    <asp:ListItem Value="True">是</asp:ListItem>
                    <asp:ListItem Value="False">否</asp:ListItem>
                </asp:RadioButtonList>
                <table id="tblGwcProductThumbSize" runat="server">
                    <tr>
                        <td>
                            缩略图宽度:<asp:TextBox ID="txtGwcProductThumbWidth" runat="server" Width="20"></asp:TextBox>缩略图高度:<asp:TextBox
                                ID="txtGwcProductThumbHeight" runat="server" Width="20"></asp:TextBox>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            如果您不能确认图片的原始尺寸，无法指定具体的宽和高时，可以只指定宽度或者高度中的一个值，0代表不设置，图片会根据您设置的宽度或高度自动调节图片大小，以此避免图片失真的情况
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否在收银台显示商品缩略图：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RadPaymentProductThumb" runat="server" RepeatLayout="Flow"
                    AutoPostBack="true" RepeatDirection="Horizontal" OnSelectedIndexChanged="RadPaymentProductThumb_SelectedIndexChanged">
                    <asp:ListItem Value="True">是</asp:ListItem>
                    <asp:ListItem Value="False">否</asp:ListItem>
                </asp:RadioButtonList>
                <table id="tblPaymentProductThumbSize" runat="server">
                    <tr>
                        <td>
                            缩略图宽度:<asp:TextBox ID="txtPaymentProductThumbWidth" runat="server" Width="20"></asp:TextBox>缩略图高度:<asp:TextBox
                                ID="txtPaymentProductThumbHeight" runat="server" Width="20"></asp:TextBox>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            如果您不能确认图片的原始尺寸，无法指定具体的宽和高时，可以只指定宽度或者高度中的一个值，0代表不设置，图片会根据您设置的宽度或高度自动调节图片大小，以此避免图片失真的情况
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否在预览页页面显示商品缩略图：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RadPreviewProductThumb" runat="server" RepeatLayout="Flow"
                    AutoPostBack="true" RepeatDirection="Horizontal" OnSelectedIndexChanged="RadPreviewProductThumb_SelectedIndexChanged">
                    <asp:ListItem Value="True">是</asp:ListItem>
                    <asp:ListItem Value="False">否</asp:ListItem>
                </asp:RadioButtonList>
                <table id="tblPreviewProductThumbSize" runat="server">
                    <tr>
                        <td>
                            缩略图宽度:<asp:TextBox ID="txtPreviewProductThumbWidth" runat="server" Width="20"></asp:TextBox>缩略图高度:<asp:TextBox
                                ID="txtPreviewProductThumbHeight" runat="server" Width="20"></asp:TextBox>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            如果您不能确认图片的原始尺寸，无法指定具体的宽和高时，可以只指定宽度或者高度中的一个值，0代表不设置，图片会根据您设置的宽度或高度自动调节图片大小，以此避免图片失真的情况
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否在订单信息页的商品列表中显示商品缩略图：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RadShowOrderProductListThumb" runat="server" AutoPostBack="true"
                    RepeatLayout="Flow" RepeatDirection="Horizontal" OnSelectedIndexChanged="RadShowOrderProductListThumb_SelectedIndexChanged">
                    <asp:ListItem Value="True">是</asp:ListItem>
                    <asp:ListItem Value="False">否</asp:ListItem>
                </asp:RadioButtonList>
                <table id="tblOrderProductListThumbSize" runat="server">
                    <tr>
                        <td>
                            缩略图宽度:<asp:TextBox ID="txtOrderProductListThumbWidth" AutoPostBack="true" runat="server"
                                Width="20"></asp:TextBox>缩略图高度:<asp:TextBox ID="txtOrderProductListThumbHeight" runat="server"
                                    Width="20"></asp:TextBox>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            如果您不能确认图片的原始尺寸，无法指定具体的宽和高时，可以只指定宽度或者高度中的一个值，0代表不设置，图片会根据您设置的宽度或高度自动调节图片大小，以此避免图片失真的情况
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否在商品管理页的商品列表中显示商品缩略图：</strong>
            </td>
            <td>
                <asp:RadioButtonList ID="RadShowProducdtListThumb" runat="server" AutoPostBack="true"
                    RepeatLayout="Flow" RepeatDirection="Horizontal" OnSelectedIndexChanged="RadShowProducdtListThumb_SelectedIndexChanged">
                    <asp:ListItem Value="True">是</asp:ListItem>
                    <asp:ListItem Value="False">否</asp:ListItem>
                </asp:RadioButtonList>
                <table id="tblProductListThumbSize" runat="server">
                    <tr>
                        <td>
                            缩略图宽度:<asp:TextBox ID="txtProductListThumbWidth" runat="server" Width="20"></asp:TextBox>缩略图高度:<asp:TextBox
                                ID="txtProductListThumbHeight" runat="server" Width="20"></asp:TextBox>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            如果您不能确认图片的原始尺寸，无法指定具体的宽和高时，可以只指定宽度或者高度中的一个值，0代表不设置，图片会根据您设置的宽度或高度自动调节图片大小，以此避免图片失真的情况
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>购物车继续购物按钮链接地址：</strong>
            </td>
            <td>
                <asp:TextBox ID="TxtContinueBuy" Width="250px" runat="server"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>订购成功返回按钮链接地址：</strong>
            </td>
            <td>
                <asp:TextBox ID="TxtAgainBuy" Width="250px" runat="server"></asp:TextBox>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>购物流程模式：</strong>
            </td>
            <td>
                <asp:RadioButton ID="NewShoppingFlow" runat="server" GroupName="ShoppingFlow" Text="三步购物流程（使用Shopping.aspx文件）-新"
                    Checked="true" />
                <asp:RadioButton ID="OldShoppingFlow" runat="server" GroupName="ShoppingFlow" Text="四步购物流程（使用ShoppingCart.aspx文件）" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>购物车中是否默认选择赠品赠送：</strong>
            </td>
            <td>
                <asp:CheckBox ID="chkShoppingCartSendPresent" runat="server" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>在线支付成功后以站内信发送卡号和密码：</strong>
            </td>
            <td>
                <asp:CheckBox ID="chkCardOnlinePayMessage" runat="server" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>在线支付成功后以手机短信发送卡号和密码：</strong>
            </td>
            <td>
                <asp:CheckBox ID="chkCardOnlinePayMobilePhone" runat="server" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>在线支付成功后以邮件发送卡号和密码：</strong>
            </td>
            <td>
                <asp:CheckBox ID="chkCardOnlinePayMail" runat="server" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>使用优惠券时是否允许优惠券抵消运费部分：</strong>
            </td>
            <td>
                <asp:CheckBox ID="chkCouponDeliverPay" runat="server" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft">
                <strong>是否自动更新模型筛选字段：</strong>
            </td>
            <td>
                <asp:CheckBox ID="ChkAutoUpdateModelFilterField" runat="server" />
            </td>
        </tr>
        <tr class="tdbgbottom">
            <td colspan="2">
                <pe:ExtendedButton ID="BtnSubmit" IsChecked="true" OperateCode="ShopParameterConfig"
                    runat="server" Text="保存设置" OnClick="BtnSubmit_Click" />
            </td>
        </tr>
    </table>
    <script type="text/javascript"> 
      if(<%=RadlEnablePartPay1.Checked.ToString().ToLower() %>)
      document.getElementById("partAgeTR").style.display='';
    </script>
</asp:Content>
