﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.ShoppingCartManage" Title="购物车管理" Codebehind="ShoppingCartManage.aspx.cs" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <pe:ExtendedGridView ID="GdvShoppingCart" runat="server" AllowPaging="True" AutoGenerateColumns="False"
        DataKeyNames="CartId" DataSourceID="OdsShoppingCart" ItemName="购物车记录" EmptyDataText="没有任何购物车记录！"
        CheckBoxFieldHeaderWidth="3%" SerialText="" OnRowDataBound="GdvShoppingCart_RowDataBound" OnRowCommand="GdvShoppingCart_RowCommand">
        <Columns>
            <pe:TemplateField HeaderText="购物车ID" SortExpression="OrderNum">
                <HeaderStyle Width="30%" />
                <ItemTemplate>
                    <a href='<%# string.Format("ShoppingCartDetail.aspx?CartID={0}&UserName={1}&UpdateTime={2}",Eval("CartId"),Server.UrlEncode(Eval("UserName").ToString()),Eval("UpdateTime")) %>'>
                        <%#Eval("CartId")%>
                    </a>
                </ItemTemplate>
            </pe:TemplateField>
             <pe:TemplateField HeaderText="用户名" SortExpression="UserName">
                <ItemTemplate>
                    <a href='../User/UserShow.aspx?UserName=<%#Eval("UserName") %>'><%# Eval("UserName")%></a>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="催单">
                <ItemTemplate>
                    <asp:Button ID="BtnInform" CommandName="Inform" runat="server" Text="手机催单" />
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="已催">
                <ItemTemplate>
                    <asp:Literal ID="LtrInformResult" Text="×" runat="server"></asp:Literal>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField DataField="UpdateTime" HeaderText="时间" DataFormatString="{0:yyyy-MM-dd HH:mm:ss}"
                HtmlEncode="False" />
            <pe:BoundField DataField="Quantity" HeaderText="数量" />
            <pe:BoundField DataField="TotalMoney" HeaderText="预计金额（元）" DataFormatString="{0:N2}"
                HtmlEncode="False" />
        </Columns>
    </pe:ExtendedGridView>
    <asp:ObjectDataSource ID="OdsShoppingCart" runat="server" SelectCountMethod="GetTotalOfShoppingCart"
        SelectMethod="GetList" TypeName="PowerEasy.Module.Shop.BusinessLogic.ShoppingCart" EnablePaging="True"
        StartRowIndexParameterName="startRowIndexId" MaximumRowsParameterName="maxNumberRows">
        <SelectParameters>
            <asp:QueryStringParameter DefaultValue="0" Name="searchType" QueryStringField="SearchType"
                Type="String" />
            <asp:QueryStringParameter DefaultValue="" Name="keyword" QueryStringField="keyword"
                Type="String" />
        </SelectParameters>
    </asp:ObjectDataSource>
</asp:Content>
