﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    CodeBehind="Stock.aspx.cs" Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.Stock"
    Title="库单添加/修改" Async="true" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" runat="server" SiteMapProvider="AdminMapProvider">
    </pe:ExtendedSiteMapPath>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    <table border="0" cellpadding="2" cellspacing="1" class="border" width="100%">
        <tr align="center">
            <td class="spacingtitle" colspan="2">
                <strong>
                    <asp:Label ID="LblTitle" runat="server"></asp:Label></strong>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 25%; text-align: right">
                单据编号：
            </td>
            <td style="width: 75%">
                <asp:Label ID="LblStockNum" runat="server"></asp:Label>
            </td>
        </tr>
        <tr class="tdbg" style="color: #000000">
            <td style="text-align: right">
                录入时间：
            </td>
            <td>
                <pe:DatePicker ID="DpkInputTime" runat="server" Width="155px" IsLongDate="True"></pe:DatePicker>
            </td>
        </tr>
        <tr class="tdbg" style="color: #000000">
            <td style="text-align: right">
                录 入 者：
            </td>
            <td>
                <asp:TextBox ID="TxtAuthor" runat="server" MaxLength="255"></asp:TextBox>
                
                    <pe:FloatDivDialog ID="OlAuthorType" runat="server" BeginString="【" EndString="】" Height="450" Width="650" CloseText="关闭" Name="选择录入者" Title="选择录入者" Skin="floatingDialogFontSkin"   ButtonWidth="180"  Enabled="true"  ></pe:FloatDivDialog>
                <pe:RequiredFieldValidator ID="ReqAuthor" runat="server" Display="Dynamic" SetFocusOnError="true"
                    ErrorMessage="录入者不能为空" Visible="false" ControlToValidate="TxtAuthor"></pe:RequiredFieldValidator>
            </td>
        </tr>
        <tr class="tdbg" style="color: #000000">
            <td style="text-align: right">
                备&nbsp; &nbsp; 注：
            </td>
            <td>
                <asp:TextBox ID="TxtRemark" runat="server" Height="65px" TextMode="MultiLine" Width="338px"
                    MaxLength="100" Wrap="true"></asp:TextBox>
                <span style="color: red"></span>
            </td>
        </tr>
        <tr align="center" class="tdbg">
            <td colspan="2" style="text-align: center">
                <pec:FloatingDialog ID="FdAddProduct" runat="server" Name="添加商品" BeginString="【"
                    EndString="】" Title="添加商品" Width="700" Height="450" LoadUrl="../Shop/ProductPicker.aspx"
                    Skin="floatingDialogFontSkin" />
            </td>
        </tr>
        <tr align="center" class="tdbg">
            <td colspan="2">
                <asp:ScriptManager ID="ScriptManager1" runat="server">
                </asp:ScriptManager>
                <asp:UpdatePanel ID="UpdatePanel1" runat="server" OnLoad="UpdatePanel1_Load">
                    <ContentTemplate>
                        <pe:ExtendedGridView ID="EgvStockItem" runat="server" AutoGenerateColumns="False"
                            CheckBoxFieldHeaderWidth="3%" SerialText="" OnRowDeleting="EgvStockItem_RowDeleting"
                            IsHoldState="True" OnRowDataBound="EgvStockItem_RowDataBound" OnDataBound="EgvStockItem_DataBound">
                            <Columns>
                                <asp:TemplateField HeaderText="商品名称">
                                    <ItemStyle HorizontalAlign="Left" />
                                    <ItemTemplate>
                                        <asp:Label runat="server" Text='' ID="LblProductName"></asp:Label>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:BoundField DataField="ProductNum" HeaderText="商品编号" />
                                <asp:BoundField DataField="Unit" HeaderText="单位">
                                    <HeaderStyle Width="5%" />
                                </asp:BoundField>
                                <asp:TemplateField HeaderText="现有库存">
                                    <ItemTemplate>
                                        <asp:Label ID="LblStock" runat="server"></asp:Label>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="数量">
                                    <ItemTemplate>
                                        <asp:TextBox ID="TxtAmount" Style="text-align: center" runat="server" Width="75px"
                                            onkeyup="TxtAmount_OnKeyUp(event)" MaxLength="9" Text='<%# Eval("Amount") %>'></asp:TextBox>
                                        <asp:RangeValidator ID="ValcAmount" runat="server" ControlToValidate="TxtAmount"
                                            Display="Dynamic" ErrorMessage="请输入数量!" MinimumValue="1" MaximumValue="2147483647"
                                            SetFocusOnError="True" Type="Integer"></asp:RangeValidator>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="入/出库后库存">
                                    <ItemTemplate>
                                        <asp:Label ID="LblAfterStock" runat="server"></asp:Label>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="价格">
                                    <ItemTemplate>
                                        <asp:TextBox ID="TxtPrice" Style="text-align: right" runat="server" Width="75px"
                                            MaxLength="12" Text='<%# Eval("Price","{0:0.00}") %>'></asp:TextBox>
                                        <asp:CompareValidator ID="ValcPrice" runat="server" ErrorMessage="请输入价钱!" Display="Dynamic"
                                            ControlToValidate="TxtPrice" Type="Double" Operator="GreaterThanEqual" ValueToCompare="0"></asp:CompareValidator>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="操作">
                                    <HeaderStyle Width="5%" />
                                    <ItemTemplate>
                                        <asp:LinkButton ID="LbtnDelete" runat="server" CausesValidation="False" CommandName="Delete">删除</asp:LinkButton>
                                    </ItemTemplate>
                                </asp:TemplateField>
                            </Columns>
                        </pe:ExtendedGridView>
                    </ContentTemplate>
                </asp:UpdatePanel>
            </td>
        </tr>
    </table>
    <asp:Panel ID="panMsg" runat="server">
        <table border="0" cellpadding="2" cellspacing="1" class="border" width="100%">
            <tr class="tdbg">
                <td style="text-align: left">
                    <asp:CheckBox ID="chkMessage" Checked="true" runat="server" Text="使用站内信确认到货通知" /><br />
                    <asp:CheckBox ID="chkEmail" Checked="true" runat="server" Text="使用Email确认到货通知" /><br />
                    <asp:CheckBox ID="chkMobile" Checked="true" runat="server" Text="使用手机短信确认到货通知" />
                </td>
            </tr>
        </table>
        注意：库存单据一旦保存后，除“备注”外其他信息将不能修改。
    </asp:Panel>
    <p style="text-align: center">
        <asp:Button ID="BtnSave" runat="server" OnClick="BtnSave_Click" Text="保 存" />&nbsp;<asp:HiddenField
            ID="HdnStockType" runat="server" />
    </p>
    <script type="text/javascript">
        function DoProductPickerPostBack(arrProductList) {
            __doPostBack('<%=UpdatePanel1.ClientID %>', arrProductList);
            CloseFloatingDialog();
        }

        function CheckLength(obj) {
            if (obj.value.length > 200) {
                obj.value = obj.value.substr(0, 200);
            }
        }
        Request = {
            QueryString: function (item) {
                var svalue = location.search.match(new RegExp("[\?\&]" + item + "=([^\&]*)(\&?)", "i"));
                return svalue ? svalue[1] : svalue;
            }
        }
        function TxtAmount_OnKeyUp(e) {
            e = e || window.event;
            var txtAmount = e.target || e.srcElement;
            var prefix = txtAmount.id.replace("TxtAmount", "")
            var lblAfterStock = document.getElementById(prefix + "LblAfterStock");
            var lblStock = document.getElementById(prefix + "LblStock");
            var amount = parseInt(txtAmount.value);
            if (isNaN(amount)) {
                amount = 0;
            }
            var action = Request.QueryString("Action");
            if (action == "Modify") {
                action = Request.QueryString("Type");
            }
            switch (action) {
                case "InStock":
                case "Replenishment":
                    lblAfterStock.innerHTML = parseInt(lblStock.innerHTML) + amount;
                    break;
                case "Shipment":
                    lblAfterStock.innerHTML = parseInt(lblStock.innerHTML) - amount;
                    break;
            }

        }
    </script>
</asp:Content>
