﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    Codebehind="StockManage.aspx.cs" Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.StockManage"
    Title="库单管理" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" runat="server" SiteMapProvider="AdminMapProvider">
    </pe:ExtendedSiteMapPath>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">
    &nbsp;<asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
    <asp:UpdatePanel ID="UpdatePanel2" runat="server">
        <ContentTemplate>
            <asp:ObjectDataSource ID="ObsStock" runat="server" EnablePaging="True" MaximumRowsParameterName="maxNumberRows"
                SelectCountMethod="GetTotalOfStock" SelectMethod="GetList" StartRowIndexParameterName="startRowIndexId"
                TypeName="PowerEasy.Module.Shop.BusinessLogic.StockManage" DeleteMethod="Delete">
                <SelectParameters>
                    <asp:QueryStringParameter DefaultValue="0" Name="searchType" QueryStringField="SearchType"
                        Type="Int32" />
                    <asp:QueryStringParameter DefaultValue="" Name="keyword" QueryStringField="KeyWord"
                        Type="String" />
                </SelectParameters>
                <DeleteParameters>
                    <asp:Parameter Name="stockId" Type="String" />
                </DeleteParameters>
            </asp:ObjectDataSource>
            <pe:ExtendedGridView ID="EgvStock" runat="server" Width="100%" AllowPaging="True" OnRowDataBound="EgvStock_RowDataBound"
                AutoGenerateCheckBoxColumn="True" AutoGenerateColumns="False" CheckBoxFieldHeaderWidth="3%"
                DataKeyNames="StockId" DataSourceID="ObsStock" SerialText="" OnRowCommand="EgvStock_RowCommand"
                OnRowDeleting="EgvStock_RowDeleting" Font-Underline="False" IsHoldState="True"
                RowDblclickBoundField="StockID" RowDblclickUrl="stock.aspx?Action=Modify&amp;ID={$Field}">
                <Columns>
                    <asp:TemplateField HeaderText="单据编号" ShowHeader="False">
                        <headerstyle width="15%" />
                        <itemtemplate>
<asp:LinkButton runat="server" CommandName="View" CausesValidation="false" id="LbtnView" Text='<%# Eval("StockNum") %>' CommandArgument='<%# Eval("StockId").ToString() +"|"+Eval("StockType").ToString()+"|"+Eval("StockNum").ToString() %>'></asp:LinkButton><asp:Label ID="LblInStockStatus" runat="server" Visible="false" ></asp:Label>
</itemtemplate>

                    </asp:TemplateField>
                    <asp:BoundField DataField="InputTime" DataFormatString="{0:yyyy-MM-dd HH:mm:ss}" HeaderText="录入时间"
                        HtmlEncode="False" SortExpression="InputTime">
                        <HeaderStyle Width="15%" />
                    </asp:BoundField>
                      <pe:TemplateField HeaderText="录入者" SortExpression="Inputer">
                        <HeaderStyle Width="10%" />
                        <ItemTemplate>
                            <%# Eval("Inputer")%>
                        </ItemTemplate>
                    </pe:TemplateField>
                    <asp:TemplateField HeaderText="备注" SortExpression="Remark">
                        <itemstyle horizontalalign="Left" />
                        <ItemTemplate>
                            <asp:Label ID="Label1" runat="server" Text='<%# PowerEasy.Framework.Common.StringHelper.SubString(Eval("Remark").ToString(),30,"...") %>'
                                ToolTip='<%# Eval("Remark") %>'></asp:Label>
                        
</ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="操作">
                        <HeaderStyle Width="20%" />
                        <ItemTemplate>
                            <asp:LinkButton ID="LbtnDelete" runat="server" CommandName="Delete" OnClientClick="if(!this.disabled) return confirm('是否要删除此记录？')">删除</asp:LinkButton>
                            <a href='stock.aspx?ID=<%#Eval("StockID") %>&Action=Modify&Type=<%#Eval("StockType") %>'>修改</a>
                            <asp:LinkButton Text="确认入库" ID="LbtnConfirmInStock" runat="server" CommandName="ConfirmInStock" 
                            CommandArgument='<%#Eval("StockID") %>' Visible="false" ></asp:LinkButton>
</ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </pe:ExtendedGridView>
        </ContentTemplate>
    </asp:UpdatePanel>
    <div style="padding:5px 0 5px 0; ">
    <asp:Button ID="BtnDelete" runat="server" Text="删除选择的记录" OnClick="BtnDelete_Click"
        OnClientClick="return batchconfirm('是否要删除选定的记录？')" />
        <asp:Button ID="BtnExportExcel" runat="server" Text="导出到Excel" 
            onclick="BtnExportExcel_Click" />
    </div>
    <asp:UpdatePanel ID="UpdatePanel1" runat="server">
        <ContentTemplate>
            <asp:Panel ID="PnlStockItem" runat="server" Visible="False" Width="100%">
                <table border="0" cellpadding="0" cellspacing="0" class="border" style="width: 100%;  ">
                    <tr>
                        <td class="title" style="height: 25px; text-align: center">
                            <asp:Label ID="LblTitle" runat="server"></asp:Label></td>

                    </tr>
                    <tr>
                        <td class="tdbg" style="padding-right: 5px; padding-left: 5px; padding-bottom: 5px;
                            padding-top: 5px">
                            <pe:ExtendedGridView ID="EgvStockItem" runat="server" AutoGenerateColumns="False"
                                CheckBoxFieldHeaderWidth="3%" OnDataBound="EgvStockItem_DataBound" OnRowDataBound="EgvStockItem_RowDataBound"
                                SerialText="" ShowFooter="True" IsHoldState="True">
                                <Columns>
                                    <asp:TemplateField HeaderText="商品名称">
                                        <itemstyle horizontalalign="Left" />
                                        <itemtemplate>
<asp:Label runat="server" Text='' id="LblProductName"></asp:Label>
</itemtemplate>
                                    </asp:TemplateField>
                                    <asp:BoundField DataField="ProductNum" HeaderText="商品编号" />
                                    <asp:BoundField DataField="Unit" HeaderText="单位" >
                                        <HeaderStyle Width="5%" />
                                    </asp:BoundField>
                                    <asp:BoundField DataField="Amount" HeaderText="数量" />
                                    <asp:BoundField DataField="Price" DataFormatString="{0:0.00}" HeaderText="价格" HtmlEncode="False">
                                        <ItemStyle HorizontalAlign="Right" />
                                    </asp:BoundField>
                                    <asp:TemplateField HeaderText="金额">
                                        <ItemStyle HorizontalAlign="Right" />
                                        <ItemTemplate>
                                            <asp:Label ID="LblMoney" runat="server"></asp:Label>
                                        
</ItemTemplate>
                                    </asp:TemplateField>
                                </Columns>
                            </pe:ExtendedGridView>
                        </td>
                    </tr>
                </table>
            </asp:Panel>
        </ContentTemplate>
        <Triggers>
            <asp:AsyncPostBackTrigger ControlID="EgvStock" EventName="RowCommand" />
        </Triggers>
    </asp:UpdatePanel>
    <br />
</asp:Content>

