﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    ValidateRequest="false" Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.TrademarkAdd"
    Title="品牌添加" Codebehind="TrademarkAdd.aspx.cs" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <table width="100%" border="0" cellpadding="2" cellspacing="1" class="border">
        <tr align="center">
            <td colspan="2" class="spacingtitle">
                <b>添加品牌信息</b>
            </td>
        </tr>
        <tr class="tdbg">
            <td style="width: 15%; white-space:nowrap;" class="tdbgleft" align="right">
                品牌名称：</td>
            <td>
                <asp:TextBox ID="TxtTrademarkName" runat="server" MaxLength="50"></asp:TextBox>
                <pe:RequiredFieldValidator ID="ValrTrademarkName" runat="server" ErrorMessage="品牌名称不能为空"
                    ControlToValidate="TxtTrademarkName" Display="Dynamic"></pe:RequiredFieldValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" align="right">
                所属厂商：</td>
            <td>
                <asp:DropDownList ID="DropProducerId" DataTextField="ProducerName" DataValueField="ProducerId"
                    runat="server">
                </asp:DropDownList>
            </td>
        </tr>
        <tr class="tdbg">
            <td  class="tdbgleft" align="right">
                是否推荐：</td>
            <td>
                <asp:CheckBox ID="ChkIsElite" runat="server" />
            </td>
        </tr>
        <tr class="tdbg">
            <td  class="tdbgleft" align="right">
                品牌分类：</td>
            <td>
                <asp:RadioButtonList ID="RadlTrademarkType" runat="server" RepeatLayout="Flow" RepeatDirection="Horizontal" /> 
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" align="right">
                进驻时间：
            </td>
            <td>
                <pe:DatePicker ID="DpkBeginDate" runat="server" Width="155px" IsLongDate="false" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" align="right">
                品牌照片：
            </td>
            <td>
                <asp:Image ID="ImgTrademarkPhoto" Visible="true" Width="150px" Height="172px" ImageAlign="AbsMiddle"
                    runat="server" ImageUrl="../../Admin/Images/default.gif" /><br />
                <pe:FileUploadControl ID="ExtenFileUpload" ModuleName="Trademark" CustomReturnJSFunction="UpdateImgSrc" IsAddFileRecord="true"
                    runat="server">
                </pe:FileUploadControl>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" align="right">
                顶部广告照片：
            </td>
            <td>
                <pe:FileUploadControl ID="FileUploadBannerPhoto" ModuleName="Trademark" CustomReturnJSFunction="UpdateImgSrc"
                    IsAddFileRecord="true" runat="server">
                </pe:FileUploadControl>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" align="right">
                广告多图：
            </td>
            <td>
                <pec:MultiplePhoto ID="MultiplePhoto1" runat="server" MaxUploadPhotoCount="5"  ModuleName="Trademark"/>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" align="right">
                中部广告照片：
            </td>
            <td>
                <pe:FileUploadControl ID="FileUploadMiddlePhoto" ModuleName="Trademark" CustomReturnJSFunction="UpdateImgSrc"
                    IsAddFileRecord="true" runat="server">
                </pe:FileUploadControl>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" align="right">
                品牌简介：
            </td>
            <td>
                <pe:UEditor ID="CKTrademarkShortIntro" runat="server" Width="580px" Height="100px" Toolbar="Simple" />
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" align="right">
                品牌介绍：
            </td>
            <td>
                <pe:UEditor Height="300px" Width="600px" ID="EditorTrademarkIntro" runat="server"
                    FlashUpload="true" LinkUpload="true" ImageUpload="true" Toolbar="Simple" ModuleName="trademark"
                    FileRecord="true">
                </pe:UEditor>
            </td>
        </tr>
        <tr class="tdbg">
            <td colspan="2" style="text-align: center">
                <pe:ExtendedButton IsChecked="true" OperateCode="TrademarkManage" ID="BtnSubmit"
                    runat="server" Text="添加" Width="58px" OnClick="BtnSubmit_Click" />&nbsp;&nbsp;
                <input name="Cancel" type="button" runat="server" class="inputbutton" id="BtnCancel"
                    value="取消" onclick="Redirect('TrademarkManage.aspx')" />
            </td>
        </tr>
    </table>

    <script type="text/javascript">
    function UpdateImgSrc(path,size,id)
    {
        document.getElementById("<%= ImgTrademarkPhoto.ClientID %>").src = "<%= m_UploadDir %>" + path;
    }
    //兼容编辑器返回值，商店没有预览
    function SetUrl(url){}
    </script>

</asp:Content>
