﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.TrademarkManage" Title="品牌管理" Codebehind="TrademarkManage.aspx.cs" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <pe:ExtendedGridView ID="EgvTrademark" runat="server" AllowPaging="True" AutoGenerateColumns="False"
        AutoGenerateCheckBoxColumn="True" DataKeyNames="TrademarkId" DataSourceID="OdsTrademark"
        ItemName="品牌" ItemUnit="个" OnRowCommand="EgvTrademark_RowCommand" OnRowDataBound="EgvTrademark_RowDataBound"
        RowDblclickBoundField="TrademarkId" RowDblclickUrl="TrademarkModify.aspx?TrademarkId={$Field}">
        <Columns>
            <pe:BoundField DataField="TrademarkName" HeaderText="品牌名称" SortExpression="TrademarkName"
                >
            </pe:BoundField>
            <pe:TemplateField HeaderText="品牌分类" SortExpression="TrademarkType">
                <ItemTemplate>
                    <%#PowerEasy.Module.Shop.BusinessLogic.Trademark.GetTrademarkType(Convert.ToInt32(Eval("TrademarkType")))%>
                </ItemTemplate>
                <HeaderStyle Width="10%" />
            </pe:TemplateField>
            <pe:TemplateField HeaderText="已启用" SortExpression="Passed">
                <HeaderStyle Width="7%" />
                <ItemTemplate>
                    <%# (bool)Eval("Passed") != false ? "<font color=green>√</font>" : "<font color=red>×</font>"%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="属性">
                <HeaderStyle Width="7%" />
                <ItemTemplate>
                    <pe:ExtendedLabel HtmlEncode="false" ID="LblTrademarkAttribute" runat="server"></pe:ExtendedLabel>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="操作">
                <HeaderStyle Width="20%" />
                <ItemTemplate>
                    <pe:ExtendedAnchor IsChecked="true" runat="server" OperateCode="TrademarkManage"
                        href='<%# Eval("TrademarkId","TrademarkModify.aspx?TrademarkId={0}") %>'>修改</pe:ExtendedAnchor>
                    <pe:ExtendedLinkButton IsChecked="true" OperateCode="TrademarkManage" ID="LbtnPassed"
                        runat="server" CommandName="Passed" CommandArgument='<%# Bind("TrademarkId") %>'
                        Visible='<%#!Convert.ToBoolean(Eval("Passed")) %>' CausesValidation="False">启用</pe:ExtendedLinkButton>
                    <pe:ExtendedLinkButton IsChecked="true" OperateCode="TrademarkManage" ID="LbtnCancelPassed"
                        runat="server" CommandName="CancelPassed" CommandArgument='<%# Bind("TrademarkId") %>'
                        Visible='<%# Convert.ToBoolean(Eval("Passed")) %>' CausesValidation="False">禁用</pe:ExtendedLinkButton>
                    <pe:ExtendedLinkButton IsChecked="true" OperateCode="TrademarkManage" ID="LbtnOnTop"
                        runat="server" CommandArgument='<%# Bind("TrademarkId") %>' CommandName="OnTop"
                        Visible='<%#!Convert.ToBoolean(Eval("OnTop")) %>' CausesValidation="False">固顶</pe:ExtendedLinkButton>
                    <pe:ExtendedLinkButton IsChecked="true" OperateCode="TrademarkManage" ID="LbtnCancelOnTop"
                        runat="server" CommandArgument='<%# Bind("TrademarkId") %>' CommandName="CancelOnTop"
                        Visible='<%#Convert.ToBoolean(Eval("OnTop")) %>' CausesValidation="False">解固</pe:ExtendedLinkButton>
                    <pe:ExtendedLinkButton IsChecked="true" OperateCode="TrademarkManage" ID="LbtnElite"
                        runat="server" CommandArgument='<%# Bind("TrademarkId") %>' CommandName="Elite"
                        Visible='<%#!Convert.ToBoolean(Eval("IsElite")) %>' CausesValidation="False">推荐</pe:ExtendedLinkButton>
                    <pe:ExtendedLinkButton IsChecked="true" OperateCode="TrademarkManage" ID="LbtnCancelElite"
                        runat="server" CommandArgument='<%# Bind("TrademarkId") %>' CommandName="CancelElite"
                        Visible='<%#Convert.ToBoolean(Eval("IsElite")) %>' CausesValidation="False">解荐</pe:ExtendedLinkButton>
                    <pe:ExtendedLinkButton IsChecked="true" OperateCode="TrademarkManage" ID="LbtnDelete"
                        runat="server" CausesValidation="False" CommandArgument='<%# Eval("TrademarkId") %>'
                        CommandName="Del" OnClientClick="return confirm('是否删除该品牌？')">删除</pe:ExtendedLinkButton>
                </ItemTemplate>
            </pe:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <asp:ObjectDataSource ID="OdsTrademark" runat="server" SelectCountMethod="GetTotalOfTrademark"
        SelectMethod="GetList" TypeName="PowerEasy.Module.Shop.BusinessLogic.Trademark" EnablePaging="True"
        StartRowIndexParameterName="startRowIndexId" MaximumRowsParameterName="maxNumberRows">
        <SelectParameters>
            <asp:QueryStringParameter Name="searchType" QueryStringField="SearchType" Type="String" />
            <asp:QueryStringParameter Name="keyword" QueryStringField="KeyWord" Type="String" />
            <asp:QueryStringParameter Name="trademarkType" QueryStringField="TrademarkType" Type="String" />
            <asp:Parameter DefaultValue="false" Name="isPassed" Type="Boolean" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <br />
    &nbsp;&nbsp;
    <pe:ExtendedButton IsChecked="true" OperateCode="TrademarkManage" ID="BtnDelete"
        runat="server" OnClientClick="return batchconfirm('是否要删除记录？')" Text="删除选中的品牌" OnClick="BtnDelete_Click" />
    <br />
</asp:Content>
