﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.TransferLogUI" Title="订单过户"
    CodeBehind="TransferLog.aspx.cs" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <table width="100%" border="0" cellpadding="2" cellspacing="1" class="border">
        <tr align="center">
            <td colspan="2" class="spacingtitle">
                <b>订单过户</b>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" style="width: 40%; text-align: right;">
                订单编号：
            </td>
            <td style="width: 484px;">
                <asp:Literal ID="LtrOrderNum" runat="server"></asp:Literal>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" style="width: 40%; text-align: right">
                当前客户：
            </td>
            <td style="width: 484px">
                <asp:Literal ID="LtrClientName" runat="server"></asp:Literal>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" style="width: 40%; text-align: right">
                当前会员：
            </td>
            <td style="width: 484px">
                <asp:Literal ID="LtrUserName" runat="server"></asp:Literal>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" style="width: 40%; text-align: right">
                欲过户给：
            </td>
            <td style="width: 484px">
                <asp:RadioButton Text="会员" runat="server" AutoPostBack='true' GroupName="aa" Checked="true"
                    ID="RdbUsers" OnCheckedChanged="RdbClient_CheckedChanged" />
                <asp:RadioButton Text="客户" runat="server" ID="RdbClient" GroupName="aa" AutoPostBack='true'
                    OnCheckedChanged="RdbClient_CheckedChanged" />
                <br />
                <asp:TextBox ID="TxtClientSelect" runat="server" CssClass="inputxt" MaxLength="255" Visible="false"></asp:TextBox>
                <pe:FloatDivDialog ID="floatClientSelect" runat="server" BeginString="【" EndString="】"
                    Height="550" Width="450" CloseText="关闭" Name="选择对应的客户" Title="选择对应的客户" Skin="floatingDialogFontSkin"
                    ButtonWidth="180" Enabled="true" Visible="false">
                </pe:FloatDivDialog>
                <asp:HiddenField ID="HnClientSelect" runat="server" />
                <pe:RequiredFieldValidator ID="ValrClientId" runat="server" Visible="false" ErrorMessage="RequiredFieldValidator"
                    ControlToValidate="TxtClientSelect" Display="Dynamic">请选择对应的客户</pe:RequiredFieldValidator>
                <asp:TextBox ID="TxtUserName" runat="server"></asp:TextBox>
                <pec:FloatingDialog ID="FdSelectUser" runat="server" Width="670" Height="450" Name="会员列表"
                    BeginString="&lt;=【" EndString="】" Skin="floatingDialogFontSkin" Title="会员列表"
                    LoadUrl="../User/UserNameList.aspx?Select=single" />
                <pe:RequiredFieldValidator ID="ValrUser" runat="server" ErrorMessage="请输入对应会员" Display="Dynamic"
                    ControlToValidate="TxtUserName"></pe:RequiredFieldValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" style="width: 40%; text-align: right; height: 28px;">
                手续费：
            </td>
            <td style="width: 484px; height: 28px;">
                <asp:TextBox ID="TxtPoundage" runat="server" MaxLength="50"></asp:TextBox>
                <asp:RangeValidator ID="RangeValidator1" runat="server" ControlToValidate="TxtPoundage"
                    Display="Dynamic" ErrorMessage="只能填写0到99999中间的货币字符" MaximumValue="99999" MinimumValue="0"
                    Type="Double"></asp:RangeValidator>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" style="width: 40%; text-align: right">
                手续费支付者：
            </td>
            <td style="width: 484px">
                <asp:RadioButtonList ID="RadlPayer" runat="server">
                    <asp:ListItem Selected="true" Value="1">订单当前所有者</asp:ListItem>
                    <asp:ListItem Value="2">过户对象</asp:ListItem>
                </asp:RadioButtonList>
            </td>
        </tr>
        <tr class="tdbg">
            <td class="tdbgleft" style="width: 40%; text-align: right; height: 27px;">
                备注：
            </td>
            <td style="width: 484px; height: 27px;">
                <asp:TextBox ID="TxtRemark" runat="server" MaxLength="50"></asp:TextBox>
            </td>
        </tr>
        <tr align="center" class="tdbg">
            <td style="height: 48px" colspan="2">
                <asp:TextBox ID="TxtOrderID" runat="server" Visible="false"></asp:TextBox>
                <pe:ExtendedButton IsChecked="true" OperateCode="OrderTransfer" ID="BtnSave" runat="server"
                    Text="确定" OnClick="BtnSave_Click" />
                <asp:Button ID="BtnReturn" runat="server" Text="取消" CausesValidation="false" OnClick="BtnReturn_Click" />
            </td>
        </tr>
    </table>
    <script type="text/javascript">
        function DoPostBack(username) {
            __doPostBack("AddUserButton", username);
        }
    </script>
</asp:Content>
