﻿<%@ Page Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true"
    Inherits="PowerEasy.Module.Shop.WebSite.Admin.Shop.TransferLogManage" Title="订单过户管理" Codebehind="TransferLogManage.aspx.cs" %>

<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="Server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="Server">
    <pe:ExtendedGridView ID="EgvTransferLog" runat="server" AutoGenerateColumns="False"
        EmptyDataText="暂无任何数据！" AllowPaging="True" DataSourceID="OdsTransferLog" DataKeyNames="TransferLogId"
        ItemName="记录" ItemUnit="条" RowDblclickBoundField="TransferLogID" RowDblclickUrl="TransferLogDetail.aspx?TransferLogID={$Field}">
        <Columns>
            <pe:BoundField DataField="TransferTime" HeaderText="时间" HeaderStyle-Width="14%" SortExpression="TransferTime"
                DataFormatString="{0:yyyy-MM-dd HH:mm:ss}" HtmlEncode="False" />
            <pe:TemplateField HeaderText="订单编号">
                <ItemTemplate>
                    <a href='<%#string.Format("OrderManage.aspx?OrderID={0}",Eval("OrderId"))%>'>
                        <%#Eval("OrderNum") %>
                    </a>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField DataField="UserName" HeaderText="当前所有者" HeaderStyle-Width="10%" SortExpression="UserName"/>
            <pe:TemplateField HeaderText="过户人">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <a href='../User/UserShow.aspx?UserName=<%#Eval("OwnerUserName") %>'><%# Eval("OwnerUserName")%></a>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="过户给">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <a href='../User/UserShow.aspx?UserName=<%#Eval("TargetUserName") %>'><%# Eval("TargetUserName")%></a>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField DataField="Poundage" HeaderText="过户费" HeaderStyle-Width="10%" DataFormatString="{0:N2}"
                HtmlEncode="false" SortExpression="Poundage" />
            <pe:BoundField DataField="PayerUserName" HeaderText="付款人" HeaderStyle-Width="10%"
                SortExpression="PayerUserName"  />
            <pe:TemplateField HeaderText="付款人">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <a href='../User/UserShow.aspx?UserName=<%#Eval("PayerUserName") %>'><%# Eval("PayerUserName")%></a>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="操作人" SortExpression="Inputer">
                <HeaderStyle Width="8%" />
                <ItemTemplate>
                    <%# Eval("Inputer")%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="操作" HeaderStyle-Width="6%">
                <ItemTemplate>
                    <a href='<%#string.Format("TransferLogDetail.aspx?TransferLogID={0}",Eval("TransferLogID"))%>'> 查看</a>
                </ItemTemplate>
            </pe:TemplateField>
        </Columns>
    </pe:ExtendedGridView>
    <asp:ObjectDataSource ID="OdsTransferLog" runat="server" SelectCountMethod="GetTotalOfTransferLog"
        SelectMethod="GetList" TypeName="PowerEasy.Module.Shop.BusinessLogic.TransferLog" EnablePaging="true"
        StartRowIndexParameterName="startRowIndexId" MaximumRowsParameterName="maxNumberRows">
        <SelectParameters>
            <asp:QueryStringParameter DefaultValue="0" Name="searchType" QueryStringField="SearchType"
                Type="String" />
            <asp:QueryStringParameter DefaultValue="0" Name="field" QueryStringField="Field"
                Type="String" />
            <asp:QueryStringParameter DefaultValue="" Name="keyword" QueryStringField="KeyWord"
                Type="String" />
        </SelectParameters>
    </asp:ObjectDataSource>
</asp:Content>
