﻿<%@ Page Title="会员积分明细" Language="C#" MasterPageFile="~/Admin/MasterPage.master" AutoEventWireup="true" CodeBehind="UserExpLog.aspx.cs" Inherits="PowerEasy.Module.General.WebSite.Admin.User.UserExpLog" %>
<asp:Content ID="Content1" ContentPlaceHolderID="CphNavigation" runat="server">
    <pe:ExtendedSiteMapPath ID="SmpNavigator" SiteMapProvider="AdminMapProvider" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="CphContent" runat="server">


    <pe:ExtendedGridView ID="EgvUserExpLog" runat="server" AllowPaging="True" 
        AutoGenerateColumns="False" CheckBoxFieldHeaderWidth="3%" DataKeyNames="LogId" 
        DataSourceID="OdsUserExpLog" IsHoldState="True" 
        ondatabound="EgvUserExpLog_DataBound" 
        onrowdatabound="EgvUserExpLog_RowDataBound" SerialText="" ShowFooter="True">
        <FooterStyle CssClass="tdbg" />
        <Columns>
            <asp:BoundField DataField="LogTime" DataFormatString="{0:yyyy-MM-dd HH:mm:ss}" 
                HeaderText="记录时间" HtmlEncode="False" SortExpression="LogTime" />
            <asp:HyperLinkField DataNavigateUrlFields="UserName" 
                DataNavigateUrlFormatString="UserShow.aspx?UserName={0}" 
                DataTextField="UserName" HeaderText="用户名" />
            <asp:BoundField DataField="IP" HeaderText="IP地址" SortExpression="IP" />
            <asp:TemplateField HeaderText="积分收入">
                <ItemStyle HorizontalAlign="Right" />
                <ItemTemplate>
                    <%# (int)Eval("IncomePayout") == 1 ? Eval("ExpNum").ToString() : "" %>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="积分支出">
                <ItemStyle HorizontalAlign="Right" />
                <ItemTemplate>
                    <%# (int)Eval("IncomePayout") == 2 ? Eval("ExpNum").ToString() : "" %>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:BoundField DataField="Remark" HeaderText="备注/说明" SortExpression="Remark" />
        </Columns>
    </pe:ExtendedGridView>
    <asp:ObjectDataSource ID="OdsUserExpLog" runat="server" EnablePaging="True" 
        MaximumRowsParameterName="maxNumberRows" SelectMethod="GetList" 
        StartRowIndexParameterName="startRowIndexId"  SelectCountMethod="GetTotal"
        TypeName="PowerEasy.Module.General.BusinessLogic.UserManage.UserExpLog">
        <SelectParameters>
            <asp:QueryStringParameter Name="userName" QueryStringField="UserName" 
                Type="String" />
            <asp:QueryStringParameter Name="searchType" QueryStringField="SearchType" 
                Type="Int32" />
            <asp:QueryStringParameter Name="keyword" QueryStringField="Keyword" 
                Type="String" />
        </SelectParameters>
    </asp:ObjectDataSource>
</asp:Content>
