﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="VoteTreeManage.aspx.cs"
    Inherits="PowerEasy.Module.General.WebSite.Admin.Vote.VoteTreeManage" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>信息选择</title>
</head>
<body>
    <form id="form1" runat="server">
    <div>
        <pe:ExtendedGridView ID="EgvContent" runat="server" DataSourceID="OdsContents" SerialText=""
            AutoGenerateColumns="False" AllowPaging="True" OnRowDataBound="EgvContent_RowDataBound"
            DataKeyNames="GeneralId" CheckBoxFieldHeaderWidth="3%" IsHoldState="True">
            <Columns>
                <asp:BoundField DataField="GeneralId" HeaderText="ID" SortExpression="GeneralId">
                    <HeaderStyle Width="5%" />
                </asp:BoundField>
                <asp:TemplateField HeaderText="标题" SortExpression="Title">
                    <ItemTemplate>
                        <pe:LinkImage ID="LinkImageModel" runat="server">
                            <pe:ExtendedLabel ID="LnkNodeLink" runat="server" />
                            <pe:ExtendedLabel ID="HypTitle" runat="server" HtmlEncode="false" />
                        </pe:LinkImage>
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Left" />
                </asp:TemplateField>
                <asp:BoundField DataField="Inputer" HeaderText="录入者" SortExpression="Inputer">
                    <HeaderStyle Width="10%" />
                </asp:BoundField>
                <asp:TemplateField HeaderText="状态" SortExpression="Status">
                    <HeaderStyle Width="15%" />
                    <ItemTemplate>
                        <asp:Label ID="LabStatusName" runat="server"></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="已生成" SortExpression="Status">
                    <ItemTemplate>
                        <pe:ExtendedLabel ID="LblIsCreateHtml" runat="server" HtmlEncode="false">
                &nbsp;&nbsp;
                        </pe:ExtendedLabel>
                    </ItemTemplate>
                    <HeaderStyle Width="10%" />
                </asp:TemplateField>
            </Columns>
        </pe:ExtendedGridView>
        <asp:HiddenField ID="HdnListType" runat="server" Value="-1" />
        <asp:HiddenField ID="HdnStatus" runat="server" Value="100" />
        <asp:HiddenField ID="HdnSearchType" runat="server" Value="" />
        <asp:HiddenField ID="HdnSearchKeyword" runat="server" Value="" />
        <asp:HiddenField ID="HdnIsMyInformation" runat="server" Value="false" />
        <asp:HiddenField ID="HdnModelID" runat="server" Value="0" />
        <asp:ObjectDataSource ID="OdsContents" runat="server" SelectMethod="GetSearchContentList"
            TypeName="PowerEasy.Module.General.BusinessLogic.Contents.ContentManage" EnablePaging="True"
            MaximumRowsParameterName="maxNumberRows" StartRowIndexParameterName="startRowIndexId"
            SelectCountMethod="GetTotalOfCommonModelInfo">
            <SelectParameters>
                <asp:QueryStringParameter Name="nodeId" QueryStringField="NodeID" Type="Int32" />
                <asp:ControlParameter Name="modelId" ControlID="HdnModelID" Type="Int32" PropertyName="Value" />
                <asp:ControlParameter ControlID="HdnListType" Type="Int32" Name="sortType" PropertyName="Value" />
                <asp:ControlParameter ControlID="HdnStatus" Type="Int32" Name="status" PropertyName="Value" />
                <asp:ControlParameter ControlID="HdnSearchType" Type="String" Name="searchType" PropertyName="Value" />
                <asp:ControlParameter ControlID="HdnSearchKeyword" Type="String" Name="keyword" PropertyName="Value" />
                <asp:ControlParameter ControlID="HdnIsMyInformation" Type="Boolean" Name="isMyInformation"
                    PropertyName="Value" />
                <asp:ControlParameter ControlID="EgvContent" DefaultValue="0" PropertyName="VirtualItemCount"
                    Type="Int32" Direction="InputOutput" Name="total" />
            </SelectParameters>
        </asp:ObjectDataSource>

        <script type="text/javascript">
            function ReturnValue(generalId, title) {
                parent.AddItem(generalId, title);
            }
        </script>

    </div>
    </form>
</body>
</html>
