﻿<%@ Control Language="C#" AutoEventWireup="true" Codebehind="AddressPicker.ascx.cs"
    Inherits="PowerEasy.Module.Shop.WebSite.Controls.Shop.AddressPicker" %>
<asp:UpdatePanel ID="UpnlAddress" runat="server" UpdateMode="Conditional">
    <ContentTemplate>
        <div class="border">
            <table border="0" cellpadding="2" cellspacing="1" style="background: #ffffff" width="100%">
                <tr>
                    <td align="right" style="width: 100px">
                        <asp:Localize ID="Localize1" Text="<%$ Res: Controls_Shop_AddressPicker_Localize1,国家： %>" runat="server" />
                    </td>
                    <td align="left" colspan="2">
                        <asp:DropDownList ID="DropCountry" runat="server" AutoPostBack="true" DataTextField="Country"
                            DataValueField="Country" OnSelectedIndexChanged="DropCountry_SelectedIndexChanged">
                        </asp:DropDownList>
                        <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ControlToValidate="DropCountry"
                            Display="Dynamic" ErrorMessage="<%$ Res: Controls_Shop_AddressPicker_RequiredFieldValidator1,请选择国家 %>" InitialValue="-1" SetFocusOnError="True"></asp:RequiredFieldValidator></td>
                </tr>
                <tr>
                    <td align="right">
                        <asp:Localize ID="Localize2" Text="<%$ Res: Controls_Shop_AddressPicker_Localize2,省份： %>" runat="server" />
                    </td>
                    <td align="left">
                        <asp:DropDownList ID="DropProvince" runat="server" AutoPostBack="true" DataTextField="Province"
                            DataValueField="Province" OnSelectedIndexChanged="DropProvince_SelectedIndexChanged">
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td align="right">
                        <asp:Localize ID="Localize3" Text="<%$ Res: Controls_Shop_AddressPicker_Localize3,城市： %>" runat="server" />
                    </td>
                    <td align="left">
                        <asp:DropDownList ID="DropCity" runat="server" AutoPostBack="true" DataTextField="City"
                            DataValueField="City" OnSelectedIndexChanged="DropCity_SelectedIndexChanged">
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td align="right">
                        <asp:Localize ID="Localize4" Text="<%$ Res: Controls_Shop_AddressPicker_Localize4,地区(县)： %>" runat="server" />
                    </td>
                    <td align="left">
                        <asp:DropDownList ID="DropArea" runat="server" AutoPostBack="true" DataTextField="Area"
                            DataValueField="Area" OnSelectedIndexChanged="DropArea_SelectedIndexChanged">
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td align="right">
                        <asp:Localize ID="Localize5" Text="<%$ Res: Controls_Shop_AddressPicker_Localize5,街道地址： %>" runat="server" />
                    </td>
                    <td align="left">
                        <asp:TextBox ID="TxtAddress" runat="server" CssClass="inputxt" Width="300px"></asp:TextBox><br /><asp:Localize ID="Localize6" Text="<%$ Res: Controls_Shop_AddressPicker_Localize6,(不需重复填写：国/省/市/区) %>" runat="server" />
                        <pe:RequiredFieldValidator
                            ID="ValrAddress" runat="server" ControlToValidate="TxtAddress" Display="dynamic"
                            ErrorMessage="<%$ Res: Controls_Shop_AddressPicker_ValrAddress_ErrorMessage,请输入街道地址！ %>" SetFocusOnError="true" RequiredText="<%$ Res: Controls_Shop_AddressPicker_ValrAddress_RequiredText,* %>" ShowRequiredText="False"></pe:RequiredFieldValidator>
                    </td>
                </tr>
            </table>
        </div>
    </ContentTemplate>
</asp:UpdatePanel>
<asp:HiddenField ID="HdnZipCode" runat="server" />
