﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="AddressPickerAjax.ascx.cs"
    Inherits="PowerEasy.Module.Shop.WebSite.Controls.Shop.AddressPickerAjax" %>
<!--浏览信息-->
<div class="orderinfo_show" id="consigneeConfirm">
    <h4>
        <span>收货人信息：</span><a id="btnConsigneeEdit">修改</a>&nbsp;&nbsp;<span id="selectExistAddress"
            style="display: none;">
            <pe:Overlay ID="FdAddress" runat="server" Height="450" ButtonText="选择已有的收货人地址" Title="收货人地址"
                Width="600" ButtonTextBeginToken="" ButtonTextEndToken="" ButtonType="Link" LoadUrl="../Shop/AddressList.aspx" />
        </span>
    </h4>
    <ul>
        <li>*
            <asp:Localize ID="Localize2" Text="<%$ Res: Shop_Payment_Localize2,收货人： %>" runat="server" />
            <asp:Label runat="server" ID="lblConsigneeName" Text="未填写"></asp:Label>
        </li>
        <li>*
            <asp:Localize ID="Localize3" Text="<%$ Res: Shop_Payment_Localize3,收货人地址： %>" runat="server" />
            <asp:Label runat="server" ID="lblAddress" Text="未填写"></asp:Label></li>
        <li>*
            <asp:Localize ID="Localize4" Text="<%$ Res: Shop_Payment_Localize4,收货人邮编： %>" runat="server" />
            <asp:Label runat="server" ID="lblZipCode" Text="未填写"></asp:Label></li>
        <li>*
            <asp:Localize ID="Localize5" Text="<%$ Res: Shop_Payment_Localize5,收货人电话： %>" runat="server" />
            <asp:Label runat="server" ID="lblTel" Text="未填写"></asp:Label></li>
        <li>*
            <asp:Localize ID="Localize6" Text="<%$ Res: Shop_Payment_Localize6,收货人邮箱： %>" runat="server" />
            <asp:Label runat="server" ID="lblEmail" Text="未填写"></asp:Label></li>
    </ul>
</div>
<!--编辑信息-->
<div class="orderinfo_edit" id="consigneeEdit">
    <h4>
        <span>收货人信息</span><a id="cancelConsigneeEdit">取消</a>
    </h4>
    <ul id="addressPicker">
        <li id="shipName"><span class="text">收货人：</span><input id="txtConsigneeName" class="textbox_4"
            type="text" maxlength="40" /></li>
        <li><span class="text">国家：</span>
            <select id="sel_country" class="select_w" style="visibility: visible;" onchange="updateAddress('getProvince',jQuery(this).val());">
                <option value="default">---请选择---</option>
            </select>
            <span class="text">省份/直辖市：</span>
            <select id="sel_province" class="select_w" style="visibility: visible;" onchange="updateAddress('getCity',jQuery(this).val());">
                <option value="default">---请选择---</option>
            </select>
            <span class="text">市：</span>
            <select id="sel_city" class="select_w" style="visibility: visible;" onchange="updateAddress('getArea',jQuery(this).val());">
                <option value="default">---请选择---</option>
            </select>
            <span class="text">地区：</span>
            <select id="sel_area" class="select_w" style="visibility: visible;" onchange="updateAddress('getZipCode',jQuery(this).val());">
                <option value="default">---请选择---</option>
            </select>
        </li>
        <li id="consigneeAddress"><span class="text">详细地址：</span><span id="selectedAddress"></span>
            <input id="txtAddress" class="textbox_x" type="text" value="" size="60" maxlength="100" /></li>
        <li id="consigneeZipCode"><span class="text">邮政编码：</span><input id="txtZipCode" class="textbox_4"
            type="text" value="" maxlength="20" /></li>
        <li class="notice" id="consigneeTips">请务必正确填写您的邮编，以确保订单顺利送达。</li>
        <li id="consigneeEmail"><span class="text">电子邮箱：<input id="txtEmail" class="textbox_4"
            type="text" maxlength="50" /></span></li>
        <li id="consigneeMobile"><span class="text">移动电话：</span><input id="txtMobile" class="textbox_4"
            type="text" maxlength="20" value="" /></li>
        <li id="consigneePhone"><span class="text">固定电话：</span><input id="txtPhone" class="textbox_4"
            type="text" maxlength="20" value="" /></li>
        <li id="consigneeButton" class="button">
            <span class="notice">填写完收货人信息后，请点击“确认收货人信息”按钮以保存信息</span><br />
            <input id="btnConfirmConsignee" class="save_button" type="button" value="确认收货人信息" />&nbsp;<div style="display:none;" id="isAddAddress"><input type="checkbox" id="ckbAddAddress"/><span class="notice">是否作为默认地址添加到收货地址中</span> </div></li>
    </ul>
    <input type="hidden" value="true" id="isSaved" />
</div>

<script type="text/javascript" language="javascript">
    var clientId = '<%=controlClientID %>';
    var postUrl = <%=SaveInfoPostUrl %>;
    var isUserLogin = '<%=m_isUserLogin %>';

    var $consigneeName = jQuery("#txtConsigneeName");
    var $consigneeAddress = jQuery("#txtAddress");
    var $consigneeZipCode = jQuery("#txtZipCode");
    var $consigneeEmail = jQuery("#txtEmail");
    var $sel_country = jQuery("#sel_country");
    var $sel_province = jQuery("#sel_province");
    var $sel_city = jQuery("#sel_city");
    var $sel_area = jQuery("#sel_area");
    var $consigneeMobile = jQuery("#txtMobile");
    var $consigneePhone = jQuery("#txtPhone");
    var country = '<%=Country %>';
    var province = '<%=Province %>';
    var city = '<%=City %>';
    var area = '<%=Area %>';
    $consigneeZipCode.focus(function() {
        updateAddress('getZipCode', '');
    });

    var updateQueue = [function() { updateAddress("getCountry", country); }, function() { updateAddress("getProvince", province); },
        function() { updateAddress("getCity", city); }, function() { updateAddress("getArea", area); }, function() { updateAddress("getZipCode", ''); } ];
    jQuery(document).queue("updateQueue", updateQueue);


    if (isUserLogin == 'True') {
        setDefault();
    }
    else {
        jQuery("#noticeForGuest").remove();
         jQuery("#selectExistAddress").hide();
        jQuery('<span id="noticeForGuest">&nbsp;&nbsp;游客请点击“修改”以更改收货地址，注册会员可以先登录获得默认地址</span>').insertAfter(jQuery("#btnConsigneeEdit")).fadeIn("slow");
        jQuery(document).dequeue("updateQueue");
    }



    function setDefault() {
        var name = '<%=ConsigneeName %>';
        var address = '<%=Address %>';
        var zipcode = '<%=ZipCode %>';
        var email = '<%=Email %>';
        var mobile = '<%=Mobile %>';
        var phone = '<%=Phone %>';
        jQuery(document).dequeue("updateQueue");
        jQuery("#isAddAddress").css("display","");

        $consigneeZipCode.val(zipcode);
        $consigneeEmail.val(email);
        $consigneeMobile.val(mobile);
        $consigneeName.val(name);
        $consigneePhone.val(phone);
        $consigneeAddress.val(address);
        jQuery("#selectExistAddress").show();
        isSetDefault=true;
    }

    //更新地址
    function updateAddress(action, value) {
        if (value != "default") {

            var elementID = "";
            var countrySelected = $sel_country.val();
            var provinceSelected = $sel_province.val();
            var citySelected = $sel_city.val();
            var areaSelected = $sel_area.val() == "-" ? "" : $sel_area.val();

            if (areaSelected == "-") {
                action = "getZipCode";
            }
            switch (action) {
                case 'getCountry':
                    elementID = 'sel_country';
                    break;
                case 'getProvince':
                    elementID = 'sel_province';
                    break;
                case 'getCity':
                    elementID = 'sel_city';
                    break;
                case 'getArea':
                    elementID = 'sel_area';
                    break;
                default: break;
            }

            var xmlDoc = getXMLDocument();

            var root = xmlDoc.createElement("root");

            var typeElement = xmlDoc.createElement("type");
            var typeText = xmlDoc.createTextNode("AddressPicker");
            typeElement.appendChild(typeText);
            root.appendChild(typeElement);

            var actionElement = xmlDoc.createElement("action");
            var actionText = xmlDoc.createTextNode(action);
            actionElement.appendChild(actionText);
            root.appendChild(actionElement);


            var countryElement = xmlDoc.createElement("country");
            var countryText = xmlDoc.createTextNode(countrySelected);
            countryElement.appendChild(countryText);
            root.appendChild(countryElement);

            var provinceElement = xmlDoc.createElement("province");
            var provinceText = xmlDoc.createTextNode(provinceSelected);
            provinceElement.appendChild(provinceText);
            root.appendChild(provinceElement);

            var cityElement = xmlDoc.createElement("city");
            var cityText = xmlDoc.createTextNode(citySelected);
            cityElement.appendChild(cityText);
            root.appendChild(cityElement);

            var areaElement = xmlDoc.createElement("area");
            var areaText = xmlDoc.createTextNode(areaSelected);
            areaElement.appendChild(areaText);
            root.appendChild(areaElement);
            
            var requestData="";
            if(typeof window.XMLSerializer=='function'){
                requestData=(new XMLSerializer()).serializeToString(root);
            }
            else{
                requestData=root.xml;
            }
            
            var status;
            jQuery.ajax({ url: "../Ajax.aspx", type: 'post', dataType: 'xml', data:requestData ,
                success: function(data) {
                    status = jQuery("status", data).text();
                    if (status == "err") {
                    }
                    else if (status == "ok") {
                        var result = jQuery("result", data).text();
                        if (action == 'getZipCode') {
                            jQuery("#txtZipCode").val(result);
                        }
                        else {
                            jQuery("#" + elementID).empty();
                            if (result != "empty") {
                                result = eval('(' + result + ')');
                                jQuery.each(result, function(entryIndex, entry) {
                                    var newOption = new Option(entryIndex, result[entryIndex]);
                                    document.getElementById(elementID).options.add(newOption);
                                });
                                if (value != '') {
                                    jQuery("#" + elementID).val(value);
                                }
                                if (jQuery(document).queue("updateQueue").length > 0) {
                                    jQuery(document).dequeue("updateQueue");
                                }
                                else {
                                    jQuery("#" + elementID).trigger("change");
                                }
                            }
                            else {
                                var newOption = new Option("-", "-");
                                document.getElementById(elementID).options.add(newOption);
                                if(action=='getArea'){
                                    updateAddress('getZipCode',"");
                                }
                            }
                            jQuery("#txtZipCode").val("");
                        }
                        var address = "";
                        if ($sel_country.val() != 'default') {
                            address += $sel_country.val();
                        }
                        if ($sel_province.val() != 'default') {
                            address += "," + $sel_province.val();
                        }
                        if ($sel_city.val() != 'default') {
                            address += "," + $sel_city.val();
                        }
                        if ($sel_area.val() != null && $sel_area.val() != 'default'&& $sel_area.val()!='-') {
                            address += "," + $sel_area.val();
                        }
                        jQuery("#selectedAddress").html(address);
                    }
                }
            });
        }
    }

    //保存修改
    jQuery("#btnConfirmConsignee").click(function() {
        jQuery("#confirmMsg").remove();
        jQuery(":input", "#consigneeEdit").filter(".textbox_4,.textbox_x").trigger("blur");
        var numErrors = jQuery(".errMsg", "#consigneeEdit").length;
        var isMobileAndPhoneEmpty = false;
        if ($consigneeMobile.val() == '' && $consigneePhone.val() == '') {
            isMobileAndPhoneEmpty = true;
            numErrors += 1;
            jQuery('<div></div>').attr("id", "confirmMsg").append('手机和电话至少填写一项！<br />')
             .insertBefore("#btnConfirmConsignee").fadeIn("normal");
            return false;
        }
        if (numErrors) {
            return false;
        }
        jQuery("#btnSubmitOrder").css("display","none");   
        jQuery.ajax({ url: postUrl, type: 'post',
            data: "consigneeName=" + $consigneeName.val() + "&consigneeAddress=" + $consigneeAddress.val() + "&country=" + $sel_country.val()
    + "&province=" + $sel_province.val() + "&city=" + $sel_city.val() + "&area=" + $sel_area.val() + "&zipcode=" + $consigneeZipCode.val()
    + "&email=" + $consigneeEmail.val() + "&mobile=" + $consigneeMobile.val() + "&phone=" + $consigneePhone.val() + "&ckbAddAddress="
    +jQuery("#ckbAddAddress").prop("checked") +"&action=EditConsigneeInfo",
            success: function(data) {
                var regx=new RegExp('<table[^>]*shoppingCartList[^>]*>([\\S\\s]*?)</table>');
                if(regx.test(data)){
                    var shoppingCartUpdate=data.match(regx)[0];
                    jQuery('#UPLShoppingCart').html(shoppingCartUpdate);
                }
                var tag = "#" + clientId;
                jQuery(tag + "lblConsigneeName").html($consigneeName.val());
                jQuery(tag + "lblAddress").html(jQuery("#selectedAddress").text() + "," + $consigneeAddress.val());
                jQuery(tag + "lblZipCode").html($consigneeZipCode.val());
                jQuery(tag + "lblEmail").html($consigneeEmail.val());
                jQuery(tag + "lblTel").html($consigneeMobile.val() + " " + $consigneePhone.val());
                jQuery("#noticeForGuest").remove();
                jQuery("#consigneeEdit").fadeOut("normal", function() {
                    jQuery("#consigneeConfirm").fadeIn();
                });
               jQuery("#isSaved").val("true");
               jQuery("#btnSubmitOrder").css("display","");   
            }
        });

    });

    jQuery("#btnConsigneeEdit").click(function() {
        if (isUserLogin == 'True') {
        window.setTimeout(function(){
            jQuery(":input", "#consigneeEdit").filter(".textbox_4,.textbox_x").trigger("blur");
            },1000);
        }
        jQuery("#isSaved").val("false");
        jQuery("#consigneeConfirm").fadeOut("normal", function() {
            jQuery("#consigneeEdit").fadeIn();
        });
    });

    jQuery("#cancelConsigneeEdit").click(function() {
         var tag = "#" + clientId;
         if(jQuery(tag + "lblConsigneeName").text()=='未填写'){
            jQuery(":input", "#consigneeEdit").filter(".textbox_4,.textbox_x").val("").next(".errMsg,.rightTag").remove();
         }
        jQuery("#isSaved").val("true");
        jQuery("#consigneeEdit").fadeOut("normal", function() {
            jQuery("#consigneeConfirm").fadeIn();
        });
        return false;
    });

    //创建XML对象
    function getXMLDocument() {
        var xDoc = null;
        if (document.implementation && document.implementation.createDocument) {
            xDoc = document.implementation.createDocument("", "", null);
        } else {
            if ((typeof ActiveXObject) != "undefined") {
                var msXmlAx = null;
                try {
                    msXmlAx = new ActiveXObject("Msxml2.DOMDocument");
                }
                catch (e) {
                    msXmlAx = new ActiveXObject("Msxml.DOMDocument");
                }
                xDoc = msXmlAx;
            }
        }
        if (xDoc == null) {
            xDoc = null;
        }
        return xDoc;
    };
    var errMsg = '<span class="errMsg"></span>'
    var errorTag = '<span class="errTag"></span>';
    var rightTag = '<span class="rightTag"></span>';
    jQuery(":input", "#consigneeEdit").filter(".textbox_4,.textbox_x").blur(function() {
        jQuery(this).next(".errMsg,.rightTag").remove();
        var inputId = jQuery(this).attr("id");
        if (this.value == '') {
            var requiredMsg = "";
            switch (inputId) {
                case 'txtConsigneeName':
                    requiredMsg = '请输入收货人姓名！';
                    break;
                case 'txtAddress':
                    requiredMsg = '请输入详细地址！';
                    break;
                case 'txtZipCode':
                    requiredMsg = '请输入邮编！';
                    break;
                case 'txtEmail':
                    requiredMsg = '请输入电子邮箱！';
                    break;
                default: break;
            }
            if (requiredMsg != '') {
                jQuery(errMsg).insertAfter(jQuery(this)).append(errorTag + requiredMsg);
            }
        }
        else {
            var valitorMsg = "";
            var regx;
            switch (inputId) {
                case 'txtZipCode':
                    valitorMsg = '请输入正确的邮编！';
                    regx = /\d{6}/;
                    break;
                case 'txtEmail':
                    valitorMsg = '请输入正确的电子邮箱！';
                    regx = /\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*/;
                    break;
                case 'txtPhone':
                    valitorMsg = '请输入正确的电话号码！';
                    regx = /0?1[358][0-9]{9}|(\(\d{3,4}\)|\d{3,4}-?)?\d{7,8}(-\d{1,5})?/;
                    break;
                case 'txtMobile':
                    valitorMsg = '请输入正确的手机号码！';
                    regx = /0?1[358][0-9]{9}|(\(\d{3,4}\)|\d{3,4}-?)?\d{7,8}(-\d{1,5})?/;
                    break;
                default: break;
            }
            if (valitorMsg != '') {
                if (!regx.test(this.value)) {
                    jQuery(errMsg).insertAfter(jQuery(this)).append(errorTag + valitorMsg);
                }
                else {
                    jQuery(rightTag).insertAfter(jQuery(this));
                }
            }
            else {
                jQuery(rightTag).insertAfter(jQuery(this));
            }
        }

    });
</script>

