﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="MergeOrder.ascx.cs"
    Inherits="PowerEasy.Module.Shop.WebSite.Controls.Shop.MergeOrder" %>
<div class="hdTitle">
    <h3>
        <asp:Localize ID="Localize1" Text="<%$ Res: Controls_Shop_MergeOrder_Localize1 , 合并订单 %>"
            runat="server" /></h3>
    </div>
    <div class="bdCont">
	<div class="model_Info_Tips">
	    注意：只能对<strong>未确认的订单</strong>进行合并。
	</div>
        <table class="tableStyle">
            <tr class='first'>
                <td class="ok_tab">
                    <asp:Localize ID="Localize2" Text="<%$ Res: Controls_Shop_MergeOrder_Localize2 , 主订单： %>"
                        runat="server" />
                </td>
                <td>
                    <asp:UpdatePanel runat="server" ID="UpnlPrincipalOrder" UpdateMode="Conditional">
                        <ContentTemplate>
                            <asp:TextBox ID="TxtPrincipalOrder" MaxLength="50" Width="150px" CssClass="inputxt"
                                runat="server"></asp:TextBox>
                            <asp:DropDownList ID="DropPrincipalOrder" DataTextField="value" DataValueField="key"
                                AutoPostBack="true" OnSelectedIndexChanged="DropPrincipalOrder_SelectedIndexChanged"
                                runat="server">
                            </asp:DropDownList>
                        </ContentTemplate>
                    </asp:UpdatePanel>
                    <pe:RequiredFieldValidator ShowRequiredText="false" ID="ValrPrincipalOrder" runat="server"
                        Display="dynamic" ControlToValidate="TxtPrincipalOrder" ErrorMessage="<%$ Res: Controls_Shop_MergeOrder_ValrPrincipalOrder , 请输入要合并的主订单！ %>"></pe:RequiredFieldValidator>
                </td>
            </tr>
            <tr>
                <td class="ok_tab">
                    <asp:Localize ID="Localize3" Text="<%$ Res: Controls_Shop_MergeOrder_Localize3 , 从订单： %>"
                        runat="server" />
                </td>
                <td>
                    <asp:UpdatePanel runat="server" ID="UpnlSubordinateOrder" UpdateMode="Conditional">
                        <ContentTemplate>
                            <asp:TextBox ID="TxtSubordinateOrder" MaxLength="50" Width="150px" CssClass="inputxt"
                                runat="server"></asp:TextBox>
                            <asp:DropDownList ID="DropSubordinateOrder" DataTextField="value" DataValueField="key"
                                runat="server" AutoPostBack="true" OnSelectedIndexChanged="DropSubordinateOrder_SelectedIndexChanged">
                            </asp:DropDownList>
                            <asp:Localize ID="Localize4" Text="<%$ Res: Controls_Shop_MergeOrder_Localize4 , 合并后从订单将被直接删除 %>"
                                runat="server" />
                        </ContentTemplate>
                    </asp:UpdatePanel>
                    <pe:RequiredFieldValidator ShowRequiredText="false" ID="ValrSubordinateOrder" runat="server"
                        Display="dynamic" ControlToValidate="TxtSubordinateOrder" ErrorMessage="<%$ Res: Controls_Shop_MergeOrder_ValrSubordinateOrder , 请输入要合并的从订单！ %>"></pe:RequiredFieldValidator>
                </td>
            </tr>
            <tr>
                <td class="ok_tab">
                    <asp:Localize ID="Localize5" Text="<%$ Res: Controls_Shop_MergeOrder_Localize5 , 合并方式： %>"
                        runat="server" />
                </td>
                <td>
                    <asp:RadioButtonList ID="RadlMergeType" runat="server" RepeatLayout="Flow">
                        <asp:ListItem Value="0" Selected="true" Text="<%$ Res: Controls_Shop_MergeOrder_ListItem1 , 合并主订单的备注留言和内部记录 %>"></asp:ListItem>
                        <asp:ListItem Value="1" Text="<%$ Res: Controls_Shop_MergeOrder_ListItem2 , 合并从订单的备注留言和内部记录 %>"></asp:ListItem>
                        <asp:ListItem Value="2" Text="<%$ Res: Controls_Shop_MergeOrder_ListItem3 , 合并主订单、从订单的备注留言和内部记录 %>"></asp:ListItem>
                    </asp:RadioButtonList>
                </td>
            </tr>
            <tr class="tdbgbottom">
                <td colspan="2">
                </td>
            </tr>
        </table>
        <div class="okBottom">
            <asp:Button ID="BtnSubmit" runat="server" Text="<%$ Res: Controls_Shop_MergeOrder_BtnSubmit , 合并 %>"
                OnClick="BtnSubmit_Click" CssClass="submit_button" />&nbsp;&nbsp;&nbsp;&nbsp;
            <input id="CancelInput" runat="server" type="button" class="submit_button" onclick="javascript:history.go(0)"
                value="<%$ Res: Controls_Shop_MergeOrder_CancelInput , 取消 %>" />
        </div>
    </div>
</div>


