﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="ShoppingCart.ascx.cs"
    Inherits="PowerEasy.Module.Shop.WebSite.Controls.Shop.ShoppingCart" %>
<asp:Repeater ID="RptShoppingCart" runat="server" OnItemDataBound="RptShoppingCart_ItemDataBound">
    <HeaderTemplate>
        <table class="border" cellspacing="0" width="100%" id="shoppingCartList">
            <thead>
                <tr class="title" align="center">
                    <th id="ProductImageTitle" runat="server" class="item-pic">
                        <asp:Localize ID="Localize1" Text="<%$ Res: Controls_ShoppingCart_Localize1 %>" runat="server" />
                    </th>
                    <th class="item-title">
                        <asp:Localize ID="Localize2" Text="<%$ Res: Controls_ShoppingCart_Localize2 %>" runat="server" />
                    </th>
                    <th class="item-unit">
                        <asp:Localize ID="Localize3" Text="<%$ Resources: DynamicPageResources ,Controls_ShoppingCart_Localize3  %>"
                            runat="server" />
                    </th>
                    <th class="item-amount">
                        <asp:Localize ID="Localize4" Text="<%$ Res: Controls_ShoppingCart_Localize4 %>" runat="server" />
                    </th>
                    <th id="tdProductTypeTitle" runat="server" class="item-producttype">
                        <asp:Localize ID="Localize5" Text="<%$ Res: Controls_ShoppingCart_Localize5 %>" runat="server" />
                    </th>
                    <th id="tdSaleTypeTitle" runat="server" class="item-saletype">
                        <asp:Localize ID="Localize6" Text="<%$ Res: Controls_ShoppingCart_Localize6 %>" runat="server" />
                    </th>
                    <th id="tdMarkPriceTitle" runat="server" class="item-markprice">
                        <asp:Localize ID="Localize7" Text="<%$ Res: Controls_ShoppingCart_Localize7 %>" runat="server" />
                    </th>
                    <th id="tdPrice" runat="server" class="item-price">
                        <asp:Localize ID="Localize8" Text="<%$ Res: Controls_ShoppingCart_Localize8 %>" runat="server" />
                    </th>
                    <th class="item-total">
                        <asp:Localize ID="Localize9" Text="<%$ Res: Controls_ShoppingCart_Localize9 %>" runat="server" />
                    </th>
                </tr>
            </thead>
            <tbody>
    </HeaderTemplate>
    <ItemTemplate>
            <tr <%# (Container.ItemIndex+1)%2==0 ? "class='even'" : string.Empty %>>
                <asp:HiddenField ID="HdfProdctId" runat="server" Value='<%#Eval("ProductId") %>' />
                <asp:HiddenField ID="HdfTableName" runat="server" Value='<%#Eval("TableName") %>' />
                <td id="ProductImage" runat="server"  class="item-pic">
                    <pe:ExtendedImage ID="extendedImage" runat="server"></pe:ExtendedImage>
                </td>
                <td  class="item-title item-title-text">
                    <pe:ExtendedLiteral ID="LitProductName" HtmlEncode="false" runat="server"></pe:ExtendedLiteral>
                    <asp:Literal ID="LitProperty" runat="server"></asp:Literal>
                </td>
                <td  class="item-unit">
                    <asp:Literal ID="LitProductUnit" runat="server"></asp:Literal>
                </td>
                <td  class="item-amount">
                    <em tabindex="0"><asp:Literal ID="LitProductAmount" runat="server" Text='<%#Eval("Quantity") %>'></asp:Literal></em>
                </td>
                <td id="tdProductType" runat="server"  class="item-producttype">
                    <asp:Literal ID="LitProductType" runat="server"></asp:Literal>
                </td>
                <td id="tdSaleType" runat="server"  class="item-saletype">
                    <asp:Literal ID="LitSaleType" runat="server"></asp:Literal>
                </td>
                <td  id="tdMarkPrice" runat="server"  class="item-markprice">
                    <em tabindex="0"><asp:Literal ID="LitPriceMarket" runat="server"></asp:Literal></em>
                </td>
                <td  id="tdPrice" runat="server" class="item-price">
                   <em tabindex="0"><asp:Literal ID="LitTruePrice" runat="server"></asp:Literal>
                    &nbsp;<pe:ExtendedLabel ID="LblInvoiceRate" runat="server" HtmlEncode="false"></pe:ExtendedLabel></em>
                </td>
                <td   class="item-total">
                    <em tabindex="0"><asp:Literal ID="LitSubTotal" runat="server"></asp:Literal></em>
                </td>
            </tr>
            <asp:Panel ID="PresentInfomation" runat="server" Visible="false">
                <tr  <%# (Container.ItemIndex+1)%2==0 ? "class='even'" : string.Empty %>>
                    <asp:HiddenField ID="HdnPresentId" runat="server" />
                    <td id="presentImage" runat="server"   class="item-pic">
                        <pe:ExtendedImage ID="extendedPresentImage" runat="server"></pe:ExtendedImage>
                    </td>
                    <td  class="item-title item-title-text">
                        <pe:ExtendedLiteral ID="LitPresentName" runat="server"></pe:ExtendedLiteral>
                    </td>
                    <td class="item-unit">
                        <asp:Literal ID="LitPresentUnit" runat="server"></asp:Literal>
                    </td>
                    <td class="item-amount">
                        <em tabindex="0"><asp:Literal ID="LitPresentNum" runat="server"></asp:Literal><br />
                        <asp:Literal ID="LitPresentMsg" runat="server"></asp:Literal></em>
                    </td>
                    <td id="tdPresentType" runat="server" class="item-producttype">
                        <asp:Literal ID="LitPresentType" runat="server"></asp:Literal>
                    </td>
                    <td id="tdPresentSaleType" runat="server" class="item-saletype">
                        <asp:Literal ID="LitPresentSaleType" runat="server"></asp:Literal>
                    </td>
                    <td  id="tdPresentMarkPrice" runat="server"  class="item-markprice">
                        <em tabindex="0"><asp:Literal ID="LitPresentPriceOriginal" runat="server"></asp:Literal></em>
                    </td>
                    <td  class="item-price"  id="tdPresentPrice" runat="server">
                        <em tabindex="0"><asp:Literal ID="LitPresentTruePrice" runat="server"></asp:Literal></em>
                    </td>
                    <td  class="item-total">
                        <em tabindex="0"><asp:Literal ID="LitPresentSubtotal" runat="server"></asp:Literal></em>
                    </td>
                </tr>
        </asp:Panel>
    </ItemTemplate>
    <FooterTemplate>
        <asp:PlaceHolder ID="PlhPresentInfo" runat="server" Visible="false">
            <tr >
                <td id="footerPresentImage" runat="server"  class="item-pic">
                    <pe:ExtendedImage ID="presentImage" runat="server"></pe:ExtendedImage>
                </td>
                <td  class="item-title item-title-text">
                    <pe:ExtendedLabel ID="LblProductName" runat="server" /><span style="color: Red"><asp:Localize
                        ID="Localize10" Text="<%$ Res: Controls_ShoppingCart_Localize10 %>" runat="server" /></span>
                </td>
                <td class="item-unit">
                    <asp:Label ID="LblUnit" runat="server"></asp:Label>
                </td>
                <td  class="item-amount">
                    <em tabindex="0">1</em>
                </td>
                <td id="footerPresentType" runat="server" class="item-producttype">
                    <span style="color: Red">
                        <asp:Localize ID="Localize11" Text="<%$ Res: Controls_ShoppingCart_Localize11 %>"
                            runat="server" /></span>
                </td>
                <td id="footerPresentSaleType" runat="server"  class="item-saletype">
                    <span style="color: Red">
                        <asp:Localize ID="Localize12" Text="<%$ Res: Controls_ShoppingCart_Localize12 %>"
                            runat="server" /></span>
                </td>
                <td id="footerPresentMarkPrice" runat="server"  class="item-markprice">
                    <em tabindex="0"><asp:Label ID="LblPresentPriceMarket" runat="server"></asp:Label></em>
                </td>
                <td  id="footerPresentTruePrice" runat="server"   class="item-price">
                    <em tabindex="0"><asp:Label ID="LblPresentPrice" runat="server"></asp:Label></em>
                </td>
                <td  id="footerPresentSalePrice" runat="server"  class="item-total">
                    <em tabindex="0"><asp:Label ID="LblPresentPrice1" runat="server"></asp:Label></em>
                </td>
            </tr>
        </asp:PlaceHolder>
        <%--<%=presentList2 %>--%>
        <tr class="tdbg">
            <td runat="server" id="footerTdThemeImage">
            </td>
            <td>
                <b>
                    <asp:Localize ID="Localize13" Text="<%$ Res: Controls_ShoppingCart_Localize13 %>"
                        runat="server" /></b>
            </td>
            <td>
                &nbsp;
            </td>
            <td  class="item-amount">
                <em tabindex="0"><%=totalAmount %></em>
            </td>
            <td runat="server" id="footerTdProductType">
            </td>
            <td runat="server" id="footerTdSaleType">
            </td>
            <td runat="server" id="footerTdMarkPrice">
            </td>
            <td runat="server" id="footerTdPrice">
                &nbsp;
            </td>
            <td align="right"  class="item-total">
                <em tabindex="0"><%=string.Format("{0:N2}",total)%></em>
            </td>
        </tr>
        <asp:PlaceHolder ID="PlhMoneyInfo" runat="server" Visible="false">
            <tr>
                <td align='left'>
                    <span style="color: Green;">总重量： </span>
                    <asp:Label ID="LblTotalWeight" runat="server"></asp:Label>千克 <span style="color: green">
                        <asp:Localize ID="Localize14" Text="<%$ Res: Controls_ShoppingCart_Localize14 %>"
                            runat="server" /></span>
                    <asp:Label ID="LblDeliverCharge" runat="server"></asp:Label><asp:Localize ID="Localize15"
                        Text="<%$ Res: Controls_ShoppingCart_Localize15 %>" runat="server" />
                    <span style="color: green">
                        <asp:Localize ID="Localize16" Text="<%$ Res: Controls_ShoppingCart_Localize16 %>"
                            runat="server" /></span><asp:Label ID="LblTaxRate" runat="server"></asp:Label><asp:Localize
                                ID="Localize18" Text="<%$ Res: Controls_ShoppingCart_Localize18 %>" runat="server" />
                    <span style="color: green">
                        <asp:Localize ID="Localize19" Text="<%$ Res: Controls_ShoppingCart_Localize19 %>"
                            runat="server" /></span><asp:Label ID="LblIncludeTax" runat="server"></asp:Label><br />
                    <pe:ExtendedLabel HtmlEncode="false" ID="LblCoupon" runat="server" Visible="false"></pe:ExtendedLabel>
                    <asp:Label ID="LblTotalMoney" runat="server"></asp:Label>
                </td>
                <td runat="server" id="footerTdMoneyInfoProductType">
                    &nbsp;
                </td>
                <td runat="server" id="footerTdMoneyInfoSaleType">
                    &nbsp;
                </td>
                <td runat="server" id="footerTdMoneyInfoMarkPrice" >
                    &nbsp;
                </td>
                <td runat="server" id="footertdMoneyPrice" >
                    &nbsp;
                </td>
                <td>
                    &nbsp;
                </td>
                <td  colspan="4"  class="item-total">
                    <b>
                        <asp:Localize ID="Localize20" Text="<%$ Res: Controls_ShoppingCart_Localize20 %>"
                            runat="server" /></b><em tabindex="0"><asp:Label ID="LblTrueTotalMoney" runat="server"></asp:Label></em><asp:Localize
                                ID="Localize21" Text="<%$ Res: Controls_ShoppingCart_Localize21 %>" runat="server" />
                </td>
            </tr>
        </asp:PlaceHolder>
        <%--        <%= priceInfomation%>--%>
        <%=presentExpInfomation%>
        <%--            <asp:Panel ID="Notes" runat="server" Visible="false">
             <tr>
                    <td colspan="8" align="right"><%=presentList%></td>
                    <td></td>
                </tr>
                <tr>
                    <td colspan="9" align="left"><b> <%= priceInfomation%></b></td>
                </tr>
             </asp:Panel>--%>
             </tbody>
        </table>
    </FooterTemplate>
</asp:Repeater>
<div id="Note" runat="server" style="text-align: left" visible="false">
    <b>
        <asp:Localize ID="Localize22" Text="<%$ Res: Controls_ShoppingCart_Localize22 %>"
            runat="server" />
        <asp:Label ID="LblPrice" runat="server" Visible="false" ForeColor="red"></asp:Label>
        <asp:Localize ID="Localize23" Text="<%$ Res: Controls_ShoppingCart_Localize23 %>"
            runat="server" /></b>
</div>
<asp:Repeater ID="RptPresentList" runat="server" Visible="false" OnItemDataBound="RptPresentList_ItemDataBound">
    <HeaderTemplate>
        <table width="100%" class="border" cellpadding="2" cellspacing="1">
            <tr class="title">
                <td style="width: 3px;">
                </td>
                <td id="changePresentHeaderImage" runat="server">
                    <asp:Localize ID="Localize24" Text="<%$ Res: Controls_ShoppingCart_Localize24 %>"
                        runat="server" />
                </td>
                <td>
                    <asp:Localize ID="Localize25" Text="<%$ Res: Controls_ShoppingCart_Localize25 %>"
                        runat="server" />
                </td>
                <td>
                    <asp:Localize ID="Localize26" Text="<%$ Res: Controls_ShoppingCart_Localize26 %>"
                        runat="server" />
                </td>
                <td>
                    <asp:Localize ID="Localize27" Text="<%$ Res: Controls_ShoppingCart_Localize27 %>"
                        runat="server" />
                </td>
                <td runat="server" id="changePresentHeaderProductType">
                    <asp:Localize ID="Localize28" Text="<%$ Res: Controls_ShoppingCart_Localize28 %>"
                        runat="server" />
                </td>
                <td runat="server" id="changePresentHeaderSaleType">
                    <asp:Localize ID="Localize29" Text="<%$ Res: Controls_ShoppingCart_Localize29 %>"
                        runat="server" />
                </td>
                <td runat="server" id="changePresentHeaderMarkPrice">
                    <asp:Localize ID="Localize30" Text="<%$ Res: Controls_ShoppingCart_Localize30 %>"
                        runat="server" />
                </td>
                <td>
                    <asp:Localize ID="Localize31" Text="<%$ Res: Controls_ShoppingCart_Localize31 %>"
                        runat="server" />
                </td>
                <td>
                    <asp:Localize ID="Localize32" Text="<%$ Res: Controls_ShoppingCart_Localize32 %>"
                        runat="server" />
                </td>
            </tr>
    </HeaderTemplate>
    <ItemTemplate>
        <tr>
            <td style="width: 5px;">
                <input type="checkbox" name="RdbPresentId" value='<%#Eval("PresentId")%>' id="RdbPresentId"
                    class="presentRadio" onclick="selectPresent(this);" />
            </td>
            <td id="changePresentImage" runat="server" align="center">
                <pe:ExtendedImage ID="changePresentListImage" runat="server"></pe:ExtendedImage>
            </td>
            <td style="text-align: center;">
                <%--<asp:HiddenField ID="HdfChangePresentTableName" runat="server" Value='<%#Eval("TableName") %>' />--%>
                <a href='<%#string.Format("PromotionProductItem.aspx?id={0}",Eval("PresentId")) %>'>
                    <asp:Literal ID="LitChangePresentName" runat="server" Text='<%#Eval("PresentName") %>'></asp:Literal>
                </a>
            </td>
            <td align="center">
                <asp:Literal ID="LitChangePresentUnit" runat="server" Text='<%#Eval("Unit") %>'></asp:Literal>
            </td>
            <td align="center">
                <asp:Literal ID="LitChangePresentAmount" runat="server" Text='<%$ Res: Controls_ShoppingCart_LitChangePresentAmount %>'></asp:Literal>
            </td>
            <td runat="server" id="changePresentType" align="center">
                <asp:Literal ID="LitChangePresentType" runat="server" Text='<%$ Res: Controls_ShoppingCart_LitChangePresentType %>'></asp:Literal>
            </td>
            <td runat="server" id="changeSaleType" align="center">
                <asp:Literal ID="LitChangePresentSaleType" runat="server" Text='<%$ Res: Controls_ShoppingCart_LitChangePresentSaleType %>'></asp:Literal>
            </td>
            <td runat="server" id="changeMarkPrice" align="center">
                <asp:Literal ID="LitChangePresentPriceMarket" runat="server"></asp:Literal>
            </td>
            <td align="center">
                <asp:Literal ID="LitChangePresentTruePrice" runat="server"></asp:Literal>
            </td>
            <td align="center">
                <asp:Literal ID="LitChangePresentSubTotal" runat="server"></asp:Literal>
            </td>
        </tr>
    </ItemTemplate>
    <FooterTemplate>
        </table>
    </FooterTemplate>
</asp:Repeater>
<script language="javascript" type="text/javascript">
    var cookiePath = '/';
    var cookieExpires = null;
    var isNewShoppingFlow = '<%=IsNewShoppingFlow %>'.toLowerCase() == 'true';
    if (isNewShoppingFlow && jQuery.pe.cookie("presentId") != null) {
        jQuery(".presentRadio").each(function () {
            if (this.value == jQuery.pe.cookie("presentId")) {
                this.checked = true;
                return false;
            }
        });
    }
    function selectPresent(obj) {
        if (isNewShoppingFlow) {
            if (obj.checked) {
                jQuery.pe.cookie("presentId", obj.value, { path: cookiePath, expires: cookieExpires });
            }
            else {
                jQuery.pe.cookie("presentId", "", { path: cookiePath, expires: cookieExpires });
            }
        }
        jQuery(".presentRadio").not(obj).prop("checked", false);
    }
</script>
