﻿<%@ Control Language="C#" AutoEventWireup="true" Inherits="PowerEasy.Module.Shop.WebSite.Controls.Shop.ShowOrder"
    CodeBehind="ShowOrder.ascx.cs" %>

<script type="text/javascript">
    function ShowOrderTabs(ID) {
        jQuery("li[id^='TabOrderTitle']").attr("class", "");
        jQuery("div[id^='Tabs_Order']").hide();
        jQuery("#TabOrderTitle" + ID.toString()).attr("class", "hover");
        jQuery("#Tabs_Order" + ID.toString()).show();
    }

    function BindShowOrderTabs() {
        jQuery("#TableTabContainer td:first").click();
    }

    jQuery(function() {
        BindShowOrderTabs();
    });
</script>

<div class="memberBoxTab">
<div class="hd">
    <ul class="hdTab">
        <% if (!IsCreditProduct)
           { %>
        <li id='TabOrderTitle0' class="on"><span><a href="###" onclick='ShowOrderTabs(0)'>
            <asp:Localize ID="Localize1" Text="<%$ Res:Controls_ShowOrder_Localize1 , 付款信息 %>"
                runat="server" />
        </a></span></li>
        <li id='TabOrderTitle1'><span><a href="###" onclick='ShowOrderTabs(1)'>
            <asp:Localize ID="Localize2" Text="<%$ Res:Controls_ShowOrder_Localize2 , 发票记录 %>"
                runat="server" /></a></span> </li>
        <% } %>
        <li id='TabOrderTitle2' class='tabtitle'><span><a href="###"  onclick='ShowOrderTabs(2)'>
            <asp:Localize ID="Localize3" Text="<%$ Res:Controls_ShowOrder_Localize3 , 发退货记录 %>"
                runat="server" /></a></span> 
        </li>
        <% if (!IsCreditProduct)
           { %>
        <li id='TabOrderTitle3' class='tabtitle' <%=IsShow()%> ><span><a href="###"  onclick='ShowOrderTabs(3)'>
            <asp:Localize ID="Localize4" Text="<%$ Res:Controls_ShowOrder_Localize4 , 过户记录 %>"
                runat="server" /></a></span> 
        </li>
        <%} %>
        <li id='TabOrderTitle4' class='tabtitle'><span><a href="###"  onclick='ShowOrderTabs(4)'>
            <asp:Localize ID="Localize5" Text="<%$ Res:Controls_ShowOrder_Localize5 , 服务记录 %>"
                runat="server" /></a></span> 
        </li>
        <li id='TabOrderTitle5' class='tabtitle'><span><a href="###"  onclick='ShowOrderTabs(5)'>
            <asp:Localize ID="Localize6" Text="<%$ Res:Controls_ShowOrder_Localize6 , 投诉记录 %>"
                runat="server" /></a></span> 
        </li>
        <li id='TabOrderTitle6' class='tabtitle' ><span><a href="###"  onclick='ShowOrderTabs(6)'>
            <asp:Localize ID="Localize7" Text="<%$ Res:Controls_ShowOrder_Localize7 , 反馈记录 %>"
                runat="server" /></a></span> 
        </li>
        <% if (!IsCreditProduct)
           { %>
        <li id='TabOrderTitle7' class='tabtitle' ><span><a href="###"  onclick='ShowOrderTabs(7)'>
            <asp:Localize ID="Localize8" Text="<%$ Res:Controls_ShowOrder_Localize8 , 在线支付记录 %>"
                runat="server" /></a></span> 
        </li>
        <%}
           if (m_ShowOptions == 0)
           { %>
        <li id='TabOrderTitle8' class='tabtitle'><span><a href="###"  onclick='ShowOrderTabs(8)'>
            <asp:Localize ID="Localize10" Text="<%$ Res:Controls_ShowOrder_Localize10 , 订单历史记录 %>"
                runat="server" />
        </li>
        <%} %>
        <li id="TabOrderTitle9" class='tabtitle' ><span><a href="###"  onclick='ShowOrderTabs(9)'>
         <asp:Localize ID="Localize11" Text="<%$ Res:Controls_ShowOrder_Localize11 , 积分明细 %>"
                runat="server" /></a></span> </li>
    </ul>
</div>
<div class="bd">
<div id="Tabs_Order0" class="border" style="width: 99%; display: block;">
    <pe:MemberExtendedGridView ID="EgvBankroll" runat="server" SerialText="" AutoGenerateColumns="False"
        EmptyDataText="<%$ Res:Controls_ShowOrder_EgvBankroll_EmptyDataText , 没有相关付款记录 %>"
        OnDataBound="EgvBankroll_DataBound" OnRowDataBound="EgvBankroll_RowDataBound"
        ShowFooter="True" CheckBoxFieldHeaderWidth="3%" IsHoldState="True">
        <Columns>
            <asp:HyperLinkField DataNavigateUrlFields="ClientID" DataTextField="ClientName" HeaderText="<%$ Res:Controls_ShowOrder_HyperLinkField1 , 客户名称 %>"
                DataNavigateUrlFormatString="~/Admin/Crm/ClientShow.aspx?ClientId={0}">
                <HeaderStyle Width="10%" />
            </asp:HyperLinkField>
            <pe:TemplateField HeaderText="<%$ Res:Controls_ShowOrder_TemplateField1 , 用户名 %>">
                <HeaderStyle Width="8%" />
                <ItemTemplate>
                    <asp:HyperLink ID="LnkUserName" runat="server" NavigateUrl='<%# Eval("UserName", "~/Admin/User/UserShow.aspx?UserName={0}") %>'
                        Text='<%# Eval("UserName") %>'></asp:HyperLink>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField DataField="DateAndTime" HeaderText="<%$ Res:Controls_ShowOrder_BoundField1 , 交易时间 %>"
                DataFormatString="{0:yyyy-MM-dd HH:mm:ss}" HtmlEncode="False">
                <HeaderStyle Width="17%" />
            </pe:BoundField>
            <pe:BoundField HeaderText="<%$ Res:Controls_ShowOrder_BoundField2 , 交易方式 %>">
                <HeaderStyle Width="8%" />
            </pe:BoundField>
            <pe:BoundField HeaderText="<%$ Res:Controls_ShowOrder_BoundField3 , 币种 %>">
                <HeaderStyle Width="7%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="<%$ Res:Controls_ShowOrder_TemplateField2 , 支出金额 %>">
                <ItemStyle HorizontalAlign="Right" />
                <HeaderStyle Width="8%" />
                <ItemTemplate>
                    <%#System.Math.Abs(Convert.ToDecimal(Eval("Money"))).ToString("N2")%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField HeaderText="<%$ Res:Controls_ShowOrder_BoundField4 , 摘要 %>">
                <HeaderStyle Width="6%" />
            </pe:BoundField>
            <pe:BoundField DataField="Remark" HeaderText="<%$ Res:Controls_ShowOrder_BoundField5 , 备注/说明 %>" />
            <asp:HyperLinkField DataNavigateUrlFields="ItemId" HeaderText="<%$ Res:Controls_ShowOrder_HyperLinkField2 , 操作 %>"
                Text="<%$ Res:Controls_ShowOrder_HyperLinkField2_Text , 查看 %>" DataNavigateUrlFormatString="~/Admin/User/BankrollItemDetail.aspx?BankrollItemID={0}">
                <HeaderStyle Width="6%" />
            </asp:HyperLinkField>
        </Columns>
        <FooterStyle CssClass="tdbg" />
    </pe:MemberExtendedGridView>
</div>
<div id="Tabs_Order1" class="border" style="width: 99%; display: none;">
    <pe:MemberExtendedGridView ID="EgvInvoice" runat="server" EmptyDataText="<%$ Res:Controls_ShowOrder_EgvInvoice_EmptyDataText , 没有相关发票记录 %>"
        AutoGenerateColumns="False" SerialText="" OnRowDataBound="EgvInvoice_RowDataBound"
        CheckBoxFieldHeaderWidth="3%" IsHoldState="True">
        <Columns>
            <pe:BoundField DataField="InvoiceDate" HeaderText="<%$ Res:Controls_ShowOrder_BoundField6 , 日期 %>"
                DataFormatString="{0:yyyy-MM-dd}" HtmlEncode="False">
                <HeaderStyle Width="10%" />
            </pe:BoundField>
            <pe:BoundField HeaderText="<%$ Res:Controls_ShowOrder_BoundField7 , 发票类型 %>">
                <HeaderStyle Width="10%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="<%$ Res:Controls_ShowOrder_TemplateField3 , 发票号码 %>"
                SortExpression="InvoiceNum">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <asp:HyperLink runat="server" Text='<%# Eval("InvoiceNum") %>' NavigateUrl='<%# Eval("InvoiceID", "~/Admin/Shop/InvoiceItemDetail.aspx?InvoiceID={0}") %>'
                        ID="LnkInvoiceID"></asp:HyperLink>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:BoundField DataField="InvoiceTitle" HeaderText="<%$ Res:Controls_ShowOrder_BoundField8 , 发票抬头 %>">
                <ItemStyle HorizontalAlign="Left" />
            </pe:BoundField>
            <pe:BoundField DataField="TotalMoney" HeaderText="<%$ Res:Controls_ShowOrder_BoundField9 , 发票金额 %>"
                DataFormatString="{0:N2}" HtmlEncode="False">
                <HeaderStyle Width="8%" />
            </pe:BoundField>
            <pe:BoundField DataField="Drawer" HeaderText="<%$ Res:Controls_ShowOrder_BoundField10 , 开票人 %>">
                <HeaderStyle Width="8%" />
            </pe:BoundField>
            <pe:BoundField DataField="Inputer" HeaderText="<%$ Res:Controls_ShowOrder_BoundField11 , 录入员 %>">
                <HeaderStyle Width="8%" />
            </pe:BoundField>
            <pe:BoundField DataField="InputTime" DataFormatString="{0:yyyy-MM-dd HH:mm:ss}" HeaderText="<%$ Res:Controls_ShowOrder_BoundField12 , 录入时间 %>"
                HtmlEncode="False">
                <HeaderStyle Width="17%" />
            </pe:BoundField>
        </Columns>
    </pe:MemberExtendedGridView>
</div>
<div id="Tabs_Order2" class="border" style="width: 99%; display: none;">
    <pe:MemberExtendedGridView ID="EgvDeliverItem" runat="server" AutoGenerateColumns="False"
        OnRowDataBound="EgvDeliverItem_RowDataBound" SerialText="" EmptyDataText="<%$ Res:Controls_ShowOrder_EgvDeliverItem_EmptyDataText , 没有相关发退货记录 %>"
        OnRowCommand="EgvDeliverItem_RowCommand" CheckBoxFieldHeaderWidth="3%" IsHoldState="True">
        <Columns>
            <asp:TemplateField HeaderText="<%$ Res:Controls_ShowOrder_BoundField13 , 日期 %>">
                <ItemTemplate>
                    <a class="expandEditHistory" deliveid='<%#Eval("DeliverId")%>' runat="server" id="ImgBtnExpand" />
                    <asp:Label ID="Label1" runat="server" Text='<%# Bind("DeliverDate", "{0:yyyy-MM-dd}") %>'></asp:Label>
                </ItemTemplate>
                <HeaderStyle Width="10%" />
            </asp:TemplateField>
            <asp:BoundField HeaderText="<%$ Res:Controls_ShowOrder_BoundField14 , 发货/客户退货 %>">
                <HeaderStyle Width="12%" />
            </asp:BoundField>
            <asp:TemplateField HeaderText="<%$ Res:Controls_ShowOrder_TemplateField4 , 快递公司名 %>">
                <ItemTemplate>
                    <asp:Literal ID="LitExpressCompony" runat="server"></asp:Literal>
                </ItemTemplate>
                <HeaderStyle Width="12%" />
            </asp:TemplateField>
            <asp:TemplateField HeaderText="<%$ Res:Controls_ShowOrder_TemplateField5 , 快递单号 %>">
                <ItemTemplate>
                    <asp:Literal ID="LitExpressNumber" runat="server"></asp:Literal>
                </ItemTemplate>
                <HeaderStyle Width="15%" />
            </asp:TemplateField>
            <asp:BoundField DataField="HandlerName" HeaderText="<%$ Res:Controls_ShowOrder_BoundField15 , 经手人 %>">
                <HeaderStyle Width="8%" />
            </asp:BoundField>
            <asp:BoundField DataField="Inputer" HeaderText="<%$ Res:Controls_ShowOrder_BoundField16 , 录入员 %>">
                <HeaderStyle Width="8%" />
            </asp:BoundField>
            <asp:BoundField HeaderText="<%$ Res:Controls_ShowOrder_BoundField17 , 客户已签收 %>">
                <HeaderStyle Width="10%" />
            </asp:BoundField>
            <asp:BoundField DataField="Remark" HeaderText="<%$ Res:Controls_ShowOrder_BoundField18 , 备注/退货原因 %>">
                <HeaderStyle Width="10%" />
            </asp:BoundField>
            <asp:TemplateField HeaderText="<%$ Res:Controls_ShowOrder_TemplateField6 , 操作 %>"
                Visible="False">
                <ItemTemplate>
                    <asp:LinkButton ID="LinkButton1" runat="server" CausesValidation="False" CommandArgument='<%# Eval("OrderNum") %>'
                        CommandName="Received" OnClientClick="<%$ Res:Controls_ShowOrder_LinkButton1_OnClientClick , return confirm('确定已经收到此订单中的货物了吗？') %>"
                        Text="<%$ Res:Controls_ShowOrder_LinkButton1 , 签收 %>"></asp:LinkButton>
                </ItemTemplate>
                <HeaderStyle Width="5%" />
            </asp:TemplateField>
            <asp:TemplateField HeaderText="<%$ Res:Controls_ShowOrder_TemplateField7 , 查看物流情况 %>">
                <ItemTemplate>
                    <pe:ExtendedLiteral ID="LitExpressState" runat="server" HtmlEncode="false"></pe:ExtendedLiteral>
                </ItemTemplate>
                <HeaderStyle Width="10%" />
            </asp:TemplateField>
        </Columns>
    </pe:MemberExtendedGridView>
</div>
<div id="Tabs_Order3" class="border" style="width: 99%; display: none;">
    <pe:MemberExtendedGridView ID="EgvTransferLog" runat="server" AutoGenerateColumns="False"
        EmptyDataText="<%$ Res:Controls_ShowOrder_EgvTransferLog_EmptyDataText , 没有相关过户记录 %>"
        SerialText="">
        <Columns>
            <pe:BoundField DataField="TransferTime" HeaderText="<%$ Res:Controls_ShowOrder_BoundField19 , 时间 %>"
                DataFormatString="{0:yyyy-MM-dd HH:mm:ss}" HtmlEncode="False">
                <HeaderStyle Width="15%" />
            </pe:BoundField>
            <pe:BoundField DataField="OwnerUserName" HeaderText="<%$ Res:Controls_ShowOrder_BoundField20 , 过户人 %>">
                <HeaderStyle Width="8%" />
            </pe:BoundField>
            <pe:BoundField DataField="TargetUserName" HeaderText="<%$ Res:Controls_ShowOrder_BoundField21 , 过户给 %>">
                <HeaderStyle Width="8%" />
            </pe:BoundField>
            <pe:BoundField DataField="Poundage" HeaderText="<%$ Res:Controls_ShowOrder_BoundField22 , 过户费 %>"
                DataFormatString="{0:N2}" HtmlEncode="False">
                <HeaderStyle Width="6%" />
            </pe:BoundField>
            <pe:BoundField DataField="PayerUserName" HeaderText="<%$ Res:Controls_ShowOrder_BoundField23 , 付款人 %>">
                <HeaderStyle Width="8%" />
            </pe:BoundField>
            <pe:BoundField DataField="Remark" HeaderText="<%$ Res:Controls_ShowOrder_BoundField24 , 备注 %>" />
            <pe:BoundField DataField="Inputer" HeaderText="<%$ Res:Controls_ShowOrder_BoundField25 , 经手人 %>">
                <HeaderStyle Width="8%" />
            </pe:BoundField>
        </Columns>
    </pe:MemberExtendedGridView>
</div>
<div id="Tabs_Order4" class="border" style="width: 99%; display: none;">
    <pe:MemberExtendedGridView ID="EgvService" runat="server" AutoGenerateColumns="False" EmptyDataText="<%$ Res:Controls_ShowOrder_EgvService_EmptyDataText , 没有相关服务记录 %>"
        SerialText="" OnRowDataBound="EgvService_RowDataBound" CheckBoxFieldHeaderWidth="3%"
        IsHoldState="True">
        <Columns>
            <asp:BoundField DataField="ServiceTime" HeaderText="<%$ Res:Controls_ShowOrder_BoundField26 , 服务时间 %>"
                SortExpression="ServiceTime" DataFormatString="{0:yyyy-MM-dd HH:mm:ss}" HtmlEncode="False">
                <HeaderStyle Width="10%" />
            </asp:BoundField>
            <asp:TemplateField HeaderText="<%$ Res:Controls_ShowOrder_TemplateField8 , 客户名称 %>"
                SortExpression="ShortedForm">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <asp:HyperLink runat="server" Text='<%# Eval("ShortedForm") %>' NavigateUrl='<%# Eval("ClientID", "~/Admin/Crm/ClientShow.aspx?ClientId={0}") %>'
                        ID="LnkClientShow"></asp:HyperLink>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="<%$ Res:Controls_ShowOrder_TemplateField9 , 主题 %>"
                SortExpression="ServiceTitle">
                <ItemTemplate>
                    <asp:HyperLink runat="server" Text='<%# Eval("ServiceTitle") %>' NavigateUrl='<%# Eval("ItemId", "~/Admin/Crm/ServiceShow.aspx?ItemId={0}") %>'
                        ID="LnkServiceTitle"></asp:HyperLink>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:BoundField HeaderText="<%$ Res:Controls_ShowOrder_BoundField27 , 服务类型 %>" SortExpression="ServiceType"
                DataField="ServiceType">
                <HeaderStyle Width="10%" />
            </asp:BoundField>
            <asp:BoundField HeaderText="<%$ Res:Controls_ShowOrder_BoundField28 , 服务方式 %>" SortExpression="ServiceMode"
                DataField="ServiceMode">
                <HeaderStyle Width="10%" />
            </asp:BoundField>
            <asp:BoundField HeaderText="<%$ Res:Controls_ShowOrder_BoundField29 , 服务人员 %>" SortExpression="Processor"
                DataField="Processor"></asp:BoundField>
            <asp:BoundField HeaderText="<%$ Res:Controls_ShowOrder_BoundField30 , 服务结果 %>" SortExpression="ServiceResult"
                DataField="ServiceResult">
                <HeaderStyle Width="10%" />
            </asp:BoundField>
            <asp:TemplateField HeaderText="<%$ Res:Controls_ShowOrder_TemplateField10 , 回访确认%>">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <%#Eval("ConfirmTime") == null ? "" : "<strong>√</strong>"%>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:BoundField HeaderText="<%$ Res:Controls_ShowOrder_BoundField31 , 客户评价 %>" DataField="ConfirmScore">
                <HeaderStyle Width="10%" />
            </asp:BoundField>
        </Columns>
    </pe:MemberExtendedGridView>
</div>
<div id="Tabs_Order5" class="border" style="width: 99%; display: none;">
    <pe:MemberExtendedGridView ID="EgvComplain" runat="server" AutoGenerateColumns="False"
        EmptyDataText="<%$ Res:Controls_ShowOrder_EgvComplain_EmptyDataText , 没有相关投诉记录 %>"
        SerialText="" OnRowDataBound="EgvComplain_RowDataBound" CheckBoxFieldHeaderWidth="3%"
        IsHoldState="True">
        <Columns>
            <asp:BoundField DataField="DateAndTime" HeaderText="<%$ Res:Controls_ShowOrder_BoundField32 , 投诉时间 %>"
                SortExpression="DateAndTime" DataFormatString="{0:yyyy-MM-dd HH:mm:ss}" HtmlEncode="False">
                <HeaderStyle Width="15%" />
            </asp:BoundField>
            <asp:TemplateField HeaderText="<%$ Res:Controls_ShowOrder_TemplateField11 , 客户名称 %>"
                SortExpression="ShortedForm">
                <HeaderStyle Width="10%" />
                <ItemTemplate>
                    <asp:HyperLink runat="server" Text='<%# Eval("ShortedForm") %>' NavigateUrl='<%# Eval("ClientID", "~/Admin/Crm/ClientShow.aspx?ClientId={0}") %>'
                        ID="LnkClientShow2"></asp:HyperLink>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:BoundField DataField="ComplainType" HeaderText="<%$ Res:Controls_ShowOrder_BoundField33 , 投诉类型 %>"
                SortExpression="ComplainType">
                <HeaderStyle Width="10%" />
            </asp:BoundField>
            <asp:TemplateField HeaderText="<%$ Res:Controls_ShowOrder_TemplateField12 ,主题 %>">
                <ItemTemplate>
                    <asp:HyperLink runat="server" Text='<%# Eval("Title") %>' NavigateUrl='<%# Eval("ItemId", "~/Admin/Crm/ComplainShow.aspx?ItemId={0}") %>'
                        ID="LnkComplainTitle"></asp:HyperLink>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:BoundField DataField="MagnitudeOfExigence" HeaderText="<%$ Res:Controls_ShowOrder_BoundField34 , 紧急程度 %>"
                SortExpression="MagnitudeOfExigence">
                <HeaderStyle Width="10%" />
            </asp:BoundField>
            <asp:BoundField DataField="Status" HeaderText="<%$ Res:Controls_ShowOrder_BoundField35 , 记录状态 %>"
                SortExpression="Status">
                <HeaderStyle Width="10%" />
            </asp:BoundField>
        </Columns>
    </pe:MemberExtendedGridView>
</div>
<div id="Tabs_Order6" class="border" style="width: 99%; display: none;">
    <pe:MemberExtendedGridView ID="EgvFeedback" runat="server" AutoGenerateColumns="False"
        AutoGenerateCheckBoxColumn="false" CssClass="TableWrap" EmptyDataText="<%$ Res:Controls_ShowOrder_EgvFeedback_EmptyDataText , 没有反馈记录 %>"
        SerialText="" OnRowCommand="EgvFeedback_RowCommand">
        <Columns>
            <pe:BoundField DataField="WriteTime" HeaderText="<%$ Res:Controls_ShowOrder_BoundField36 , 时间 %>"
                DataFormatString="{0:yyyy-MM-dd HH:mm:ss}" HtmlEncode="False">
                <HeaderStyle Width="15%" />
            </pe:BoundField>
            <pe:BoundField DataField="Content" ItemStyle-CssClass="TdWrap" ItemStyle-HorizontalAlign="left"
                HeaderText="<%$ Res:Controls_ShowOrder_BoundField37 , 内容 %>">
            </pe:BoundField>
            <pe:BoundField DataField="ReplyName" HeaderText="<%$ Res:Controls_ShowOrder_BoundField38 , 管理员名 %>">
                <HeaderStyle Width="10%" />
            </pe:BoundField>
            <pe:TemplateField HeaderText="<%$ Res:Controls_ShowOrder_TemplateField13 , 操作 %>">
                <HeaderStyle Width="14%" />
                <ItemTemplate>
                    <asp:LinkButton ID="LbtnReply" Visible='<%#string.IsNullOrEmpty(Convert.ToString(Eval("ReplyContent")))%>'
                        runat="server" Text="<%$ Res:Controls_ShowOrder_LbtnReply , 回复 %>" CommandArgument='<%#Eval("Id") %>'
                        CommandName="ReplyContent"></asp:LinkButton>
                    <a href='OrderFeedbackModify.aspx?ID=<%#Eval("Id")%><%#string.IsNullOrEmpty(Convert.ToString(Eval("ReplyName")))?"":"&Action=ModifyReply"%>'>
                        <asp:Localize ID="Localize9" Text="<%$ Res:Controls_ShowOrder_Localize9 , 修改 %>"
                            runat="server" /></a>
                    <asp:LinkButton ID="LbtnDelFeedback" runat="server" Text="<%$ Res:Controls_ShowOrder_LbtnDelFeedback , 删除 %>"
                        CommandArgument='<%#Eval("Id") %>' CommandName='<%#string.IsNullOrEmpty(Convert.ToString(Eval("ReplyName")))?"Del":"DelReply" %>'></asp:LinkButton>
                </ItemTemplate>
            </pe:TemplateField>
        </Columns>
    </pe:MemberExtendedGridView>
</div>
<div id="Tabs_Order7" class="border" style="width: 99%; display: none;">
    <pe:MemberExtendedGridView ID="GdvPaymentLogList" runat="server" AutoGenerateCheckBoxColumn="False"
        AutoGenerateColumns="False" OnRowDataBound="GdvPaymentLogList_RowDataBound" HorizontalAlign="Center">
        <Columns>
            <pe:TemplateField HeaderText="<%$ Res:Controls_ShowOrder_TemplateField14 , 支付序号 %>">
                <HeaderStyle Width="18%" />
                <ItemTemplate>
                    <asp:HyperLink ID="LnkPaymentNum" runat="server"></asp:HyperLink>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="<%$ Res:Controls_ShowOrder_TemplateField15 , 支付平台 %>">
                <ItemTemplate>
                    <asp:Label ID="LblPlatform" runat="server" />
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="<%$ Res:Controls_ShowOrder_TemplateField16 , 交易时间 %>"
                SortExpression="PayTime">
                <HeaderStyle Width="20%" />
                <ItemTemplate>
                    <%# Eval("PayTime", "{0:yyyy-MM-dd HH:mm:ss}")%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="<%$ Res:Controls_ShowOrder_TemplateField17 , 汇款金额 %>"
                SortExpression="MoneyPay">
                <HeaderStyle Width="12%" />
                <ItemStyle HorizontalAlign="right" />
                <ItemTemplate>
                    <%# Eval("MoneyPay", "{0:N2}")%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="<%$ Res:Controls_ShowOrder_TemplateField18 , 实际转账金额 %>"
                SortExpression="MoneyTrue">
                <HeaderStyle Width="12%" />
                <ItemStyle HorizontalAlign="right" />
                <ItemTemplate>
                    <%# Eval("MoneyTrue", "{0:N2}")%>
                </ItemTemplate>
            </pe:TemplateField>
            <pe:TemplateField HeaderText="<%$ Res:Controls_ShowOrder_TemplateField19 , 交易状态 %>">
                <HeaderStyle Width="8%" />
                <ItemTemplate>
                    <asp:Label ID="LblStatus" runat="server" />
                </ItemTemplate>
            </pe:TemplateField>
        </Columns>
    </pe:MemberExtendedGridView>
</div>
<div id="Tabs_Order8" class="border" style="width: 99%; display: none">
    <pe:MemberExtendedGridView ID="EgvOrderHistory" runat="server" AutoGenerateColumns="False"
        CheckBoxFieldHeaderWidth="3%" IsHoldState="True" SerialText="" OnRowDataBound="EgvOderHistory_RowDataBound">
        <Columns>
            <asp:TemplateField SortExpression="ActionName" HeaderText="<%$ Res:Controls_ShowOrder_TemplateField191 , 操作名称 %>">
                <ItemTemplate>
                    <a class="expandEditHistory" orderhistoryid='<%#Eval("OrderHistoryID")%>' visible="false"
                        runat="server" id="ImgBtnExpand" />
                    <asp:Label runat="server" ID="lblActionName" Text='<%# Eval("ActionName") %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:BoundField DataField="ActionTime" HeaderText="<%$ Res:Controls_ShowOrder_TemplateField192 , 操作时间 %>"
                SortExpression="ActionTime" />
            <asp:BoundField DataField="UserIP" HeaderText="<%$ Res:Controls_ShowOrder_TemplateField193 , 操作员IP %>"
                SortExpression="UserIP" />
            <asp:BoundField DataField="UserName" HeaderText="<%$ Res:Controls_ShowOrder_TemplateField194 , 操作人 %>"
                SortExpression="UserName" />
            <asp:TemplateField SortExpression="Remark" HeaderText="<%$ Res:Controls_ShowOrder_TemplateField195 , 操作备注 %>"
                HeaderStyle-Width="390" ControlStyle-Width="100%" ItemStyle-HorizontalAlign="Left">
                <ItemTemplate>
                    <asp:Label ID="Remark" runat="server" Text='<%# Bind("Remark") %>'>无</asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
        </Columns>
    </pe:MemberExtendedGridView>
</div>
<div id="Tabs_Order9" class="border" style="width: 99%; display: none">
    <pe:MemberExtendedGridView ID="EgvUserExpLog" runat="server" AutoGenerateColumns="False"
        CheckBoxFieldHeaderWidth="3%" DataKeyNames="LogId" IsHoldState="True" SerialText="">
        <Columns>
            <asp:BoundField DataField="LogTime" DataFormatString="{0:yyyy-MM-dd HH:mm:ss}" HeaderText="记录时间"
                HtmlEncode="False" SortExpression="LogTime" />
            <asp:HyperLinkField DataNavigateUrlFields="UserName" DataNavigateUrlFormatString="UserShow.aspx?UserName={0}"
                DataTextField="UserName" HeaderText="用户名" />
            <asp:BoundField DataField="IP" HeaderText="IP地址" SortExpression="IP" />
            <asp:TemplateField HeaderText="积分记录">
                <ItemStyle HorizontalAlign="Right" />
                <ItemTemplate>
                    <%# (int)Eval("IncomePayout") == 1 ? "+" : "-" %><%# Eval("ExpNum") %>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:BoundField DataField="Remark" HeaderText="备注/说明" SortExpression="Remark" />
        </Columns>
    </pe:MemberExtendedGridView>
	</div>
</div>
</div>
<script type="text/javascript">
    function ShowOrder_ModifyItem(arg, context) {
        if(jQuery(context).attr("hasdata")){
            jQuery(context).parent().parent().next('.editHistoryContainer').show();
        }else{
            <%=m_HistoryItemsCallServer %>
        }
        return false;
    }

    function ShowOrder_CloseModifyItem(context) {
    var $editHistoryContainer=jQuery(context).parent().parent().next('.editHistoryContainer');
        $editHistoryContainer.fadeOut('fast');//,function(){ $editHistoryContainer.remove();});
        return false;
    }
    
    <%--jQuery("#<%=EgvOrderHistory.ClientID %> .expandEditHistory").toggle(function() {
        ShowOrder_ModifyItem("OrderHistory|"+jQuery(this).attr("orderhistoryid"), this);
        jQuery(this).css("background-position","0 -15px");
    }, function() { jQuery(this).css("background-position","0 0");ShowOrder_CloseModifyItem(this); });--%>

    jQuery("#<%=EgvOrderHistory.ClientID %> .expandEditHistory").click(function () {
        if (jQuery(this).css("background-position") == undefined || jQuery(this).css("background-position").indexOf("-15px") < 0) {
            ShowOrder_ModifyItem("OrderHistory|" + jQuery(this).attr("orderhistoryid"), this);
            jQuery(this).css("background-position", "0 -15px");
        }
        else {
            jQuery(this).css("background-position", "0 0"); ShowOrder_CloseModifyItem(this);
        }
    });
    
    <%--jQuery("#<%=EgvDeliverItem.ClientID %> .expandEditHistory").toggle(
        function(){ShowOrder_ModifyItem("DeliverItemDetails|"+jQuery(this).attr("deliveid"),this);jQuery(this).css("background-position","0 -15px");},
        function(){jQuery(this).css("background-position","0 0");ShowOrder_CloseModifyItem(this);
    });--%>

    jQuery("#<%=EgvDeliverItem.ClientID %> .expandEditHistory").click(function () {
        if (jQuery(this).css("background-position") == undefined || jQuery(this).css("background-position").indexOf("-15px") < 0) {
            ShowOrder_ModifyItem("DeliverItemDetails|" + jQuery(this).attr("deliveid"), this); jQuery(this).css("background-position", "0 -15px");
        }
        else {
            jQuery(this).css("background-position", "0 0"); ShowOrder_CloseModifyItem(this);
        }
    });

    function ShowOrder_onSuccess(result, context) {
        var headitems;
        if(context.id.indexOf('OrderHistory') > 0){
            headitems = ["<%=Resources.DynamicPageResources.Controls_ShowOrder_TemplateField196 %>","<%=Resources.DynamicPageResources.Controls_ShowOrder_TemplateField197 %>","<%=Resources.DynamicPageResources.Controls_ShowOrder_TemplateField198 %>"];                        
            ShowData(headitems,['FieldName','OldValue','NewValue'],result,context);            
        }else if(context.id.indexOf('DeliverItem') > 0){
            ShowData(['商品名称','商品规格','数量'],['Name','Pty','Num'],result,context);
        }    
    }    
    
    function ShowData(headitems,properties,result,context){
        var cols = jQuery(context).parent().parent().find("td").length;
        var itemList = eval(result);
        var $editHistoryContainer = jQuery("<tr class='editHistoryContainer tdbg'><td colspan='"+cols+"'></td></tr>");
        result = '';
        if (itemList.length > 0) {
            var sb = new Sys.StringBuilder("<table class='border' cellspacing='1' cellpadding='0' style=' width: 500px;'>");//margin: 0pt auto;
            sb.append("<tr class='gridtitle' style='height:25px;'>");            
            for(var j in headitems){
                sb.append("<th scope='col'>");
                sb.append(headitems[j]);
                sb.append("</th>");
            }
            sb.append("</tr>");
            for (var i in itemList) {
                sb.append("<tr class='tdbg' align='center'>");
                for(var p in properties){
                    sb.append("<td align='center'>");                    
                    sb.append(itemList[i][properties[p]]);
                    sb.append("</td>");                    
                }
                sb.append("</tr>");
            }
            sb.append("</table>");
            result = sb.toString();
        }
        else {
            result = '无相关记录';
        }
        $editHistoryContainer.find('td').eq(0).append(result);
        jQuery($editHistoryContainer).insertAfter(jQuery(context).parent().parent()).show('fast');
        jQuery(context).attr("hasdata","true");
    }
</script>

