﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="ShowOrderDetail.ascx.cs"
    Inherits="PowerEasy.Module.Shop.WebSite.Controls.Shop.ShowOrderDetail" %>
<div class="hdTitle">
    <h3><strong><asp:Localize ID="Localize1" Text="<%$ Res: Controls_ShowOrderDetail_Localize1 , 订 单 信 息 %>"
        runat="server" /><asp:Localize ID="Localize2" Text="<%$ Res: Controls_ShowOrderDetail_Localize2 ,（订单编号： %>"
            runat="server" /><asp:Label ID="LblOrderNum" runat="server"></asp:Label>）</strong></h3>
</div>
<div class="bdCont">
    <table  class="tableStyle tableStyleBorder" id="tabInfo01">
        <tr class="first">
            <td>
                <asp:Localize ID="Localize3" Text="<%$ Res: Controls_ShowOrderDetail_Localize3 ,客户名称： %>"
                    runat="server" /><asp:HyperLink ID="HlkClientName" runat="server"></asp:HyperLink>
            </td>
            <td>
                <asp:Localize ID="Localize4" Text="<%$ Res: Controls_ShowOrderDetail_Localize4 ,用 户 名： %>"
                    runat="server" /><asp:HyperLink ID="HlkUserName" runat="server"></asp:HyperLink>
            </td>
            <td>
                <asp:Localize ID="Localize5" Text="<%$ Res: Controls_ShowOrderDetail_Localize5 ,代 理 商： %>"
                    runat="server" />
                <asp:HyperLink ID="HlkAgentName" runat="server"></asp:HyperLink>
            </td>
            <td>
                <asp:Localize ID="Localize6" Text="<%$ Res: Controls_ShowOrderDetail_Localize6 ,购买日期： %>"
                    runat="server" /><asp:Label ID="LblBeginDate" runat="server"></asp:Label>
            </td>
            <td>
                <asp:Localize ID="Localize7" Text="<%$ Res: Controls_ShowOrderDetail_Localize7 ,下单时间： %>"
                    runat="server" /><asp:Label ID="LblInputTime" runat="server"></asp:Label>
            </td>
        </tr>
        <tr>
            <%if (!m_IsCreditProduct)
              { %>
            <td>
                <asp:Localize ID="Localize8" Text="<%$ Res: Controls_ShowOrderDetail_Localize8 , 需要发票： %>"
                    runat="server" /><pe:ExtendedLabel HtmlEncode="false" ID="LblNeedInvoice" runat="server"></pe:ExtendedLabel>
            </td>
            <td>
                <asp:Localize ID="Localize9" Text="<%$ Res: Controls_ShowOrderDetail_Localize9 ,已开发票： %>"
                    runat="server" /><pe:ExtendedLabel HtmlEncode="false" ID="LblInvoiced" runat="server"></pe:ExtendedLabel>
            </td>
            <%} %>
            <td>
                <asp:Localize ID="Localize10" Text="<%$ Res: Controls_ShowOrderDetail_Localize10 ,订单状态： %>"
                    runat="server" /><pe:ExtendedLabel HtmlEncode="false" ID="LblStatus" runat="server"></pe:ExtendedLabel>
            </td>
            <td>
                <%if (!m_IsCreditProduct)
                  { %>
                <asp:Localize ID="Localize11" Text="<%$ Res: Controls_ShowOrderDetail_Localize11 ,付款情况： %>"
                    runat="server" />
                <%}
                  else
                  { %>
                <asp:Localize ID="LocCreditProductStatus" Text="<%$ Res: Controls_ShowOrderDetail_CreditProductStatus ,积分状态： %>"
                    runat="server" />
                <%} %><pe:ExtendedLabel HtmlEncode="false" ID="LblMoneyTotal" runat="server"></pe:ExtendedLabel>
            </td>
            <td <%=m_IsCreditProduct ? "colspan='4'":"" %>>
                <asp:Localize ID="Localize12" Text="<%$ Res: Controls_ShowOrderDetail_Localize12 ,物流状态： %>"
                    runat="server" /><pe:ExtendedLabel HtmlEncode="false" ID="LblDeliverStatus" runat="server"></pe:ExtendedLabel>
            </td>
        </tr>
    </table>
    <table  class="tableStyle  tableStyleBorder" id="tabInfo02">
        <tr>
            <td class="ok_tab">
                <asp:Localize ID="Localize13" Text="<%$ Res: Controls_ShowOrderDetail_Localize13 ,收货人姓名： %>"
                    runat="server" />
            </td>
            <td>
                <asp:Label ID="LblContacterName" runat="server"></asp:Label>
            </td>
            <td class="ok_tab">
                <asp:Localize ID="Localize14" Text="<%$ Res: Controls_ShowOrderDetail_Localize14 ,联系电话： %>"
                    runat="server" />
            </td>
            <td>
                <asp:Label ID="LblPhone" runat="server"></asp:Label>
            </td>
        </tr>
        <tr>
            <td class="ok_tab">
                <asp:Localize ID="Localize15" Text="<%$ Res: Controls_ShowOrderDetail_Localize15 ,收货人地址： %>"
                    runat="server" />
            </td>
            <td>
                <asp:Label ID="LblAddress" runat="server"></asp:Label>
            </td>
            <td class="ok_tab">
                <asp:Localize ID="Localize16" Text="<%$ Res: Controls_ShowOrderDetail_Localize16 ,邮政编码： %>"
                    runat="server" />
            </td>
            <td>
                <asp:Label ID="LblZipCode" runat="server"></asp:Label>
            </td>
        </tr>
        <tr>
            <td class="ok_tab">
                <asp:Localize ID="Localize17" Text="<%$ Res: Controls_ShowOrderDetail_Localize17 ,收货人邮箱： %>"
                    runat="server" />
            </td>
            <td>
                <asp:Label ID="LblEmail" runat="server"></asp:Label>
            </td>
            <td class="ok_tab">
                <asp:Localize ID="Localize18" Text="<%$ Res: Controls_ShowOrderDetail_Localize18 ,收货人手机： %>"
                    runat="server" />
            </td>
            <td>
                <asp:Label ID="LblMobile" runat="server"></asp:Label>
            </td>
        </tr>
        <tr>
            <td class="ok_tab">
                <asp:Localize ID="Localize19" Text="<%$ Res: Controls_ShowOrderDetail_Localize19 ,付款方式： %>"
                    runat="server" />
            </td>
            <td>
                <asp:Label ID="LblPaymentType" runat="server"></asp:Label>
            </td>
            <td class="ok_tab">
                <asp:Localize ID="Localize20" Text="<%$ Res: Controls_ShowOrderDetail_Localize20 ,送货方式： %>"
                    runat="server" />
            </td>
            <td>
                <asp:Label ID="LblDeliverType" runat="server"></asp:Label>
            </td>
        </tr>
        <tr>
            <td class="ok_tab">
                <asp:Localize ID="Localize21" Text="<%$ Res: Controls_ShowOrderDetail_Localize21 ,发票信息： %>"
                    runat="server" />
            </td>
            <td>
                <asp:Label ID="LblInvoiceContent" runat="server"></asp:Label>
            </td>
            <td class="ok_tab">
                <asp:Literal ID="LtrMemoTitle" Text="<%$ Res: Controls_ShowOrderDetail_LtrMemoTitle ,内部记录： %>"
                    runat="server" Visible="false"></asp:Literal>
            </td>
            <td>
                <asp:Label ID="LblMemo" runat="server" Visible="false"></asp:Label>
            </td>
        </tr>
        <tr runat="server" id="ShowFunctionary" visible="false">
            <td class="ok_tab">
                <asp:Localize ID="Localize22" Text="<%$ Res: Controls_ShowOrderDetail_Localize22 ,订单类型： %>"
                    runat="server" />
            </td>
            <td>
                <asp:Label ID="LblOrderType" runat="server"></asp:Label>
            </td>
            <td class="ok_tab">
                <asp:Localize ID="Localize23" Text="<%$ Res: Controls_ShowOrderDetail_Localize23 ,跟单员： %>"
                    runat="server" />
            </td>
            <td>
                <asp:Label ID="LblFunctionary" runat="server"></asp:Label>
            </td>
        </tr>
        <asp:Repeater ID="RptProduct" runat="server" OnItemDataBound="RptProduct_ItemDataBound">
            <ItemTemplate>
                <tr>
                    <td class="ok_tab">
                        <%# Eval("FieldAlias")%>：
                    </td>
                    <td colspan="3" style="word-wrap: break-word; word-break: break-all;">
                        <asp:Literal ID="litProductText" runat="server"></asp:Literal>
                    </td>
                </tr>
            </ItemTemplate>
        </asp:Repeater>
    </table>
    <asp:Repeater ID="RptOrderItem" runat="server" OnItemDataBound="RptOrderItem_ItemDataBound">
        <HeaderTemplate>
            <table class="tableStyle tableStyleBorder" id="tabInfoList">
                <tr class="first">
                    <td style="width:8%;text-align: center;" id="ProductImageTitle" runat="server">
                        <asp:Localize ID="Localize36" Text="<%$ Res: Controls_ShowOrderDetail_Localize36 ,商品图片 %>"
                            runat="server" />
                    </td>
                    <td style="width:25%;padding-left: 0px; padding-right: 0px; text-align: center;">
                        <asp:Localize ID="Localize24" Text="<%$ Res: Controls_ShowOrderDetail_Localize24 ,商品名称 %>"
                            runat="server" />
                    </td>
                    <td style="width: 5%; padding-left: 0px; padding-right: 0px; text-align: center;">
                        <asp:Localize ID="Localize25" Text="<%$ Res: Controls_ShowOrderDetail_Localize25 ,单位 %>"
                            runat="server" />
                    </td>
                    <td style="width: 6%; padding-left: 0px; padding-right: 0px; text-align: center;">
                        <asp:Localize ID="Localize26" Text="<%$ Res: Controls_ShowOrderDetail_Localize26 ,数量 %>"
                            runat="server" />
                    </td>
                    <td style="width: 5%; padding-left: 0px; padding-right: 0px; text-align: center;"
                        runat="server" id="tdStockTitle">
                        现有库存
                    </td>
                    <td style="width: 5%; padding-left: 0px; padding-right: 0px; text-align: center;"
                        runat="server" id="tdStockStateTitle">
                        库存状态
                    </td>
                    <td id="tdMarkPrice" runat="server" style="width: 9%; padding-left: 0px; padding-right: 0px; text-align: center;">
                        <asp:Localize ID="Localize27" Text="<%$ Res: Controls_ShowOrderDetail_Localize27 ,市场价 %>"
                            runat="server" />
                    </td>
                    <%if (m_IsCreditProduct)
                      {%>
                    <td style="padding-left: 0px; padding-right: 0px; text-align: center;">
                        换购积分
                    </td>
                    <td style="padding-left: 0px; padding-right: 0px; text-align: center;">
                        总积分
                    </td>
                    <%}
                      else
                      { %>
                    <td id="tdPrice" runat="server"  style="width: 9%; padding-left: 0px; padding-right: 0px; text-align: center;">
                        <asp:Localize ID="Localize28" Text="<%$ Res: Controls_ShowOrderDetail_Localize28 ,实价 %>"
                            runat="server" />
                    </td>
                    <td style="width: 9%; padding-left: 0px; padding-right: 0px; text-align: center;">
                        <asp:Localize ID="Localize29" Text="<%$ Res: Controls_ShowOrderDetail_Localize29 ,指定价 %>"
                            runat="server" />
                    </td>
                    <td style="width: 10%; padding-left: 0px; padding-right: 0px; text-align: center;">
                        <asp:Localize ID="Localize30" Text="<%$ Res: Controls_ShowOrderDetail_Localize30 ,金额 %>"
                            runat="server" />
                    </td>
                    <%} %>
                    <td style="width: 10%; padding-left: 0px; padding-right: 0px; text-align: center;">
                        <asp:Localize ID="Localize31" Text="<%$ Res: Controls_ShowOrderDetail_Localize31 ,服务期限 %>"
                            runat="server" />
                    </td>
                    <td style="width: 12%; padding-left: 0px; padding-right: 0px; text-align: center;">
                        <asp:Localize ID="Localize32" Text="<%$ Res: Controls_ShowOrderDetail_Localize32 ,备注 %>"
                            runat="server" />
                    </td>
                </tr>
        </HeaderTemplate>
        <ItemTemplate>
            <tr align='center'>
                <td id="ProductImage" runat="server" style="text-align: center;">
                    <pe:ExtendedImage ID="extendedImage" runat="server"></pe:ExtendedImage>
                </td>
                <td align="left" style="text-align: center;">
                    <asp:HyperLink ID="LnkProduct" Text='<%#GetProductName(Convert.ToString(Eval("ProductName")),(Eval("Property")==null?"":Eval("Property").ToString()),Convert.ToInt32(Eval("SaleType"))) %>'
                        runat="server"></asp:HyperLink>
                </td>
                <td style="text-align: center;">
                    <asp:Literal ID="LtrUnit" runat="server" Text='<%#Eval("Unit")%>'></asp:Literal>
                </td>
                <td style="text-align: center;">
                    <asp:Literal ID="LtrAmount" runat="server" Text='<%#Eval("Amount") %>'></asp:Literal>
                </td>
                <td style="width: 5%; text-align: center;" runat="server" id="tdStock">
                    <asp:Literal ID="LtrStock" runat="server"></asp:Literal>
                </td>
                <td style="width: 5%; text-align: center;" runat="server" id="tdStockState">
                    <pe:ExtendedLabel ID="LblStockState" runat="server" HtmlEncode="false"></pe:ExtendedLabel>
                </td>
                <td  id="tdMarkPrice" runat="server" style="text-align: center;">
                    <asp:Literal ID="LtrPrice_Original" runat="server" Text='<%#Decimal.Round(Convert.ToDecimal(Eval("PriceMarket")),2) %>'></asp:Literal>
                </td>
                <% if (m_IsCreditProduct)
                   { %>
                <td style="text-align: center;">
                    <%# Eval("PresentExp") %>
                </td>
                <td style="text-align: center;">
                    <%# (int)Eval("Amount") * (int)Eval("PresentExp") %>
                </td>
                <%}
                   else
                   { %>
                <td  id="tdPrice" runat="server" style="text-align: center;">
                    <asp:Literal ID="LtrPrice" runat="server" Text='<%#Decimal.Round(Convert.ToDecimal(Eval("Price")),2) %>'></asp:Literal>
                </td>
                <td style="text-align: center;">
                    <asp:Literal ID="LtrTruePrice" runat="server" Text='<%#Decimal.Round(Convert.ToDecimal(Eval("TruePrice")),2) %>'></asp:Literal>
                </td>
                <td style="text-align: center;">
                    <asp:Literal ID="LtrTotalMoney" runat="server" Text='<%#Decimal.Round(Convert.ToDecimal((int)Eval("Amount")*(decimal)Eval("TruePrice")),2) %>'></asp:Literal>
                </td>
                <%} %>
                <td style="text-align: center;">
                    <pe:ExtendedLiteral HtmlEncode="false" ID="LtrServiceTerm" runat="server"></pe:ExtendedLiteral>
                </td>
                <td style="text-align: center;">
                    <asp:Label ID="LblItemRemark" runat="server"></asp:Label>
                </td>
            </tr>
        </ItemTemplate>
        <FooterTemplate>
            <%if (m_IsCreditProduct)
              { %>
            <tr>
                <td style="text-align: center;" colspan=''>
                    <asp:Localize ID="Localize38" Text="<%$ Res: Controls_ShowOrderDetail_Localize37 ,合计数量： %>"
                        runat="server" />
                </td>
                <td colspan="2"></td>
                <td style="text-align: center;">
                    <%=m_SumNum.ToString() %>
                </td>
                <td align="right" colspan='<%= IsAdminPage ? 4 : 2 %>'>
                    <asp:Localize ID="Localize39" Text="合计积分" runat="server" />
                </td>
                <td id="tdMarkPrice3" runat="server"></td>
                <td style="text-align: center;">
                    <%=m_TotalPresentExp.ToString()%>
                </td>
                <td></td>
            </tr>
            <%}
              else
              { %>
            <tr class='tdbg'>
                <td align="right" colspan='3' class="ok_tab" >
                    <asp:Localize ID="Localize37" Text="<%$ Res: Controls_ShowOrderDetail_Localize37 ,合计数量： %>"
                        runat="server" />
                </td>
                <td style="text-align: center;">
                    <%=m_SumNum.ToString() %>
                </td>
                <td class="ok_tab" align="right" colspan='3'>
                    <asp:Localize ID="Localize33" Text="<%$ Res: Controls_ShowOrderDetail_Localize33 ,合计金额： %>"
                        runat="server" />
                </td>
                <td align="right">
                    <%=m_SubTotal.ToString("N2")%>
                </td>
                <td id="tdmarkPrice2" runat="server"></td>
                <td id="tdPrice2" runat="server"></td>
            </tr>
            <tr class='tdbg'>
                <td align='left' colspan='4'>
                    <%=m_SumInfo%>
                </td>
                <td id="tdMarkPrice" runat="server"></td>
                <td id="tdPrice" runat="server"></td>
                <td class="ok_tab">
                    <asp:Localize ID="Localize34" Text="<%$ Res: Controls_ShowOrderDetail_Localize34 ,实际金额： %>"
                        runat="server" />
                </td>
                <td align="right">
                    <%=m_TotalMoney.ToString("N2")%>
                </td>
                <td align='left' colspan='2'>
                    <asp:Localize ID="Localize35" Text="<%$ Res: Controls_ShowOrderDetail_Localize35 ,已付款： %>"
                        runat="server" /><%=m_MoneyReceipt%>
                </td>
            </tr>
            <%} %>
            </table>
        </FooterTemplate>
    </asp:Repeater>
</div>
