﻿
jQuery(document).ready(function() {

    //比较栏HTML框架
    var compareBox = "";
    compareBox += '<div id="CompareBox" class="compareBox">';
    compareBox += '    <div id="CompareShowBox" class="hd">';
    compareBox += '        <span class="comClose">&gt;&nbsp;收起</span>';
    compareBox += '        <h3>商品对比</h3>';
    compareBox += '    </div>';
    compareBox += '    <div id="CompareProductList" class="bd">';
    compareBox += '        <ul></ul>';
    compareBox += '        <p><a id="ShowCompare" class="comBtn" title="只比较前4个商品" href="#" target="blank">开始比较</a><a title="清除全部商品" id="ClearAllProduct" class="clearAll" href="#">[清空]</a></p>';
    compareBox += '    </div>';
    compareBox += '</div>';
    compareBox += '<div id="CompareHideBox"></div>';

    if (jQuery("#CompareBox").length == 0) {
        jQuery("body").append(compareBox);
    }


    var compareBoxUpTop = 180; //比较栏顶部距离窗口顶部的初始值
    var speed = 500; //动画运行速度（ms）
    var pageSize = 4; //比较栏一次能显示的商品数
    var pageIndex = 0;
    var productCount = 0;
    var cookieExpires = null; //cookie的有效期:null表示有效期为浏览进程；可填入天数和具体的有效日期
    var cookieDomain = ""; //cookie的域,默认为网站的域名
    var cookiePath = '/'; //cookie的路径,如果发生cookie错误，一般是这里的路径没设置对
    if (document.URL.indexOf('WebApplication') > 0) {
        cookiePath = '/WebApplication/';
    }

    /*获取比较商品cookie*/
    if (jQuery.cookie("compareProducts") != "" && jQuery.cookie("compareProducts") != null) {
        var compareProducts = jQuery.cookie("compareProducts");
        compareProducts = compareProducts.substring(0, compareProducts.length - 1).split(";");
        for (var i = 0; i < compareProducts.length; i++) {
            var compareProduct = eval('(' + compareProducts[i] + ')');
            if (IsExistProduct(compareProduct["ProductID"])) {
                productCount++;
                continue;
            }
            AddProduct(compareProduct["ProductID"], compareProduct["ProductName"], compareProduct["ImgSrc"], compareProduct["Link"]);
        }
    };

    /*添加商品信息到cookie*/
    function AddProductToCookie(productID, productName, imgSrc, link) {
        var compareProducts = "";
        if (jQuery.cookie("compareProducts") != "" && jQuery.cookie("compareProducts") != null) {
            compareProducts = jQuery.cookie("compareProducts");
        }
        var newCompareProduct = '{"ProductID":' + productID + ',"ProductName":"' + productName + '","ImgSrc":"' + imgSrc + '","Link":"' + link + '"};';
        compareProducts += newCompareProduct;
        jQuery.cookie("compareProducts", compareProducts, { path: cookiePath, expires: cookieExpires });
    };

    /*从cookie移除商品*/
    function RemoveProductFromCookie(productID, productName, imgSrc, link) {
        var compareProducts = jQuery.cookie("compareProducts");
        var regxLink = link;
        regxLink = regxLink.replace(".", "\.").replace("/", "\/");
        var regx = new RegExp('\{"ProductID":' + productID + ',[\\s\\S]*?,"Link":"' + regxLink + '"\};');
        if (compareProducts != null) {
            compareProducts = compareProducts.replace(regx, "");
        }
        jQuery.cookie("compareProducts", compareProducts, { path: cookiePath, expires: cookieExpires });
    }

    /*为添加按钮绑定点击事件*/
    jQuery(".addCompare").each(function(index) {
        jQuery(this).click(function() {
			if( jQuery("#CompareProductList li").size()>=4){ alert("最多只能比较4个商品。"); return false; }

            if (IsExistProduct(jQuery(this).prop("value"))) {
                ShowMsg("已经存在该商品！", this);
                return false;
            }
            AddProduct(jQuery(this).prop("value"),
                jQuery(this).attr("name"),
                jQuery(this).attr("imgSrc"),
                jQuery(this).attr("link")
                );
            AddProductToCookie(jQuery(this).prop("value"),
                jQuery(this).attr("name"),
                jQuery(this).attr("imgSrc"),
                jQuery(this).attr("link")
                );
        });
    });


    jQuery("#CompareShowBox .comClose").click(function() {
        jQuery("#CompareBox").hide("fast");
        jQuery("#CompareHideBox").show("fast");
    });

    jQuery("#CompareHideBox").click(function() {
        jQuery(this).hide("fast");
        jQuery("#CompareBox").show("fast");
    });

    jQuery("#ClearAllProduct").click(function() {
        ClearAllProduct();
    });

    function movePrev(event) {
        if (event.target == this) {
            MoveProductList("prev");
        }
    };

    function moveNext(event) {
        if (event.target = this) {
            MoveProductList("next");
        }
    };

    /*滚动比较栏*/
    function MoveProductList(dir) {
        var l = jQuery("#CompareProductList li").length;
        var ts = l - 1;
        var ot = pageIndex;
        switch (dir) {
            case "next":
                pageIndex = (ot >= ts) ? ts : pageIndex + 1;
                break;
            case "prev":
                pageIndex = (pageIndex <= 0) ? 0 : pageIndex - 1;
                break;
            default:
                break;
        }

        var $productItems = jQuery("#CompareProductList li");
        var th = 0;
        for (var i = 0; i < pageIndex; i++) {
            th += $productItems.eq(i).outerHeight(true);
        }

        var p = th * -1;
        jQuery("#CompareProductList ul").animate({
            marginTop: p
        }, 'normal');

        SetControlButton();
    };

    /*设置滚动按钮*/
    function SetControlButton() {
        var ts = jQuery("#CompareProductList li").length - 1;
        if (pageIndex == ts) {
            jQuery("#nextBtn").unbind("click", moveNext);
        }
        else {
            jQuery("#nextBtn").bind("click", moveNext);
        }
        if (pageIndex == 0) {
            jQuery("#prevBtn").unbind("click", movePrev);
        }
        else {
            jQuery("#prevBtn").bind("click", movePrev);
        }
    };

    /*清空比较栏商品*/
    function ClearAllProduct() {
        productCount = 0;
        jQuery.cookie("compareProducts", null, { path: cookiePath });
        jQuery("#ShowProductCount").text("商品总数:0");
        jQuery("#CompareProductList li").remove();
        jQuery("#CompareProductList ul").css("margin-top", "0px");
        jQuery("#CompareProductList").css("height", "");
        jQuery("#nextBtn").unbind("click", moveNext);
        jQuery("#prevBtn").unbind("click", movePrev);
    };

    /*判断是否已存在商品在比较栏中*/
    function IsExistProduct(productID) {
        var isExist = false;
        jQuery("li", "#CompareProductList ul").each(function() {
            if (jQuery(this).attr("id") == productID) {
                isExist = true;
                return false;
            }
        })
        return isExist;
    };

    /*显示信息*/
    function ShowMsg(msg, obj) {
        var position = jQuery(obj).position();
        var msgBox = '<div class="cue">' + msg + '</div>';
        jQuery(msgBox).insertBefore(obj).css({ top: position.top + "px", left: (position.left + jQuery(obj).outerWidth()) + "px" }).oneTime(1000, function() {
            jQuery(this).show("fast", function() {
                jQuery(this).hide("fast", function() {
                    jQuery(this).remove();
                })
            })
        });
    };

    /*添加商品到比较栏*/
    function AddProduct(productID, productName, imgSrc, link) {
        var html = "";
        html += '<li id="' + productID + '">';
        html += '<a value="' + productID + '" class="removeProduct" ></a >';
        //html += '<img src="' + imgSrc + '"  class="thumbnail"/>';
        html += '<a href="' + link + '" title="查看商品详情">' + decodeURI(productName) + '</a>';
        html += '</li>';
        jQuery("#CompareProductList ul").prepend(html);
        jQuery("a.removeProduct").each(function() {
            jQuery(this).click(function() {
                productCount--;
                if (productCount < 0) {
                    productCount = 0;
                }
                jQuery("#ShowProductCount").text("商品总数:" + productCount);
                var $product = jQuery("#" + jQuery(this).prop("value"), "#CompareProductList ul");
                $product.slideUp("fast", function() { $product.remove() });
                if (productCount == 0) {
                    jQuery("#CompareProductList").css("height", "");
                    jQuery("#CompareProductList ul").css("margin-top", "0px");
                }
                var oldProductID = $product.attr("id");
                var oldProductName = jQuery("a", $product).not(".removeProduct").text();
                var oldImgSrc = jQuery("img", $product).attr("src");
                var oldLink = jQuery("a", $product).not(".removeProduct").attr("href");
                RemoveProductFromCookie(oldProductID, oldProductName, oldImgSrc, oldLink);
                SetControlButton();
                if (productCount <= pageSize) {
                    jQuery("#CompareProductList ul").animate({
                        marginTop: 0
                    }, 'normal');
                }
            })
            return false;
        });

        productCount++;
        jQuery("#ShowProductCount").text("商品总数:" + productCount);
        SetControlButton();
        jQuery("#CompareBox").show("normal");
        jQuery("#CompareHideBox").hide("fast");
        checkHeight();
    };

    /*浮动*/
    function Flow() {
        var newUpTop = compareBoxUpTop + jQuery(document).scrollTop();
        if (jQuery.browser.msie) {
            newUpTop = compareBoxUpTop + document.documentElement.scrollTop;
        }
        jQuery("#CompareBox").css("top", newUpTop);
        jQuery("#CompareHideBox").css("top", newUpTop);
    };

    jQuery("#ShowCompare").click(function(event) {		
        if (event.target == this) {
            var idList = new Array();
            var index = 0;
            jQuery("#CompareProductList li").each(function() {
                if (index >= 4) {
                    return false;
                }
                idList.push(jQuery(this).attr("id"));
                index++;
            });
            var location = document.URL;
            var url = '';
            if (location.indexOf('search.aspx') < 0) {
                url = "../Shop/ShowCompare.aspx?IDList=";
            }
            else {
                url = "Shop/ShowCompare.aspx?IDList=";
            }
            this.href = url + idList.join(","); //document.URL.substring(0,document.URL.lastIndexOf('/')+1)+url + idList.join(",");
        }
    }); 

    jQuery(window).everyTime(10, function() {
        Flow(); //checkHeight();
    });

    function checkHeight() {
        if (productCount > pageSize) {
            var h = 0;
            var $productItems = jQuery("#CompareProductList li")
            for (var i = 0; i < pageSize; i++) {
                h += parseInt($productItems.eq(i).outerHeight(true));
            }
            "asa".lastIndexOf
           // jQuery("#CompareProductList").css("height", h.toString() + "px");
        }
    }

    setTimeout(checkHeight, 300);
});