﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="CreditsProductCheckOut.aspx.cs"
    Inherits="PowerEasy.Module.Shop.WebSite.Shop.CreditsProductCheckOut" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
</head>
<body>
    <form id="form1" runat="server">
    <asp:ScriptManager ID="SmgePayment" runat="server" ScriptMode="Inherit">
    </asp:ScriptManager>
    <div id="container">
        <ul id="steps">
            <li id="step1">第1步：我的积分购物车</li>
            <li class="part"></li>
            <li id="step2" class="current">第2步：确认订单信息</li>
            <li class="part"></li>
            <li id="step3">第3步：成功提交订单</li>
        </ul>
        <div class="topInfo clearfix">
            <div class="tips confirm fl">
                请确认以下信息，然后提交订单</div>
        </div>
        <div class="customerInfo">
            <div class="customerInfoItem editInfo" id="customerInfoAddress">
                <div class="hd">
                    <span>收货人信息</span><a onclick="SetItemInfoState(this, 'edit','')" href="javascript:void(0)"
                        class="editSwitch infoEdit">[修改]</a><a href="javascript:void(0)" onclick="SetItemInfoState(this, 'save','SaveAddressInfo')"
                            class="editSwitch infoClose">[关闭]</a>
                </div>
                <div class="bd">
                    <div class="editResult">
                        <strong>已选择：</strong> <span id="LtrAddress">
                            <asp:Literal ID="LtrDefaultAddress" runat="server"></asp:Literal>
                        </span>
                    </div>
                    <div class="editBox">
                        <ul class="editAddressList">
                            <asp:Repeater ID="RptAddress" runat="server">
                                <ItemTemplate>
                                    <li>
                                        <input type="radio" name="address" id="address-<%#Eval(" AddressId") %>" addressid="<%#Eval(" AddressId") %>"
                                            <%#(bool)Eval("IsDefault")?"checked":"" %> /><label for="address-<%#Eval("AddressId") %>"><%#Eval("ConsigneeName")%>，<%#Eval("Province")%>，<%#Eval("City")%>，<%#Eval("Area")%>，<%#Eval("Address")%>，<%#Eval("ZipCode")%>，<%#Eval("Mobile")%>,
                                                <%#Eval("HomePhone")%></label></li>
                                </ItemTemplate>
                            </asp:Repeater>
                            <li>
                                <input type="radio" name="address" id="address-other" addressid="0" /><label for="address-other">使用其他地址</label></li>
                        </ul>
                        <ul id="ULAddressEdit" class="editAddressAdd" style="display: none">
                            <li>
                                <label>
                                    地 址：</label>
                                <p>
                                    <select id="DropProvince" class="select_w" style="visibility: visible;" onchange="GetRegion('getCity',jQuery(this).val());">
                                        <option value="default">---请选择---</option>
                                    </select>
                                    <select id="DropCity" class="select_w" style="visibility: visible;" onchange="GetRegion('getArea',jQuery(this).val());">
                                        <option value="default">---请选择---</option>
                                    </select>
                                    <select id="DropArea" class="select_w" style="visibility: visible;" onchange="GetRegion('getZipCode',jQuery(this).val());">
                                        <option value="default">---请选择---</option>
                                    </select>
                                    <input id="TxtAddress" class="text" type="text" value="" size="60" maxlength="100"
                                        customvalparam='[{Type:"require",ErrMsg:"详细地址不能为空"}]' groupname="ConsigneeAddress" />
                                </p>
                            </li>
                            <li>
                                <label for="TxtZipCode">
                                    邮 编：</label><p>
                                        <input type="text" class="text" id="TxtZipCode" customvalparam='[{Type:"require",ErrMsg:"邮编不能为空"},{Type:"zipcode",ErrMsg:"请输入正确的邮编"}]'
                                            groupname="ConsigneeAddress" /></p>
                            </li>
                            <li>
                                <label for="TxtConsigneeName">
                                    收货人：</label><p>
                                        <input type="text" class="text" id="TxtConsigneeName" customvalparam='[{Type:"require",ErrMsg:"收货人不能为空"}]'
                                            groupname="ConsigneeAddress" /></p>
                            </li>
                            <li>
                                <label for="TxtMobile">
                                    手 机：</label><p>
                                        <input type="text" class="text" id="TxtMobile" customvalparam='[{Type:"relctrl",RelCtrl:"TxtHomePhone"},{Type:"require" ,ErrMsg:"手机号码和固话必填一个"},{Type:"mobile",ErrMsg:"请输入正确的手机号码"}]'
                                            groupname="ConsigneeAddress" /></p>
                            </li>
                            <li>
                                <label for="TxtHomePhone">
                                    电 话：</label><p>
                                        <input type="text" class="text" id="TxtHomePhone" customvalparam='[{Type:"relctrl",RelCtrl:"TxtMobile"},{Type:"require",ErrMsg:"手机号码和固话必填一个"},{Type:"mobile",ErrMsg:"请输入正确的电话号码"}]'
                                            groupname="ConsigneeAddress" /></p>
                            </li>
                            <li>
                                <label for="TxtEmail">
                                    电子邮箱：</label><p>
                                        <input type="text" class="text" id="TxtEmail" customvalparam='[{Type:"require",ErrMsg:"电子邮箱不能为空"},{Type:"email",ErrMsg:"请输入正确的电子邮箱"}]'
                                            groupname="ConsigneeEmail" /></p>
                            </li>
                        </ul>
                        <div class="submit">
                            <button type="button" class="btn btnAddress" onclick="SetItemInfoState(this, 'save','SaveAddressInfo')">
                                确定收货人信息</button>
                            <asp:HiddenField ID="HdnAddressInfo" runat="server" />
                            <asp:HiddenField ID="HdnEmail" runat="server" />
                        </div>
                    </div>
                </div>
            </div>
            <div class="customerInfoItem editInfo" id="customerInfoRemark">
                <div class="hd">
                    <span>其他要求</span><a href="javascript:void(0)" onclick="SetItemInfoState(this, 'edit','')"
                        class="editSwitch infoEdit">[修改]</a><a href="javascript:void(0)" onclick="SetItemInfoState(this, 'close','CancelRemark')"
                            class="editSwitch infoClose">[关闭]</a>
                </div>
                <div class="bd">
                    <div class="editResult">
                        <p id="LtrRemark">
                        </p>
                    </div>
                    <div class="editBox">
                        <div class="edit-remark">
                            <p class="tips">
                                声明：备注中有关收货人信息、支付方式、配送方式、发票信息等购买要求一律以上面的选择为准，备注无效。</p>
                            <div id="DivOther">
                                <ul>
                                    <asp:Repeater ID="RepModel" runat="server" OnItemDataBound="RepModel_OnItemDataBound">
                                        <ItemTemplate>
                                            <li id="Tab" runat="server"><span class="text">
                                                <%# Eval("FieldAlias")%>
                                                ：
                                                <%# Eval("Tips") %></span>
                                                <pe:FieldControl ID="Field" runat="server" EnableNull='<%# (bool)Eval("EnableNull") %>'
                                                    FieldAlias='<%# Eval("FieldAlias")%>' Tips='<%# Eval("Tips") %>' FieldName='<%#Eval("FieldName")%>'
                                                    ControlType='<%# Eval("FieldType") %>' FieldLevel='<%# Eval("FieldLevel") %>'
                                                    ModelId='<%# Eval("ModelId") %>' Description='<%# Eval("Description")%>' Settings='<%# ((PowerEasy.Module.General.Model.CommonModel.FieldInfo)Container.DataItem).Settings %>'
                                                    Value='<%# Eval("DefaultValue") %>' IsAdminManage="false">
                                                </pe:FieldControl>
                                            </li>
                                        </ItemTemplate>
                                    </asp:Repeater>
                                </ul>
                            </div>
                        </div>
                        <div class="submit">
                            <button type="button" class="btn btn-remark" onclick="SetItemInfoState(this, 'save','SaveRemark')">
                                确定支付方式</button>
                            <asp:HiddenField ID="HdnRemark" runat="server" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <script type="text/javascript">
            function hideNoPhysical() {
                if (!GiftCart.hasPhysical()) {
                    jQuery(".customerInfo").hide();
                }
            }
            hideNoPhysical();
        </script>
        <div class="orderinfoListbox">
            <h4>
                <span>商品清单：</span><a id="goBackList" href="CreditsProductList.aspx">返回积分商品列表页</a>
            </h4>
            <div class="orderinfoList">
                <table cellspacing="0" id="shoppingCartList">
                    <tr class="title">
                        <td style="width: 55%">
                            商品名称
                        </td>
                        <td style="width: 5%">
                            积分
                        </td>
                        <td style="width: 10%">
                            数量
                        </td>
                        <td style="width: 5%;">
                            小计
                        </td>
                        <td style="width: 5%;">
                            操作
                        </td>
                    </tr>
                </table>
            </div>
        </div>
        <div class="orderinfoSend">
            <p class="sty3">
                请核对以上信息，点击“提交订单”<asp:Button ID="btnSubmitOrder" runat="server" OnClick="btnSubmitOrder_Click"
                    Text="提交订单" OnClientClick="if(!validator(this)) return false;" /></p>
        </div>
    </div>
    <asp:HiddenField ID="HdnIDList" runat="server" />
    <asp:HiddenField ID="HdnQuantityList" runat="server" />

    <script type="text/javascript" language="javascript">
        //模板中要导入bi.js 才能访问 GiftCart对象
        jQuery(function () {
            var arr = GiftCart.gifts();
            for (var i = 0; i<arr.length; i++) {
                addProductToShoppingCart(arr[i].id, unescape(arr[i].giftName), arr[i].point, arr[i].qty,arr[i].pic)
            }
            jQuery("#shoppingCartList").append('<tr class="total"><td colspan="2">总计</td><td id="allCount">' + GiftCart.count() + '</td><td id="allTotalPoint">' + GiftCart.point() + '</td><td></td>');
        });

        function addProductToShoppingCart(productId, productName, productCredit, productQuantity,pic) {
            var shoppingCartItem = '<tr id="' + productId + '" class="shoppingCartItem">';
            shoppingCartItem += '     <td class="productName">';
            shoppingCartItem += '      <div class="itemPic"><a href="CreditsProductItem.aspx?id='+productId+'"><img src="'+pic+'" /></a></div>';
            shoppingCartItem += '        <a href="CreditsProductItem.aspx?id='+productId+'">' + productName + '</a></td>';
            shoppingCartItem += '     <td class="productCredit">' + productCredit + '</td>';
            shoppingCartItem += '     <td class="productQuantity">';
            shoppingCartItem += '       <a class="reduce" onclick="setAmount(' + productId + ',false)" href="javascript:void(0)">-</a>';
            shoppingCartItem += '         <input class="txtNum" onblur="changeAmount('+ productId +',this)" type="text" size="2" maxlength="6" value="' + productQuantity + '" />';
            shoppingCartItem += '       <a class="add" onclick="setAmount(' + productId + ',true)" href="javascript:void(0)">+</a>';
            shoppingCartItem += '     </td>';
            shoppingCartItem += '     <td class="productTotalCredit">' + (productCredit * productQuantity) + '</td>';
            shoppingCartItem += '     <td class="op"><a href="javascript:;" onclick="remove(' + productId + ')">删除</a> </td>';
            shoppingCartItem += '   </tr>';
            jQuery("#shoppingCartList").append(shoppingCartItem);
        }

        var userCredits = <%=m_Credits %>;

        //购买数量，加减按钮
        function setAmount(giftId, isAdd) {
            var obj = isAdd ? GiftCart.addAmount(giftId) : GiftCart.reduceAmount(giftId);
            if(isAdd && (userCredits < GiftCart.point())){
                GiftCart.reduceAmount(giftId);
                jQuery.pe.pealert("您的积分不足！");
                return;
            }
            if (obj) {
                jQuery("#shoppingCartList #" + giftId + " .productQuantity .txtNum").val(obj.qty);
                jQuery("#shoppingCartList #" + giftId + " .productTotalCredit").html(obj.point * obj.qty);
                jQuery("#shoppingCartList #allTotalPoint").html(GiftCart.point());
                jQuery("#allCount").html(GiftCart.count());
            }
        }

        function changeAmount(giftId , e){            
            var amount = parseInt(jQuery(e).val()) || 1;
            var obj = GiftCart.getGiftById(giftId);
            if(obj){
                if(userCredits < obj.point * amount){
                    jQuery.pe.pealert("您的积分不足！");
                    jQuery(e).val(obj.qty);
                    return;
                }else{
                   GiftCart.remove(giftId);
                   GiftCart.addGift(giftId,obj.giftName,obj.point,obj.character,amount,obj.pic);
                   jQuery(e).val(amount);
                   jQuery("#shoppingCartList #" + giftId + " .productTotalCredit").html(obj.point * amount);
                   jQuery("#shoppingCartList #allTotalPoint").html(GiftCart.point());
                   jQuery("#allCount").html(GiftCart.count());
                }
            }            
        }


        function remove(giftId) {
            GiftCart.remove(giftId);
            jQuery("#shoppingCartList #" + giftId).remove();
            jQuery("#shoppingCartList #allTotalPoint").html(GiftCart.point());
            jQuery("#allCount").html(GiftCart.count());
            hideNoPhysical();
        }

        function validator(obj) {
            Page_IsValid=true;
            if(GiftCart.hasPhysical()){
                var errMsg = "";
                if (jQuery("#customerInfoAddress").hasClass("editInfo")) {errMsg += "请确认收货信息<br />"; }
                else if (!SaveAddressInfo()) { errMsg += "请填写正确的收货信息<br />"; }
                if (errMsg != "") {
                    jQuery.pe.pealert(errMsg);
                    Page_IsValid = false;
                    return Page_IsValid;
                }
            }
            if(Page_IsValid){
                var idList = "";
                var quantityList = "";
                jQuery(".shoppingCartItem", "#shoppingCartList").each(function(index) {
                    if (index > 0) {
                        idList += ",";
                        quantityList += ",";
                    }
                    idList += jQuery(this).attr("id");
                    quantityList += jQuery(this).find(".productQuantity .txtNum").val();
                });

                jQuery("#HdnIDList").val(idList);
                jQuery("#HdnQuantityList").val(quantityList);
                //GiftCart.clear();
            }
            return Page_IsValid;    
        }
    </script>
    </form>
</body>
</html>
