﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="FastRegister.aspx.cs" Inherits="PowerEasy.Module.Shop.WebSite.Shop.FastRegister"
    Async="true" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>
        <asp:Localize ID="Localize10" Text="<%$ Res: Shop_FastRegister_Page,快速注册 %>" runat="server" />
    </title>
</head>
<body>
    <form id="form1" runat="server">
    <div id="bizideaLoginBox" class="userFormIn">
        <div class="hd">
            <asp:Localize ID="Localize9" Text="<%$ Res: Shop_FastRegister_Localize9,用户登录 %>"
                runat="server" /></div>
        <div class="bd">
            <table id="Table2">
                <tr>
                    <td class="tdbgleft" style="width:25%">
                        <asp:Localize ID="Localize1" Text="<%$ Res: Shop_FastRegister_Localize1,用户名： %>"
                            runat="server"></asp:Localize>
                    </td>
                    <td style="width:75%">
                        <asp:TextBox ID="TxtUserName" MaxLength="50" runat="server" ValidationGroup="valsLogin" CssClass="inp"></asp:TextBox>
                        <pe:RequiredFieldValidator ID="RegLogOnUserName" runat="server" ControlToValidate="TxtUserName"
                            ValidationGroup="valsLogin" SetFocusOnError="false" ErrorMessage="<%$ Res: Shop_FastRegister_RegLogOnUserName_ErrorMessage,用户名不能为空 %>"
                            Display="Dynamic"></pe:RequiredFieldValidator>
                    </td>
                </tr>
                <tr>
                    <td class="tdbgleft">
                        <asp:Localize ID="Localize2" Text="<%$ Res: Shop_FastRegister_Localize2 , 密 码： %>"
                            runat="server" />
                    </td>
                    <td>
                    <%-- 取消Type=Password，利用JS在页面加载完毕后修改 --%>
                        <asp:TextBox ID="TxtPassword" runat="server" ValidationGroup="valsLogin" CssClass="inp" AutoComplete="off"></asp:TextBox>
                        <pe:RequiredFieldValidator ID="RegLogOnPassword" runat="server" ValidationGroup="valsLogin"
                            ControlToValidate="TxtPassword" SetFocusOnError="false" ErrorMessage="<%$ Res: Shop_FastRegister_RegLogOnPassword_ErrorMessage , 密码不能为空 %>"
                            Display="Dynamic"></pe:RequiredFieldValidator>
                    </td>
                </tr>
                <asp:PlaceHolder ID="PhValCode" runat="server">
                    <tr>
                    <td class="tdbgleft">
                            <asp:Localize ID="Localize3" Text="<%$ Res: Shop_FastRegister_Localize3 , 验证码： %>"
                                runat="server" />
                        </td>
                        <td>
                            <asp:TextBox ID="TxtValidateCode" MaxLength="6" Width="60" runat="server" onfocus="this.select();"
                                ValidationGroup="valsLogin" CssClass="inp"></asp:TextBox>
                            <pe:ValidateCode ImageAlign="AbsMiddle" ID="VcodeLogOn" runat="server" RefreshLinkToolTip="<%$ Res: Shop_FastRegister_AbsMiddle , 看不清楚，换一个 %>" />&nbsp;<pe:RequiredFieldValidator
                                ID="RequiredFieldValidator2" runat="server" ValidationGroup="valsLogin" ControlToValidate="TxtValidateCode"
                                SetFocusOnError="false" ErrorMessage="<%$ Res: Shop_FastRegister_RegLogOnPassword_ErrorValidateCode , 验证码不能为空 %>"
                                Display="Dynamic"  ></pe:RequiredFieldValidator>
                        </td>
                    </tr>
                </asp:PlaceHolder>

					<tr>
						<td colspan="2" class="tdCookie" >
                        <asp:CheckBox ID="ChkCookieMonth" runat="server" />
						<label for="ChkCookieMonth">保留一个月</label>
					</td>

					</tr>
                <tr>
                    <td class="tdbgleft">
                    </td>
                    <td>
                        <asp:Button ID="BtnLogOn" CssClass="btn" runat="server" Text="<%$ Res: Shop_FastRegister_BtnLogOn , 登录 %>"
                            ValidationGroup="valsLogin" OnClick="BtnLogOn_Click"  OnClientClick="return BeginClick(1);"/>
                    </td>
                </tr>
            </table>
        </div>
    </div>
    <div id="regBox" class="userFormIn">
        <div class="hd">
            <asp:Localize ID="Localize4" Text="<%$ Res: Shop_FastRegister_Localize4 , 快速注册 %>"
                runat="server" /></div>
        <div class="bd">
            <table id="TableRegisterMust" runat="server"  >
                <tr>
					<td class="tdbgleft" style="width:25%">
                        <asp:Localize ID="Localize5" Text="<%$ Res: Shop_FastRegister_Localize5 , 用户名： %>"
                            runat="server" />
                    </td>
                    <td valign="middle"  style="width:75%">
                        <asp:TextBox ID="TxtRegUserName" runat="server" MaxLength="50" ValidationGroup="valsRegister" CssClass="inp"></asp:TextBox>
                        <pe:RequiredFieldValidator ID="ReqTxtUserName" runat="server" ControlToValidate="TxtRegUserName" Display="Dynamic"
                            ValidationGroup="valsRegister" ErrorMessage="<%$ Res: Shop_FastRegister_ReqTxtUserName_ErrorMessage , 用户名不能为空 %>"
                            RequiredText=""></pe:RequiredFieldValidator>
                        <asp:RegularExpressionValidator ID="ValgTextMaxLength" ControlToValidate="TxtRegUserName"
                            ValidationGroup="valsRegister" runat="server"></asp:RegularExpressionValidator>
					 <p class="tips">
                        <asp:Label ID="LblRegTitle" runat="server"></asp:Label></p>
                    </td>
                </tr>
                <tr>
                    <td class="tdbgleft">
                        <asp:Localize ID="Localize6" Text="<%$ Res: Shop_FastRegister_Localize6 , 密 码： %>"
                            runat="server" />
                    </td>
                    <td>
                    <%-- 取消Type=Password，利用JS在页面加载完毕后修改 --%>
                        <asp:TextBox ID="TxtRegPassword" runat="server" MaxLength="20" AutoComplete="off"
                            ValidationGroup="valsRegister"  CssClass="inp"></asp:TextBox><pe:RequiredFieldValidator ID="ReqTxtPassword"
                                runat="server" Display="Dynamic" ControlToValidate="TxtRegPassword" ValidationGroup="valsRegister"
                                SetFocusOnError="false" ErrorMessage="<%$ Res: Shop_FastRegister_ReqTxtPassword_ErrorMessage , 密码不能为空 %>"></pe:RequiredFieldValidator>
                        <asp:RegularExpressionValidator ID="RegularExpressionValidatorPassword" runat="server"
                            ValidationGroup="valsRegister" ControlToValidate="TxtRegPassword" SetFocusOnError="false"
                            ValidationExpression="[\S]{6,}" ErrorMessage="<%$ Res: Shop_FastRegister_RegularExpressionValidatorPassword_ErrorMessage , 密码至少6位 %>"
                            Display="Dynamic"></asp:RegularExpressionValidator>
                    </td>
                </tr>
                <tr>
                    <td class="tdbgleft">
                        <asp:Localize ID="Localize7" Text="<%$ Res: Shop_FastRegister_Localize7 , 确认密码： %>"
                            runat="server" />
                    </td>
                    <td>
                    <%-- 取消Type=Password，利用JS在页面加载完毕后修改 --%>
                        <asp:TextBox ID="TxtPwdConfirm" runat="server" MaxLength="20" CssClass="inp" AutoComplete="off"></asp:TextBox><pe:RequiredFieldValidator
                            ID="ReqTxtPwdConfirm" runat="server" ControlToValidate="TxtPwdConfirm" ValidationGroup="valsRegister"
                            SetFocusOnError="false" ErrorMessage="<%$ Res: Shop_FastRegister_ReqTxtPwdConfirm_ErrorMessage , 确认密码不能为空 %>"
                            Display="Dynamic"></pe:RequiredFieldValidator><asp:CompareValidator ID="ValCompPassword"
                                runat="server" Display="Dynamic" ControlToValidate="TxtPwdConfirm" ValidationGroup="valsRegister"
                                ControlToCompare="TxtRegPassword" Operator="Equal" SetFocusOnError="false" ErrorMessage="<%$ Res: Shop_FastRegister_ValCompPassword_ErrorMessage , 两次密码输入不一致 %>"></asp:CompareValidator>
                    </td>
                </tr>
                <tr id="trEmail" runat="server">
                    <td class="tdbgleft">
                        <asp:Localize ID="Localize8" Text="<%$ Res: Shop_FastRegister_Localize8 , Email地址： %>"
                            runat="server" />
                    </td>
                    <td>
                        <asp:TextBox ID="TxtEmail" runat="server" MaxLength="50" CssClass="inp"></asp:TextBox><pe:RequiredFieldValidator
                            ID="ReqTxtEmail" runat="server" ValidationGroup="valsRegister" ControlToValidate="TxtEmail"
                            Display="Dynamic" SetFocusOnError="false" ErrorMessage="<%$ Res: Shop_FastRegister_ReqTxtEmail_ErrorMessage , Email不能为空 %>"></pe:RequiredFieldValidator>
                        <pe:RegexValidator ValidateType="Email" ID="ValeTxtEmail" runat="server" ControlToValidate="TxtEmail"
                            ValidationGroup="valsRegister" Display="Dynamic" ErrorMessage="<%$ Res: Shop_FastRegister_ValeTxtEmail_ErrorMessage , 请输入正确的Email %>"
                            SetFocusOnError="false"></pe:RegexValidator>
                    </td>
                </tr>
                <tr id="PhRegisterValCode" runat="server" visible="false">
                    <td class="tdbgleft">
                        <asp:Localize ID="Localize11" Text="<%$ Res: Shop_FastRegister_Localize3 , 验证码： %>"
                            runat="server" />
                    </td>
                    <td>
                        <asp:TextBox ID="TxtRegisterValidateCode" MaxLength="6" Width="60" runat="server" onfocus="this.select();"
                            ValidationGroup="valsRegister" CssClass="inp"></asp:TextBox>
                        <img id="ImgUserRegValidateCode" title="看不清楚，换一个" onclick=" RefreshUserRegValidateCodeImage(this); "
                            src="../Controls/ValidateCodeImage3.aspx" align="absmiddle" style="border-width: 0px; cursor: hand;" />
                        <script type="text/javascript" language="JavaScript">
                            function RefreshUserRegValidateCodeImage(valdisplayDateCodeImageControl) {
                                valdisplayDateCodeImageControl.src = valdisplayDateCodeImageControl.src + '?code=' + RandomNum2(10);
                            }

                            function RandomNum2(n) {
                                var rnd = '';
                                for (var i = 0; i < n; i++)
                                    rnd += Math.floor(Math.random() * 10);
                                return rnd;
                            }
                        </script>
                        &nbsp;<pe:RequiredFieldValidator
                            ID="RequiredFieldValidator1" runat="server" ValidationGroup="valsRegister" ControlToValidate="TxtRegisterValidateCode"
                            SetFocusOnError="false" ErrorMessage="<%$ Res: Shop_FastRegister_RegLogOnPassword_ErrorValidateCode , 验证码不能为空 %>"
                            Display="Dynamic"></pe:RequiredFieldValidator>
                    </td>
                </tr>
                <tr>
                    <td class="tdbgleft">
                    </td>
                    <td>
                        <asp:Button ID="BtnRegister" ValidationGroup="valsRegister" runat="server" Text="<%$ Res: Shop_FastRegister_BtnRegister , 确定 %>"
                            OnClick="BtnRegister_Click" CssClass="btn" OnClientClick="return BeginClick(2);"/>
                        &nbsp;
                        <asp:Button ID="btnUnRegisterBuy" runat="server" Text="<%$ Res: Shop_FastRegister_btnUnRegisterBuy , 不注册直接购买 %>"
                            OnClick="BtnunRegisterBuy_Click" CssClass="btn"  ValidationGroup="UnregisterBuy" OnClientClick="return BeginClick(3);"/>
                    </td>
                </tr>
            </table>
        </div>
    </div>
        
    <script type="text/javascript" src="../JS/Encrypt/BigInt.js"></script>
    <script type="text/javascript" src="../JS/Encrypt/Encrypt.js"></script>
    <script type="text/javascript" src="../JS/Encrypt/Barrett.js"></script>
    <script type="text/javascript" src="../JS/Encrypt/Common.js"></script>
    <script type="text/javascript">
        $(function () {
            var $userpass = $("#TxtPassword")[0];
            try {
                $userpass.type = 'password';
            } catch (e) {
                $userpass.outerHTML = $userpass.outerHTML.replace('type=text', '').replace('>', ' type="password">');
            }
            var $userregpass = $("#TxtRegPassword")[0];
            try {
                $userregpass.type = 'password';
            } catch (e) {
                $userregpass.outerHTML = $userregpass.outerHTML.replace('type=text', '').replace('>', ' type="password">');
            }
            var $userconpass = $("#TxtPwdConfirm")[0];
            try {
                $userconpass.type = 'password';
            } catch (e) {
                $userconpass.outerHTML = $userconpass.outerHTML.replace('type=text', '').replace('>', ' type="password">');
            }
        });
        var BeginClick = function (a) {
            var thisValidationGroup = "valsLogin";
            if (a == 2) {
                thisValidationGroup = "valsRegister";
            }
            else if (a == 3) {
                thisValidationGroup = "UnregisterBuy";
            }
            if (Page_ClientValidate(thisValidationGroup)) {
                GetRsaEncrypt(1);
                $("#TxtPassword").val(rsaEncrypt($("#TxtPassword").val()));
                $("#TxtRegPassword").val(rsaEncrypt($("#TxtRegPassword").val()));
                $("#TxtRegPassword").attr("maxlength", "300");
                $("#TxtPwdConfirm").val(rsaEncrypt($("#TxtPwdConfirm").val()));
                $("#TxtPwdConfirm").attr("maxlength", "300");
                return true;
            } else {
                return false;
            }
        }
    </script>
    </form>
</body>
</html>
