﻿<%@ Page Language="C#" AutoEventWireup="true" Codebehind="Payment.aspx.cs" ValidateRequest="false" Inherits="PowerEasy.Module.Shop.WebSite.Shop.Payment"  EnableEventValidation="false"%>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title><asp:Localize ID="Localize10" Text="<%$ Res: Shop_Payment_Page,收银台 %>" runat="server" /></title>
</head>
<body>
    <form id="form1" runat="server">
        <asp:ScriptManager ID="SmgePayment" runat="server" ScriptMode="Inherit"></asp:ScriptManager>
            <table class="border" cellspacing="1">
                <tr class="title">
                    <td colspan="2"><strong><asp:Localize ID="Localize1" Text="<%$ Res: Shop_Payment_Localize1,收 银 台 %>" runat="server" /></strong></td>
                </tr>
                <tr class="tdbg" runat="server" id="trAlipayLogin" visible="false">
                    <td colspan="2" style="height:70px;">
                        如果您是支付宝用户，请选择一站式购物，可免填写付款/收货人信息，赚取更多积分 <asp:ImageButton ID="btnAlipayLogins" ValidationGroup="AlipayLogin" ImageUrl="../Images/Alipay_UserShare.jpg" runat="server" OnClick="btnAlipayLogin_Click"/>    
                    </td>
                </tr>
                
                <tr class="tdbg">
                    <td style="width: 25%" valign="top">
                       <asp:Localize ID="Localize2" Text="<%$ Res: Shop_Payment_Localize2,收货人姓名： %>" runat="server" />
                    </td>
                    <td align="left">
                        <asp:TextBox ID="TxtContacterName" runat="server"></asp:TextBox>
                        <pe:RequiredFieldValidator ID="ValrContacterName" ControlToValidate="TxtContacterName"
                            runat="server" SetFocusOnError="true" Display="dynamic" ErrorMessage="<%$ Res: Shop_Payment_ValrContacterName_ErrorMessage,请输入收货人姓名！ %>"></pe:RequiredFieldValidator></td>
                </tr>
                <tr class="tdbg">
                    <td valign="top">
                       <asp:Localize ID="Localize3" Text="<%$ Res: Shop_Payment_Localize3,收货人地址： %>" runat="server" />
                    </td>
                    <td>
                        <pe:Overlay ID="FdAddress" runat="server" Height="450" ButtonText="<%$ Res: Shop_Payment_FdAddress_Name,选择已有的收货人地址 %>"
                            Title="<%$ Res: Shop_Payment_FdAddress_Title,收货人地址 %>" Width="600" ButtonTextBeginToken="【" ButtonTextEndToken="】" ButtonType="Link" />
                        
                        <pe:AddressPicker ID="AddressPick" runat="server" />
                    </td>
                </tr>
                <tr class="tdbg">
                    <td style="width: 25%" valign="top">
                        <asp:Localize ID="Localize4" Text="<%$ Res: Shop_Payment_Localize4,收货人邮编： %>" runat="server" />
                    </td>
                    <td align="left">
                        <asp:UpdatePanel ID="UpnlZipCode" runat="server" UpdateMode="Conditional">
                            <ContentTemplate>
                              <asp:TextBox ID="TxtZipCode" runat="server"></asp:TextBox>
                        <pe:RegexValidator ValidateType="ZipCode" ID="VzipZipCode" ControlToValidate="TxtZipCode" Display="dynamic" SetFocusOnError="true" runat="server"></pe:RegexValidator>
                        <pe:RequiredFieldValidator ID="ValrZipCode" ShowRequiredText="false"  ControlToValidate="TxtZipCode" runat="server"
                            SetFocusOnError="true" Display="Dynamic" ErrorMessage="<%$ Res: Shop_Payment_ValrZipCode_ErrorMessage,请输入收货人邮编！ %>"></pe:RequiredFieldValidator>
                            </ContentTemplate>
                            <Triggers>
                                <asp:AsyncPostBackTrigger ControlID="AddressPick" EventName="AddressChanged" />
                            </Triggers>
                        </asp:UpdatePanel>
                    </td>
                </tr>
                <tr class="tdbg">
                    <td style="width: 25%" valign="top">
                        <asp:Localize ID="Localize5" Text="<%$ Res: Shop_Payment_Localize5,收货人电话： %>" runat="server" />
                    </td>
                    <td align="left">
                        <asp:TextBox ID="TxtPhone" runat="server"></asp:TextBox>  
                        <pe:RegexValidator ValidateType="Mobile" ID="VtelPhone" ControlToValidate="TxtPhone" SetFocusOnError="true" Display="dynamic" ErrorMessage="<%$ Res: Shop_Payment_VtelPhone_ErrorMessage,收货人电话格式不正确 %>" runat="server"></pe:RegexValidator>
                        <asp:CustomValidator ID="ValxPhone" ClientValidationFunction="ValxPhone_ClientValidate" Display="dynamic" ValidateEmptyText="true" SetFocusOnError="true" runat="server" ErrorMessage="<%$ Res: Shop_Payment_ValxPhone_ErrorMessage,至少要输入收货人电话和收货人手机中的一个 %>" OnServerValidate="ValxPhone_ServerValidate" ControlToValidate="TxtPhone"></asp:CustomValidator>
                    </td>
                </tr>
                <tr class="tdbg">
                    <td style="width: 25%" valign="top">
                       <asp:Localize ID="Localize6" Text="<%$ Res: Shop_Payment_Localize6,收货人邮箱： %>" runat="server" />
                    </td>
                    <td align="left">
                        <asp:TextBox ID="TxtEmail" runat="server"></asp:TextBox>
                        <pe:RequiredFieldValidator ID="ValfEmail" ControlToValidate="TxtEmail" runat="server"
                            SetFocusOnError="true" Display="dynamic" ErrorMessage="<%$ Res: Shop_Payment_ValfEmail_ErrorMessage,请输入收货人邮箱！ %>"></pe:RequiredFieldValidator><pe:RegexValidator ValidateType="Email"
                                ID="VmailEmail" Display="dynamic" SetFocusOnError="true" ControlToValidate="TxtEmail"
                                runat="server"></pe:RegexValidator></td>
                </tr>
                <tr class="tdbg">
                    <td style="width: 25%" valign="top">
                       <asp:Localize ID="Localize7" Text="<%$ Res: Shop_Payment_Localize7,收货人手机： %>" runat="server" />
                    </td>
                    <td align="left">
                        <asp:TextBox ID="TxtMobile" runat="server"></asp:TextBox>
                        <pe:RegexValidator ValidateType="Mobile" ID="VmblMobile" ControlToValidate="TxtMobile" Display="dynamic" SetFocusOnError="true" ErrorMessage="<%$ Res: Shop_Payment_VmblMobile_ErrorMessage,收货人手机格式不正确 %>" runat="server"></pe:RegexValidator>
                    </td>
                </tr>
                <tr class="tdbg">
                    <td style="width: 25%" valign="top">
                      <asp:Localize ID="Localize8" Text="<%$ Res: Shop_Payment_Localize8,代理商： %>" runat="server" />
                    </td>
                    <td align="left">
                        <pe:SelectAgent ID="SelectAgent1" IsAdminDir="false" runat="server" />
                    </td>
                </tr>
                <tr class="tdbg">
                    <td style="width: 25%" valign="top">
                       <asp:Localize ID="Localize9" Text="<%$ Res: Shop_Payment_Localize9,送货方式： %>" runat="server" />
                    </td>
                    <td align="left">
                        <asp:UpdatePanel ID="UpnlDeliverType" UpdateMode="Conditional" runat="server">
                            <ContentTemplate>
                                <asp:DropDownList ID="DropDeliverType" DataTextField="TypeName" AutoPostBack="true"
                                    DataValueField="TypeId" runat="server" OnSelectedIndexChanged="DropDeliverType_SelectedIndexChanged">
                                </asp:DropDownList><br />
                                <asp:Label ID="LblDeliverTypeIntro" runat="server"></asp:Label>
                            </ContentTemplate>
                        </asp:UpdatePanel>
                    </td>
                </tr>
                <tr class="tdbg">
                    <td valign="top">
                      <asp:Localize ID="Localize12" Text="<%$ Res: Shop_Payment_Localize12,付款方式： %>" runat="server" />
                    </td>
                    <td>
                        <asp:UpdatePanel ID="UpnlPaymentType" UpdateMode="Conditional" runat="server">
                            <ContentTemplate>
                                <table width="95%" class="border" border="0" cellspacing="1" cellpadding="0">
                                    <tr class="tdbg">
                                        <td>
                                            <asp:DropDownList ID="DropPaymentType" DataTextField="TypeName" DataValueField="TypeId" AutoPostBack="true" OnSelectedIndexChanged="DropPaymentType_SelectedIndexChanged" runat="server"></asp:DropDownList>
                                        </td>
                                    </tr>
                                    <tr class="tdbg">
                                        <td>
                                            <asp:RadioButtonList ID="RadlPayPlatform" Visible="false" DataTextField="PayPlatformName"
                                                DataValueField="PayPlatformId" runat="server">
                                            </asp:RadioButtonList>
                                        </td>
                                    </tr>
                                    <tr class="tdbg">
                                        <td>
                                            <asp:Label ID="LblPaymentTypeIntro" runat="server"></asp:Label>
                                        </td>
                                    </tr>
                                </table>
                            </ContentTemplate>
                        </asp:UpdatePanel>
                        <asp:RequiredFieldValidator ID="ValfPaymentType" runat="server" ControlToValidate="DropPaymentType"
                            Display="Dynamic" ErrorMessage="<%$ Res: Shop_Payment_ValfPaymentType_ErrorMessage,请选择付款方式 %>"></asp:RequiredFieldValidator></td>
                </tr>
                <tr class="tdbg">
                    <td valign="top">
                        <asp:Localize ID="Localize13" Text="<%$ Res: Shop_Payment_Localize13,发票信息： %>" runat="server" /></td>
                    <td>
                        <asp:TextBox ID="TxtInvoiceContent" Text="<%$ Res: Shop_Payment_TxtInvoiceContent,发票抬头： 
商品名称： 
发票金额： 元 %>" TextMode="MultiLine" Height="50px" runat="server" Width="250px"></asp:TextBox>
                        <asp:CheckBox ID="ChkNeedInvoice" runat="server" Text="<%$ Res: Shop_Payment_ChkNeedInvoice,需要发票 %>" OnCheckedChanged="ChkNeedInvoice_CheckedChanged" AutoPostBack="true"/>
                    </td>
                </tr>
                 <tr class="tdbg">
                      <td colspan="2">
                        <asp:UpdatePanel ID="UpnlOrderOption" runat="server" UpdateMode="Conditional">
                        <ContentTemplate>
                            <table cellpadding="2" cellspacing="1" style="width: 98%; background-color: white;">
                                <asp:Repeater ID="RepModel" runat="server" OnItemDataBound="RepModel_OnItemDataBound">
                                    <ItemTemplate>
                                        <tr id='Tab' runat="server" class='tdbg'>
                                            <td align='left' style="width: 25%;">
                                                <div class="DivWordBreak">
                                                        <%# Eval("FieldAlias")%>
                                                        ：&nbsp;<br />
                                                    <%# Eval("Tips") %>
                                                </div>
                                            </td>
                                            <td class='tdbg' align='left'>
                                                <pe:FieldControl ID="Field" runat="server" EnableNull='<%# (bool)Eval("EnableNull") %>'
                                                    FieldAlias='<%# Eval("FieldAlias")%>' Tips='<%# Eval("Tips") %>' FieldName='<%#Eval("FieldName")%>'
                                                    ControlType='<%# Eval("FieldType") %>' FieldLevel='<%# Eval("FieldLevel") %>' ModelId='<%# Eval("ModelId") %>'
                                                    Description='<%# Eval("Description")%>' Settings='<%# ((PowerEasy.Module.General.Model.CommonModel.FieldInfo)Container.DataItem).Settings %>'
                                                    Value='<%# Eval("DefaultValue") %>' IsAdminManage="false">
                                                </pe:FieldControl>
                                            </td>
                                        </tr>
                                    </ItemTemplate>
                                </asp:Repeater>
                            </table>
                        </ContentTemplate>
                    </asp:UpdatePanel>
                      </td>
                </tr>
            </table>
            <div class="p_center">          
            <asp:Button ID="BtnGotoPreview" runat="server" OnClick="BtnGotoPreview_Click"
                Text="<%$ Res: Shop_Payment_BtnGotoPreview,确认订单&gt;&gt; %>" />&nbsp; 
            <asp:Button ID="BtnReturn" runat="server" OnClick="BtnReturn_Click" CausesValidation="false" Text="<%$ Res: Shop_Payment_BtnReturn,返回上一步 %>" />    
            </div>    
            <pe:ShoppingCart ID="ShoppingCart1" runat="server" />
            <br />     
    <script language="javascript" type="text/javascript">
        function ValxPhone_ClientValidate(s,e)
        {
            var phone = document.getElementById('<%=TxtPhone.ClientID %>').value;
            var mobile = document.getElementById('<%=TxtMobile.ClientID %>').value;
            if(phone == "" && mobile == "")
            {
                e.IsValid = false;
            }
            else
            {
                e.IsValid = true;
            }
        }
    </script>
    </form>
</body>
</html>
