/**
 * User: Jinqn
 * Date: 14-04-08
 * Time: 下午16:34
 * 上传图片对话框逻辑代码,包括tab: 远程图片/上传图片/在线图片/搜索图片
 */

var remoteImage;

window.onload = function () {
    $('#ImgUpload').attr('src', '../../FileUpload.aspx' + "?" + (editor.options.PEParam != undefined ? editor.options.PEParam : "") + "&type=image");
    var showFliesPath = editor.options.PEShowFilesPath;
    if (editor.options.PEShowFilesPath != undefined) {
        $('#ImgUploadShow').attr('src', editor.options.PEShowFilesPath + "?CKEditorFuncNum=101");
    }
    else {
        $('#ImgUploadShow').attr('src', "/user/Accessories/ShowUploadFiles.aspx?CKEditorFuncNum=101");
    }
    initTabs();
    initAlign();
    initButtons();
};

/* 初始化tab标签 */
function initTabs() {
    var tabs = $G('tabhead').children;
    var PEImageUpload = editor.options.PEImageUpload;

    for (var i = 0; i < tabs.length; i++) {
        if (PEImageUpload == 0 && i == 1) {
            tabs[i].style.display = "none";
        }
        domUtils.on(tabs[i], "click", function (e) {
            var target = e.target || e.srcElement;
            setTabFocus(target.getAttribute('data-content-id'));
        });
    }
    setTabFocus('remote');
}

/* 初始化tabbody */
function setTabFocus(id) {
    if (!id) return;
    var i, bodyId, tabs = $G('tabhead').children;
    for (i = 0; i < tabs.length; i++) {
        bodyId = tabs[i].getAttribute('data-content-id');
        if (bodyId == id) {
            domUtils.addClass(tabs[i], 'focus');
            domUtils.addClass($G(bodyId), 'focus');
        } else {
            domUtils.removeClasses(tabs[i], 'focus');
            domUtils.removeClasses($G(bodyId), 'focus');
        }
    }
    switch (id) {
        case 'remote':
            remoteImage = remoteImage || new RemoteImage();
            break;
        case 'upload':
            setAlign(editor.getOpt('imageInsertAlign'));
            break;
        case 'online':
            setAlign(editor.getOpt('imageManagerInsertAlign'));
            break;
    }
}

/* 初始化onok事件 */
function initButtons() {

    dialog.onok = function () {
        var remote = false, list = [], id, tabs = $G('tabhead').children;
        for (var i = 0; i < tabs.length; i++) {
            if (domUtils.hasClass(tabs[i], 'focus')) {
                id = tabs[i].getAttribute('data-content-id');
                break;
            }
        }

        switch (id) {
            case 'remote':
                list = remoteImage.getInsertList();
                break;
            case 'upload':
                list = window.document.getElementById("ImgUpload").contentWindow.GetInsertList();
                if (false != list) {
                }
                else {
                    return false;
                }
                break;
            case 'online':
                break;
        }
        if (list) {
            editor.execCommand('insertimage', list);
            for (i = 0; i < list.length; i++) {
                data = list[i];
                link = data.src;
                try {
                    parent.homeImageAssignment2(link);
                } catch (H) { }
            }

            remote && editor.fireEvent("catchRemoteImage");
        }
    };
}


/* 初始化对其方式的点击事件 */
function initAlign() {
    /* 点击align图标 */
    domUtils.on($G("alignIcon"), 'click', function (e) {
        var target = e.target || e.srcElement;
        if (target.className && target.className.indexOf('-align') != -1) {
            setAlign(target.getAttribute('data-align'));
        }
    });
}

/* 设置对齐方式 */
function setAlign(align) {
    align = align || 'none';
    var aligns = $G("alignIcon").children;
    for (i = 0; i < aligns.length; i++) {
        if (aligns[i].getAttribute('data-align') == align) {
            domUtils.addClass(aligns[i], 'focus');
            $G("align").value = aligns[i].getAttribute('data-align');
        } else {
            domUtils.removeClasses(aligns[i], 'focus');
        }
    }
}
/* 获取对齐方式 */
function getAlign() {
    var align = $G("align").value || 'none';
    return align == 'none' ? '' : align;
}

function setValue(src) {
    remoteImage = remoteImage || new RemoteImage();
    remoteImage.setData(src);
    setTabFocus('remote');
}

/* 在线图片 */
function RemoteImage(target) {
    this.container = utils.isString(target) ? document.getElementById(target) : target;
    this.init();
}
RemoteImage.prototype = {
    init: function () {
        this.initContainer();
        this.initEvents();
    },
    initContainer: function () {
        this.dom = {
            'url': $G('url'),
            'width': $G('width'),
            'height': $G('height'),
            'border': $G('border'),
            'vhSpace': $G('vhSpace'),
            'title': $G('title'),
            'align': $G('align')
        };
        var img = editor.selection.getRange().getClosedNode();
        if (img) {
            this.setImage(img);
        }
    },
    initEvents: function () {
        var _this = this,
            locker = $G('lock');

        /* 改变url */
        domUtils.on($G("url"), 'keyup', updatePreview);
        domUtils.on($G("border"), 'keyup', updatePreview);
        domUtils.on($G("title"), 'keyup', updatePreview);

        domUtils.on($G("width"), 'keyup', function () {
            updatePreview();
            if (locker.checked) {
                var proportion = locker.getAttribute('data-proportion');
                $G('height').value = Math.round(this.value / proportion);
            } else {
                _this.updateLocker();
            }
        });
        domUtils.on($G("height"), 'keyup', function () {
            updatePreview();
            if (locker.checked) {
                var proportion = locker.getAttribute('data-proportion');
                $G('width').value = Math.round(this.value * proportion);
            } else {
                _this.updateLocker();
            }
        });
        domUtils.on($G("lock"), 'change', function () {
            var proportion = parseInt($G("width").value) / parseInt($G("height").value);
            locker.setAttribute('data-proportion', proportion);
        });

        function updatePreview() {
            _this.setPreview();
        }
    },
    updateLocker: function () {
        var width = $G('width').value,
            height = $G('height').value,
            locker = $G('lock');
        if (width && height && width == parseInt(width) && height == parseInt(height)) {
            locker.disabled = false;
            locker.title = '';
        } else {
            locker.checked = false;
            locker.disabled = 'disabled';
            locker.title = lang.remoteLockError;
        }
    },
    setImage: function (img) {
        /* 不是正常的图片 */
        if (!img.tagName || img.tagName.toLowerCase() != 'img' && !img.getAttribute("src") || !img.src) return;

        var wordImgFlag = img.getAttribute("word_img"),
            src = wordImgFlag ? wordImgFlag.replace("&amp;", "&") : (img.getAttribute('_src') || img.getAttribute("src", 2).replace("&amp;", "&")),
            align = editor.queryCommandValue("imageFloat");

        /* 防止onchange事件循环调用 */
        if (src !== $G("url").value) $G("url").value = src;
        if (src) {
            /* 设置表单内容 */
            $G("width").value = img.width || '';
            $G("height").value = img.height || '';
            $G("border").value = img.getAttribute("border") || '0';
            $G("vhSpace").value = img.getAttribute("vspace") || '0';
            $G("title").value = img.title || img.alt || '';
            setAlign(align);
            this.setPreview();
            this.updateLocker();
        }
    },
    setData: function (src) {
        $G('url').value = src;
        this.setPreview();
    },
    getData: function () {
        var data = {};
        for (var k in this.dom) {
            data[k] = this.dom[k].value;
        }
        return data;
    },
    setPreview: function () {
        var url = $G('url').value,
            ow = parseInt($G('width').value, 10) || 0,
            oh = parseInt($G('height').value, 10) || 0,
            border = parseInt($G('border').value, 10) || 0,
            title = $G('title').value,
            preview = $G('preview'),
            width,
            height;
        url = utils.unhtmlForUrl(url);
        title = utils.unhtml(title);

        width = ((!ow || !oh) ? preview.offsetWidth : Math.min(ow, preview.offsetWidth));
        width = width + (border * 2) > preview.offsetWidth ? width : (preview.offsetWidth - (border * 2));
        height = (!ow || !oh) ? '' : width * oh / ow;

        if (url) {
            if (width == 0) {
                width = "";
            }
            preview.innerHTML = '<img src="' + url + '" width="' + width + '" height="' + height + '" border="' + border + 'px solid #000" title="' + title + '" />';
        }
    },
    getInsertList: function () {
        var data = this.getData();
        if (data['url']) {
            return [{
                src: data['url'],
                _src: data['url'],
                width: data['width'] || '',
                height: data['height'] || '',
                border: data['border'] || '',
                floatStyle: data['align'] || '',
                vspace: data['vhSpace'] || '',
                title: data['title'] || '',
                alt: data['title'] || '',
                style: "width:" + data['width'] + "px;height:" + data['height'] + "px;"
            }];
        } else {
            return [];
        }
    }
};
