﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="BuyPoint.aspx.cs" Inherits="PowerEasy.Module.General.WebSite.User.Info.BuyPoint" %>

<%@ Import Namespace="Resources" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
</head>
<body>
    <pe:ExtendedSiteMapPath ID="YourPosition" SiteMapProvider="UserMapProvider" runat="server" />
    <form id="MainForm" runat="server">
    <div class="model_info_one">
        <asp:Localize ID="Localize4" Text="<%$ Res: User_Info_BuyPoint_Localize1,购买 %>" runat="server" /><pe:ShowPointName
            ID="ShowPointName1" runat="server" />
    </div>
    <div class="model_info_content">
        <table width="100%" border="0" cellspacing="1" cellpadding="0" class="table_style">
            <tr class="first" runat="server" id="Point">
                <td class="ok_tab">
                    <asp:Localize ID="Localize1" Text="<%$ Res:Controls_ShowUserInfo_Localize5 , 可用 %>"
                        runat="server" /><pe:ShowPointName ID="ShowPointName2" runat="server" />：
                </td>
                <td>
                    <asp:Label ID="LblPoint" runat="server" Text="" />
                    <pe:ShowPointName ID="ShowPointName3" PointType="PointUnit" runat="server" />
                </td>
            </tr>
            <tr>
                <td class="ok_tab">
                    <asp:Localize ID="Localize2" Text="<%$ Res: User_Info_BuyPoint_Localize2,购买单价： %>"
                        runat="server" />
                </td>
                <td>
                    <asp:Label ID="LblPrice" runat="server"></asp:Label>
                    <asp:Localize ID="Localize6" Text="<%$ Res: User_Info_BuyPoint_Localize6,元 %>" runat="server" />/<pe:ShowPointName
                        ID="ShowPointName5" PointType="PointUnit" runat="server" />
                </td>
            </tr>
            <tr>
                <td class="ok_tab">
                    <asp:Localize ID="Localize7" Text="<%$ Res: User_Info_BuyPoint_Localize7,购买数： %>"
                        runat="server" />
                </td>
                <td>
                    <asp:TextBox ID="TxtPointAmount" CssClass="inputxt" runat="server" MaxLength="6"
                        Width="60px" /><input type="button" class="input_button" runat="server" id="Calculation"
                            value="<%$ Res: User_Info_BuyPoint_Calculation,计算 %>" onclick="account()" />
                    <pe:RequiredFieldValidator ID="ValrTxtPointAmount" ControlToValidate="TxtPointAmount"
                        runat="server" SetFocusOnError="true" Display="Dynamic" ErrorMessage="<%$ Res: User_Info_BuyPoint_ValrTxtPointAmount,请输入购买的数量！ %>" />
                    <asp:RegularExpressionValidator ID="ValeTxtPointAmount" ControlToValidate="TxtPointAmount"
                        ValidationExpression="^[1-9]\d*$" SetFocusOnError="true" Display="dynamic" runat="server"
                        ErrorMessage="<%$ Res: User_Info_BuyPoint_ValeTxtPointAmount,请输入大于0的整数 %>"></asp:RegularExpressionValidator>
                </td>
            </tr>
            <tr>
                <td class="ok_tab">
                    <asp:Localize ID="Localize8" Text="<%$ Res: User_Info_BuyPoint_Localize8,需要支付： %>"
                        runat="server" />
                </td>
                <td>
                    <span id="NeedPay"></span>
                </td>
            </tr>
        </table>
        <div class="ok_bottom">
            <asp:Button ID="BtnSubmit" runat="server" Text="<%$ Res: User_Info_BuyPoint_BtnSubmit,购买 %>"
                OnClick="BtnSubmit_Click" CssClass="submit_button" />
        </div>

        <script language="javascript" type="text/javascript">
                function account() {
                    var LblNeedPay = document.getElementById('NeedPay');
                    var price = document.getElementById('<%=LblPrice.ClientID%>').innerHTML;
                    var amount = document.getElementById('<%=TxtPointAmount.ClientID%>').value;
                    var needPay = price * amount;
                    if (isNaN(needPay) == false) {
                        LblNeedPay.innerHTML = round(needPay, 2) + "<%=DynamicPageResources.User_Info_BuyPoint_JSYuan%>";
                    }
                }
                function round(v, e) {
                    var t = 1;
                    for (; e > 0; t *= 10, e--);
                    for (; e < 0; t /= 10, e);
                    return Math.round(v * t) / t;
                } 
        </script>

    </div>
    </form>
</body>
</html>
