﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="AddressManager.aspx.cs"
    Inherits="PowerEasy.Module.Shop.WebSite.User.Shop.AddressManager" EnableEventValidation="true" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
</head>
<body>
    <pe:ExtendedSiteMapPath ID="YourPosition" SiteMapProvider="UserMapProvider" runat="server" />
    <form id="MainForm" runat="server">
    <div class="model_info_sate mtop10">
        <ul>
            <li id="TabTitle6" class="hover"><span>
                <asp:HyperLink runat="server" ID="LnkShowAll" Text="<%$ Res: User_Shop_AddressManager_Page,收货地址管理 %>" /></span></li>
        </ul>
    </div>
    <div class="model_info_content">
        <pe:MemberExtendedGridView ID="EgvAddress" runat="server" AutoGenerateColumns="False"
            CheckBoxFieldHeaderWidth="3%" DataSourceID="OdsAddress" SerialText="" OnRowDataBound="EgvAddress_RowDataBound"
            Width="100%" DataKeyNames="AddressId" OnRowCommand="EgvAddress_RowCommand" IsHoldState="True">
            <Columns>
                <asp:BoundField DataField="ConsigneeName" HeaderText="<%$ Res: User_Shop_AddressManager_BoundField1,收货人 %>"
                    SortExpression="ConsigneeName">
                    <HeaderStyle Width="10%" />
                </asp:BoundField>
                <asp:TemplateField HeaderText="<%$ Res: User_Shop_AddressManager_TemplateField1,所在地区 %>">
                    <HeaderStyle Width="12%" />
                    <ItemTemplate>
                        <asp:Label ID="LblArea" runat="server"></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="<%$ Res: User_Shop_AddressManager_TemplateField2,街道地址 %>">
                    <ItemStyle HorizontalAlign="Left" />
                    <ItemTemplate>
                        <asp:Label runat="server" ID="LblAddress"></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:BoundField DataField="ZipCode" HeaderText="<%$ Res: User_Shop_AddressManager_BoundField2,邮政编码 %>"
                    SortExpression="ZipCode">
                    <HeaderStyle Width="8%" />
                </asp:BoundField>
                <asp:BoundField DataField="HomePhone" HeaderText="<%$ Res: User_Shop_AddressManager_BoundField3,电话号码 %>">
                    <HeaderStyle Width="13%" />
                </asp:BoundField>
                <asp:BoundField DataField="Mobile" HeaderText="<%$ Res: User_Shop_AddressManager_BoundField4,手机号码 %>">
                    <HeaderStyle Width="13%" />
                </asp:BoundField>
                <asp:TemplateField HeaderText="<%$ Res: User_Shop_AddressManager_TemplateField3,默认 %>"
                    SortExpression="IsDefault">
                    <HeaderStyle Width="4%" />
                    <ItemTemplate>
                        <%# (bool)Eval("IsDefault") ? "√" : ""%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="<%$ Res: User_Shop_AddressManager_TemplateField4,操作 %>">
                    <HeaderStyle Width="15%" />
                    <ItemTemplate>
                        <asp:LinkButton ID="LbtnDefault" runat="server" CausesValidation="False" CommandArgument='<%# Eval("AddressID") %>'
                            CommandName="Default" Enabled='<%#!(bool)Eval("IsDefault") %>' Text="<%$ Res: User_Shop_AddressManager_LbtnDefault,默认 %>"></asp:LinkButton>
                        <asp:LinkButton ID="LbtnModify" runat="server" CausesValidation="False" CommandArgument='<%# Eval("AddressID") %>'
                            CommandName="Modify" Text="<%$ Res: User_Shop_AddressManager_LbtnModify,修改 %>"></asp:LinkButton>
                        <asp:LinkButton ID="LbtnDelete" runat="server" CausesValidation="False" CommandArgument='<%# Eval("AddressID") %>'
                            CommandName="Del" OnClientClick="<%$ Res: User_Shop_AddressManager_LbtnDelete_OnClientClick,return confirm('是否要删除此收货地址？') %>"
                            Text="<%$ Res: User_Shop_AddressManager_LbtnDelete,删除 %>"></asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </pe:MemberExtendedGridView>
        <asp:ObjectDataSource ID="OdsAddress" runat="server" SelectMethod="GetAddressListByUserName"
            TypeName="PowerEasy.Module.General.BusinessLogic.UserManage.Address">
            <SelectParameters>
                <asp:ControlParameter ControlID="HdnUserName" Name="userName" PropertyName="Value"
                    Type="string" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <asp:HiddenField ID="HdnUserName" runat="server" />
    </div>
    <br />
    <asp:Button ID="btnAdd" runat="server" CssClass='submit_button_six' Text="<%$ Res:User_Shop_AddressManager_Add ,添加收货地址 %>"
        OnClick="btnAdd_OnClick" />
    </form>
</body>
</html>
