﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="BrowseManager.aspx.cs"
    Inherits="PowerEasy.Module.Shop.WebSite.User.Shop.BrowseManager" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>
        <asp:Localize ID="LocalizePageTitle" Text="<%$ Res: User_BrowseList_PageTitle,我最近浏览过的商品 %>"
            runat="server" /></title>
</head>
<body>
    <pe:ExtendedSiteMapPath ID="YourPosition" SiteMapProvider="UserMapProvider" runat="server" />
    <form id="MainForm" runat="server">
    <div class="model_info_list">
        <div class="model_info_sate mtop10">
            <ul>
                <li class="hover"><span><a href="###">
                    <asp:Localize ID="Localize4" Text="<%$ Res: User_BrowseList_PageTitle,我最近浏览过的商品 %>"
                        runat="server" /></a></span></li>
            </ul>
        </div>
        <div class="model_info_content">
            <pe:MemberExtendedGridView ID="GdvBrowseList" runat="server" DataKeyNames="ProductId"
                AutoGenerateColumns="False" AllowPaging="false" OnRowDataBound="GdvBrowseList_RowDataBound"
                AutoGenerateCheckBoxColumn="true" SerialText="" CheckBoxFieldHeaderWidth="3%">
                <Columns>
                    <pe:BoundField DataField="ProductID" HeaderStyle-Width="6%" HeaderText="ID" SortExpression="ProductID" />
                    <pe:TemplateField HeaderText="<%$ Res: User_BuyList_ProductImage,商品图片 %>">
                        <ItemStyle HorizontalAlign="center" Width="10%" />
                        <ItemTemplate>
                            <pe:ExtendedImage ID="extendedImage" runat="server" />
                        </ItemTemplate>
                    </pe:TemplateField>
                    <pe:TemplateField HeaderText="<%$ Res: User_BuyList_ProductName,商品名称 %>" SortExpression="ProductName">
                        <ItemStyle HorizontalAlign="Left" Width="50%" />
                        <ItemTemplate>
                            <a target="_blank" href='<%# BasePath + "Item.aspx?id=" +  Eval("ProductId").ToString() %>'>
                                <%# Eval("ProductName") %>
                        </ItemTemplate>
                        <ItemStyle HorizontalAlign="Left" />
                    </pe:TemplateField>
                    <pe:BoundField DataField="Unit" HeaderText="<%$ Res: User_BuyList_ProductUnit,单位 %>"
                        SortExpression="Unit">
                        <HeaderStyle Width="5%" />
                    </pe:BoundField>
                    <pe:TemplateField HeaderText="<%$ Res: User_BuyList_ProductPrice,商品价格 %>" SortExpression="Price">
                        <ItemStyle CssClass="content_right" />
                        <HeaderStyle Width="10%" />
                        <ItemTemplate>
                            <asp:Label ID="LblProductPrice" runat="server"></asp:Label>
                        </ItemTemplate>
                    </pe:TemplateField>
                </Columns>
            </pe:MemberExtendedGridView>
        </div>
    </div>
    <div class="clear">
    </div>
    <div class="model_list_manage">
        <label for="ChkAll" class="checkbox">
        <input id="ChkAll" type="checkbox" /> <asp:Localize ID="Localize3" Text="<%$ Res: User_Contents_Browse_Localize3,选中本页显示的所有项目 %>"
                                runat="server" /></label>
        <asp:Button ID="BtnBatchDelete" runat="server" CssClass="input_button_seven" Text="<%$ Res:User_Contents_Browse_BtnBatchDelete,删除选中的浏览 %>"
            OnClick="BtnBatchDelete_Click" OnClientClick='return confirm("是否删除所选定的浏览?")' />
        <asp:Button ID="BtnAddShoppingCart" Width="15%" CssClass="input_button_eight" runat="server"
            Text="<%$ Res: User_Contents_Favorite_BtnAddToShoppingCart,批量添加至购物车 %>" OnClick="BtnAddShoppingCart_Click" />
        <asp:HiddenField ID="HdnUserName" runat="server" />
    </div>
    </form>
</body>
</html>
