﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="BuyList.aspx.cs" Inherits="PowerEasy.Module.Shop.WebSite.User.Shop.BuyList" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>
        <asp:Localize ID="LocalizePageTitle" Text="<%$ Res: User_BuyList_PageTitle,我最近购买的商品 %>"
            runat="server" /></title>
</head>
<body>
    <pe:ExtendedSiteMapPath ID="YourPosition" SiteMapProvider="UserMapProvider" runat="server" />
    <form runat="server" id="MainForm">
    <div class="model_info_list">
        <div class="model_info_sate mtop10">
            <ul>
                <li id="TabTitle6" class="hover"><span>
                    <asp:HyperLink runat="server" ID="LnkShowAll" Text="<%$ Res: User_BuyList_PageTitle,我最近购买的商品 %>" /></span></li>
            </ul>
        </div>
        <div class="model_info_content">
            <pe:MemberExtendedGridView ID="GdvProductList" runat="server" AutoGenerateColumns="False"
                AllowPaging="True" OnRowDataBound="GdvProductList_RowDataBound" DataSourceID="OdsProductList">
                <Columns>
                    <pe:TemplateField HeaderText="<%$ Res: User_BuyList_ProductImage,商品图片 %>">
                        <ItemStyle HorizontalAlign="center" Width="10%" />
                        <ItemTemplate>
                            <pe:ExtendedImage ID="extendedImage" runat="server" />
                        </ItemTemplate>
                    </pe:TemplateField>
                    <pe:TemplateField HeaderText="<%$ Res: User_BuyList_ProductName,商品名称 %>" SortExpression="ProductName">
                        <ItemStyle HorizontalAlign="Left" Width="50%" />
                        <ItemTemplate>
                            <a href='<%# BasePath + "Item.aspx?id=" +  Eval("ProductId").ToString() %>'>
                                <%# Eval("ProductName") %>
                        </ItemTemplate>
                    </pe:TemplateField>
                    <pe:BoundField DataField="Unit" HeaderText="<%$ Res: User_BuyList_ProductUnit,单位 %>"
                        SortExpression="Unit">
                        <HeaderStyle Width="5%" />
                    </pe:BoundField>
                    <pe:TemplateField HeaderText="<%$ Res: User_BuyList_ProductPrice,商品价格 %>" SortExpression="Price">
                        <ItemStyle CssClass="content_right"/>
                        <HeaderStyle Width="10%" />
                        <ItemTemplate>
                            <asp:Label ID="LblProductPrice" runat="server"></asp:Label>
                        </ItemTemplate>
                    </pe:TemplateField>
                </Columns>
            </pe:MemberExtendedGridView>
            <asp:ObjectDataSource ID="OdsProductList" runat="server" SelectMethod="GetOrderItemByUserId"
                TypeName="PowerEasy.Module.Shop.BusinessLogic.Order" EnablePaging="True" MaximumRowsParameterName="maxNumberRows"
                SelectCountMethod="GetTotalOfOrderItem" StartRowIndexParameterName="startRowIndexId">
                <SelectParameters>
                    <asp:ControlParameter ControlID="HdnUserName" DefaultValue="" Name="userName" PropertyName="Value"
                        Type="String" />
                </SelectParameters>
            </asp:ObjectDataSource>
            <asp:HiddenField ID="HdnUserName" runat="server" />
        </div>
    </div>
    </form>
</body>
</html>
