﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="DeliverItemList.aspx.cs"
    Inherits="PowerEasy.Module.Shop.WebSite.User.Shop.DeliverItemList" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title>发退货明细</title>
</head>
<body>
    <pe:ExtendedSiteMapPath ID="YourPosition" SiteMapProvider="UserMapProvider" runat="server" />
    <form id="MainForm" runat="server">
	<div class="hdTitle">
		<h3><strong>发退货明细</strong></h3>
		<div class="fr searchIn">
			<asp:TextBox ID="TxtKeyword" runat="server" value="" ToolTip="快递公司、快递单号、订单编号、用户名、收货人姓名" onfocus="if (this.value!='')this.value=''" />
			<asp:DropDownList ID="DropSearchType" runat="server" AutoPostBack="false">
				<asp:ListItem Text="收货人姓名" Selected="True" Value="2" />
				<asp:ListItem Text="快递公司" Value="4" />
				<asp:ListItem Text="快递单号" Value="5" />
				<asp:ListItem Text="发退货日期" Value="7" />
				<asp:ListItem Text="订单ID" Value="8" />
			</asp:DropDownList>
			<asp:Button runat="server" ID="BtnSearch" Text="查询" UseSubmitBehavior="true"/>
		</div>
	</div>
	<div class="bdCont">
		<div class="memberBoxTab">
			<div class="hd">
				<ul class="hdTab fl">
					<li id="TabTitle0" class="on"><span><a href="DeliverItemList.aspx">所有明细</a></span></li>
					<li id="TabTitle3"><span><a href="DeliverItemList.aspx?ShowType=3">发货记录</a></span></li>
					<li id="TabTitle4"><span><a href="DeliverItemList.aspx?ShowType=4">退货记录</a></span></li>
				</ul>
				<span class="fr orderDate">
					<asp:DropDownList ID="DropOrderType" runat="server" AutoPostBack="true">
						<asp:ListItem Text="最近10天的记录" Selected="True" Value="1" />
						<asp:ListItem Text="最近一个月订单" Value="2" />
						<asp:ListItem Text="全部记录" Value="0" />
					</asp:DropDownList>
				</span>
			</div>
			<div class="bd">
				<pe:MemberExtendedGridView ID="EgvDeliverItem" runat="server" AutoGenerateColumns="False"
					AllowPaging="True" DataSourceID="OdsDeliverItem" CheckBoxFieldHeaderWidth="3%"
					SerialText="" OnRowDataBound="EgvDeliverItem_OnRowDataBound" RowDblclickBoundField="DeliverId"
					RowDblclickUrl="DeliverItemDetail.aspx?DeliverItemID={$Field}">
					<Columns>
						<pe:BoundField DataField="DeliverDate" DataFormatString="{0:yyyy-MM-dd}" HtmlEncode="False"
							HeaderText="日期" SortExpression="DeliverDate">
							<HeaderStyle Width="12%" />
						</pe:BoundField>
						<pe:TemplateField HeaderText="方向">
							<HeaderStyle Width="6%" />
							<ItemTemplate>
								<%# (Int32)Eval("DeliverDirection") == 1 ? "发货" : "<font color=red>退货</font>"%>
							</ItemTemplate>
						</pe:TemplateField>
						<pe:TemplateField HeaderText="收货人姓名">
							<HeaderStyle Width="9%" />
							<ItemTemplate>
								<%# Eval("ContacterName") %>
							</ItemTemplate>
						</pe:TemplateField>
						<pe:TemplateField HeaderText="订单编号">
							<HeaderStyle Width="20%" />
							<ItemTemplate>
								<pe:ExtendedAnchor ID="ExtendedAnchor1" runat="server" href='<%# Eval("OrderId", "ShowOrder.aspx?OrderID={0}") %>'>
									<%# Eval("OrderNum") %>
								</pe:ExtendedAnchor>
							</ItemTemplate>
						</pe:TemplateField>
						<pe:TemplateField HeaderText="快递公司">
							<HeaderStyle Width="10%" />
							<ItemTemplate>
								<asp:Literal ID="LitExpressCompany" runat="server"></asp:Literal>
							</ItemTemplate>
						</pe:TemplateField>
						<pe:BoundField DataField="ExpressNumber" HeaderText="快递单号" SortExpression="ExpressNumber">
							<HeaderStyle Width="12%" />
						</pe:BoundField>
						<pe:TemplateField HeaderText="操作人">
							<HeaderStyle Width="8%" />
							<ItemTemplate>
								<%# Eval("Inputer")%>
							</ItemTemplate>
						</pe:TemplateField>
						<pe:TemplateField HeaderText="经手人">
							<HeaderStyle Width="8%" />
							<ItemTemplate>
								<%# Eval("HandlerName")%>
							</ItemTemplate>
						</pe:TemplateField>
						<pe:TemplateField HeaderText="已签收">
							<HeaderStyle Width="7%" />
							<ItemTemplate>
								<%# (bool)Eval("Received") == false ? "" : "<font color=red>√</font>"%>
							</ItemTemplate>
						</pe:TemplateField>
						<pe:TemplateField HeaderText="操作">
							<ItemTemplate>
								<a href='<%#string.Format("DeliverItemDetail.aspx?DeliverItemID={0}",Eval("DeliverId"))%>'>
									查看</a>
								<pe:ExtendedLinkButton ID="LBtnSignIn" IsChecked="false"
									runat="server" OnClick="LBtnSignIn_Click" Text="签收"></pe:ExtendedLinkButton>
							</ItemTemplate>
						</pe:TemplateField>
					</Columns>
				</pe:MemberExtendedGridView>
			</div>
		</div>
		<asp:HiddenField ID="HdnType" runat="server" Value="0" />
		<asp:ObjectDataSource ID="OdsDeliverItem" runat="server" SelectCountMethod="GetTotalOfDeliverItem"
			SelectMethod="GetList" TypeName="PowerEasy.Module.Shop.BusinessLogic.DeliverItem"
			EnablePaging="True" StartRowIndexParameterName="startRowIndexId" MaximumRowsParameterName="maxNumberRows">
			<SelectParameters>
				<asp:ControlParameter ControlID="DropSearchType" DefaultValue="2" Name="searchType"
					PropertyName="SelectedValue" Type="Int32" />
				<asp:ControlParameter ControlID="TxtKeyword" DefaultValue="" Name="keyword" PropertyName="Text"
					Type="String" />
				<asp:ControlParameter ControlID="DropOrderType" DefaultValue="0" Name="quickSearch"
					PropertyName="SelectedValue" Type="Int32" />
				<asp:QueryStringParameter Name="type" QueryStringField="ShowType" Type="Int32" />
				<asp:ControlParameter ControlID="HdnUserName" DefaultValue="" Name="userName" PropertyName="Value"
					Type="String" />
			</SelectParameters>
		</asp:ObjectDataSource>
		<asp:HiddenField ID="HdnUserName" runat="server" />
	</div>
    <script type="text/javascript">

//        jQuery(".searchIn #TxtKeyword").bind("focus", function () {
//            jQuery(this).css("color", "#333");
//            if (jQuery(this).val() == "") {
//                jQuery(this).val("");
//            } else {
//                jQuery(this).get(0).select();
//            }
//        });

        // jq select
        jQuery(".searchIn select").styledSelect({
            selectClass: 'PESelect',
            selectedOptionClass: 'current',
            zIndexApply: true,
            zIndexStart: 300
        });
        // jq select
        jQuery(".memberBoxTab .hd span.fr select").styledSelect({
            selectClass: 'PESelect',
            selectedOptionClass: 'current'
        });
        Request = {
            QueryString: function (item) {
                var svalue = location.search.match(new RegExp("[\?\&]" + item + "=([^\&]*)(\&?)", "i"));
                return svalue ? svalue[1] : svalue;
            }
        };
        var t = parseInt(Request.QueryString("ShowType"));
        t = isNaN(t) ? 0 : t;
        jQuery("li[id^='TabTitle']").removeClass("on");
        jQuery("#TabTitle" + t.toString()).addClass("on");

    </script>
    </form>
</body>
</html>
